----------------------------------------------------
--  
--      VHDL code generated by Visual Elite
--
--  Design Unit:
--  ------------
--      Unit    Name  :  R_TYPE_Decode
--      Library Name  :  PCS_verilog
--  
--      Creation Date :  Tue Jul 13 11:21:49 2004
--      Version       :  3.5.1 build 43. Date: Feb 22 2004. License: 2004.2
--  
--  Options Used:
--  -------------
--      Target
--         Language   :  VHDL
--         Purpose    :  Synthesis
--         Vendor     :  Design Compiler
--  
--      Style
--         Use tasks                      :  No
--         Code Destination               :  1 File per Unit
--         Attach Packages                :  No
--         Generate Entity                :  Yes
--         Attach Directives              :  Yes
--         Structural                     :  No
--         Preserve spacing for free text :  Yes
--         Declaration alignment          :  No
--
----------------------------------------------------
----------------------------------------------------
--  
--  Library Name :  PCS_verilog
--  Unit    Name :  R_TYPE_Decode
--  Unit    Type :  Text Unit
--  
------------------------------------------------------
 
-- ---------------- Xilinx, CTD Systems & Apps  ------------------------
--  FileName: R_TYPE_Decode.v
--  Start of Coding Date: Mon May 14 2001 ( 1:00 pm)
--  File name: R_Type_Decode.v
--  Description: This file has the code for checking the validity of the
--               codes received from the PMA and does the translation into
--               XGMII codes. This function is part of the decodeing function
--               performed by the PCS.
--   Disclaimer: LIMITED WARRANTY AND DISCLAMER. These designs are
--               provided to you "as is". Xilinx and its licensors make, and you
--               receive no warranties or conditions, express, implied,
--               statutory or otherwise, and Xilinx specifically disclaims any
--               implied warranties of merchantability, non-infringement, or
--               fitness for a particular purpose. Xilinx does not warrant that
--               the functions contained in these designs will meet your
--               requirements, or that the operation of these designs will be
--               uninterrupted or error free, or that defects in the Designs
--               will be corrected. Furthermore, Xilinx does not warrant or
--               make any representations regarding use or the results of the
--               use of the designs in terms of correctness, accuracy,
--               reliability, or otherwise.
--               LIMITATION OF LIABILITY. In no event will Xilinx or its
--               licensors be liable for any loss of data, lost profits, cost
--               or procurement of substitute goods or services, or for any
--               special, incidental, consequential, or indirect damages
--               arising from the use or operation of the designs or
--               accompanying documentation, however caused and on any theory
--               of liability. This limitation will apply even if Xilinx
--               has been advised of the possibility of such damage. This
--               limitation shall apply not-withstanding the failure of the
--               essential purpose of any limited remedies herein.
--   Copyright  2002 Xilinx, Inc.
--   All rights reserved
--                        Revision History
-- -----------------------------------------------------------------
--  Date Modified             User Name            Full Name
--         Descrition of Changes
-- 
--   2013-05-15               Stepan Friedl
--         Removed asynchronous reset: DeScr_RXD_reg, sync_header, coded_data,
--         decoded_data
-- -----------------------------------------------------------------
--  $Log$
-- -----------------------------------------------------------------
--  NOTES:
-- -----------------------------------------------------------------
-- -----------------------------------------------------------------

--library SYNOPSYS;
--use SYNOPSYS.ATTRIBUTES.ALL;
 
 
library ieee;
use ieee.STD_LOGIC_1164.all;
use ieee.STD_LOGIC_ARITH.all;
use ieee.STD_LOGIC_MISC.all;
use ieee.STD_LOGIC_UNSIGNED.all;
 
 
entity R_TYPE_Decode is
  port (
        rstb156 : in STD_LOGIC;
        clk156 : in STD_LOGIC;
        DeScr_RXD : in STD_LOGIC_VECTOR(65 downto 0 );
        R_TYPE : out STD_LOGIC_VECTOR(2 downto 0 );
        rx_data : out STD_LOGIC_VECTOR(63 downto 0 );
        rx_control : out STD_LOGIC_VECTOR(7 downto 0 )
        );
end R_TYPE_Decode;

 
architecture R_TYPE_Decode of R_TYPE_Decode is

  -- Block types
  constant T_SEQ   : std_logic_vector(2 downto 0) := "000";
  constant T_START : std_logic_vector(2 downto 0) := "001";
  constant T_DATA  : std_logic_vector(2 downto 0) := "011";
  constant T_TERM  : std_logic_vector(2 downto 0) := "010";
  constant T_ERROR : std_logic_vector(2 downto 0) := "100";
 
  -- Functions for "||" translation
  function or_logic ( arg1, arg2 : std_logic) return std_logic
  is
  begin
    if (  arg1 = '1' or arg2 = '1' )
    then
      return '1';
    else
      return '0';
    end if;
  end or_logic;
  function or_logic ( arg1, arg2  : boolean ) return std_logic
  is
  begin
    if arg1  or arg2
    then
      return '1';
    else
      return '0';
    end if;
  end or_logic;
  function or_logic ( arg1  : std_logic; arg2  : boolean  ) return std_logic
  is
  begin
    if (  arg1 = '1' or arg2 )
    then
      return '1';
    else
      return '0';
    end if;
  end or_logic;
  function or_logic ( arg1  : boolean ; arg2 :std_logic) return std_logic
  is
  begin
    if (  arg1 or arg2 = '1' )
    then
      return '1';
    else
      return '0';
    end if;
  end or_logic;
  -- End functions for "||" translation
 
  -- Functions for "&&" translation
  function and_logic ( arg1, arg2  : boolean ) return std_logic
  is
  begin
    if arg1  and arg2
    then
      return '1';
    else
      return '0';
    end if;
  end and_logic;
  -- End functions for "&&" translation
 
  --
  function not_logic ( arg : std_logic) return std_logic
  is
  begin
    case (arg) is
      when 'X' | 'Z' => return 'X';
      when '1' => return '0';
      when others => return '1'; -- when '0'
    end case;
  end not_logic;
  --
 
  function conv_std_logic ( arg : boolean ) return std_logic is
  begin
    if arg
    then
      return '1';
    else
      return '0';
    end if;
  end;
  component PCS_to_XGMII
      port (
            in_code : in STD_LOGIC_VECTOR(6 downto 0 ) := "ZZZZZZZ";
            out_code : out STD_LOGIC_VECTOR(7 downto 0 )
            );
  end component;
  signal C_7 : STD_LOGIC_VECTOR(7 downto 0 );  --  before leaving.
  signal C_6 : STD_LOGIC_VECTOR(7 downto 0 );
  signal C_5 : STD_LOGIC_VECTOR(7 downto 0 );
  signal C_4 : STD_LOGIC_VECTOR(7 downto 0 );
  signal C_3 : STD_LOGIC_VECTOR(7 downto 0 );
  signal C_2 : STD_LOGIC_VECTOR(7 downto 0 );
  signal C_1 : STD_LOGIC_VECTOR(7 downto 0 );
  signal C_0 : STD_LOGIC_VECTOR(7 downto 0 );
  signal err_7 : STD_LOGIC;
  signal err_6 : STD_LOGIC;
  signal err_5 : STD_LOGIC;
  signal err_4 : STD_LOGIC;
  signal err_3 : STD_LOGIC;
  signal err_2 : STD_LOGIC;
  signal err_1 : STD_LOGIC;
  signal err_0 : STD_LOGIC;
  signal err_7_0 : STD_LOGIC;
  signal err_6_0 : STD_LOGIC;
  signal err_5_0 : STD_LOGIC;
  signal err_4_0 : STD_LOGIC;
  signal err_3_0 : STD_LOGIC;
  signal err_2_0 : STD_LOGIC;
  signal err_1_0 : STD_LOGIC;
  signal err_0_0 : STD_LOGIC;
  signal DeScr_RXD_reg : STD_LOGIC_VECTOR(65 downto 0 ) := X"000000000000001E" & "01";
  signal sync_header : STD_LOGIC_VECTOR(1 downto 0 ) := "01";
  signal coded_data : STD_LOGIC_VECTOR(63 downto 0 ) := X"000000000000001E";
  signal decoded_data : STD_LOGIC_VECTOR(63 downto 0 ):= X"0707070707070707";
begin
 
 
  --  for sync state machine
  Con_7: PCS_to_XGMII
    port map (
              DeScr_RXD_reg(65 downto 59),
              C_7
              );
 
  Con_6: PCS_to_XGMII
    port map (
              DeScr_RXD_reg(58 downto 52),
              C_6
              );
 
  Con_5: PCS_to_XGMII
    port map (
              DeScr_RXD_reg(51 downto 45),
              C_5
              );
 
  Con_4: PCS_to_XGMII
    port map (
              DeScr_RXD_reg(44 downto 38),
              C_4
              );
 
  Con_3: PCS_to_XGMII
    port map (
              DeScr_RXD_reg(37 downto 31),
              C_3
              );
 
  Con_2: PCS_to_XGMII
                           --  TX code select
    port map (
              DeScr_RXD_reg(30 downto 24),
              C_2
              );
 
  Con_1: PCS_to_XGMII
    port map (
              DeScr_RXD_reg(23 downto 17),
              C_1
              );
 
  Con_0: PCS_to_XGMII
    port map (
              DeScr_RXD_reg(16 downto 10),
              C_0
              );
  err_7_0 <= and_reduce(C_7);
  err_6_0 <= and_reduce(C_6);
  err_5_0 <= and_reduce(C_5);
  err_4_0 <= and_reduce(C_4);
  err_3_0 <= and_reduce(C_3);
  err_2_0 <= and_reduce(C_2);
  err_1_0 <= and_reduce(C_1);
  err_0_0 <= and_reduce(C_0);
  process (clk156, rstb156)
  begin
 
    if (rstb156 = '0') then
      err_7 <= transport '0';
      err_6 <= transport '0';
      err_5 <= transport '0';
      err_4 <= transport '0';
      err_3 <= transport '0';
      err_2 <= transport '0';
      err_1 <= transport '0';
      err_0 <= transport '0';
                           --  For Encoder
    elsif (clk156'event and clk156 = '1') then
      err_7 <= transport err_7_0;
      err_6 <= transport err_6_0;
      err_5 <= transport err_5_0;
      err_4 <= transport err_4_0;
      err_3 <= transport err_3_0;
      err_2 <= transport err_2_0;
      err_1 <= transport err_1_0;
      err_0 <= transport err_0_0;
 
    end if ;
  end process ;
  
 process (clk156)
  begin
     if (clk156'event and clk156 = '1') then
      DeScr_RXD_reg <= transport DeScr_RXD;
      sync_header   <= transport DeScr_RXD_reg(1 downto 0);
      coded_data(63 downto 0)   <= transport DeScr_RXD_reg(65 downto 2);
      decoded_data(63 downto 0) <= transport (C_7& C_6& C_5& C_4& C_3& C_2& C_1&
                                             C_0);
     end if ;
  end process ;
   
 
  process (sync_header, coded_data, decoded_data, err_7, err_6, err_5, err_4,
    err_3, err_2, err_1, err_0)
    variable case_var : STD_LOGIC_VECTOR(7 downto 0);
       -- Generated for case statement
 
  begin
    case sync_header is
      --  data frame
      when "10" =>
        rx_control <= X"00";
        rx_data    <= coded_data;
        R_TYPE     <= T_DATA; -- Data
 
      --  check for control , start , terminate, or error frame
      when "01" =>
        case_var := coded_data(7 downto 0) ;
        case case_var is
          when X"1E" => -- IDLE
            if (decoded_data(63 downto 56) = X"FE") or (decoded_data(55
                downto 48) = X"FE") or (decoded_data(47 downto 40) = X"FE"
               ) or (decoded_data(39 downto 32) = X"FE") or (decoded_data(
               31 downto 24) = X"FE") or (decoded_data(23 downto 16) = X"FE"
               ) or (decoded_data(15 downto 8) = X"FE") or (decoded_data(7
                downto 0) = X"FE") then
              rx_control <= "11111111";
              rx_data    <= STD_LOGIC_VECTOR'(X"FEFEFEFEFEFEFEFE");
              R_TYPE     <= T_ERROR; -- Error
            else
              if (err_7) = '1'  or (err_6) = '1'  or (err_5) = '1'  or (err_4)
                  = '1'  or (err_3) = '1'  or (err_2) = '1'  or (err_1) = '1'
                 or (err_0) = '1'  then
                rx_control <= "11111111";
                rx_data    <= STD_LOGIC_VECTOR'(X"FEFEFEFEFEFEFEFE");
                R_TYPE     <= T_ERROR; -- Error
 
              else
                rx_control <= "11111111";
                rx_data    <= decoded_data;
                R_TYPE     <= T_SEQ; -- Idle
 
              end if ;
            end if ;
 
          -- Start of packet
          when X"78" =>
            rx_control <= "00000001";
            rx_data    <= (coded_data(63 downto 8)& X"FB");
            R_TYPE     <= T_START; -- SOP
 
          -- Ordered set  
          when X"4B" =>
            if (err_7) = '1'  or (err_6) = '1'  or (err_5) = '1'  or (err_4)
                = '1'  or (((coded_data(35 downto 32) /= "0000") and (coded_data
               (35 downto 32) /= "1111"))) then
              rx_control <= "11111111";
              rx_data    <= STD_LOGIC_VECTOR'(X"FEFEFEFEFEFEFEFE");
              R_TYPE     <= T_ERROR;
 
            else
              if coded_data(35 downto 32) = "0000" then
                -- Sequence ordered set 
                rx_data    <= (coded_data(63 downto 8)& X"9C"); -- Latch!fixed
                R_TYPE     <= T_SEQ;
                rx_control <= "00000001";
              else
                -- Signal ordered set 
                rx_data    <= (coded_data(63 downto 8)& X"5C");  -- Latch!fixed
                R_TYPE     <= T_SEQ;
                rx_control <= "00000001";
 
              end if ;
            end if ;
 
          -- End of packet (0 data bytes)  
          when X"87" =>
            if (err_7) = '1'  or (err_6) = '1'  or (err_5) = '1'  or (err_4)
                = '1'  or (err_3) = '1'  or (err_2) = '1'  or (err_1) = '1'
                then
              rx_control <= "11111111";
              rx_data    <= STD_LOGIC_VECTOR'(X"FEFEFEFEFEFEFEFE");
              R_TYPE     <= T_ERROR; -- Error
 
            else
              rx_control <= "11111111";
              rx_data    <= (decoded_data(63 downto 8)& X"FD");
              R_TYPE     <= T_TERM; -- EOP
 
            end if ;
 
          -- End of packet (1 data byte)  
          when X"99" =>
            if (err_7) = '1'  or (err_6) = '1'  or (err_5) = '1'  or (err_4)
                = '1'  or (err_3) = '1'  or (err_2) = '1'  then
              rx_control <= "11111111";
              rx_data    <= STD_LOGIC_VECTOR'(X"FEFEFEFEFEFEFEFE");
              R_TYPE     <= T_ERROR; -- Error
 
            else
              rx_control <= X"FE";
              rx_data    <= (decoded_data(63 downto 16)& X"FD"& coded_data(15 downto 8));
              R_TYPE     <= T_TERM; -- EOP
 
            end if ;
 
          -- End of packet (2 data bytes)  
          when X"AA" =>
            if (err_7) = '1'  or (err_6) = '1'  or (err_5) = '1'  or (err_4)
                = '1'  or (err_3) = '1'  then
              rx_control <= "11111111";
              rx_data    <= STD_LOGIC_VECTOR'(X"FEFEFEFEFEFEFEFE");
              R_TYPE     <= T_ERROR; -- Error
 
            else
              rx_control <= "11111100";
              rx_data    <= (decoded_data(63 downto 24)& X"FD"& coded_data(23 downto 8));
              R_TYPE     <= T_TERM; -- EOP
 
            end if ;
 
          -- End of packet (3 data bytes)  
          when X"B4" =>
            if (err_7) = '1'  or (err_6) = '1'  or (err_5) = '1'  or (err_4)
                = '1'  then
              rx_control <= "11111111";
              rx_data    <= STD_LOGIC_VECTOR'(X"FEFEFEFEFEFEFEFE");
              R_TYPE     <= T_ERROR; -- Error
 
            else
              rx_control <= "11111000";
              rx_data    <= (decoded_data(63 downto 32)& X"FD"& coded_data(31 downto 8));
              R_TYPE     <= T_TERM; -- EOP
 
            end if ;
 
          -- End of packet (4 data bytes)  
          when X"CC" =>
            if (err_7) = '1'  or (err_6) = '1'  or (err_5) = '1'  then
              rx_control <= "11111111";
              rx_data    <= STD_LOGIC_VECTOR'(X"FEFEFEFEFEFEFEFE");
              R_TYPE     <= T_ERROR; -- Error
 
            else
              rx_control <= "11110000";
              rx_data    <= (decoded_data(63 downto 40)& X"FD"& coded_data(39 downto 8)); 
              R_TYPE     <= T_TERM; -- EOP
 
            end if ;
 
          -- End of packet (5 data bytes)  
          when X"D2" =>
            if (err_7) = '1'  or (err_6) = '1'  then
              rx_control <= "11111111";
              rx_data    <= STD_LOGIC_VECTOR'(X"FEFEFEFEFEFEFEFE");
              R_TYPE     <= T_ERROR; -- Error
 
            else
              rx_control <= "11100000";
              rx_data    <= (decoded_data(63 downto 48)& X"FD"& coded_data(47 downto 8));
              R_TYPE     <= T_TERM; -- EOP
 
            end if ;
 
          -- End of packet (6 data bytes)  
          when X"E1" =>
            if (err_7)='1' then
              rx_control <= "11111111";
              rx_data    <= STD_LOGIC_VECTOR'(X"FEFEFEFEFEFEFEFE");
              R_TYPE     <= T_ERROR; -- Error
 
            else
              rx_control <= "11000000";
              rx_data    <= (decoded_data(63 downto 56)& X"FD"& coded_data(55 downto 8)); 
              R_TYPE     <= T_TERM; -- EOP
 
            end if ;
 
          -- End of packet (7 data bytes)  
          when X"FF" =>
            rx_control <= "10000000";
            rx_data    <= (STD_LOGIC_VECTOR'(X"FD")& coded_data(63 downto 8));
            R_TYPE     <= T_TERM; -- EOP
 
          when others  =>
            rx_control <= "11111111";
            rx_data    <= STD_LOGIC_VECTOR'(X"FEFEFEFEFEFEFEFE");
            R_TYPE     <= T_ERROR; -- Error
 
 
        end case  ;
 
      when others  =>
        rx_control <= "11111111";
        rx_data    <= STD_LOGIC_VECTOR'(X"FEFEFEFEFEFEFEFE");
        R_TYPE     <= T_ERROR; -- Error
 
 
    end case  ;
 
  end process ;
 
 
end ;

-- R_TYPEs:
-- 000 IDLE (control)
-- 100 Error
-- 001 SOP
-- 010 EOP
-- 011 Data frame
