# 100ge_phy_lr4.xdc: Local constrains for 100G Eth PHY in LR4 configuration
# Copyright (C) 2014 CESNET
# Author: Stepan Friedl <friedl@cesnet.cz>
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in
#    the documentation and/or other materials provided with the
#    distribution.
# 3. Neither the name of the Company nor the names of its contributors
#    may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# This software is provided ``as is'', and any express or implied
# warranties, including, but not limited to, the implied warranties of
# merchantability and fitness for a particular purpose are disclaimed.
# In no event shall the company or contributors be liable for any
# direct, indirect, incidental, special, exemplary, or consequential
# damages (including, but not limited to, procurement of substitute
# goods or services; loss of use, data, or profits; or business
# interruption) however caused and on any theory of liability, whether
# in contract, strict liability, or tort (including negligence or
# otherwise) arising in any way out of the use of this software, even
# if advised of the possibility of such damage.
#
# $Id$
#

###############################################################################
# GTZ output clocks timing  
###############################################################################

create_clock -period 6.206 -name OCTAL0_TXOUTCLK0 [get_pins -hierarchical *gtze2_octal_north/TXOUTCLK0]
## Needed if USRCLK is generated from BUFG_LB
create_generated_clock -name TXUSRCLK0 -source [get_pins -hierarchical *gtze2_octal_north/TXOUTCLK0] -divide_by 1 [get_pins -hierarchical -filter name=~*gtze2_inf_north*clkbuflbtx0*CLKOUT]
create_clock -period 6.206 -name OCTAL0_RXOUTCLK0 [get_pins -hierarchical *gtze2_octal_north/RXOUTCLK0]
set_property LOC BUFGCTRL_X0Y9 [get_cells PMA_I/gt_usrclk_source_i/mmcm_out_rx1]

#########################################################################################################
## Management - PMA/PCS control and status paths
#########################################################################################################
# PCS reset
set_false_path -from [get_pins MGMT/pcs_rst_reg/C] -to [get_pins pcs_rx_reset_in_reg/D]
set_false_path -from [get_pins MGMT/pcs_rst_reg/C] -to [get_pins pcs_rx_reset_mi_reg/D]
set_false_path -from [get_pins MGMT/pcs_rst_reg/C] -to [get_pins pcs_rx_reset_pc_reg/D]
set_false_path -from [get_pins MGMT/pcs_rst_reg/C] -to [get_pins pcs_tx_reset_mi_reg/D]
set_false_path -from [get_pins MGMT/pcs_rst_reg/C] -to [get_pins pcs_tx_reset_in_reg/D]
set_false_path -from [get_pins MGMT/pcs_rst_reg/C] -to [get_pins pcs_tx_reset_pc_reg/D]
# PMA reset
set_false_path -from [get_pins MGMT/pma_rst_reg/C] -to [get_cells -quiet -filter {PRIMITIVE_GROUP == "RTL_REGISTER" || PRIMITIVE_GROUP == "FLOP_LATCH"} PMA_I/gtz_caui4_v3_0_init_i/reset_fsm_oct0_gt*/*_reg*]
set_false_path -from [get_pins MGMT/pma_rst_reg/C] -to [get_cells -quiet -filter {PRIMITIVE_GROUP == "RTL_REGISTER" || PRIMITIVE_GROUP == "FLOP_LATCH"} PMA_I/gtz_caui4_v3_0_init_i/reset_fsm_oct0_gt*/state_r_reg[*]]
set_false_path -from [get_pins MGMT/pma_rst_reg/C] -to [get_cells -quiet -filter {PRIMITIVE_GROUP == "RTL_REGISTER" || PRIMITIVE_GROUP == "FLOP_LATCH"} PMA_I/gtz_caui4_v3_0_init_i/tuning_oct0_i/redo_channel_tuning_*_reg]
set_false_path -from [get_pins MGMT/pma_rst_reg/C] -to [get_cells -quiet -filter {PRIMITIVE_GROUP == "RTL_REGISTER" || PRIMITIVE_GROUP == "FLOP_LATCH"} PMA_I/gt_usrclk_source_i/softip_rst_b_reg]
set_false_path -from [get_pins MGMT/pma_rst_reg/C] -to [get_cells -quiet -filter {PRIMITIVE_GROUP == "RTL_REGISTER" || PRIMITIVE_GROUP == "FLOP_LATCH"} PMA_I/gtz_caui4_v3_0_init_i/tx_startup_gt0_i/timer_en_reg]
set_false_path -from [get_pins MGMT/pma_rst_reg/C] -to [get_cells -quiet -filter {PRIMITIVE_GROUP == "RTL_REGISTER" || PRIMITIVE_GROUP == "FLOP_LATCH"} {drp_state_reg[*]}]
set_false_path -from [get_pins MGMT/pma_rst_reg/C] -to [get_cells -quiet -filter {PRIMITIVE_GROUP == "RTL_REGISTER" || PRIMITIVE_GROUP == "FLOP_LATCH"} PMA_I/gtz_caui4_v3_0_init_i/tx_startup_gt*_i/*_reg*]

# Control
set_false_path -from [get_cells -quiet -filter {PRIMITIVE_GROUP == "RTL_REGISTER" || PRIMITIVE_GROUP == "FLOP_LATCH"} {MGMT/scr_bypass_r_reg*}]
set_false_path -from [get_pins MGMT/pcs_rxl_stat_l_reg/C] -to [get_pins {MGMT/MI_DRD_reg[*]/D}]
set_false_path -from [get_pins MGMT/pma_loc_lpbk_reg/C] -to [get_pins PMA_I/gtz_caui4_v3_0_init_i/gtz_caui4_i/inst/octal0_gtz_caui4_i/gtz_caui4_octal0_i/gtze2_inf_north/NEARLOOPBACKEN*_FD/D]
set_false_path -from [get_pins MGMT/pma_loc_lpbk_reg/C] -to [get_pins PMA_I/gtz_caui4_v3_0_init_i/tuning_oct0_i/loopback_r_reg[0]/D]
set_false_path -from [get_pins MGMT/pcs_blk_lock_l_reg/C] -to [get_pins {MGMT/MI_DRD_reg[*]/D}]
set_false_path -from [get_pins MGMT/pcs_hi_ber_l_reg/C] -to [get_pins {MGMT/MI_DRD_reg[*]/D}]
set_false_path -from [get_pins {MGMT/r3200_rd_r_reg[*]/C}] -to [get_pins {RX_PATH/reagsync_bip_err_clr_reg[*]/D}]
set_false_path -from [get_pins MGMT/r333_rd_r_reg/C] -to [get_pins MGMT/r333_clr_sync_reg/D]
set_false_path -from [get_pins MGMT/r333_rd_r_reg/C] -to [get_pins RX_PATH/regasync_clr_ber_cnt_reg/D]
set_false_path -from [get_pins MGMT/r301_rd_r_reg/C] -to [get_pins MGMT/r301_clr_sync_reg/D]
set_false_path -from [get_pins MGMT/PMA_RETUNE_reg/C] -to [get_cells PMA_I/gtz_caui4_v3_0_init_i/tuning_oct0_i/redo_channel_tuning_*_reg]
# Status
set_false_path -from [get_cells RX_PATH/ALIGN/locked_i_reg] -to [get_cells {MGMT/MI_DRD_reg[*]}]
set_false_path -from [get_cells RX_PATH/ALIGN/locked_i_reg] -to [get_cells MGMT/pcs_blk_lock_l_reg]
set_false_path -from [get_cells RX_PATH/ALIGN/locked_i_reg] -to [get_cells MGMT/pcs_rxl_stat_l_reg]
set_false_path -from [get_pins {RX_PATH/ALIGN/GEN_AM_LOOKUP[*].bip_err_cntrs_i_reg[*]/C}] -to [get_pins {MGMT/bip_ercntr_r_reg[*]/D}]
set_false_path -from [get_pins {RX_PATH/ALIGN/GEN_AM_LOOKUP[*].lanes_aligned_i_reg[*]/C}] -to [get_pins {MGMT/MI_DRD_reg[*]/D}]
set_false_path -from [get_pins {RX_PATH/ALIGN/GEN_AM_LOOKUP[*].lane_mapping_reg[*]/C}] -to [get_pins {MGMT/MI_DRD_reg[*]/D}]
#
set_false_path -from [get_cells RX_PATH/BER_MONITOR/HI_BER_reg] -to [get_cells MGMT/pcs_rxl_stat_l_reg]
set_false_path -from [get_cells RX_PATH/BER_MONITOR/HI_BER_reg] -to [get_cells MGMT/pcs_hi_ber_l_reg]
set_false_path -from [get_cells RX_PATH/BER_MONITOR/HI_BER_reg] -to [get_cells {MGMT/MI_DRD_reg[*]}]
set_false_path -from [get_pins {RX_PATH/BER_MONITOR/ber_counter_reg[*]/C}] -to [get_pins {MGMT/ber_count_r_reg[*]/D}]
set_false_path -from [get_pins PMA_I/gtz_caui4*rx_block_sync_oct0_gt*_i/block_sync_sm*/BLOCKSYNC_OUT_reg/C] -to [get_pins MGMT/pcs_blk_lock_l_reg/D]
set_false_path -from [get_pins PMA_I/gtz_caui4*rx_block_sync_oct0_gt*_i/block_sync_sm*/BLOCKSYNC_OUT_reg/C] -to [get_pins {MGMT/MI_DRD_reg[*]/D}]
set_false_path -from [get_pins PMA_I/gtz_caui4_v3_0_init_i/reset_fsm_oct0_gt*/RESETFSMDONE_OUT_reg/C] -to [get_pins {MGMT/MI_DRD_reg*/D}]
set_false_path -from [get_pins {RX_PATH/DECODE/BLK_ERR_CNTR_reg[*]/C}] -to [get_pins {MGMT/blk_err_cntr_r_reg[*]/D}]

#########################################################################################################
## PMA and PCS async paths
#########################################################################################################
set_false_path -from [get_cells -quiet {PMA_I/gt_usrclk_source_i/*_state_reg*}] -to [get_cells pcs_rx_reset_in_reg]
set_false_path -from [get_cells -quiet {PMA_I/gt_usrclk_source_i/*_state_reg*}] -to [get_cells pcs_rx_reset_pc_reg]
set_false_path -from [get_cells -quiet {PMA_I/gt_usrclk_source_i/*_state_reg*}] -to [get_cells pcs_rx_reset_pcs_reg]
set_false_path -from [get_cells -quiet {PMA_I/gt_usrclk_source_i/*_state_reg*}] -to [get_cells pcs_rx_reset_int_reg]
set_false_path -from [get_cells -quiet {PMA_I/oct0_gt*_rxresetdone_r2_reg}]     -to [get_cells pcs_rx_reset_in_reg]
set_false_path -from [get_cells -quiet {PMA_I/oct0_gt*_rxresetdone_r2_reg}]     -to [get_cells pma_rxreset_done_r_reg]
set_false_path -from [get_cells -quiet {PMA_I/oct0_gt*_txresetdone_r2_reg}]     -to [get_cells pma_txreset_done_r_reg]
set_false_path -from [get_cells -quiet {PMA_I/oct0_gt*_txresetdone_r2_reg}]     -to [get_cells pcs_tx_reset_in_reg]
set_false_path -from [get_cells -quiet {PMA_I/gt_usrclk_source_i/*_state_reg*}] -to [get_cells pma_rxreset_done_r_reg]
set_false_path -from [get_cells -quiet {PMA_I/gt_usrclk_source_i/*_state_reg*}] -to [get_cells PMA_I/gtz_caui4_v3_0_rx_block_sync_oct0_gt?_i/block_sync_sm?_i/*reg]
set_false_path -from [get_cells -quiet {PMA_I/gt_usrclk_source_i/*_state_reg*}] -to [get_cells PMA_I/gtz_caui4_v3_0_rx_block_sync_oct0_gt*/block_sync_sm*/*_reg]
set_false_path -from [get_pins PMA_I/gtz_caui4_v3_0_init_i/tx_startup_gt*/RESET_DONE_reg/C] -to [get_cells -quiet -filter {PRIMITIVE_GROUP == "RTL_REGISTER" || PRIMITIVE_GROUP == "FLOP_LATCH"} PMA_I/oct0_gt*_txresetdone_r*]
set_false_path -from [get_pins PMA_I/gtz_caui4_v3_0_init_i/reset_fsm_oct*/RESETFSMDONE_OUT_reg/C] -to [get_pins PMA_I/oct0_gt*_rxresetdone*_reg/CLR] 
set_false_path -from [get_pins PMA_I/gtz_caui4_v3_0_init_i/reset_fsm_oct*/RESETFSMDONE_OUT_reg/C] -to [get_pins PMA_I/oct0_gt*_rxresetdone*_reg/D]
set_false_path -from [get_pins PMA_I/gtz_caui4_v3_0_rx_block_sync_oct0_gt*_i/block_sync_sm*_i/BLOCKSYNC_OUT_reg/C] -to [get_cells {RX_PATH/ALIGN/am_match_reg[*]}]
set_false_path -from [get_pins PMA_I/gtz_caui4_v3_0_rx_block_sync_oct0_gt?_i/block_sync_sm*/BLOCKSYNC_OUT_reg/C] -to [get_pins RX_PATH/reasync_blk_lock_reg*/D]
set_false_path -from [get_pins RX_PATH/ALIGN/locked_i_reg/C] -to [get_pins RX_PATH/blk_lock_all_reg*/D]
set_false_path -from [get_pins RX_PATH/BER_MONITOR/HI_BER_reg/C] -to [get_pins RX_PATH/reasync_hi_ber_reg/D]
set_false_path -through [get_pins PMA_I/gtz_caui4_v3_0_init_i/gtz_caui4_i/inst/octal0_gtz_caui4_i/gtz_caui4_octal0_i/gtze2_octal_north/RXRDY*] -to [get_cells -quiet -filter {PRIMITIVE_GROUP == "RTL_REGISTER" || PRIMITIVE_GROUP == "FLOP_LATCH"} {PMA_I/gtz_caui4_v3_0_init_i/tx_startup_gt*/rxrdy_si_reg}]
set_false_path -through [get_pins PMA_I/gtz_caui4_v3_0_init_i/gtz_caui4_i/inst/octal0_gtz_caui4_i/gtz_caui4_octal0_i/gtze2_octal_north/RXRDY*] -to [get_cells {PMA_I/gtz_caui4_v3_0_init_i/reset_fsm_oct0_gt*/rxrdy_*_reg*}]
set_false_path -through [get_pins PMA_I/gtz_caui4_v3_0_init_i/gtz_caui4_i/inst/octal0_gtz_caui4_i/gtz_caui4_octal0_i/gtze2_octal_north/TXRDY*] -to [get_cells -quiet -filter {PRIMITIVE_GROUP == "RTL_REGISTER" || PRIMITIVE_GROUP == "FLOP_LATCH"} {PMA_I/gtz_caui4_v3_0_init_i/tx_startup_gt*/txrdy_si_reg}]
set_false_path -from [get_pins PMA_I/gtz_caui4_v3_0_init_i/gtz_caui4_i/inst/octal0_gtz_caui4_i/gtz_caui4_octal0_i/gtze2_inf_north/TXRESETDONE*_FD/C] -to [get_cells -quiet -filter {PRIMITIVE_GROUP == "RTL_REGISTER" || PRIMITIVE_GROUP == "FLOP_LATCH"} {PMA_I/gtz_caui4_v3_0_init_i/tx_startup_gt*/txresetdone_si_reg}] 
set_false_path -from [get_pins PMA_I/gtz_caui4_v3_0_init_i/gtz_caui4_i/inst/octal0_gtz_caui4_i/gtz_caui4_octal0_i/gtze2_inf_north/RXRESETDONE*_FD/C] -to [get_cells -quiet -filter {PRIMITIVE_GROUP == "RTL_REGISTER" || PRIMITIVE_GROUP == "FLOP_LATCH"} {PMA_I/gtz_caui4_v3_0_init_i/reset_fsm_oct0_gt*/rxresetdone_r_reg*}]
set_false_path -to [get_cells PMA_I/gtz_caui4_v3_0_init_i/reset_fsm_oct0_gt*_i/rxdata_ok_r_reg]

#########################################################################################################
## GTZ DRP interface
#########################################################################################################
set_false_path -from [get_cells drp_*_mi_reg*] -to [get_cells drp*_reg*]
set_false_path -from [get_pins drp_done_reg/C] -to [get_pins {mi_drd_drp_reg[*]/D}]
set_false_path -from [get_pins {drp_drd_reg[*]/C}] -to [get_pins {mi_drd_drp_reg[*]/D}]
set_false_path -from [get_pins {drp_status_r_reg[*]/C}] -to [get_pins {mi_drd_drp_reg[*]/D}]

#########################################################################################################
## Optional - these constraints are not necessary, but can greatly improve the timing
## These paths are synchronous, but due to their character they can be wieved as asynchronous or multi-cycle
#########################################################################################################
set_false_path -from [get_pins RX_PATH/hi_ber_xclk_reg*/C] -to [get_cells -quiet -filter {PRIMITIVE_GROUP == "RTL_REGISTER" || PRIMITIVE_GROUP == "FLOP_LATCH"} {RX_PATH/DECODE/GEN_DECODER[*].DECODER/visual_0_RX_FSM/*_reg*}]
set_false_path -from [get_pins RX_PATH/blk_lock_all_reg*/C] -to [get_cells -quiet -filter {PRIMITIVE_GROUP == "RTL_REGISTER" || PRIMITIVE_GROUP == "FLOP_LATCH"} {RX_PATH/DECODE/GEN_DECODER[*].DECODER/visual_0_RX_FSM/*_reg*}]
set_false_path -from [get_pins {RX_PATH/ALIGN/GEN_AM_LOOKUP[*].lane_mapping_reg[*]/C}] -to [get_pins {RX_PATH/ALIGN/Q_reg[*]/D}]
set_false_path -from [get_pins PMA_I/gtz_caui4*rx_block_sync_oct0_gt*_i/block_sync_sm*/BLOCKSYNC_OUT_reg/C]
## Async resets
set_false_path -from [get_pins pcs_rx_reset_mii_reg/C] -to [get_cells -quiet -filter {PRIMITIVE_GROUP == "RTL_REGISTER" || PRIMITIVE_GROUP == "FLOP_LATCH"} {RX_PATH/DECODE/GEN_DECODER[*].DECODER/visual_0_RX_FSM/*_reg*}]
set_false_path -from [get_pins pcs_rx_reset_mii_reg/C] -to [get_cells -quiet -filter {PRIMITIVE_GROUP == "RTL_REGISTER" || PRIMITIVE_GROUP == "FLOP_LATCH"} {RX_PATH/DECODE/GEN_DECODER[*].DECODER/visual_0_R_TYPE_Decode/err*_reg}]
set_false_path -from [get_pins pcs_tx_reset_mii_reg/C] -to [get_cells -quiet -filter {PRIMITIVE_GROUP == "RTL_REGISTER" || PRIMITIVE_GROUP == "FLOP_LATCH"} {TX_PCS/ENCODE/GEN_ENCODERS[*].ENCODE/visual_0_T_TYPE_Encode/err*_reg}]
set_false_path -from [get_pins pcs_rx_reset_pcs_reg/C] -to [get_cells -quiet -filter {PRIMITIVE_GROUP == "RTL_REGISTER" || PRIMITIVE_GROUP == "FLOP_LATCH"} {RX_PATH/BER_MONITOR/ber_counter_reg[*]}]

#########################################################################################################
## PMA pattern generator - debug only
#########################################################################################################
# set_false_path -from [get_pins MGMT/PMA_PTRN_EN_reg/C] -to [get_pins PMA_I/gtz_caui4_v3_0_init_i/gtz_caui4_i/inst/octal0_gtz_caui4_i/gtze2_inf_north/*_FD/*]
# set_false_path -from [get_pins MGMT/PMA_PTRN_EN_reg/C] -to [get_pins PMA_I/gtz_caui4_v3_0_init_i/gtz_caui4_i/inst/octal0_gtz_caui4_i/gtze2_inf_north/TXDATA*/D]
# set_false_path -from [get_pins MGMT/PMA_PTRN_EN_reg/C] -to [get_pins PMA_I/gtz_caui4_v3_0_tx_interface_oct0_gt*/*_reg*/*]

# Old lane align (FIFO version) - debug only
# set_false_path -from [get_pins {RX_PATH/ALIGN/lane_mapping_reg*/C}] -to [get_pins {MGMT/MI_DRD_reg[*]/D}]
# set_false_path -from [get_pins {RX_PATH/ALIGN/lanes_aligned_i_reg*/C}] -to [get_pins {MGMT/MI_DRD_reg[*]/D}]
# set_false_path -from [get_pins {RX_PATH/ALIGN/bip_err_cntrs_i_reg*/C}] -to [get_pins {MGMT/bip_ercntr_r_reg[*]/D}]

## Startup debug - state of startup FSMs 
set_false_path -from [get_cells -quiet -filter {PRIMITIVE_GROUP == "RTL_REGISTER" || PRIMITIVE_GROUP == "FLOP_LATCH"} PMA_I/gtz_caui4_v3_0_init_i/tuning_oct0_i/*_reg*] -to [get_cells -quiet -filter {PRIMITIVE_GROUP == "RTL_REGISTER" || PRIMITIVE_GROUP == "FLOP_LATCH"} {mi_drd_drp_reg*}]
set_false_path -from [get_cells -quiet -filter {PRIMITIVE_GROUP == "RTL_REGISTER" || PRIMITIVE_GROUP == "FLOP_LATCH"} PMA_I/gtz_caui4_v3_0_init_i/reset_fsm_oct0_gt*/*_reg*] -to [get_cells -quiet -filter {PRIMITIVE_GROUP == "RTL_REGISTER" || PRIMITIVE_GROUP == "FLOP_LATCH"} {mi_drd_drp_reg*}]
set_false_path -from [get_cells -quiet -filter {PRIMITIVE_GROUP == "RTL_REGISTER" || PRIMITIVE_GROUP == "FLOP_LATCH"} PMA_I/gtz_caui4_v3_0_init_i/tx_startup_gt*/*_reg*] -to [get_cells -quiet -filter {PRIMITIVE_GROUP == "RTL_REGISTER" || PRIMITIVE_GROUP == "FLOP_LATCH"} {mi_drd_drp_reg*}]

# Chipscope - PMA startup
#set_false_path -through [get_pins PMA_I/gtz_caui4_v3_0_init_i/gtz_caui4_i/inst/octal0_gtz_caui4_i/gtze2_octal_north/RXRDY*] -to [get_pins {PMA_I/gtz_caui4_v3_0_init_i/DRP_ILA/inst/ila_core_inst/shifted_data_in_reg[*][*]_srl8/D}]
#set_false_path -through [get_pins PMA_I/gtz_caui4_v3_0_init_i/gtz_caui4_i/inst/octal0_gtz_caui4_i/gtze2_octal_north/RXRDY*] -to [get_pins {PMA_I/gtz_caui4_v3_0_init_i/DRP_ILA/inst/ila_core_inst/u_trig/U_TM/G_NMU[0].U_M/allx_typeA_match_detection.cs_allx_typeA_inst/probeDelay1_reg[*]/D}]
#set_false_path -from [get_pins PMA_I/gtz_caui4_v3_0_init_i/gtz_caui4_i/inst/octal0_gtz_caui4_i/gtze2_inf_north/RXRESETDONE*_FD/C] -to [get_pins {PMA_I/gtz_caui4_v3_0_init_i/DRP_ILA/inst/ila_core_inst/shifted_data_in_reg[*][*]_srl8/D}] 
#set_false_path -from [get_pins PMA_I/gtz_caui4_v3_0_init_i/gtz_caui4_i/inst/octal0_gtz_caui4_i/gtze2_inf_north/RXRESETDONE*_FD/C] -to [get_pins {PMA_I/gtz_caui4_v3_0_init_i/DRP_ILA/inst/ila_core_inst/u_trig/U_TM/G_NMU[0].U_M/allx_typeA_match_detection.cs_allx_typeA_inst/probeDelay1_reg[*]/D}]
#set_false_path -through [get_pins PMA_I/gtz_caui4_v3_0_init_i/gtz_caui4_i/inst/octal0_gtz_caui4_i/gtze2_octal_north/TXRDY*] -to [get_pins {PMA_I/gtz_caui4_v3_0_init_i/DRP_ILA/inst/ila_core_inst/shifted_data_in_reg[*][*]_srl8/D}]
#set_false_path -through [get_pins PMA_I/gtz_caui4_v3_0_init_i/gtz_caui4_i/inst/octal0_gtz_caui4_i/gtze2_octal_north/TXRDY*] -to [get_pins {PMA_I/gtz_caui4_v3_0_init_i/DRP_ILA/inst/ila_core_inst/u_trig/U_TM/G_NMU[0].U_M/allx_typeA_match_detection.cs_allx_typeA_inst/probeDelay1_reg[*]/D}]
#set_false_path -from [get_pins PMA_I/gtz_caui4_v3_0_init_i/gtz_caui4_i/inst/octal0_gtz_caui4_i/gtze2_inf_north/TXRESETDONE*_FD/C] -to [get_pins {PMA_I/gtz_caui4_v3_0_init_i/DRP_ILA/inst/ila_core_inst/shifted_data_in_reg[*][*]_srl8/D}] 
#set_false_path -from [get_pins PMA_I/gtz_caui4_v3_0_init_i/gtz_caui4_i/inst/octal0_gtz_caui4_i/gtze2_inf_north/TXRESETDONE*_FD/C] -to [get_pins {PMA_I/gtz_caui4_v3_0_init_i/DRP_ILA/inst/ila_core_inst/u_trig/U_TM/G_NMU[0].U_M/allx_typeA_match_detection.cs_allx_typeA_inst/probeDelay1_reg[*]/D}]

## TX PCS ILA
#set_false_path -through [get_pins TX_PCS/TXFIFO/ASFIFO/full_fifos_gen[0].FIFO_DUALCLOCK_MACRO_inst/bl.fifo_36_inst_bl_1.fifo_36_bl_1/EMPTY] -to [get_pins {TX_PCS/ILA/U0/ila_core_inst/shifted_data_in_reg[7][592]_srl8/D}]
#set_false_path -through [get_pins TX_PCS/TXFIFO/ASFIFO/full_fifos_gen[0].FIFO_DUALCLOCK_MACRO_inst/bl.fifo_36_inst_bl_1.fifo_36_bl_1/EMPTY] -to [get_pins {TX_PCS/ILA/U0/ila_core_inst/u_trig/U_TM/G_NMU[4].U_M/allx_typeA_match_detection.cs_allx_typeA_inst/probeDelay1_reg[16]/D}]
#set_false_path -from [get_pins {TX_PCS/BLOCK_DISTR/FSM_onehot_cycle_reg[*]/C}] -to [get_pins {TX_PCS/ILA/U0/ila_core_inst/shifted_data_in_reg[*][*]_srl8/D}]
#set_false_path -from [get_pins {TX_PCS/BLOCK_DISTR/FSM_onehot_cycle_reg[*]/C}] -to [get_pins {TX_PCS/ILA/U0/ila_core_inst/u_trig/U_TM/G_NMU[*].U_M/allx_typeA_match_detection.cs_allx_typeA_inst/probeDelay1_reg[*]/D}]
