#include "summworkerthread.h"


SummWorkerThread::SummWorkerThread(SummAlgorithmCore *method, cv::Mat data, QString filename, QObject *parent) : QThread(parent)
{
    tubes = NULL;
    setMethod(method);
    setData(data, filename);
    setStatus(ST_UNPROCESSED);
}

void SummWorkerThread::run()
{
    setStatus(ST_PROCESSING);
    emit started(this);

    try
    {
        tubes = method->process(data, filename);
        setStatus(ST_DONE);
    }
    catch(...)
    {
        setStatus(ST_ERROR);
    }

    emit finished(this);
}

void SummWorkerThread::setData(cv::Mat & data, QString filename)
{
    assert(!data.empty());
    this->data = data;
    this->filename = filename;
}

void SummWorkerThread::setMethod(SummAlgorithmCore *method)
{
    assert(method != NULL);
    this->method = method;
}

void SummWorkerThread::setStatus(SummWorkerThread::Status status)
{
    bool changed = this->status != status;
    this->status = status;

    if(changed)
    {
        emit statusChanged(this, status);
    }
}

SummWorkerThread::Status SummWorkerThread::getStatus() const
{
    return status;
}

SummarizationFramework::Model::TubeCollectionPtr SummWorkerThread::getTubes() const
{
    return tubes;
}
