#ifndef SUMMALGORITHMCORE_H
#define SUMMALGORITHMCORE_H

#include <QString>
#include <QDebug>
#include "../SummarizationFramework/CommonTypes.h"
#include "../SummarizationFramework/Model/VideoSequence.h"
#include "../SummarizationFramework/Model/TubeCollection.h"
#include "../SummarizationFramework/TubeFeatures/Segmentation/FixedLengthIntervalLmFeatureSegmentator.h"
#include "../SummarizationFramework/TubeFeatures/Segmentation/CoverageDrivenLmFeatureSegmentator.h"
#include "../SummarizationFramework/TubeFeatures/Features/ITubeFeature.h"


/*===== Interfaces =====*/
class SummAlgorithmParams
{
public:
    virtual SummAlgorithmParams *clone() const = 0;
};

class SummAlgorithmCore
{
protected:
    int id;

public:
    SummAlgorithmCore(int id = -1);
    int getId() const;
    void setId(int id);
    virtual SummAlgorithmCore* clone() const = 0;
    virtual void setParams(SummAlgorithmParams *params) = 0;
    virtual SummAlgorithmParams *getParams() const = 0;
    virtual SummAlgorithmParams *createDefaultParams() const = 0;
    virtual SummarizationFramework::Model::TubeCollectionPtr process(cv::Mat & data, QString filename) = 0;
};


/*===== FixedLengthIntervalLmAlgorithm =====*/
class FixedLengthIntervalLmAlgorithmParams : public SummAlgorithmParams
{
public:
    int segmentLength;
    int segmentCount;
    int featureRowIndex;

    FixedLengthIntervalLmAlgorithmParams();
    virtual SummAlgorithmParams *clone() const;
};

class FixedLengthIntervalLmAlgorithmCore : public  SummAlgorithmCore
{
private:
    FixedLengthIntervalLmAlgorithmParams *params;

public:
    FixedLengthIntervalLmAlgorithmCore();
    virtual SummAlgorithmCore *clone() const;
    virtual void setParams(SummAlgorithmParams *params);
    virtual SummAlgorithmParams *getParams() const;
    virtual SummAlgorithmParams *createDefaultParams() const;
    virtual SummarizationFramework::Model::TubeCollectionPtr process(cv::Mat & data, QString filename);
};


/*===== CoverageDrivenLmFeatureSegmentator =====*/
class CoverageDrivenLmAlgorithmParams : public SummAlgorithmParams
{
public:
    int segmentLength;
    int segmentCount;
    int featureRowIndex;

    CoverageDrivenLmAlgorithmParams();
    virtual SummAlgorithmParams *clone() const;
};

class CoverageDrivenLmAlgorithmCore : public  SummAlgorithmCore
{
private:
    CoverageDrivenLmAlgorithmParams *params;

public:
    CoverageDrivenLmAlgorithmCore();
    virtual SummAlgorithmCore *clone() const;
    virtual void setParams(SummAlgorithmParams *params);
    virtual SummAlgorithmParams *getParams() const;
    virtual SummAlgorithmParams *createDefaultParams() const;
    virtual SummarizationFramework::Model::TubeCollectionPtr process(cv::Mat & data, QString filename);
};

#endif // SUMMALGORITHMCORE_H
