#include "paramswidgetfixedlengthlm.h"
#include "ui_paramswidgetfixedlengthlm.h"

ParamsWidgetFixedLengthLm::ParamsWidgetFixedLengthLm(QWidget *parent) :
    ParamsWidget(parent),
    ui(new Ui::ParamsWidgetFixedLengthLm)
{
    ui->setupUi(this);
}

ParamsWidgetFixedLengthLm::~ParamsWidgetFixedLengthLm()
{
    delete ui;
}

SummAlgorithmParams *ParamsWidgetFixedLengthLm::getParams()
{
    FixedLengthIntervalLmAlgorithmParams *params = new FixedLengthIntervalLmAlgorithmParams();
    params->segmentLength = ui->segmentLengthInput->value();
    params->segmentCount = ui->segmentsCountInput->value();
    params->featureRowIndex = ui->featureRowInput->value();

    return params;
}

void ParamsWidgetFixedLengthLm::setParams(SummAlgorithmParams *params)
{
    FixedLengthIntervalLmAlgorithmParams *paramsFixedLength = (FixedLengthIntervalLmAlgorithmParams *)params;

    ui->segmentLengthInput->setValue(paramsFixedLength->segmentLength);
    ui->segmentsCountInput->setValue(paramsFixedLength->segmentCount);
    ui->featureRowInput->setValue(paramsFixedLength->featureRowIndex);
}

void ParamsWidgetFixedLengthLm::on_segmentLengthInput_valueChanged(int arg1)
{
    Q_UNUSED(arg1);
    emit paramsChanged();
}

void ParamsWidgetFixedLengthLm::on_segmentsCountInput_valueChanged(int arg1)
{
    Q_UNUSED(arg1);
    emit paramsChanged();
}

void ParamsWidgetFixedLengthLm::on_featureRowInput_valueChanged(int arg1)
{
    Q_UNUSED(arg1);
    emit paramsChanged();
}
