#ifndef EXPORTWINDOW_H
#define EXPORTWINDOW_H

#include <QDialog>
#include <QString>
#include <QThread>
#include <QDebug>
#include "cvvideoplayer.h"
#include "../SummarizationFramework/Model/TubeCollection.h"
#include "../SummarizationFramework/Optimization/ScenarioSolver/StaticScenarioSolver.h"
#include "../SummarizationFramework/Model/NullVideoSequence.h"
#include "../SummarizationFramework/Presentation/StaticRenderer.h"


namespace Ui {
class ExportWindow;
class ExportWindowWorkerThread;
class FrameCreatedCallback;
}

class ExportWindowWorkerThread;

class FrameCreatedCallback : public SummarizationFramework::Presentation::IRenderer::FrameCreatedCallback
{
private:
    ExportWindowWorkerThread *worker;

public:
    FrameCreatedCallback::FrameCreatedCallback(ExportWindowWorkerThread *worker);
    virtual void OnFrameCreated(SummarizationFramework::Frame & frame, int no, int length);
};

class ExportWindowWorkerThread : public QThread
{
    Q_OBJECT;

private:
    QString inputFile;
    QString outputFile;
    SummarizationFramework::Model::TubeCollectionPtr tubes;

signals:
    void started(ExportWindowWorkerThread *thread);
    void finished(ExportWindowWorkerThread *thread);
    void progressChanged(ExportWindowWorkerThread *thread, QImage frame, int progress);

public:
    ExportWindowWorkerThread(QString inputFile, QString outputFile, SummarizationFramework::Model::TubeCollectionPtr tubes, QObject *parent = NULL);
    void emitProgressChanged(QImage frame, int progress);
    void run();
};

class ExportWindow : public QDialog
{
    Q_OBJECT

public:
    explicit ExportWindow(QString inputFile, QString outputFile, SummarizationFramework::Model::TubeCollectionPtr tubes, QWidget *parent = 0);
    ~ExportWindow();

private slots:
    void on_cancelButton_clicked();
    void on_ExportWindow_finished(int result);
    void on_worker_started(ExportWindowWorkerThread *thread);
    void on_worker_finished(ExportWindowWorkerThread *thread);
    void on_worker_progressChanged(ExportWindowWorkerThread *thread, QImage frame, int progress);

private:
    Ui::ExportWindow *ui;
    ExportWindowWorkerThread *worker;
    QImage frame;

    void terminateWorker();
    void resizeEvent(QResizeEvent *e);
};

#endif // EXPORTWINDOW_H
