#ifndef CVVIDEOPLAYER_H
#define CVVIDEOPLAYER_H

#include <vector>
#include <QWidget>
#include <QImage>
#include <QDebug>
#include <QResizeEvent>
#include <QImage>
#include <opencv2/opencv.hpp>


namespace Ui {
class CvVideoPlayer;
}

class CvVideoPlayer : public QWidget
{
    Q_OBJECT

public:
    typedef std::vector<cv::Vec2i> PlaySchema;

    explicit CvVideoPlayer(QWidget *parent = 0);
    ~CvVideoPlayer();
    void open(QString filename, PlaySchema schema = PlaySchema());
    void close();
    void setSchema(PlaySchema schema = PlaySchema());
    int getPosition() const;
    bool setPosition(int frame);
    bool next();
    void previousSegment();    
    void nextSegment();
    static QImage matToQimage(cv::Mat & src);
    
signals:
    void positionChanged(int frame);

private:
    Ui::CvVideoPlayer *ui;
    QImage frame;
    cv::VideoCapture *capture;
    PlaySchema schema;
    int currentSegmentIdx;

    void readImage();
    int findNextSegmentIdx(int currentPos);

    void resizeEvent(QResizeEvent *e);
};

#endif // CVVIDEOPLAYER_H
