#pragma once
#ifndef COMMONTYPES_H
#define COMMONTYPES_H

#include <string>
#include <vector>
#include <opencv2/core/core.hpp>
#include "Exceptions.h"

namespace SummarizationFramework
{


typedef cv::Mat Frame;
typedef cv::Ptr<Frame> FramePtr;

typedef cv::Mat FrameMask;
typedef cv::Ptr<FrameMask> FrameMaskPtr;

typedef int FramePosition;
typedef cv::Size FrameSize;

struct FrameSpan {
	static FramePosition EmptyValue;

	FramePosition From;
	FramePosition To;
	
	FrameSpan(FramePosition from = EmptyValue, FramePosition to = EmptyValue)
	{
		From = from;
		To = to;
	}

	int GetLength() const
	{
		return To - From + 1;
	}

	FrameSpan Intersect(FrameSpan & other) const
	{
		if(!IsIntersecting(other))
		{
			return FrameSpan();
		}
	
		return FrameSpan(MAX(From, other.From), MIN(To, other.To));
	}

	bool IsEmpty() const
	{
		return From == EmptyValue || To == EmptyValue;
	}

	bool IsIntersecting(FrameSpan & other) const
	{
		return From <= other.To && To >= other.From;
	}
};

#ifndef QT
SummarizationFramework::FramePosition SummarizationFramework::FrameSpan::EmptyValue = -1;
#endif


}

#endif // COMMONTYPES_H
