/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.ar.pl;

import android.app.Activity;
import android.content.pm.ApplicationInfo;
import android.content.res.Configuration;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemTools {
    public static final int AR_ERROR_NONE = 0;
    public static final int AR_ERROR_UNKNOWN = 1;
    public static final int AR_ERROR_INVALID_VALUE = 2;
    public static final int AR_ERROR_INVALID_ENUM = 3;
    public static final int AR_ERROR_INVALID_HANDLE = 4;
    public static final int AR_ERROR_INVALID_OPERATION = 5;
    public static final int AR_ERROR_OPERATION_FAILED = 6;
    public static final int AR_ERROR_OPERATION_CANCELED = 7;
    public static final int AR_ERROR_OPERATION_TIMEOUT = 8;
    public static final int AR_DEVICE_ORIENTATION_UNKNOWN = 0x10005010;
    public static final int AR_DEVICE_ORIENTATION_0 = 268455954;
    public static final int AR_DEVICE_ORIENTATION_180 = 268455955;
    public static final int AR_DEVICE_ORIENTATION_90 = 268455956;
    public static final int AR_DEVICE_ORIENTATION_270 = 0x10005015;
    public static final int AR_VIDEOTEXTURE_ROTATION_UNKNOWN = 0x10005010;
    public static final int AR_RENDERING_TEXTURE_ROTATION_AUTO = 0x10005011;
    public static final int AR_RENDERING_TEXTURE_ROTATION_PORTRAIT = 268455954;
    public static final int AR_RENDERING_TEXTURE_ROTATION_PORTRAIT_UPSIDEDOWN = 268455955;
    public static final int AR_RENDERING_TEXTURE_ROTATION_LANDSCAPE_LEFT = 268455956;
    public static final int AR_RENDERING_TEXTURE_ROTATION_LANDSCAPE_RIGHT = 0x10005015;
    private static final String MODULENAME = "SystemTools";

    public static native void setSystemErrorCode(int var0);

    public static native void logSystemError(String var0);

    public static native Activity getActivityFromNative();

    public static boolean checkMinimumApiLevel(int apiLevel) {
        return Build.VERSION.SDK_INT >= apiLevel;
    }

    public static void sendKillSignal() {
        final Activity activity = SystemTools.getActivityFromNative();
        activity.runOnUiThread(new Runnable(){

            public void run() {
                try {
                    Method method = activity.getClass().getDeclaredMethod("onPause", new Class[0]);
                    method.setAccessible(true);
                    method.invoke((Object)activity, new Object[0]);
                    method = activity.getClass().getDeclaredMethod("onDestroy", new Class[0]);
                    method.setAccessible(true);
                    method.invoke((Object)activity, new Object[0]);
                }
                catch (Exception e) {
                    SystemTools.logSystemError("Error attempting to call onPause and onDestroy, will proceed with exiting");
                    SystemTools.logSystemError(e.getCause().toString());
                    for (StackTraceElement i : e.getStackTrace()) {
                        SystemTools.logSystemError(i.toString());
                    }
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.exit(0);
            }
        });
    }

    public static Method retrieveClassMethod(Class<?> cls, String name, Class<?> ... parameterTypes) {
        Method classMethod = null;
        try {
            classMethod = cls.getMethod(name, parameterTypes);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (classMethod != null) {
            // empty if block
        }
        return classMethod;
    }

    public static int getDeviceOrientation(Activity activity) {
        if (activity == null) {
            return 0x10005010;
        }
        Configuration config = activity.getResources().getConfiguration();
        Display display = ((WindowManager)activity.getSystemService("window")).getDefaultDisplay();
        int displayRotation = SystemTools.checkMinimumApiLevel(8) ? display.getRotation() : display.getOrientation();
        int activityOrientation = displayRotation == 0 ? 268455954 : (displayRotation == 1 ? 268455956 : (displayRotation == 2 ? 268455955 : (displayRotation == 3 ? 0x10005015 : 0x10005010)));
        return activityOrientation;
    }

    public static int getActivityOrientation(Activity activity) {
        if (activity == null) {
            return 0x10005010;
        }
        Configuration config = activity.getResources().getConfiguration();
        Display display = ((WindowManager)activity.getSystemService("window")).getDefaultDisplay();
        int displayRotation = SystemTools.checkMinimumApiLevel(8) ? display.getRotation() : display.getOrientation();
        int activityOrientation = 0x10005010;
        switch (config.orientation) {
            case 1: 
            case 3: {
                activityOrientation = displayRotation == 0 || displayRotation == 3 ? 268455954 : 268455955;
                break;
            }
            case 2: {
                activityOrientation = displayRotation == 0 || displayRotation == 1 ? 268455956 : 0x10005015;
                break;
            }
        }
        return activityOrientation;
    }

    public static String getNativeLibraryPath(Activity activity) {
        if (activity == null) {
            return null;
        }
        String path = null;
        try {
            ApplicationInfo appInfo = activity.getApplicationInfo();
            if (appInfo != null) {
                if (SystemTools.checkMinimumApiLevel(9)) {
                    path = appInfo.nativeLibraryDir;
                    if (path != null && path.length() > 0 && path.charAt(path.length() - 1) != '/') {
                        path = path + '/';
                    }
                } else {
                    path = "/data/data/" + activity.getPackageName() + "/lib/";
                }
            }
        }
        catch (Exception e) {
            return null;
        }
        return path;
    }

    public static int[] getActivitySize(Activity activity) {
        if (activity == null) {
            return null;
        }
        DisplayMetrics metrics = new DisplayMetrics();
        activity.getWindowManager().getDefaultDisplay().getMetrics(metrics);
        int screenWidth = metrics.widthPixels;
        int screenHeight = metrics.heightPixels;
        if (screenWidth > 0 && screenHeight > 0) {
            int[] screenSize = new int[]{screenWidth, screenHeight};
            return screenSize;
        }
        return null;
    }
}

