/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.ar.pl;

import java.io.File;
import java.io.UnsupportedEncodingException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;

public class ARHttpRequest {
    private static final String MODULENAME = "ARHttpRequest";
    public String url;
    public String method;
    public String[] headers;
    boolean isQuery;
    public String contentType = null;
    public String contentEncoding = null;
    public String contentPath = null;
    public byte[] content = null;
    public long nativeRequestPtr;

    public static HttpUriRequest createHttpRequest(ARHttpRequest arRequest) throws UnsupportedEncodingException {
        if (arRequest.method.equals("POST")) {
            HttpPost httpPost = new HttpPost(arRequest.url);
            for (int i = 0; i < arRequest.headers.length / 2; ++i) {
                httpPost.addHeader(arRequest.headers[2 * i], arRequest.headers[2 * i + 1]);
            }
            if (!arRequest.isQuery) {
                if (arRequest.contentPath != null) {
                    FileEntity entity = new FileEntity(new File(arRequest.contentPath), arRequest.contentType);
                    httpPost.setEntity((HttpEntity)entity);
                } else if (arRequest.content != null) {
                    ByteArrayEntity bae = new ByteArrayEntity(arRequest.content);
                    bae.setContentType(arRequest.contentType);
                    ByteArrayEntity entity = bae;
                    httpPost.setEntity((HttpEntity)entity);
                }
            } else {
                StringEntity entity = new StringEntity("", "UTF-8");
                httpPost.setEntity((HttpEntity)entity);
            }
            return httpPost;
        }
        if (arRequest.method.equals("GET")) {
            HttpGet httpGet = new HttpGet(arRequest.url);
            for (int i = 0; i < arRequest.headers.length / 2; ++i) {
                httpGet.addHeader(arRequest.headers[2 * i], arRequest.headers[2 * i + 1]);
            }
            return httpGet;
        }
        throw new UnsupportedOperationException("Attemped to use an unsupported HTTP operation");
    }
}

