/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.QCARUnityPlayer;

import android.app.Activity;
import android.content.res.AssetManager;
import android.os.AsyncTask;
import com.qualcomm.QCAR.QCAR;
import com.qualcomm.QCARUnityPlayer.DebugLog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class QCARPlayerSharedActivity {
    private static final int APPSTATUS_UNINITED = -1;
    private static final int APPSTATUS_INIT_APP = 0;
    private static final int APPSTATUS_INIT_QCAR = 1;
    private static final int APPSTATUS_INIT_UNITY = 2;
    private static final int APPSTATUS_INITED = 3;
    private static final String NATIVE_LIB_UNITYPLAYER = "QCARUnityPlayer";
    private static final String NATIVE_LIB_QCARWRAPPER = "QCARWrapper";
    private static final String NATIVE_LIB_QCAR = "Vuforia";
    private int mAppStatus = -1;
    private InitQCARTask mInitQCARTask;
    private InitUnityTask mInitUnityTask;
    private Object mShutdownLock = new Object();
    private int mQCARFlags = 0;
    private IUnityInitializer mUnityInitializer;
    private Activity mActivity;

    public native void setErrorCode(int var1);

    public void onCreate(Activity activity, int gles_mode, IUnityInitializer unityInitializer) {
        this.mActivity = activity;
        this.mUnityInitializer = unityInitializer;
        int n = this.mQCARFlags = gles_mode == 1 ? 1 : 2;
        if (QCAR.isInitialized()) {
            QCAR.setInitParameters((Activity)this.mActivity, (int)this.mQCARFlags);
            this.updateApplicationStatus(2);
        } else {
            this.updateApplicationStatus(0);
        }
    }

    public void onResume() {
        QCAR.onResume();
    }

    public void onPause() {
        QCAR.onPause();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDestroy() {
        if (this.mInitQCARTask != null && this.mInitQCARTask.getStatus() != AsyncTask.Status.FINISHED) {
            this.mInitQCARTask.cancel(true);
            this.mInitQCARTask = null;
        }
        if (this.mInitUnityTask != null && this.mInitUnityTask.getStatus() != AsyncTask.Status.FINISHED) {
            this.mInitUnityTask.cancel(true);
            this.mInitUnityTask = null;
        }
        Object object = this.mShutdownLock;
        synchronized (object) {
            QCAR.deinit();
        }
    }

    private synchronized void updateApplicationStatus(int appStatus) {
        if (this.mAppStatus == appStatus) {
            return;
        }
        this.mAppStatus = appStatus;
        switch (this.mAppStatus) {
            case 0: {
                this.initApplication();
                this.updateApplicationStatus(1);
                break;
            }
            case 1: {
                try {
                    this.mInitQCARTask = new InitQCARTask();
                    this.mInitQCARTask.execute(new Activity[]{this.mActivity});
                }
                catch (Exception e) {
                    DebugLog.LOGE("Initializing QCAR SDK failed");
                }
                break;
            }
            case 2: {
                try {
                    this.mInitUnityTask = new InitUnityTask();
                    this.mInitUnityTask.execute(new Void[0]);
                }
                catch (Exception e) {
                    DebugLog.LOGE("Initializing Unity failed");
                }
                break;
            }
            case 3: {
                System.gc();
                break;
            }
            default: {
                throw new RuntimeException("Invalid application state");
            }
        }
    }

    private native void initApplicationNative(int var1, int var2, int var3);

    private void initApplication() {
        int major = 0;
        int minor = 0;
        int change = 0;
        try {
            String version = this.ReadUnityVersion();
            String[] versionSplit = version.split("\\.");
            major = Integer.parseInt(versionSplit[0]);
            minor = Integer.parseInt(versionSplit[1]);
            change = Integer.parseInt(versionSplit[2]);
        }
        catch (Exception e) {
            DebugLog.LOGW("Could not interpret unity version number: " + e.getMessage());
        }
        this.initApplicationNative(major, minor, change);
    }

    private String ReadUnityVersion() {
        FileReader fileReader;
        File filesDir;
        String unityVersion = "0.0.0";
        try {
            AssetManager assetManager = this.mActivity.getAssets();
            InputStreamReader inputStreamReader = new InputStreamReader(assetManager.open("QCAR/unity.txt"));
            unityVersion = QCARPlayerSharedActivity.ReadFileContents(inputStreamReader);
            DebugLog.LOGD("Found unity version file in activity assets.");
        }
        catch (Exception e) {
            DebugLog.LOGD("Could not find unity version file in activity assets: " + e.getMessage());
        }
        try {
            filesDir = this.mActivity.getFilesDir();
            fileReader = new FileReader(filesDir.getAbsolutePath() + "/unity.txt");
            unityVersion = QCARPlayerSharedActivity.ReadFileContents(fileReader);
            DebugLog.LOGD("Found unity version file in internal file dir.");
        }
        catch (Exception e) {
            DebugLog.LOGD("Could not find unity version file in internal file dir: " + e.getMessage());
        }
        try {
            filesDir = this.mActivity.getExternalFilesDir("");
            fileReader = new FileReader(filesDir.getAbsolutePath() + "/unity.txt");
            unityVersion = QCARPlayerSharedActivity.ReadFileContents(fileReader);
            DebugLog.LOGD("Found unity version file in external file dir.");
        }
        catch (Exception e) {
            DebugLog.LOGD("Could not find unity version file in external file dir: " + e.getMessage());
        }
        if (unityVersion.equals("0.0.0")) {
            DebugLog.LOGW("No unity version file found this time. This should only happen on first application start in some rare cases. A version file will be generated for the next application start");
        }
        return unityVersion;
    }

    private static String ReadFileContents(InputStreamReader inputStreamReader) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String ret = bufferedReader.readLine();
        bufferedReader.close();
        return ret;
    }

    public static boolean loadLibrary(String nLibName) {
        try {
            System.loadLibrary(nLibName);
            return true;
        }
        catch (UnsatisfiedLinkError ulee) {
            DebugLog.LOGE("The library lib" + nLibName + ".so could not be loaded: " + ulee.toString());
        }
        catch (SecurityException se) {
            DebugLog.LOGE("The library lib" + nLibName + ".so was not allowed to be loaded");
        }
        return false;
    }

    static {
        QCARPlayerSharedActivity.loadLibrary(NATIVE_LIB_QCAR);
        QCARPlayerSharedActivity.loadLibrary(NATIVE_LIB_QCARWRAPPER);
        QCARPlayerSharedActivity.loadLibrary(NATIVE_LIB_UNITYPLAYER);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InitUnityTask
    extends AsyncTask<Void, Integer, Boolean> {
        private InitUnityTask() {
        }

        protected Boolean doInBackground(Void ... params) {
            return true;
        }

        protected void onPostExecute(Boolean result) {
            DebugLog.LOGI("Initializing UnityPlayer");
            QCARPlayerSharedActivity.this.mUnityInitializer.InitializeUnity();
            QCARPlayerSharedActivity.this.updateApplicationStatus(3);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InitQCARTask
    extends AsyncTask<Activity, Integer, Boolean> {
        private int mProgressValue = -1;

        private InitQCARTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground(Activity ... params) {
            Object object = QCARPlayerSharedActivity.this.mShutdownLock;
            synchronized (object) {
                if (QCAR.isInitialized()) {
                    DebugLog.LOGD("InitQCARTask::doInBackground: forcing QCAR deinitialization");
                    QCAR.deinit();
                }
                QCAR.setInitParameters((Activity)(params.length > 0 ? params[0] : null), (int)QCARPlayerSharedActivity.this.mQCARFlags);
                do {
                    this.mProgressValue = QCAR.init();
                    this.publishProgress(new Integer[]{this.mProgressValue});
                } while (!this.isCancelled() && this.mProgressValue >= 0 && this.mProgressValue < 100);
                return this.mProgressValue > 0;
            }
        }

        protected void onProgressUpdate(Integer ... values) {
        }

        protected void onPostExecute(Boolean result) {
            if (result.booleanValue()) {
                DebugLog.LOGI("QCAR initialization successful");
                QCARPlayerSharedActivity.this.updateApplicationStatus(2);
            } else {
                DebugLog.LOGE("QCAR initialization failed");
                QCARPlayerSharedActivity.this.mUnityInitializer.InitializeUnity();
                QCARPlayerSharedActivity.this.setErrorCode(this.mProgressValue);
            }
        }
    }

    public static interface IUnityInitializer {
        public void InitializeUnity();
    }
}

