/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.QCARUnityPlayer;

import android.app.Activity;
import android.app.NativeActivity;
import android.content.ContextWrapper;
import android.content.res.Configuration;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import com.qualcomm.QCARUnityPlayer.QCARPlayerSharedActivity;
import com.unity3d.player.UnityPlayer;
import java.lang.reflect.Method;

public class QCARPlayerNativeActivity
extends NativeActivity {
    private QCARPlayerSharedActivity mQCARShared;
    protected UnityPlayer mUnityPlayer;

    protected void onCreate(Bundle savedInstanceState) {
        this.requestWindowFeature(1);
        this.mUnityPlayer = new UnityPlayer((ContextWrapper)this);
        super.onCreate(savedInstanceState);
        this.mQCARShared = new QCARPlayerSharedActivity();
        int gles_mode = this.mUnityPlayer.getSettings().getInt("gles_mode", 1);
        this.mQCARShared.onCreate((Activity)this, gles_mode, new UnityInitializer());
        this.getWindow().takeSurface(null);
        this.setTheme(16973831);
        this.getWindow().setFormat(4);
        if (this.mUnityPlayer.getSettings().getBoolean("hide_status_bar", true)) {
            this.getWindow().setFlags(1024, 1024);
        }
    }

    protected void onDestroy() {
        this.mQCARShared.onDestroy();
        this.mUnityPlayer.quit();
        super.onDestroy();
    }

    protected void onPause() {
        super.onPause();
        this.mUnityPlayer.pause();
        this.mQCARShared.onPause();
    }

    protected void onResume() {
        super.onResume();
        this.mQCARShared.onResume();
        this.mUnityPlayer.resume();
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.mUnityPlayer.configurationChanged(newConfig);
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        super.onWindowFocusChanged(hasFocus);
        this.mUnityPlayer.windowFocusChanged(hasFocus);
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        if (event.getAction() == 2) {
            return this.mUnityPlayer.onKeyMultiple(event.getKeyCode(), event.getRepeatCount(), event);
        }
        return super.dispatchKeyEvent(event);
    }

    private class UnityInitializer
    implements QCARPlayerSharedActivity.IUnityInitializer {
        private UnityInitializer() {
        }

        public void InitializeUnity() {
            try {
                Class<?> cls = Class.forName("com.unity3d.player.UnityPlayer");
                Method method = cls.getMethod("init", Integer.TYPE, Boolean.TYPE);
                int glesMode = QCARPlayerNativeActivity.this.mUnityPlayer.getSettings().getInt("gles_mode", 1);
                boolean trueColor8888 = false;
                method.invoke((Object)QCARPlayerNativeActivity.this.mUnityPlayer, glesMode, trueColor8888);
            }
            catch (Exception e) {
                // empty catch block
            }
            View playerView = QCARPlayerNativeActivity.this.mUnityPlayer.getView();
            QCARPlayerNativeActivity.this.setContentView(playerView);
            playerView.requestFocus();
        }
    }
}

