# -*- coding: utf-8 -*-
# Signal handling
#
# Copyright (C) 2011 Michal Kajan, Libor Polčák, Petr Kramoliš
# 
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

"""
This module collects functions and classes related to signal handling
"""

import sys
python3 = sys.version_info >= (3,)

if python3:
    from . import log

import signal

class SignalException(Exception):
    pass

def signalExceptionHandler(signum, frame):
    """ Handler raises SignalException when a signal is caught """
    description = "Caught signal %d" % signum
    if python3:
        log.debug(description)
    raise SignalException(description)

def setHandlerForCommonSignals(handler):
    """ Sets given handler for signals for which it makes sense not to exit violently """
    signal.signal(signal.SIGALRM, handler)
    signal.signal(signal.SIGHUP, handler)
    signal.signal(signal.SIGINT, handler)
    signal.signal(signal.SIGQUIT, handler)
    signal.signal(signal.SIGABRT, handler)
    signal.signal(signal.SIGTERM, handler)
    signal.signal(signal.SIGUSR1, handler)
    signal.signal(signal.SIGUSR2, handler)
