# Class describing IRI message
#
# Copyright (C) 2011 Matěj Grégr, Michal Kajan, Libor Polčák, Vladimír Veselý
# 
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import time
from ..tools.time import periodToStructTime
from .nid import CreateNIDType

class IRI(object):

    def __init__(self, source, timestamp, iriType, iriDescription, nidCC):
        """ Constructor

        source - IRI module
        timestamp - time when comunication was intercept in IRI-IIF
        iriType - One of strings: IRI_BEGIN, IRI_END, IRI_REPORT, IRI_CONTINUE
        nidList - List of 2-tuples of NID-type, NID-value
        """
        self.__source = source
        self.__timestamp = float(timestamp)
        self.__iriType = iriType
        self.__iriDescription = iriDescription
        self.__nids = nidCC

    # Getters
    def getSource(self):
        return self.__source

    def getIRIType(self):
        return self.__iriType

    def getDescription(self):
        return self.__iriDescription

    def getTimestamp(self):
        return self.__timestamp

    def getNIDs(self):
        return self.__nids
