#include <iostream>
#include "common.h"
#include "ethernet.h"
#include "ipv6.h"
#include "ipv4.h"
#include "icmpv6.h"


int main()
{
	Ethernet *p = new Ethernet();
	Buffer *pkt = new Buffer();
	debug = 2;

	p->src("12:23:45:67:89:ab");
	p->dest("cd:ef:45:67:89:ab");

	IPv6 *ip6 = new IPv6();
	ip6->src("2001:718:802:809::93e5:90b");
	ip6->dest("2001:718:802:809::93e5:90c");
	p->attach(ip6);

#ifdef false
	ICMPv6ND_RA *ra = new ICMPv6ND_RA();
	NDOptionSourceLLA *slla= new NDOptionSourceLLA(p->src());
	ra->add_option(slla);
	NDOptionPrefixInfo *pi = new NDOptionPrefixInfo("2001:718:802:809::", 64);
	ra->add_option(pi);
	ip6->attach(ra);
#else
	ICMPv6ND_RS *rs = new ICMPv6ND_RS();
	ip6->attach(rs);
#endif
	if (!p->build(*pkt)) {
		cout << "build failed" << endl;
		return 0;
	}
	cout << "After build:" << endl;
	cout << ip6 << endl;
	cout << ip6->payload() << endl;
	cout << "Raw packet:" << endl;
	cout << pkt << endl;
	pkt->setup(pkt->length());

	Ethernet *de = new Ethernet();
	cout << "Decoded packet:" << endl;
	if (de->decode(*pkt)) {
		cout << "OK: " << de << endl;
		cout << "OK: " << de->payload() << endl;
		cout << "OK: " << de->payload()->payload() << endl;
	} else {
		cout << "FAIL Ethernet decode" << endl;
	}

}
