#include "common.h"
#include "ethernet.h"
#include "pcap.h"

#ifndef DEV
#define DEV "em0"
#endif

int main(int argc, char **argv)
{

	PCAP pcap;
	Ethernet *e = new Ethernet();
	Buffer buf;
	string dev(DEV);
	debug = 2;

	if (argc == 2) {
		dev = argv[1];
	} else 
	if (argc > 2) {
		cerr << argv[0] << ": [intf]" << endl;
		return 1;
	}
	if (!pcap.open(dev)) {
		cerr << "cannot open pcap device" << endl;
		return 1;
	}
	pcap.set_filter("icmp6 or ip6 proto 0");
	while (1) {
		if (!pcap.read(buf, dev)) continue;
		cout << buf << endl;
		if (e->decode(buf)) {
			cout << e << endl;
			if (e->payload()) {
				cout << e->payload() << endl;
				if (e->payload()->payload()) {
					cout << e->payload()->payload() << endl;
				}
			}
		}
		// free
	}
}
