/*****************************************************\
| File: packet_capture.h                              | 
| Author: Jan Drazil (xdrazi00)                       |
| Desc: Utility to capture data from uProbe exporter  |
|                                                     |
| Copyright (c) 2014 Brno University of Technology    |
\*****************************************************/


#include <stdint.h>

extern int verbose;
#ifdef ALLOW_VERBOSE
	#define VERBOSE(...) do{if(verbose)fprintf(stderr,__VA_ARGS__);}while(0)
#else
	#define VERBOSE(...) {}
#endif

#define GLOBAL_PCAP_HEADER_LEN 24
#define INI3_HEADER_SIZE 16
#define BUFF_SIZE 2048
#define PCAP_HEADER_ITEM_SIZE 16

uint8_t global_pcap_header_ini3[GLOBAL_PCAP_HEADER_LEN] = {0xd4, 0xc3, 0xb2, 0xa1, // Magic
                                                           0x02, 0x00, 0x04, 0x00, // Version 2.4
                                                           0x00, 0x00, 0x00, 0x00, // GMT timezone offset
                                                           0x00, 0x00, 0x00, 0x00, // Timestamp accurancy
                                                           0xff, 0xff, 0x00, 0x00, // Max length of packet - 65535
                                                           0x01, 0x00, 0x00, 0x00  // Link type - 150 - INI3
                                                          };

struct __attribute__ ((__packed__)) ini3_header {
    uint16_t blob_size;
    uint8_t interface;
    uint8_t reserved;
    uint32_t timestamp_s;
    uint32_t timestamp_ns;
    uint16_t RID0;
    uint16_t RID1;
};

struct __attribute__ ((__packed__)) pcap_packet_header {
    uint32_t ts_sec;         /* timestamp seconds */
    uint32_t ts_usec;        /* timestamp microseconds */
    uint32_t incl_len;       /* number of octets of packet saved in file */
    uint32_t orig_len;       /* actual length of packet */
};
