﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace DatabaseModule
{
    public partial class DatabaseTest : UserControl
    {

        public DatabaseModule.DatabaseModuleClass DatabaseUnit = new DatabaseModule.DatabaseModuleClass(); // empty connection

        public DatabaseTest()
        {
            InitializeComponent();
        }

        private void GUI_ShowAllPatients(Int32 P_ID = 0) 
        {
            datagridPatient.Rows.Clear();

            int cols = 7;
            datagridPatient.ColumnCount = cols;
            datagridPatient.Columns[0].Name = "#";
            datagridPatient.Columns[0].Width = 50;
            datagridPatient.Columns[1].Name = "P_ID";
            datagridPatient.Columns[1].Width = 50;
            datagridPatient.Columns[2].Name = "PIN"; 
            datagridPatient.Columns[2].Width = 100;
            datagridPatient.Columns[3].Name = "Name";
            datagridPatient.Columns[4].Name = "Surname";
            datagridPatient.Columns[5].Name = "Register";
            datagridPatient.Columns[6].Name = "Update";

            // Get list of all patients
            List<CommonBridge.Patient> patlist = DatabaseUnit.GetPatientList(null,P_ID);
            if (patlist != null && patlist.Count > 0)
            {
                string[] row = new string[cols];
                for (int i = 0; i < patlist.Count; i++)
                {
                    CommonBridge.Patient item = patlist[i];
                    row[0] = i.ToString();
                    row[1] = item.P_ID.ToString();
                    row[2] = item.PIN;
                    row[3] = item.name;
                    row[4] = item.surname;
                    row[5] = item.time_insert.ToString("yyyy-MM-dd HH:mm:ss");
                    row[6] = item.time_update.ToString("yyyy-MM-dd HH:mm:ss");
                    datagridPatient.Rows.Add(row);
                }
            }
        }

        private void GUI_ShowOnePatient(Int32 P_ID = 0)
        {
            datagridPatient.Rows.Clear();

            int cols = 7;
            datagridPatient.ColumnCount = cols;
            datagridPatient.Columns[0].Name = "#";
            datagridPatient.Columns[1].Name = "P_ID";
            datagridPatient.Columns[2].Name = "PIN";
            datagridPatient.Columns[3].Name = "Name";
            datagridPatient.Columns[4].Name = "Surname";
            datagridPatient.Columns[5].Name = "Register";
            datagridPatient.Columns[6].Name = "Update";

            // Get list of all patients
            CommonBridge.Patient item = DatabaseUnit.GetOnePatient(P_ID);
            if (item != null)
            {
                string[] row = new string[cols];
                row[0] = "-";
                row[1] = item.P_ID.ToString();
                row[2] = item.PIN;
                row[3] = item.name;
                row[4] = item.surname;
                row[5] = item.time_insert.ToString("yyyy-MM-dd HH:mm:ss");
                row[6] = item.time_update.ToString("yyyy-MM-dd HH:mm:ss");
                datagridPatient.Rows.Add(row);               
            }
        }

        private void GUI_ShowAllExamination(Int32 P_ID = 0)
        {
            // clear grid
            datagridExaminations.Rows.Clear();

            // set columns
            datagridExaminations.ColumnCount = 5;
            datagridExaminations.Columns[0].Name = "#";
            datagridExaminations.Columns[1].Name = "E_ID";
            datagridExaminations.Columns[2].Name = "P_ID";
            datagridExaminations.Columns[3].Name = "Exam Date";
            datagridExaminations.Columns[4].Name = "Slide";

            // Get list of all patients
            List<CommonBridge.Examination> examlist = DatabaseUnit.GetExaminationList(null,0, P_ID, "E_ID");

            if (examlist != null && examlist.Count > 0)
            {
                string[] row = new string[datagridExaminations.ColumnCount];
                for (int i = 0; i < examlist.Count; i++)
                {
                    CommonBridge.Examination item = examlist[i];

                    row[0] = i.ToString();
                    row[1] = item.E_ID.ToString();
                    row[2] = item.P_ID.ToString();
                    row[3] = item.time_insert.ToString();
                    row[4] = item.slide;

                    datagridExaminations.Rows.Add(row);
                }
            }
        }

        private void GUI_ShowOneExamination(Int32 E_ID = 0)
        {
            // clear grid
            datagridExaminations.Rows.Clear();

            // set columns
            datagridExaminations.ColumnCount = 5;
            datagridExaminations.Columns[0].Name = "#";
            datagridExaminations.Columns[1].Name = "E_ID";
            datagridExaminations.Columns[2].Name = "P_ID";
            datagridExaminations.Columns[3].Name = "Exam Date";
            datagridExaminations.Columns[4].Name = "Slide";

            // Get list of all patients
            CommonBridge.Examination item = DatabaseUnit.GetOneExamination(E_ID);

            if (item != null)
            {
                string[] row = new string[datagridExaminations.ColumnCount];

                row[0] = "-";
                row[1] = item.E_ID.ToString();
                row[2] = item.P_ID.ToString();
                row[3] = item.time_insert.ToString("yyyy-MM-dd HH:mm:ss");
                row[4] = item.slide;

                datagridExaminations.Rows.Add(row);
            }
        }

        private void GUI_ShowAllImages(Int32 E_ID = 0)
        {
            // clear grid
            datagridImages.Rows.Clear();

            // set columns
            datagridImages.ColumnCount = 6;
            datagridImages.Columns[0].Name = "#";
            datagridImages.Columns[1].Name = "I_ID";
            datagridImages.Columns[2].Name = "E_ID";
            datagridImages.Columns[3].Name = "Filename";
            datagridImages.Columns[4].Name = "Timestamp";
            datagridImages.Columns[5].Name = "Done";

            // Get list of all patients
            List<CommonBridge.CapturedImage> imglist = DatabaseUnit.GetImagesList(null, 0, E_ID);

            if (imglist != null && imglist.Count > 0)
            {
                string[] row = new string[datagridImages.ColumnCount];
                for (int i = 0; i < imglist.Count; i++)
                {
                    CommonBridge.CapturedImage item = imglist[i];

                    row[0] = i.ToString();
                    row[1] = item.I_ID.ToString();
                    row[2] = item.E_ID.ToString();
                    row[3] = item.filename;
                    row[4] = item.time_insert.ToString("yyyy-MM-dd HH:mm:ss");
                    row[5] = item.done.ToString();

                    datagridImages.Rows.Add(row);
                }
            }
        }

        private void GUI_ShowOneImage(Int32 I_ID)
        {
            // clear grid
            datagridImages.Rows.Clear();

            // set columns
            datagridImages.ColumnCount = 6;
            datagridImages.Columns[0].Name = "#";
            datagridImages.Columns[1].Name = "I_ID";
            datagridImages.Columns[2].Name = "E_ID";
            datagridImages.Columns[3].Name = "Filename";
            datagridImages.Columns[4].Name = "Timestamp";
            datagridImages.Columns[5].Name = "Done";

            // Get list of all patients
            CommonBridge.CapturedImage item = DatabaseUnit.GetOneImage(I_ID);

            if (item != null)
            {
                string[] row = new string[datagridImages.ColumnCount];

                row[0] = "-";
                row[1] = item.I_ID.ToString();
                row[2] = item.E_ID.ToString();
                row[3] = item.filename;
                row[4] = item.time_insert.ToString("yyyy-MM-dd HH:mm:ss");
                row[5] = item.done.ToString();
                datagridImages.Rows.Add(row);
            }
        }
        
        private void GUI_ShowOneSubImage(Int32 SI_ID)
        {
            // clear grid
            datagridSubimages.Rows.Clear();

            // set columns
            datagridSubimages.ColumnCount = 6;
            datagridSubimages.Columns[0].Name = "#";
            datagridSubimages.Columns[1].Name = "SI_ID";
            datagridSubimages.Columns[2].Name = "I_ID";
            datagridSubimages.Columns[3].Name = "Filename";
            datagridSubimages.Columns[4].Name = "Timestamp";
            datagridSubimages.Columns[5].Name = "Done";

            // Get list of all patients
            CommonBridge.CapturedSubImage item = DatabaseUnit.GetOneSubImage(SI_ID);

            if (item != null)
            {
                string[] row = new string[datagridImages.ColumnCount];

                row[0] = "";
                row[1] = item.SI_ID.ToString();
                row[2] = item.I_ID.ToString();
                row[3] = item.filename;
                row[4] = item.time_insert.ToString("yyyy-MM-dd HH:mm:ss");
                row[5] = item.done.ToString();
                datagridSubimages.Rows.Add(row);
            }
        }

        private void GUI_ShowAllSubImages(Int32 E_ID = 0)
        {
            // clear grid
            datagridSubimages.Rows.Clear();

            // set columns
            datagridSubimages.ColumnCount = 6;
            datagridSubimages.Columns[0].Name = "#";
            datagridSubimages.Columns[1].Name = "SI_ID";
            datagridSubimages.Columns[2].Name = "I_ID";
            datagridSubimages.Columns[3].Name = "Filename";
            datagridSubimages.Columns[4].Name = "Timestamp";
            datagridSubimages.Columns[5].Name = "Done";

            // Get list of all patients
            List<CommonBridge.CapturedSubImage> imglist = DatabaseUnit.GetSubImagesList(null, 0, E_ID);

            if (imglist != null && imglist.Count > 0)
            {
                string[] row = new string[datagridImages.ColumnCount];
                for (int i = 0; i < imglist.Count; i++)
                {
                    CommonBridge.CapturedSubImage item = imglist[i];

                    row[0] = i.ToString();
                    row[1] = item.SI_ID.ToString();
                    row[2] = item.I_ID.ToString();
                    row[3] = item.filename;
                    row[4] = item.time_insert.ToString("yyyy-MM-dd HH:mm:ss");
                    row[5] = item.done.ToString();

                    datagridSubimages.Rows.Add(row);
                }
            }
        }
        
        private void GUI_ShowAllNucleus(Int32 I_ID = 0)
        {
            // clear grid
            datagridNuclei.Rows.Clear();

            // set columns
            datagridNuclei.ColumnCount = 7;
            datagridNuclei.Columns[0].Name = "#";
            datagridNuclei.Columns[1].Name = "N_ID";
            datagridNuclei.Columns[2].Name = "I_ID";
            datagridNuclei.Columns[3].Name = "E_ID";
            datagridNuclei.Columns[4].Name = "Area";
            datagridNuclei.Columns[5].Name = "Width";
            datagridNuclei.Columns[6].Name = "Height"; ;

            // Get list of all nucleu
            List<CommonBridge.Nucleus> nucleulist = DatabaseUnit.GetNucleiList(null, 0, I_ID);

            if (nucleulist != null && nucleulist.Count > 0)
            {
                string[] row = new string[datagridNuclei.ColumnCount];
                for (int i = 0; i < nucleulist.Count; i++)
                {
                    CommonBridge.Nucleus one_nucleu = nucleulist[i];

                    row[0] = i.ToString();
                    row[1] = one_nucleu.N_ID.ToString();
                    row[2] = one_nucleu.I_ID.ToString();
                    row[3] = one_nucleu.E_ID.ToString();
                    row[4] = one_nucleu.area.ToString();
                    row[5] = one_nucleu.width.ToString();
                    row[6] = one_nucleu.height.ToString();

                    datagridNuclei.Rows.Add(row);
                }
            }
        }

        private void GUI_ShowOneNucleu(Int32 N_ID)
        {
            // clear grid
            datagridNuclei.Rows.Clear();

            // set columns
            datagridNuclei.ColumnCount = 7;
            datagridNuclei.Columns[0].Name = "#";
            datagridNuclei.Columns[1].Name = "N_ID";
            datagridNuclei.Columns[2].Name = "I_ID";
            datagridNuclei.Columns[3].Name = "E_ID";
            datagridNuclei.Columns[4].Name = "Area";
            datagridNuclei.Columns[5].Name = "Width";
            datagridNuclei.Columns[6].Name = "Height";

            // Get list of all patients
            CommonBridge.Nucleus one_nucleu = DatabaseUnit.GetOneNucleus(N_ID);

            if (one_nucleu != null)
            {
                string[] row = new string[datagridNuclei.ColumnCount];

                row[0] = "-";
                row[1] = one_nucleu.N_ID.ToString();
                row[2] = one_nucleu.I_ID.ToString();
                row[3] = one_nucleu.E_ID.ToString();
                row[4] = one_nucleu.area.ToString();
                row[5] = one_nucleu.width.ToString();
                row[6] = one_nucleu.height.ToString();

                datagridNuclei.Rows.Add(row);

            }
        }

        private void GUI_ShowAllSignals(Int32 N_ID = 0)
        {
            // clear grid
            datagridSignals.Rows.Clear();

            // set columns
            datagridSignals.ColumnCount = 6;
            datagridSignals.Columns[0].Name = "#";
            datagridSignals.Columns[1].Name = "S_ID";
            datagridSignals.Columns[2].Name = "N_ID";
            datagridSignals.Columns[3].Name = "Area";
            datagridSignals.Columns[4].Name = "x";
            datagridSignals.Columns[5].Name = "y";

            // Get list of all signals
            //List<CommonBridge.Signal> siglist = DatabaseUnit.GetSignalsList(0, C_ID, null, 10, 10);  // select 10 items, offset 10, order by unknown
            List<CommonBridge.Signal> siglist = DatabaseUnit.GetSignalsList(0, N_ID);

            if (siglist != null && siglist.Count > 0)
            {
                string[] row = new string[datagridSignals.ColumnCount];
                for (int i = 0; i < siglist.Count; i++)
                {
                    CommonBridge.Signal item = siglist[i];

                    row[0] = i.ToString();
                    row[1] = item.S_ID.ToString();
                    row[2] = item.N_ID.ToString();
                    row[3] = item.area.ToString();
                    row[4] = item.x.ToString();
                    row[5] = item.y.ToString();

                    datagridSignals.Rows.Add(row);
                }
            }
        }

        private void GUI_ShowOneSignal(Int32 S_ID)
        {
            // clear grid
            datagridSignals.Rows.Clear();

            // set columns
            datagridSignals.ColumnCount = 6;
            datagridSignals.Columns[0].Name = "#";
            datagridSignals.Columns[1].Name = "S_ID";
            datagridSignals.Columns[2].Name = "N_ID";
            datagridSignals.Columns[3].Name = "Area";
            datagridSignals.Columns[4].Name = "x";
            datagridSignals.Columns[5].Name = "y";

            // Get list of all patients
            CommonBridge.Signal item = DatabaseUnit.GetOneSignal(S_ID);

            if (item != null)
            {
                string[] row = new string[datagridSignals.ColumnCount];
                row[0] = "-";
                row[1] = item.S_ID.ToString();
                row[2] = item.N_ID.ToString();
                row[3] = item.area.ToString();
                row[4] = item.x.ToString();
                row[5] = item.y.ToString();
                datagridSignals.Rows.Add(row);
            }
        }


        private void btnLoadAllPatients_Click(object sender, EventArgs e)
        { 
            GUI_ShowAllPatients();
        }

        private void btnLoadThisPatient_Click(object sender, EventArgs e)
        {
            GUI_ShowOnePatient(Convert.ToInt32(tb_P_ID.Text));
        }


        private void btnLoadAllExamination_Click(object sender, EventArgs e)
        {
            GUI_ShowAllExamination();             
        }

        private void btnLoadOneExamination_Click(object sender, EventArgs e)
        {
            GUI_ShowAllExamination(Convert.ToInt32(tb_P_ID2.Text));
        }




        private void btnLoadAllCells_Click(object sender, EventArgs e)
        {
            GUI_ShowAllNucleus();
        }   
     

        private void btnLoadAllImages_Click(object sender, EventArgs e)
        {
            GUI_ShowAllImages();
        }

        private void btnLoadImagesExams_Click(object sender, EventArgs e)
        {
            GUI_ShowAllImages(Convert.ToInt32(tb_E_ID.Text));
        }

        private void btnLoadCellsImage_Click(object sender, EventArgs e)
        {
            GUI_ShowAllNucleus(Convert.ToInt32(tb_I_ID.Text));
        }

        private void btnLoadOneExam_Click(object sender, EventArgs e)
        {
            GUI_ShowOneExamination(Convert.ToInt32(tb_E_ID1.Text));
        }

        private void btnLoadOneImage_Click(object sender, EventArgs e)
        {
            GUI_ShowOneImage(Convert.ToInt32(tb_I_ID1.Text));
        }

        private void btnLoadOneCell_Click(object sender, EventArgs e)
        {
            GUI_ShowOneNucleu(Convert.ToInt32(tb_N_ID1.Text));
        }

        private void btnLoadAllSignals_Click(object sender, EventArgs e)
        {
            GUI_ShowAllSignals();
        }

        private void btnLoadSignalsCell_Click(object sender, EventArgs e)
        {
            GUI_ShowAllSignals(Convert.ToInt32(tb_N_ID2.Text));
        }

        private void btnLoadOneSignal_Click(object sender, EventArgs e)
        {
            GUI_ShowOneSignal(Convert.ToInt32(tb_S_ID1.Text));
        }

        private void button1_Click(object sender, EventArgs e)
        {
            int rows = 0;
            int all_count = 0;
            string[] row;
            string query;

            // clear grid
            datagridCount.Rows.Clear();

            // set columns
            int cols = 3;
            datagridCount.ColumnCount = cols;
            datagridCount.Columns[0].Name = "#";
            datagridCount.Columns[1].Name = "Table name";
            datagridCount.Columns[1].Name = "Count";

            row = new string[cols];
            all_count = DatabaseUnit.CountAllPatients();
            row[0] = (rows++).ToString();
            row[1] = DatabaseUnit.GetTableName_Patient();
            row[2] = all_count.ToString();
            datagridCount.Rows.Add(row);

            row = new string[cols];
            all_count = DatabaseUnit.CountAllExaminations();
            row[0] = (rows++).ToString();
            row[1] = DatabaseUnit.GetTableName_Examination();
            row[2] = all_count.ToString();
            datagridCount.Rows.Add(row);

            row = new string[cols];
            all_count = DatabaseUnit.CountAllImages();
            row[0] = (rows++).ToString();
            row[1] = DatabaseUnit.GetTableName_Images();
            row[2] = all_count.ToString();
            datagridCount.Rows.Add(row);

            row = new string[cols];
            all_count = DatabaseUnit.CountAllNucleus();
            row[0] = (rows++).ToString();
            row[1] = DatabaseUnit.GetTableName_Nucleus();
            row[2] = all_count.ToString();
            datagridCount.Rows.Add(row);

            row = new string[cols];
            all_count = DatabaseUnit.CountAllSignals();
            row[0] = (rows++).ToString();
            row[1] = DatabaseUnit.GetTableName_Signals();
            row[2] = all_count.ToString();
            datagridCount.Rows.Add(row);

            row = new string[cols];
            all_count = DatabaseUnit.CountAllDemo("");
            row[0] = (rows++).ToString();
            row[1] = DatabaseUnit.GetTableName_Demo();
            row[2] = all_count.ToString();
            datagridCount.Rows.Add(row);


            
        }

        private void btnInsertPatient_Click(object sender, EventArgs e)
        {
            CommonBridge.Patient one_patient = new CommonBridge.Patient();
            one_patient.Set_Name(tbName.Text);
            one_patient.Set_Surname(tbSurname.Text);
            one_patient.Set_PIN(tbPIN.Text);

            if (DatabaseUnit.InsertOne(one_patient) > -1)
            {
                btnInsertPatient.BackColor = System.Drawing.Color.LightGreen;
            }
            else 
            { 
                btnInsertPatient.BackColor = System.Drawing.Color.LightCoral;
            }
        }

        private void btnLoadPatient_Click(object sender, EventArgs e)
        {
            // Get one patient
            CommonBridge.Patient one_patient = DatabaseUnit.GetOnePatient(System.Convert.ToInt32(tbPID.Text));
            if (one_patient != null)
            {
                tbPID.Text = one_patient.P_ID.ToString();
                tbPIN.Text = one_patient.PIN;
                tbName.Text = one_patient.name;
                tbSurname.Text = one_patient.surname;
            }
            else 
            {
                System.Windows.Forms.MessageBox.Show("Unknown P_ID >" + tbPID.Text +"<");
            }
        }

        private void btnUpdatePatient_Click(object sender, EventArgs e)
        {
            if (tbName.Text.Length == 0) return;
 
            CommonBridge.Patient one_patient = new CommonBridge.Patient();
            one_patient.Set_P_ID(tbPID.Text);
            one_patient.Set_Name(tbName.Text);
            one_patient.Set_Surname(tbSurname.Text);
            one_patient.Set_PIN(tbPIN.Text);

            if (DatabaseUnit.UpdateOne(one_patient)>0)
            {
                btnUpdatePatient.BackColor = System.Drawing.Color.LightGreen;
            }
            else
            {
                btnUpdatePatient.BackColor = System.Drawing.Color.LightCoral;
            }
        }

        private void btnPatientUpdateList_Click(object sender, EventArgs e)
        {
            
            // Get list of all patients
            List<CommonBridge.Patient> itemslist = DatabaseUnit.GetPatientList();

            // check if list exist
            if (itemslist != null && itemslist.Count > 0)
            {
                Random rnd = new Random();

                int i, items = itemslist.Count;
                for (i = 0; i < items; i++)
                {
                    CommonBridge.Patient item = itemslist[i];

                    // change PIN with random number
                    item.PIN = rnd.Next(1000000, 10000000).ToString();                     
                }

                // try to update
                if (DatabaseUnit.UpdateList(ref itemslist) > 0)
                {
                    btnPatientUpdateList.BackColor = System.Drawing.Color.LightGreen;
                }
                else
                {
                    btnPatientUpdateList.BackColor = System.Drawing.Color.LightCoral;
                }
            }            
        }

        private void btnPatientInsertList_Click(object sender, EventArgs e)
        {
            // Get list of all patients
            List<CommonBridge.Patient> itemslist = new List<CommonBridge.Patient>();

            // check if list exist
            if (itemslist != null)
            {
                Random rnd = new Random();

                int i, items = 3;
                for (i = 0; i < items; i++)
                {
                    CommonBridge.Patient item = new CommonBridge.Patient();

                    // change PIN with random number
                    item.PIN = rnd.Next(1000000, 10000000).ToString();
                    item.name = "jmeno" + rnd.Next(1000, 10000).ToString();
                    item.surname = "surname" + rnd.Next(1000, 10000).ToString();

                    itemslist.Add(item);
                }

                // try to update
                if (DatabaseUnit.InsertList(ref itemslist) > 0)
                {
                    btnPatientInsertList.BackColor = System.Drawing.Color.LightGreen;
                }
                else
                {
                    btnPatientInsertList.BackColor = System.Drawing.Color.LightCoral;
                }
            }     
        }

        private void btnLoadExam_Click(object sender, EventArgs e)
        {
            // Get one exam
            CommonBridge.Examination one_exam = DatabaseUnit.GetOneExamination(System.Convert.ToInt32(tbe_E_ID.Text));
            if (one_exam != null)
            {
                tbe_P_ID.Text = one_exam.P_ID.ToString();
                tbe_E_ID.Text = one_exam.E_ID.ToString();
                tbe_Slide.Text = one_exam.slide;
                tbe_Path.Text = one_exam.subdir;
                tbe_DateInsert.Text = one_exam.time_insert.ToString();
                tbe_DateUpdate.Text = one_exam.time_update.ToString();
            }
            else
            {
                System.Windows.Forms.MessageBox.Show("Unknown E_ID >" + tb_E_ID.Text + "<");
            }
        }

        private void btnUpdateList_Click(object sender, EventArgs e)
        {

        }

        private void btnInsertList_Click(object sender, EventArgs e)
        {

        }

        private void btnExamUpdateList_Click(object sender, EventArgs e)
        {
            // Get list of all patients
            List<CommonBridge.Examination> itemslist = DatabaseUnit.GetExaminationList();

            // check if list exist
            if (itemslist != null && itemslist.Count > 0)
            {
                Random rnd = new Random();

                int i, items = itemslist.Count;
                for (i = 0; i < items; i++)
                {
                    CommonBridge.Examination item = itemslist[i];

                    // change PIN with random number
                    item.slide = "slide" + rnd.Next(1000000, 10000000).ToString();
                }

                // try to update
                if (DatabaseUnit.UpdateList(ref itemslist) > 0)
                {
                    btnExamUpdateList.BackColor = System.Drawing.Color.LightGreen;
                }
                else
                {
                    btnExamUpdateList.BackColor = System.Drawing.Color.LightCoral;
                }
            }
        }

        private void btnExamInsertList_Click(object sender, EventArgs e)
        {
            // Get list of all patients
            List<CommonBridge.Examination> itemslist = new List<CommonBridge.Examination>();

            // check if list exist
            if (itemslist != null)
            {
                Random rnd = new Random();

                int i, items = 3;
                for (i = 0; i < items; i++)
                {
                    CommonBridge.Examination item = new CommonBridge.Examination();

                    // change PIN with random number
                    item.P_ID = rnd.Next(1, 20);
                    item.subdir = "path" + rnd.Next(1000, 10000).ToString();
                    item.slide = "slide" + rnd.Next(1000, 10000).ToString();

                    itemslist.Add(item);
                }

                // try to update
                if (DatabaseUnit.InsertList(ref itemslist) > 0)
                {
                    btnExamInsertList.BackColor = System.Drawing.Color.LightGreen;
                }
                else
                {
                    btnExamInsertList.BackColor = System.Drawing.Color.LightCoral;
                }
            }
        }

        private void btnUpdateImagesList_Click(object sender, EventArgs e)
        {
            // Get list of all images
            List<CommonBridge.CapturedImage> itemslist = DatabaseUnit.GetImagesList();

            // check if list exist
            if (itemslist != null && itemslist.Count > 0)
            {
                Random rnd = new Random();

                int i, items = itemslist.Count;
                for (i = 0; i < items; i++)
                {
                    CommonBridge.CapturedImage item = itemslist[i];

                    // change PIN with random number
                    item.filename = "file" + rnd.Next(1000000, 10000000).ToString() + ".jpg";
                }

                // try to update
                if (DatabaseUnit.UpdateList(ref itemslist) > 0)
                {
                    btnUpdateImagesList.BackColor = System.Drawing.Color.LightGreen;
                }
                else
                {
                    btnUpdateImagesList.BackColor = System.Drawing.Color.LightCoral;
                }
            }
        }

        private void btnUpdateCellList_Click(object sender, EventArgs e)
        {
            // Get list of all nucleu
            List<CommonBridge.Nucleus> itemslist = DatabaseUnit.GetNucleiList(null);

            // check if list exist
            if (itemslist != null && itemslist.Count > 0)
            {
                Random rnd = new Random();

                int i, items = itemslist.Count;
                for (i = 0; i < items; i++)
                {
                    CommonBridge.Nucleus item = itemslist[i];
            
                    item.area = rnd.Next(1000, 10000);
                    item.width = rnd.Next(100, 500);
                    item.height = rnd.Next(100, 500);
                }

                // try to update
                if (DatabaseUnit.UpdateList(ref itemslist) > 0)
                {
                    btnUpdateCellList.BackColor = System.Drawing.Color.LightGreen;
                }
                else
                {
                    btnUpdateCellList.BackColor = System.Drawing.Color.LightCoral;
                }
            }
        }

        private void btnUpdateSignalList_Click(object sender, EventArgs e)
        {
            // Get list of all images
            List<CommonBridge.Signal> itemslist = DatabaseUnit.GetSignalsList();

            // check if list exist
            if (itemslist != null && itemslist.Count > 0)
            {
                Random rnd = new Random();

                int i, items = itemslist.Count;
                for (i = 0; i < items; i++)
                {
                    CommonBridge.Signal item = itemslist[i];

                    item.area = rnd.Next(10, 50);
                    item.x = rnd.Next(10, 50);
                    item.y = rnd.Next(10, 50);
                    item.intensity = rnd.Next(10, 200);
                }

                // try to update
                if (DatabaseUnit.UpdateList(ref itemslist) > 0)
                {
                    btnUpdateSignalList.BackColor = System.Drawing.Color.LightGreen;
                }
                else
                {
                    btnUpdateSignalList.BackColor = System.Drawing.Color.LightCoral;
                }
            }
        }

        private void btnInsertImagesList_Click(object sender, EventArgs e)
        {
            // Get list of all patients
            List<CommonBridge.CapturedImage> itemslist = new List<CommonBridge.CapturedImage>();

            // check if list exist
            if (itemslist != null)
            {
                Random rnd = new Random();

                int i, items = 3;
                for (i = 0; i < items; i++)
                {
                    CommonBridge.CapturedImage item = new CommonBridge.CapturedImage();

                    // change PIN with random number
                    item.filename = "file" + rnd.Next(1000, 10000).ToString();

                    itemslist.Add(item);
                }

                // try to update
                if (DatabaseUnit.InsertList(ref itemslist) > 0)
                {
                    btnInsertImagesList.BackColor = System.Drawing.Color.LightGreen;
                }
                else
                {
                    btnInsertImagesList.BackColor = System.Drawing.Color.LightCoral;
                }
            }
        }

        private void btnInsertCellsList_Click(object sender, EventArgs e)
        {
            // Get list of all nucleus
            List<CommonBridge.Nucleus> itemslist = new List<CommonBridge.Nucleus>();

            // check if list exist
            if (itemslist != null)
            {
                Random rnd = new Random();

                int i, items = 3;
                for (i = 0; i < items; i++)
                {
                    CommonBridge.Nucleus item = new CommonBridge.Nucleus();

                    // change with random number
                    item.intensity = rnd.Next(50, 200);
                    item.x = rnd.Next(100, 200);
                    item.y = rnd.Next(100, 200);

                    itemslist.Add(item);
                }

                // try to update
                if (DatabaseUnit.InsertList(ref itemslist) > 0)
                {
                    btnInsertCellsList.BackColor = System.Drawing.Color.LightGreen;
                }
                else
                {
                    btnInsertCellsList.BackColor = System.Drawing.Color.LightCoral;
                }
            }
        }

        private void btnInsertSignalsList_Click(object sender, EventArgs e)
        {
            // Get list of all patients
            List<CommonBridge.Signal> itemslist = new List<CommonBridge.Signal>();

            // check if list exist
            if (itemslist != null)
            {
                Random rnd = new Random();

                int i, items = 3;
                for (i = 0; i < items; i++)
                {
                    CommonBridge.Signal item = new CommonBridge.Signal();

                    // change with random number  
                    item.intensity = rnd.Next(50, 200);
                    item.x = rnd.Next(100, 200);
                    item.y = rnd.Next(100, 200);

                    itemslist.Add(item);
                }

                // try to update
                if (DatabaseUnit.InsertList(ref itemslist) > 0)
                {
                    btnInsertSignalsList.BackColor = System.Drawing.Color.LightGreen;
                }
                else
                {
                    btnInsertSignalsList.BackColor = System.Drawing.Color.LightCoral;
                }
            }
        }

        private void btnTableExist_Click(object sender, EventArgs e)
        {
            Boolean tf = DatabaseUnit.ExistTable(DatabaseModuleClass.TableEnum.TABLE_DEMO);

            if (tf)
            {
                btnTableExist.BackColor = System.Drawing.Color.LightGreen;
            }
            else
            {
                btnTableExist.BackColor = System.Drawing.Color.LightCoral;
            }
        }

        private void btnTableCreate_Click(object sender, EventArgs e)
        {                  
            if (DatabaseUnit.CreateTable(DatabaseModuleClass.TableEnum.TABLE_DEMO))
            {
                btnTableCreate.BackColor = System.Drawing.Color.LightGreen;
            }
            else
            {
                btnTableCreate.BackColor = System.Drawing.Color.LightCoral;
            }
        }

        private void btnTableClear_Click(object sender, EventArgs e)
        {

            if (DatabaseUnit.ClearTable(DatabaseModuleClass.TableEnum.TABLE_DEMO))
            {
                btnTableClear.BackColor = System.Drawing.Color.LightGreen;
            }
            else
            {
                btnTableClear.BackColor = System.Drawing.Color.LightCoral;
            }
        }

        private void btnTableDrop_Click(object sender, EventArgs e)
        {

            if (DatabaseUnit.DropTable(DatabaseModuleClass.TableEnum.TABLE_DEMO))
            {
                btnTableDrop.BackColor = System.Drawing.Color.LightGreen;
            }
            else
            {
                btnTableDrop.BackColor = System.Drawing.Color.LightCoral;
            }
        }

        private void btnLoadAllSubimages_Click(object sender, EventArgs e)
        {
            GUI_ShowAllSubImages();
        }

        private void btnLoadSubimages_Click(object sender, EventArgs e)
        {
            GUI_ShowAllSubImages(Convert.ToInt32(tb_I_ID3.Text));
        }

        private void btnDeleteSignal_Click(object sender, EventArgs e)
        {
            DatabaseUnit.HardDeleteOneSignal(Convert.ToInt32(tb_S_ID1.Text));
        }

        private void btnDeleteMoreSignals_Click(object sender, EventArgs e)
        {
            DatabaseUnit.HardDeleteSignalsOfNucleus(Convert.ToInt32(tb_N_ID2.Text));
        }

        private void btnHardDeleteExam_Click(object sender, EventArgs e)
        {
            DatabaseUnit.CompleteSoftDeleteOneExamination(Convert.ToInt32(tb_E_ID1.Text));
        }

        private void btnSoftImage_Click(object sender, EventArgs e)
        {
            //tb_I_ID1;

            DatabaseUnit.CompleteSoftDeleteOneImage(Convert.ToInt32(tb_E_ID1.Text));

        }

        private void btnSoftDeletePatient_Click(object sender, EventArgs e)
        {

            DatabaseUnit.CompleteSoftDeleteOnePatient(Convert.ToInt32(tb_P_ID.Text));
        }
    }
}
