﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace GraphicModule
{
    
    public partial class ControlPatientTable : UserControl
    {
        
        public DatabaseModule.DatabaseModuleClass DatabaseUnit = new DatabaseModule.DatabaseModuleClass(); // empty connection

        int id_id = -1;
        int id_pid = -1;
        int id_pin = -1;
        int id_name = -1;
        int id_surname = -1;
        int id_register = -1;
        int id_update = -1;
        int id_count = -1;
        int id_state = -1;
        int id_comment = -1;
        
        Boolean gridUpdate = false;    

        public int actual_P_ID = -1;
        public int actual_E_ID = -1;

        public CommonBridge.Patient actual_patient = null;
        public CommonBridge.Examination actual_examination = null;

        public List<CommonBridge.Patient> patlist;
        public List<CommonBridge.Examination> examlist;


        // PATIENT
        /*
        public delegate void PatientSelected_CallbackHandle(Int32 selected_P_ID);
        public event PatientSelected_CallbackHandle PatientSelected_Callback = null;
        */

        public delegate void PatientSelectedEdit_CallbackHandle(Int32 selected_P_ID);
        public event PatientSelectedEdit_CallbackHandle PatientSelectedEdit_Callback = null;

        public delegate void PatientAddNew_CallbackHandle();
        public event PatientAddNew_CallbackHandle PatientAddNew_Callback = null;
          
         
        // EXAMINATION
        public delegate void ExaminationSelected_CallbackHandle(Int32 selected_E_ID);
        public event ExaminationSelected_CallbackHandle ExaminationSelected_Callback = null;

        public delegate void ExaminationSelectedEdit_CallbackHandle(Int32 selected_E_ID);
        public event ExaminationSelectedEdit_CallbackHandle ExaminationSelectedEdit_Callback = null;

        // add new examination for selected patient
        public delegate void ExaminationAddNew_CallbackHandle(Int32 selected_P_ID);
        public event ExaminationAddNew_CallbackHandle ExaminationAddNew_Callback = null;


        public ControlPatientTable()
        {
            InitializeComponent(); 
        }

        public void Init()
        {
            extable.DatabaseUnit = DatabaseUnit;
            
            actual_P_ID = -1;
            actual_patient = null;

            actual_E_ID = -1; 
            actual_examination = null;

            GUI_CreatePatientHeader();

            extable.ExaminationSelected_Callback += new ControlExaminationTable.ExaminationSelected_CallbackHandle(ExaminationSelected_Callback);
            extable.ExaminationSelectedEdit_Callback += new ControlExaminationTable.ExaminationSelectedEdit_CallbackHandle(ExaminationSelectedEdit_Callback);
            extable.ExaminationAddNew_Callback += new ControlExaminationTable.ExaminationAddNew_CallbackHandle(ExaminationAddNew_Callback);

            
            extable.GUI_CreateExaminationHeader();
            extable.btnAddNewExam.Visible = true;
        }

        /// <summary>
        /// 
        /// </summary>
        public void GUI_CreatePatientHeader() 
        {
            datagrid.Rows.Clear();

            int cols = 10;
            datagrid.ColumnCount = cols;   

            int j = 0;

            id_id = j++;
            datagrid.Columns[id_id].Name = "#";
            datagrid.Columns[id_id].Width = 20;

            id_pid = j++;
            datagrid.Columns[id_pid].Name = "PID";
            datagrid.Columns[id_pid].Width = 30;

            id_pin = j++;
            datagrid.Columns[id_pin].Name = "PIN";
            datagrid.Columns[id_pin].Width = 100;

            id_name = j++;
            datagrid.Columns[id_name].Name = "Name";
            datagrid.Columns[id_name].Width = 100;

            id_surname = j++;
            datagrid.Columns[id_surname].Name = "Surname";
            datagrid.Columns[id_surname].Width = 100;

            id_register = j++;
            datagrid.Columns[id_register].Name = "Register";
            datagrid.Columns[id_register].Width = 120;

            /*
            id_update = j++;
            datagrid.Columns[id_update].Name = "Update";
            datagrid.Columns[id_update].Width = 120;
            */

            id_count = j++;
            datagrid.Columns[id_count].Name = "Exams.";
            datagrid.Columns[id_count].Width = 50;
                                          
            id_state = j++;
            datagrid.Columns[id_state].Name = "State";
            datagrid.Columns[id_state].Width = 50;

            id_comment = j++;
            datagrid.Columns[id_comment].Name = "Comment";
            datagrid.Columns[id_comment].Width = 100;

            cols = j;
            datagrid.ColumnCount = cols;
        }

        /// <summary>
        /// 
        /// </summary>
        public void GUI_ShowAllPatients()
        {
            // create header
            GUI_CreatePatientHeader();             

            // Get list of all patients
            patlist = DatabaseUnit.GetPatientList(DatabaseUnit.GetTableViewName_Patient());
            if (patlist != null && patlist.Count > 0)
            {
                gridUpdate = true;
                // for every patient in lit
                for (int i= 0; i < patlist.Count; i++)
                {
                    // get one patient
                    CommonBridge.Patient item = patlist[i];

                    // and show item
                    GUI_ShowOnePatient(item,i);
                }
                gridUpdate = false;
            }

            if (patlist != null)
            {
                labCount.Text = String.Format("({0} pacientů)", patlist.Count);
            }
            else
            {
                labCount.Text = String.Format("(N/A pacientů)");
            }
            actual_E_ID = -1;

            // and selected row
            GUI_SelectedActualPatient();

            FindActualPatient();
        }

        public void GUI_ShowAllExamination() 
        {
            extable.GUI_ShowAllExamination();
        }

        public void GUI_ShowAllExamination(Int32 P_ID)
        {
            extable.GUI_ShowAllExamination(P_ID);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="item"></param>
        /// <param name="ID_ID"></param>
        public void GUI_ShowOnePatient(CommonBridge.Patient item, int ID_ID)
        {
            // check if item exist
            if (item != null) 
            {
                // count columns of table
                int cols = datagrid.ColumnCount;

                // create row string
                string[] row = new string[cols];
                
                // fill row string 
                if (id_id > -1) row[id_id] = ID_ID.ToString();
                if (id_pid > -1) row[id_pid] = item.P_ID.ToString();
                if (id_pin > -1) row[id_pin] = item.PIN;
                if (id_name > -1) row[id_name] = item.name;
                if (id_surname > -1) row[id_surname] = item.surname;
                if (id_register > -1) row[id_register] = item.time_insert.ToString();
                if(id_update>-1) row[id_update] = item.time_update.ToString();
                if (id_state > -1) row[id_state] = item.state.ToString();

                if (id_count > -1) row[id_count] = item.count_exams.ToString();

                if (id_comment>-1 && item.comment != null) 
                {                
                    if (item.comment.Length > 10)
                        row[id_comment] = item.comment.Substring(0, 10) + "...";
                    else
                        row[id_comment] = item.comment;
                }

                // insert row
                int row_index = datagrid.Rows.Add(row);
                datagrid.Rows[row_index].Tag = (Object)item.P_ID;

                if (id_comment>-1) datagrid.Rows[row_index].Cells[id_comment].ToolTipText = item.comment;//item.comment.Replace("\n", Environment.NewLine);
           
            }             
        }

        public void GUI_SelectedActualPatient()
        {
            datagrid.ClearSelection();

            if (actual_P_ID > -1)
            {

                try
                {
                    // find in rows P_ID
                    foreach (DataGridViewRow row in datagrid.Rows)
                    {
                        // compare P_ID with actual_P_ID
                        if (Convert.ToInt32(row.Tag) == actual_P_ID)
                        {
                            row.Selected = true;
                            break;
                        }
                    }                   
                }
                catch
                {
                    //
                }
            }
        }

        public bool FindActualPatient() 
        {
            bool tf = false;
            actual_patient = null;
            actual_examination = null;
            if (actual_P_ID > -1) 
            {            
                // find actual patient in list
                for (int i = 0; i < patlist.Count; i++)
                {
                    // get one patient
                    CommonBridge.Patient item = patlist[i];

                    if (actual_P_ID == item.P_ID)
                    {
                        actual_patient = item;                        
                        tf = true;
                    }                     
                }
            }

            if (actual_patient != null) label4.Text = actual_patient.name + "-->" + actual_patient.count_exams.ToString();
            else label4.Text = "ouuu";

            return tf;
        }



        private void OnPatientSelected()
        {
                        
            if (actual_P_ID > -1)
            {                                
                // delete examination
                actual_E_ID = -1;
                extable.GUI_ShowAllExamination(actual_P_ID);                 
            }
        }

        private void OnExaminationSelected()
        {
            /*
            if (PatientSelected_Callback != null)
            {
                PatientSelected_Callback(actual_P_ID);
            }
            */ 
            
            if (ExaminationSelected_Callback != null)
            {
                ExaminationSelected_Callback(actual_E_ID);
            } 
        }


        private void btnLoadAllPatients_Click(object sender, EventArgs e)
        {
            GUI_ShowAllPatients();
        }

        private void btnLoadThisPatient_Click(object sender, EventArgs e)
        {
            OnPatientSelected();
        }

        private void btnEditPatient_Click(object sender, EventArgs e)
        {
            if (actual_P_ID > -1)
            {
                if (PatientSelectedEdit_Callback != null)
                {
                    PatientSelectedEdit_Callback(actual_P_ID);
                }
            }       
        }
       
        private void datagrid_DoubleClick(object sender, EventArgs e)
        {
            if (datagrid.SelectedRows.Count > 0)
            {                 
                OnPatientSelected();
            }            
            
        }
              
        private void selectToolStripMenuItem_Click(object sender, EventArgs e)
        {
            OnPatientSelected();
        }

        private void editToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (actual_P_ID > -1)
            {
                if (PatientSelectedEdit_Callback != null)
                {
                    PatientSelectedEdit_Callback(actual_P_ID);
                }
            } 
        }

        private void datagrid_MouseDown(object sender, MouseEventArgs e)
        {
            // mousedown
            var hti = datagrid.HitTest(e.X, e.Y);
            //datagrid.ClearSelection();
            if (hti.RowIndex >= 0 && hti.RowIndex < datagrid.Rows.Count)
            {
                datagrid.Rows[hti.RowIndex].Selected = true;
            }
        }

        private void btnAddPatient_Click(object sender, EventArgs e)
        {
            if (PatientAddNew_Callback != null)
            {
                PatientAddNew_Callback();
            }
        }

        private void deleteToolStripMenuItem_Click(object sender, EventArgs e)
        {
            //CommonBridge.Patient item = DatabaseUnit.GetOnePatient(P_ID);

            if (actual_patient != null) 
            {
                // set valid = 1 ... deleted
                actual_patient.state = 1;
                int items = DatabaseUnit.UpdateOne(actual_patient);
                
                // if successfuly forget selected patient
                if (items > 0)
                {
                    actual_P_ID = -1;
                    actual_E_ID = -1;

                    GUI_ShowAllPatients();
                    OnPatientSelected();
                    
                    //GUI_ShowAllExamination(actual_P_ID);
                }
            }               

        }

        private void ControlPatientTable_Load(object sender, EventArgs e)
        {

        }



        private void btnLoadExamination_Click(object sender, EventArgs e)
        {
            OnExaminationSelected();
        }

        private void btnEditExamination_Click(object sender, EventArgs e)
        {
            if (actual_P_ID > -1 && actual_E_ID > -1)
            {
                if (ExaminationSelectedEdit_Callback != null)
                {
                    ExaminationSelectedEdit_Callback(actual_E_ID);
                }
            }
        }

        private void exeditMenuItem1_Click(object sender, EventArgs e)
        {
            if (actual_P_ID > -1 && actual_E_ID > -1)
            {    
                if (ExaminationSelectedEdit_Callback != null)
                {
                    ExaminationSelectedEdit_Callback(actual_E_ID);
                }
            }
        }

        private void btnNewExamination_Click(object sender, EventArgs e)
        {

        }

        private void exdeleteMenuItem1_Click(object sender, EventArgs e)
        {
            //CommonBridge.Patient item = DatabaseUnit.GetOnePatient(P_ID);

            if (actual_examination != null)
            {
                // set valid = 1 ... deleted
                actual_examination.state = 1;
                int items = DatabaseUnit.UpdateOne(actual_examination);

                // if successfuly forget selected patient
                if (items > 0)
                {                      
                    actual_E_ID = -1;

                    GUI_ShowAllPatients();
                    //OnPatientSelected();

                }
            }
        }

        private void tableLayoutPanel1_Paint(object sender, PaintEventArgs e)
        {

        }

        private void datagrid_RowEnter(object sender, DataGridViewCellEventArgs e)
        {

        }

        private void datagridex_RowEnter(object sender, DataGridViewCellEventArgs e)
        {  
            
        }

        private void datagrid_SelectionChanged(object sender, EventArgs e)
        {
            if (gridUpdate) return;
            if (datagrid.SelectedRows != null && datagrid.SelectedRows.Count > 0)
            {
                DataGridViewRow selected_row = datagrid.SelectedRows[0];
                if (selected_row.Index >= 0 && selected_row.Index < datagrid.Rows.Count)
                {
                    try
                    {
                        if (selected_row.Tag == null) return;
                        int new_actual_P_ID = System.Convert.ToInt32(selected_row.Tag);                        

                        labPID.Text = new_actual_P_ID.ToString();

                        // change P_ID?
                        if (new_actual_P_ID != actual_P_ID)
                        {
                            actual_P_ID = new_actual_P_ID;
                            actual_E_ID = -1;
                            extable.GUI_ShowAllExamination(actual_P_ID);
                            FindActualPatient();
                        }

                    }
                    catch
                    {
                        actual_P_ID = -1; actual_E_ID = -1;
                    }
                    labPID.Text = actual_P_ID.ToString();
                }
                else
                {
                    int b;
                }
            }

        }
  
    }
}
