﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Drawing;

using CommonBridge;

namespace GraphicModule
{
    public class GraphicModuleClass
    {

        // ------------------------------------------------------------------------------
        //
        //     TRANSLATOR MODULE
        //
        // ------------------------------------------------------------------------------
        // VARIABLE 
        internal TranslateModule.TranslateModuleClass Translator = null;

        /// <summary>
        /// Register translator to this module
        /// </summary>
        /// <param name="_Translator"></param>
        /// <returns></returns>
        public bool RegisterTranslator(TranslateModule.TranslateModuleClass _Translator)
        {
            Translator = _Translator;
            return true;
        }

        // ------------------------------------------------------------------------------
        //
        //     DATABASE MODULE
        //
        // ------------------------------------------------------------------------------      
        internal DatabaseModule.DatabaseModuleClass Database = null;
        public bool RegisterDatabase(DatabaseModule.DatabaseModuleClass _Database)
        {
            Database = _Database;
            return true;
        }

        // ------------------------------------------------------------------------------
        //
        //     COMPONENTS
        //
        // ------------------------------------------------------------------------------ 
        internal CellGraph cellGraph = null;
        internal Gallery gallery = null;
        internal RangeSelector rangeSelector = null;
        internal Buttons buttons = null;
        internal System.Windows.Forms.Timer timer = null;
        public bool RegisterComponents(CellGraph _cellGraph, Gallery _gallery, RangeSelector _rangeSelector, Buttons _buttons, System.Windows.Forms.Timer _timer)
        {
            cellGraph = _cellGraph;
            gallery = _gallery;
            rangeSelector = _rangeSelector;
            buttons = _buttons;
            timer = _timer;
            return true;
        }

        /// <summary>
        /// Wrapped translator function
        /// </summary>
        /// <param name="str">String for translation</param>
        /// <returns>translated text</returns>
        public string i18n(string str)
        {
            // default set output string
            string trans = "X:" + str;

            // if Translator exist, call i18n function
            if (Translator != null)
                trans = Translator.i18n(str);
            return trans;
        }


        // ------------------------------------------------------------------------------
        //
        //      VARIABLES
        //
        // -----------------------------------------------------------------------------

        // LOG
        String ModuleName = "";
        public LoggerModule.LoggerClass LogUnit = new LoggerModule.LoggerClass();

        private List<Nucleus> nucleus;
        private List<int>[] nucleus_IDs = new List<int>[4];

        // ------------------------------------------------------------------------------
        //
        //      DELEGATES
        //
        // -----------------------------------------------------------------------------



        // ------------------------------------------------------------------------------
        //
        //      FUNCTIONS
        //
        // -----------------------------------------------------------------------------
        /// <summary>
        /// Constructor
        /// </summary>
        public GraphicModuleClass()
        {
            ModuleName = this.ToString();                
        }

        /// <summary>
        /// Destructor
        /// </summary>
        ~GraphicModuleClass()
        {
            if (LogUnit != null)
            {
                LogUnit.LogDebug(ModuleName, "Destructor");
                LogUnit = null;
            }
        }


        /// <summary>
        /// 
        /// </summary>        
        public bool InitExamination(Int32 selected_E_ID) 
        {            
            try
            { 
            
            AxesRange ar;
            if (Database.CountAllNucleusOnView("nucleus_view.valid = 1") > 0)
                ar = Database.GetAxesRange();
            else
                ar = new AxesRange(-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1);

            rangeSelector.InitRangeSelector(ar, Database.GetHistogram("nucleus_view.eccentricity"), Database.GetHistogram("nucleus_view.area"), Database.GetHistogram("nucleus_view.intensity"),
                Database.GetHistogram("signals_view.dist_border"), Database.GetHistogram("nucleus_view.dist"), Database.GetHistogram("signals_view.intensity"), Database.GetHistogram("signals_view.area"), new DoubleTrackBar.CallbackHandler(RestartRefreshTimer));

            nucleus = Database.GetNucleiList("nucleus_view");
            
            for (int i = 0; i < 4; i++) nucleus_IDs[i] = new List<int>();
            UpdateNucleusByRange();

            CommonBridge.Examination selected_examination = Database.GetOneExamination(selected_E_ID);


            //gallery.InitGallery(Database.GetImagesList("images_view"), ref nucleus, ref nucleus_IDs, @"D:\projects\Genex\data\2014-10-29\preproc\");

            String path = @"d:\Galerie\GENEX\GENERATOR\" + selected_examination.subdir + "\\";

            gallery.InitGallery(Database.GetImagesList("images_view"), ref nucleus, ref nucleus_IDs, path);
            buttons.InitButtons(new Buttons.chCellShowChanged(gallery.ChangeCellStyle), new Buttons.chSaveChartButtonPressed(cellGraph.ExportChart));

            cellGraph.RefreshPieGraph(nucleus_IDs[0].Count, nucleus_IDs[1].Count, nucleus_IDs[2].Count, nucleus_IDs[3].Count);
            
            timer.Tick += new System.EventHandler((sender, e) => TickRefreshTimer(sender, e, nucleus));
return true;
            }
            catch(Exception exc)
            {
                System.Windows.Forms.MessageBox.Show(exc.Message);
                return false;
            }        

}

        public void ExitExamination() 
        {
            System.Windows.Forms.DialogResult dialogResult = System.Windows.Forms.MessageBox.Show("Save expert?", "Save", System.Windows.Forms.MessageBoxButtons.YesNo);
            if (dialogResult == System.Windows.Forms.DialogResult.Yes)
            {
                Database.UpdateNucleusByExpert(nucleus);            
            }
            
            
        }


        /// <summary>
        /// Load module configuration
        /// </summary>
        /// <param name="ini_filename"></param>
        /// <returns></returns>
        public bool LoadConfiguration(String ini_filename)
        {
            bool iniExist = false;
            INIFile ini = null;

            // try to open ini file (create new)
            try
            {
                ini = new INIFile(ini_filename, out iniExist);
            }
            catch (Exception exc)
            {
                System.Windows.Forms.MessageBox.Show(exc.Message, i18n("Exception") + "_" + this.ToString());
                return false;
            }

            if (iniExist)
            {
                try
                {
                    String str = "";
                    Boolean tf = true;

                    String SectionName = "SECTION";

                    str = ini.GetValue(SectionName, "Port","");

                    if (tf == false)
                    {
                        System.Windows.Forms.MessageBox.Show(i18n("Failed configuration") + "" + this.ToString());
                        return false;
                    }
                }
                catch (Exception exc)
                {
                    System.Windows.Forms.MessageBox.Show(exc.ToString());
                    return false;
                }
                return true;
            }
            else
            {
                return false;
            }
        }

        private bool ValueInRange(int val, float min_val, float max_val)
        {
            return val >= min_val && val <= max_val;
        }

        private bool ValueInRange(float val1, float val2, float min_val, float max_val)
        {
            return val1 >= min_val && val2 <= max_val;
        }

        private void UpdateNucleusByRange()
        {
            AxesRange ar = rangeSelector.GetRanges();

            for (int i = 0; i < 4; i++ )
            {
                nucleus_IDs[i].Clear();                
            }


            for (int i = 0; i < nucleus.Count(); i++)
            { 
                Nucleus n = nucleus[i];
                if (n.expert != ExpertType.no)
                { 
                    nucleus_IDs[(int)n.expert].Add(i);
                    continue;
                }

                if (n.type != NucleusType.bad && (ValueInRange(n.area, ar.min_nucleu_area, ar.max_nucleu_area) && 
                    ValueInRange(n.intensity, ar.min_nucleu_intensity, ar.max_nucleu_intensity) &&
                    ValueInRange(n.eccentricity, ar.min_nucleu_eccentricity, ar.max_nucleu_eccentricity) &&
                    ValueInRange(n.min_sig_area, n.max_sig_area, ar.min_signal_area, ar.max_signal_area) &&
                    ValueInRange(n.min_sig_inten, n.max_sig_inten, ar.min_signal_intensity, ar.max_signal_intensity) &&
                    ValueInRange(n.min_sig_dist, n.max_sig_dist, ar.min_signal_border_dist, ar.max_signal_border_dist) &&
                    (ValueInRange(n.dist, ar.min_signal_signal_dist, ar.max_signal_signal_dist) || n.dist == 0)))
                { 
                    //actual_ids[(int)n.type].Add(n.N_ID);
                    nucleus_IDs[(int)n.type].Add(i);
                }
                else
                    //actual_ids[(int)NucleuType.bad].Add(n.N_ID);
                    nucleus_IDs[(int)NucleusType.bad].Add(i);
            }
            
        }

        private void TickRefreshTimer(object sender, EventArgs e, List<Nucleus> nucleus)
        {
            timer.Stop();

            UpdateNucleusByRange();
            cellGraph.RefreshPieGraph(nucleus_IDs);
            gallery.UpdateGalleries(nucleus_IDs);
        }


        public void RestartRefreshTimer()
        {
            timer.Stop();
            timer.Start();
        }

        private void UpdateGraph()
        {
            cellGraph.RefreshPieGraph(nucleus_IDs);
        }



    }
}
