﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using CommonBridge;
//using DBconnection;

namespace GraphicModule
{
    public partial class CellGraph : UserControl
    {
        private int[] y_vals = { 0, 0, 0, 0 };
        private static string[] x_vals = { "Bad", "X", "XX", "XY" };
     
        public CellGraph()
        {
            InitializeComponent();
        }
       
        /// <summary>
        /// Update of the pie graph with actual axes range.
        /// </summary>   
        ///  <param name="range"> 
        /// Tolerated range of the axes with respect to statistic.
        ///  </param>
        public void RefreshPieGraph(int BADval, int Xval, int XXval, int XYval)            
        {
            y_vals[3] = XYval;
            y_vals[2] = XXval;
            y_vals[1] = Xval;
            y_vals[0] = BADval;

            chart.Series[0].Points.DataBindXY(x_vals, y_vals);
            chart.Update();
            //Console.WriteLine(y_vals[0] + " " + y_vals[1] + " " + y_vals[2] + " " + y_vals[3]);
            //Console.WriteLine(x_vals[0] + " " + x_vals[1] + " " + x_vals[2] + " " + x_vals[3]);
        }


        public void RefreshPieGraph(List<Nucleus> nucleus)
        {
            foreach (Nucleus n in nucleus)
            {
                y_vals[(int)n.type]++;
            }

            chart.Series[0].Points.DataBindXY(x_vals, y_vals);
            chart.Update();
            //Console.WriteLine(y_vals[0] + " " + y_vals[1] + " " + y_vals[2] + " " + y_vals[3]);
            //Console.WriteLine(x_vals[0] + " " + x_vals[1] + " " + x_vals[2] + " " + x_vals[3]);
        }


        public void RefreshPieGraph(List<int>[] nucleus_IDs)
        {
            y_vals[3] = nucleus_IDs[3].Count();
            y_vals[2] = nucleus_IDs[2].Count();
            y_vals[1] = nucleus_IDs[1].Count();
            y_vals[0] = nucleus_IDs[0].Count();

            chart.Series[0].Points.DataBindXY(x_vals, y_vals);
            chart.Update();
            //Console.WriteLine(y_vals[0] + " " + y_vals[1] + " " + y_vals[2] + " " + y_vals[3]);
            //Console.WriteLine(x_vals[0] + " " + x_vals[1] + " " + x_vals[2] + " " + x_vals[3]);
        }

        private void exportToolStripMenuItem_Click(object sender, EventArgs e)
        {
            ExportChart();
        }


        public int[] GetCellCounts()
        {
            return y_vals;
        }


        /// <summary>
        /// Export chart to jpg, bmp or png format.
        /// </summary>   
        public void ExportChart() 
        {
            SaveFileDialog saveFileDialog1 = new SaveFileDialog();
            saveFileDialog1.Filter = "JPeg Image|*.jpg|Bitmap Image|*.bmp|PNG Image|*.png";
            saveFileDialog1.Title = "Save an Image File";
            saveFileDialog1.ShowDialog();

            if (saveFileDialog1.FileName != "")
            {
                Bitmap bmp = new Bitmap(chart.Width, chart.Height, System.Drawing.Imaging.PixelFormat.Format32bppArgb);
                chart.DrawToBitmap(bmp, new Rectangle(0, 0, chart.Width, chart.Height));

                switch (saveFileDialog1.FilterIndex)
                {
                    case 1:
                        bmp.Save(saveFileDialog1.FileName, System.Drawing.Imaging.ImageFormat.Jpeg);
                        break;

                    case 2:
                        bmp.Save(saveFileDialog1.FileName, System.Drawing.Imaging.ImageFormat.Bmp);
                        break;

                    case 3:
                        bmp.MakeTransparent(this.BackColor);
                        bmp.Save(saveFileDialog1.FileName, System.Drawing.Imaging.ImageFormat.Png);
                        break;
                }
            }
        }
    }
}
