function F = lbp(X, P)
% F = LBP(X, P) calculated LBP transform of Xs.
%
% Is a parallel pool is available, samples are evaluated in parallel.
%
% Input:
% X     [MxNxCxK] Image matrix
% P     [5xU] LBP parameters. Each column corresponds to [m,n,mm,nn,c]'
%             feature parameters.
%
% Output
% F     [KxU] uint8 matrix with LBP responses
%

fprintf('Local Binary Patterns...'); start = clock;
if isempty(X), F=[]; return; end;
%{
[u,v,c,n]=size(X); batch=128; s=0; i=1; ns=[];
while s<n, ns(i)=min(batch,n-s);s=s+batch;i=i+1;end; %#ok<AGROW>
X1 = mat2cell(X,u,v,c,ns);
F = cell(1,length(ns));
parfor i = 1:length(ns), F{i}=lbp1(X1{i}, P); end;
F = vertcat(F{:});
%}
F = mexLBP(X, P, 1);
fprintf('done (time=%.0fs).\n',etime(clock,start));
end

function F = lbp1(X, P)
U = size(P,2); K = size(X,4); F = zeros(K, U, 'uint8');
if isempty(X), return; end;
P(1:2,:) = P(1:2,:) + 1; P(5,:) = P(5,:) + 1;
[u,v] = meshgrid(0:2,0:2); u = u(:); v = v(:);
data = zeros(9,K,'single');
wts =  [1 2 4 8 16 32 64 128]';
%wts =  [0 1 0 2  4  0  8   0]';
for f = 1:U % feature loop
    p = num2cell(P(:,f)); [m,n,mm,nn,k] = deal(p{:});
    for j = 1:9
        m0 = m + u(j)*mm; m1 = m0+mm-1;
        n0 = n + v(j)*nn; n1 = n0+nn-1;
        data(j,:) = sum(reshape(X(m0:m1,n0:n1,k,:),[],K),1);
    end
    C = bsxfun(@gt, data([1 2 3 4 6 7 8 9],:), data(5,:));
    F(:,f) = sum(bsxfun(@times, C, wts))';
end
end