#include <memory>
#include "lbpdetector_cv.h"
#include "detector.h"
#include "opencv2/opencv.hpp"
#include <json/json.h>


using namespace std;
using namespace cv;
using namespace LBPDetector;

int main(int argc, char** argv)
{
	// TODO: process options

    VideoCapture cap(argv[1]);
    if(!cap.isOpened()) return -1;

    // TODO: get video parameters - size, framerate

    Detector * D = loadDetectorPB("../tst.bin"); // FIXME: correct detector file
    
    Json::FastWriter writer;

    int f = 0;
    for(;;++f)
    {
        Mat frame;
        cap >> frame; // get a new frame
        if (!frame.data) break;
        // TODO: check if captured successfuly
        // TODO: get currect frame info - timestamp
        Detections dets = lbp_detect_image(frame, D, 10, 2, 0, 2, 0.5, 1, 1, 6, 0, 4, 256); // TODO: pass params


        Json::Value lst;
        lst["nFtrs"] = dets.nf;
        lst["nWins"] = dets.ns;
        lst["frame"] = f;
        Json::Value objs(Json::arrayValue);
        for (size_t j = 0; j < dets.bbs.size(); ++j)
        {
            cv::Rect & bb = dets.bbs[j]; float h = dets.hs[j];
            Json::Value bb1(Json::arrayValue);
            bb1.append(bb.x);
            bb1.append(bb.y);
            bb1.append(bb.width);
            bb1.append(bb.height);
            bb1.append(h);
            objs.append(bb1);
        }
        lst["bbs"] = objs;
        cout << writer.write(lst);


        for (auto bb:dets.bbs)
        {

            rectangle(frame, Point(bb.x,bb.y), Point((bb.x+bb.width), (bb.y+bb.height)),Scalar(0,255,0),3);
            rectangle(frame, Point(bb.x,bb.y), Point((bb.x+bb.width), (bb.y+bb.height)),0,2);
        }
        imshow("im", frame); waitKey(1);           
        

        // TODO: preview if required

    }

    destroyDetector(&D);

    return 0;
}