/*
 *
 * Roman Juranek <ijuranek@fit.vutbr.cz>
 * Faculty of Information Technology, BUT, Brno
 *
 */

#ifndef _COMMON_H_
#define _COMMON_H_

#include <algorithm>

// This is a general image representation structure compatible with MATLAB
// and OpenCV.
struct Image
{
private:
    void fillStrides()
    {
        strides[0] = 1;
        strides[1] = dims[0] * strides[0];
        strides[2] = dims[1] * strides[1];
    }
public:
    const float * data {0};
    int dims[3] {1,1,1};
    int strides[3] {1,1,1};
    bool init {false};
    Image(const float * d, int w, int h, int c=1)
        :data(d), dims{w,h,c}
    {
        if (!data) return;
        fillStrides();
        init = true;
    }
    Image(const float * d, int nd, const int * ds)
        :data(d)
    {
        if (!data || nd > 3) return;
        std::copy_n(ds, nd, dims);
        fillStrides();
        init = true;
    }
    Image(const Image & im)
        :data(im.data)
    {
        std::copy_n(im.dims, 3, dims);
        std::copy_n(im.strides, 3, strides);
        init = true;
    }
    ~Image() { }
    int getIndex(int d0, int d1, int d2 = 0) const
    {
        return d0*strides[0] + d1*strides[1] + d2*strides[2];
    }
};

#endif
