# Low-level API

`lbpdetector` implements the detector core - scanning an image and representation of results. *Nothing else*! 

```c++
LBPDetector::ScalarResult scalar_scan_image(
    const Image & im,
    const int x0, const int y0, const int x1, const int y1, const int stride,
    const Detector & D, const float scale, bool useCache);
```

- **im** Input image structure (see [common.h](common.h))
- **x0**,**y1**,**x1**,**y1** Rectangle in image to scan
- **stride** Spatial step of scanning window
- **D** The detector structure
- **scale** Scale of the image
- **useCache** Flag if LBP cache can be used

# OpenCV API for LBPDetector

The low level API does not care much about *how* the image was created, it just scans the given data and returns the result. OpenCV API implements basic pyramid structure (with many options) and multi-thread scanning of the pyramid.

```c++
Detections lbpDetectImage(
    cv::Mat & im,
    LBPDetector::Detector * detector, LBPDetector::ChnsParams & pChns, 
    float thr = 0, int stride = 1,
    int group = 1, float overlap = 0.5f, float scaleX = 1.0f, float scaleY = 1.0f,
    unsigned int nThreads = 1, int tile = 32, bool useCache = true);
```

The input here is an `cv::Mat` image; e.g. loaded by `imread` function. The result then contains a list of detected locations and their scores, and also supplementary information about total amount of features and locations evaluated.

# Tools

## `detect_lbp`

## `detect_lbp_video`

## `minimal`
