function k = check(D)
% Check validity of detector structure.
%
%       valid = check(detector)
%
% If the check passes, it is safe to use it in lbpDetect.

try
    classes_ok = ...
        (isa(D.clf.size,'uint32') || isa(D.clf.size,'int32'))&& ...
        isa(D.clf.thr,'single') && ...
        isa(D.clf.ftr,'uint8') && ...
        isa(D.clf.hs,'single');
    T = length(D.clf.thr);
    sizes_ok = isvector(D.clf.size) && length(D.clf.size) == 2 && ...
        isvector(D.clf.thr) && length(D.clf.thr) == T && ...
        ismatrix(D.clf.ftr) && all(size(D.clf.ftr)==[5,T]) && ...
        ismatrix(D.clf.hs) && all(size(D.clf.hs)==[256,T]);
    window_ok = all(D.clf.size' >= max(D.clf.ftr(1:2,:) + 3*D.clf.ftr(3:4,:),[],2));
    k = classes_ok && sizes_ok && window_ok;
catch
    k = false;
end