/*
 * MainWindow.java
 *
 * Created on Sobota, 2008, január 26, 10:27
 */

package GUI;

import utilityXML.*;

import javax.swing.*;
import java.awt.*;

import javax.swing.tree.DefaultMutableTreeNode;

import java.io.*;
import java.util.*;

/**
 *
 * @author  Myshinoo
 */
public class MainWindow extends javax.swing.JFrame {

  /** Creates new form MainWindow */
  public MainWindow() {
    initComponents();
    initXMLtree();
    initCanvas();

    MainWindow.this.setLocationRelativeTo(null); 
   }
  
  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the Form Editor.
   */
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    closeDialog = new javax.swing.JDialog();
    dialogLB = new javax.swing.JLabel();
    diaBTPanel = new javax.swing.JPanel();
    dialogYesBT = new javax.swing.JButton();
    dialogNoBT = new javax.swing.JButton();
    dialogCanBT = new javax.swing.JButton();
    treePopup = new javax.swing.JPopupMenu();
    showPup = new javax.swing.JMenuItem();
    addNewChildPup = new javax.swing.JMenuItem();
    addNewAttrPup = new javax.swing.JMenuItem();
    renamePup = new javax.swing.JMenuItem();
    deletePup = new javax.swing.JMenuItem();
    toolBar = new javax.swing.JToolBar();
    newBt = new javax.swing.JButton();
    openBt = new javax.swing.JButton();
    saveBt = new javax.swing.JButton();
    closeBt = new javax.swing.JButton();
    splitPane = new javax.swing.JSplitPane();
    scrollPaneCanvas = new javax.swing.JScrollPane();
    scrollPaneTree = new javax.swing.JScrollPane();
    menuBar = new javax.swing.JMenuBar();
    fileMenu = new javax.swing.JMenu();
    newMenuItem = new javax.swing.JMenuItem();
    openMenuIten = new javax.swing.JMenuItem();
    saveMenuItem = new javax.swing.JMenuItem();
    saveAsMenuItem = new javax.swing.JMenuItem();
    closeMenuItem = new javax.swing.JMenuItem();
    exitMenuItem = new javax.swing.JMenuItem();
    optionsMenu = new javax.swing.JMenu();
    helpMenu = new javax.swing.JMenu();

    closeDialog.setTitle("XMLvisualizer");
    closeDialog.setModal(true);
    closeDialog.setResizable(false);
    closeDialog.setSize(230,120);

    dialogLB.setFont(new java.awt.Font("Arial", 0, 12));
    dialogLB.setText("Save opened document ?");

    dialogYesBT.setFont(new java.awt.Font("Arial", 0, 11));
    dialogYesBT.setText("Yes");
    dialogYesBT.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        dialogYesBTActionPerformed(evt);
      }
    });
    diaBTPanel.add(dialogYesBT);

    dialogNoBT.setFont(new java.awt.Font("Arial", 0, 11));
    dialogNoBT.setText("No");
    dialogNoBT.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        dialogNoBTActionPerformed(evt);
      }
    });
    diaBTPanel.add(dialogNoBT);

    dialogCanBT.setFont(new java.awt.Font("Arial", 0, 11));
    dialogCanBT.setText("Cancel");
    dialogCanBT.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        dialogCanBTActionPerformed(evt);
      }
    });
    diaBTPanel.add(dialogCanBT);

    javax.swing.GroupLayout closeDialogLayout = new javax.swing.GroupLayout(closeDialog.getContentPane());
    closeDialog.getContentPane().setLayout(closeDialogLayout);
    closeDialogLayout.setHorizontalGroup(
      closeDialogLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addComponent(diaBTPanel, javax.swing.GroupLayout.DEFAULT_SIZE, 213, Short.MAX_VALUE)
      .addGroup(closeDialogLayout.createSequentialGroup()
        .addGap(18, 18, 18)
        .addComponent(dialogLB, javax.swing.GroupLayout.PREFERRED_SIZE, 174, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addContainerGap(21, Short.MAX_VALUE))
    );
    closeDialogLayout.setVerticalGroup(
      closeDialogLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(closeDialogLayout.createSequentialGroup()
        .addGap(18, 18, 18)
        .addComponent(dialogLB)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
        .addComponent(diaBTPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
    );

    showPup.setFont(new java.awt.Font("Arial", 0, 12));
    showPup.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/showPopUp.png"))); // NOI18N
    showPup.setText("Show");
    treePopup.add(showPup);

    addNewChildPup.setFont(new java.awt.Font("Arial", 0, 12));
    addNewChildPup.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/addPopUp.png"))); // NOI18N
    addNewChildPup.setText("Add New Child");
    treePopup.add(addNewChildPup);

    addNewAttrPup.setFont(new java.awt.Font("Arial", 0, 12));
    addNewAttrPup.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/addPopUp.png"))); // NOI18N
    addNewAttrPup.setText("Add New Attribute");
    treePopup.add(addNewAttrPup);

    renamePup.setFont(new java.awt.Font("Arial", 0, 12));
    renamePup.setText("Rename");
    treePopup.add(renamePup);

    deletePup.setFont(new java.awt.Font("Arial", 0, 12));
    deletePup.setText("Delete");
    treePopup.add(deletePup);

    setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
    setTitle("XML visualizer");
    setFont(new java.awt.Font("Arial", 0, 12));
    addWindowListener(new java.awt.event.WindowAdapter() {
      public void windowClosing(java.awt.event.WindowEvent evt) {
        formWindowClosing(evt);
      }
    });

    toolBar.setBackground(new java.awt.Color(223, 223, 234));
    toolBar.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(153, 153, 153)));
    toolBar.setRollover(true);

    newBt.setBackground(new java.awt.Color(223, 223, 234));
    newBt.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/newDoc.png"))); // NOI18N
    newBt.setToolTipText("");
    newBt.setBorder(null);
    newBt.setFocusable(false);
    newBt.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
    newBt.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
    newBt.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        newBtActionPerformed(evt);
      }
    });
    toolBar.add(newBt);

    openBt.setBackground(new java.awt.Color(223, 223, 234));
    openBt.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/openDoc.png"))); // NOI18N
    openBt.setBorder(null);
    openBt.setFocusable(false);
    openBt.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
    openBt.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
    openBt.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        openBtActionPerformed(evt);
      }
    });
    toolBar.add(openBt);

    saveBt.setBackground(new java.awt.Color(223, 223, 234));
    saveBt.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/saveDoc.png"))); // NOI18N
    saveBt.setBorder(null);
    saveBt.setFocusable(false);
    saveBt.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
    saveBt.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
    saveBt.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        saveBtActionPerformed(evt);
      }
    });
    toolBar.add(saveBt);

    closeBt.setBackground(new java.awt.Color(223, 223, 234));
    closeBt.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/closeDoc.png"))); // NOI18N
    closeBt.setBorder(null);
    closeBt.setFocusable(false);
    closeBt.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
    closeBt.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
    closeBt.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        closeBtActionPerformed(evt);
      }
    });
    toolBar.add(closeBt);

    splitPane.setDividerLocation(150);

    scrollPaneCanvas.setBackground(new java.awt.Color(255, 255, 255));
    splitPane.setRightComponent(scrollPaneCanvas);
    splitPane.setLeftComponent(scrollPaneTree);

    menuBar.setBorder(null);
    menuBar.setFont(new java.awt.Font("Arial", 0, 12));
    menuBar.setMargin(new java.awt.Insets(0, 0, 1, 0));

    fileMenu.setText("File");
    fileMenu.setFont(new java.awt.Font("Arial", 0, 12));

    newMenuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_N, java.awt.event.InputEvent.CTRL_MASK));
    newMenuItem.setFont(new java.awt.Font("Arial", 0, 12));
    newMenuItem.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/newDocMenu.png"))); // NOI18N
    newMenuItem.setText("  New Document");
    newMenuItem.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        newMenuItemActionPerformed(evt);
      }
    });
    fileMenu.add(newMenuItem);

    openMenuIten.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_O, java.awt.event.InputEvent.CTRL_MASK));
    openMenuIten.setFont(new java.awt.Font("Arial", 0, 12));
    openMenuIten.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/openDocMenu.png"))); // NOI18N
    openMenuIten.setText("  Open Document");
    openMenuIten.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        openMenuItenActionPerformed(evt);
      }
    });
    fileMenu.add(openMenuIten);

    saveMenuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_S, java.awt.event.InputEvent.CTRL_MASK));
    saveMenuItem.setFont(new java.awt.Font("Arial", 0, 12));
    saveMenuItem.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/saveDocMenu.png"))); // NOI18N
    saveMenuItem.setText("  Save");
    saveMenuItem.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        saveMenuItemActionPerformed(evt);
      }
    });
    fileMenu.add(saveMenuItem);

    saveAsMenuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_S, java.awt.event.InputEvent.CTRL_MASK));
    saveAsMenuItem.setFont(new java.awt.Font("Arial", 0, 12));
    saveAsMenuItem.setText("  Save As");
    saveAsMenuItem.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        saveAsMenuItemActionPerformed(evt);
      }
    });
    fileMenu.add(saveAsMenuItem);

    closeMenuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_W, java.awt.event.InputEvent.CTRL_MASK));
    closeMenuItem.setFont(new java.awt.Font("Arial", 0, 12));
    closeMenuItem.setText("  Close");
    closeMenuItem.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        closeMenuItemActionPerformed(evt);
      }
    });
    fileMenu.add(closeMenuItem);

    exitMenuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_Q, java.awt.event.InputEvent.CTRL_MASK));
    exitMenuItem.setFont(new java.awt.Font("Arial", 0, 12));
    exitMenuItem.setText("  Exit");
    exitMenuItem.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        exitMenuItemActionPerformed(evt);
      }
    });
    fileMenu.add(exitMenuItem);

    menuBar.add(fileMenu);

    optionsMenu.setText("Tools");
    optionsMenu.setFont(new java.awt.Font("Arial", 0, 12));
    menuBar.add(optionsMenu);

    helpMenu.setText("Help");
    helpMenu.setFont(new java.awt.Font("Arial", 0, 12));
    menuBar.add(helpMenu);

    setJMenuBar(menuBar);

    javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
    getContentPane().setLayout(layout);
    layout.setHorizontalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addComponent(toolBar, javax.swing.GroupLayout.DEFAULT_SIZE, 888, Short.MAX_VALUE)
      .addComponent(splitPane, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 888, Short.MAX_VALUE)
    );
    layout.setVerticalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addComponent(toolBar, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(splitPane, javax.swing.GroupLayout.DEFAULT_SIZE, 583, Short.MAX_VALUE)
        .addContainerGap())
    );

    pack();
  }// </editor-fold>//GEN-END:initComponents

  private void newBtActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_newBtActionPerformed
    if(parser!=null){
      if(parser.isDocumentChanged())
        showDialog("Save changes to opened document?");
    }
    //inicializovanie komponentov    
    initXMLtree();
    initCanvas();
  }//GEN-LAST:event_newBtActionPerformed

  private void openBtActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_openBtActionPerformed
    if(parser!=null){
      if(parser.isDocumentChanged())
        showDialog("Save changes to opened document?");
    }
    openXMLdocument();
  }//GEN-LAST:event_openBtActionPerformed

  private void saveBtActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_saveBtActionPerformed
    if(parser != null)
      parser.saveXMLdoc(parser.openDocument, parser.openFile);
  }//GEN-LAST:event_saveBtActionPerformed

  private void closeBtActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_closeBtActionPerformed
    
    if(parser!=null){
      if(parser.isDocumentChanged())
        showDialog("Save changes to opened document?");
    }
    System.out.print(this.dialogRetCode);
    //inicializovanie komponentov    
    initXMLtree();
    initCanvas();

  }//GEN-LAST:event_closeBtActionPerformed

  //Menu buttons
  private void newMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_newMenuItemActionPerformed
   
    if(parser!=null){
      if(parser.isDocumentChanged())
        showDialog("Save changes to opened document?");
    }
    //inicializovanie komponentov    
    initXMLtree();
    initCanvas();
  }//GEN-LAST:event_newMenuItemActionPerformed

  private void openMenuItenActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_openMenuItenActionPerformed
    
    if(parser!=null){
      if(parser.isDocumentChanged())
        showDialog("Save changes to opened document?");
    }
    
    openXMLdocument();
  }//GEN-LAST:event_openMenuItenActionPerformed

  private void saveMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_saveMenuItemActionPerformed
    if(parser != null)
      parser.saveXMLdoc(parser.openDocument, parser.openFile);
  }//GEN-LAST:event_saveMenuItemActionPerformed

  private void closeMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_closeMenuItemActionPerformed
   
    if(parser!=null){
      if(parser.isDocumentChanged())
        showDialog("Save changes to opened document?");
    }   
    //inicializovanie komponentov    
    initXMLtree();
    initCanvas();
  }//GEN-LAST:event_closeMenuItemActionPerformed

  private void exitMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_exitMenuItemActionPerformed
    
    if(parser!=null){
      if(parser.isDocumentChanged())
        showDialog("Save changes to opened document?");
    }
    
    System.exit(1);
  }//GEN-LAST:event_exitMenuItemActionPerformed

  private void saveAsMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_saveAsMenuItemActionPerformed
    saveXMLdocument();
  }//GEN-LAST:event_saveAsMenuItemActionPerformed

  //Dialog buttons
  private void dialogYesBTActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_dialogYesBTActionPerformed
    dialogRetCode="yes";
    closeDialog.setVisible(false);
  }//GEN-LAST:event_dialogYesBTActionPerformed

  private void dialogNoBTActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_dialogNoBTActionPerformed
    dialogRetCode="no";
    closeDialog.setVisible(false);
  }//GEN-LAST:event_dialogNoBTActionPerformed

  private void dialogCanBTActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_dialogCanBTActionPerformed
    dialogRetCode="cancel";
    closeDialog.setVisible(false);
  }//GEN-LAST:event_dialogCanBTActionPerformed

  private void formWindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosing
    if(parser!=null){
      if(parser.isDocumentChanged())
        showDialog("Save changes to opened document?");
    }
  }//GEN-LAST:event_formWindowClosing
  
  /**
   * @param args the command line arguments
   */
  public static void main(String args[]){
    java.awt.EventQueue.invokeLater(new Runnable() {
      public void run() {
        new MainWindow().setVisible(true);
      }
    });
  }
  
  /**
   * @param args the command line arguments
   */
  public void initXMLtree(){
    //Create the nodes.
    DefaultMutableTreeNode top = new DefaultMutableTreeNode("unknow");
    //Create a tree that allows one selection at a time.
    myTree= new XMLtree(top, this); 
    //zaregistrujem popup menu pre strom
    myTree.add(this.treePopup);
    //Create the scroll pane and add the tree to it. 
    scrollPaneTree.setViewportView(myTree); 
  }
  
  /**
   * @param args the command line arguments
   */
  public void initCanvas(){
    drawPanel= new DrawPanel();
    scrollPaneCanvas.setViewportView(drawPanel);
    drawPanel.setPreferredSize(new Dimension(550,450));
    //Let the scroll pane know to update itself
    //and its scrollbars.
    drawPanel.revalidate();
    drawPanel.repaint();
  }
 
  public void showPopUp(Component comp, int x, int y){
    this.treePopup.show(comp, x, y);
  }
  
  
  /**
   * @param args the command line arguments
   */
  public void openXMLdocument(){

    JFileChooser chooser = new JFileChooser();
    
    //nastavime pozadovany typ pisma
    recursivelySetFonts(chooser, new Font("Arial", 0, 12));
    
    chooser.setDialogTitle("Open Document");
    
    javax.swing.filechooser.FileNameExtensionFilter filter = new javax.swing.filechooser.FileNameExtensionFilter("xml", "XML");
    chooser.setFileFilter(filter);
    int returnVal = chooser.showOpenDialog(this);
    if(returnVal == JFileChooser.APPROVE_OPTION) {
      File file = chooser.getSelectedFile();
      
      parser = new XMLreader();
      try{
        //premazanie canvasu
        initCanvas();
        //vytvorenie stromu zo vstupneho xml dokumentu
        myTree.createTree(parser.openXMLdoc(file));
      }
      catch(Exception e){
        e.printStackTrace(); 
      }
    }
  }
 
  /**
   * @param args the command line arguments
   */
  public void saveXMLdocument(){
    JFileChooser chooser = new JFileChooser();
    
    //nastavime pozadovany typ pisma
    recursivelySetFonts(chooser, new Font("Arial", 0, 12));
    
    chooser.setDialogTitle("Save Document");
    javax.swing.filechooser.FileNameExtensionFilter filter = new javax.swing.filechooser.FileNameExtensionFilter("xml", "XML");
    chooser.setFileFilter(filter);
    int returnVal = chooser.showSaveDialog(this);
    if(returnVal == JFileChooser.APPROVE_OPTION && parser != null) {
      File file = chooser.getSelectedFile();
      if(file.exists()){
        System.out.println("Zelate si prepisat dokument");
        parser.saveXMLdoc(parser.openDocument, file);
      }  
      else{
        file = new File(chooser.getSelectedFile().toString()+".xml");
        parser.saveXMLdoc(parser.openDocument, file);
      }
    }  
  }
  
  
    /**
   * @param args the command line arguments
   */
  public void recursivelySetFonts(Component comp, Font font){
    comp.setFont(font);
    if(comp instanceof Container){
      Container cont = (Container) comp;
      for(int j=0, ub=cont.getComponentCount(); j<ub; ++j)
        recursivelySetFonts(cont.getComponent(j), font);
    }
  }
  
  
  /**
   * @param args the command line arguments
   */
  public void showDialog(String actionText){
    //pociatocne nastavenie navratoveho kodu
    dialogRetCode=null;
    
    //nastavenie polohy
    Dimension formsize = this.getSize();
    Point p = this.getLocation();
    closeDialog.setLocation((p.x+formsize.width/3),(p.y+formsize.height/3));
    
    this.dialogLB.setText(actionText);
    this.closeDialog.setVisible(true);
    closeDialog.pack();

  }
  
  
  public XMLtree myTree;
  public DrawPanel drawPanel;
  public XMLreader parser;
  private String dialogRetCode;
  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JMenuItem addNewAttrPup;
  private javax.swing.JMenuItem addNewChildPup;
  private javax.swing.JButton closeBt;
  private javax.swing.JDialog closeDialog;
  private javax.swing.JMenuItem closeMenuItem;
  private javax.swing.JMenuItem deletePup;
  private javax.swing.JPanel diaBTPanel;
  private javax.swing.JButton dialogCanBT;
  private javax.swing.JLabel dialogLB;
  private javax.swing.JButton dialogNoBT;
  private javax.swing.JButton dialogYesBT;
  private javax.swing.JMenuItem exitMenuItem;
  private javax.swing.JMenu fileMenu;
  private javax.swing.JMenu helpMenu;
  private javax.swing.JMenuBar menuBar;
  private javax.swing.JButton newBt;
  private javax.swing.JMenuItem newMenuItem;
  private javax.swing.JButton openBt;
  private javax.swing.JMenuItem openMenuIten;
  private javax.swing.JMenu optionsMenu;
  private javax.swing.JMenuItem renamePup;
  private javax.swing.JMenuItem saveAsMenuItem;
  private javax.swing.JButton saveBt;
  private javax.swing.JMenuItem saveMenuItem;
  private javax.swing.JScrollPane scrollPaneCanvas;
  private javax.swing.JScrollPane scrollPaneTree;
  private javax.swing.JMenuItem showPup;
  private javax.swing.JSplitPane splitPane;
  private javax.swing.JToolBar toolBar;
  private javax.swing.JPopupMenu treePopup;
  // End of variables declaration//GEN-END:variables
 
    
  
}
