/*
 * ElementPanel.java
 *
 * Created on Utorok, 2008, február 5, 13:37
 */

package GUI;

import java.io.*;
import java.util.*;

import java.awt.*;
import javax.swing.*;

import org.jdom.*;
import org.jdom.input.*;

/**
 *
 * @author  Michal
 */
public class ElementPanel extends javax.swing.JPanel {
 
  private MainWindow mainWin;
  
  //vlastny element v XML
  private Element thisElement=null;
  
  public ElementPanel myParent=null;
  
  //zoznam vykreslovanych potomkov elementu
  public java.util.Vector<ElementPanel> drawChildList = new java.util.Vector();
  
  //poloha kurzora pre mouse drag
  private int startCursorPosX;
  private int startCursorPosY;
  
  /** Creates new form ElementPanel */
  public ElementPanel(MainWindow mainWin){
    initComponents();
    this.mainWin=mainWin;
  }
  
  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the Form Editor.
   */
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    tabbedPane = new javax.swing.JTabbedPane();
    childPanel = new javax.swing.JPanel();
    childScrollPane = new javax.swing.JScrollPane();
    childList = new javax.swing.JList();
    attrPanel = new javax.swing.JPanel();
    attrBox = new javax.swing.JComboBox();
    attrValueTfield = new javax.swing.JTextField();
    movePanel = new javax.swing.JPanel();
    elementName = new javax.swing.JLabel();
    exitBt = new javax.swing.JButton();

    setBackground(new java.awt.Color(168, 205, 230));
    setBorder(new javax.swing.border.LineBorder(new java.awt.Color(255, 255, 255), 1, true));

    tabbedPane.setFont(new java.awt.Font("Arial", 0, 11));

    childList.setFont(new java.awt.Font("Arial", 0, 11));
    childList.addMouseListener(new java.awt.event.MouseAdapter() {
      public void mouseClicked(java.awt.event.MouseEvent evt) {
        childListMouseClicked(evt);
      }
    });
    childScrollPane.setViewportView(childList);

    javax.swing.GroupLayout childPanelLayout = new javax.swing.GroupLayout(childPanel);
    childPanel.setLayout(childPanelLayout);
    childPanelLayout.setHorizontalGroup(
      childPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addComponent(childScrollPane, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 136, Short.MAX_VALUE)
    );
    childPanelLayout.setVerticalGroup(
      childPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(childPanelLayout.createSequentialGroup()
        .addComponent(childScrollPane, javax.swing.GroupLayout.PREFERRED_SIZE, 61, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addContainerGap(63, Short.MAX_VALUE))
    );

    tabbedPane.addTab("child", childPanel);

    attrBox.setFont(new java.awt.Font("Arial", 0, 11));
    attrBox.addMouseListener(new java.awt.event.MouseAdapter() {
      public void mouseClicked(java.awt.event.MouseEvent evt) {
        attrBoxMouseClicked(evt);
      }
    });
    attrBox.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        attrBoxActionPerformed(evt);
      }
    });

    javax.swing.GroupLayout attrPanelLayout = new javax.swing.GroupLayout(attrPanel);
    attrPanel.setLayout(attrPanelLayout);
    attrPanelLayout.setHorizontalGroup(
      attrPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addComponent(attrBox, javax.swing.GroupLayout.Alignment.TRAILING, 0, 136, Short.MAX_VALUE)
      .addComponent(attrValueTfield, javax.swing.GroupLayout.DEFAULT_SIZE, 136, Short.MAX_VALUE)
    );
    attrPanelLayout.setVerticalGroup(
      attrPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(attrPanelLayout.createSequentialGroup()
        .addGap(6, 6, 6)
        .addComponent(attrBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(attrValueTfield, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addContainerGap(70, Short.MAX_VALUE))
    );

    tabbedPane.addTab("attribute", attrPanel);

    movePanel.setBackground(new java.awt.Color(95, 153, 209));
    movePanel.addMouseListener(new java.awt.event.MouseAdapter() {
      public void mousePressed(java.awt.event.MouseEvent evt) {
        movePanelMousePressed(evt);
      }
      public void mouseReleased(java.awt.event.MouseEvent evt) {
        movePanelMouseReleased(evt);
      }
    });
    movePanel.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
      public void mouseDragged(java.awt.event.MouseEvent evt) {
        movePanelMouseDragged(evt);
      }
    });

    elementName.setFont(new java.awt.Font("Arial", 1, 13));
    elementName.setText("Element"); // NOI18N

    exitBt.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/closeElement.png"))); // NOI18N
    exitBt.setBorder(javax.swing.BorderFactory.createCompoundBorder());
    exitBt.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        exitBtActionPerformed(evt);
      }
    });

    javax.swing.GroupLayout movePanelLayout = new javax.swing.GroupLayout(movePanel);
    movePanel.setLayout(movePanelLayout);
    movePanelLayout.setHorizontalGroup(
      movePanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, movePanelLayout.createSequentialGroup()
        .addContainerGap()
        .addComponent(elementName, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        .addGap(64, 64, 64)
        .addComponent(exitBt))
    );
    movePanelLayout.setVerticalGroup(
      movePanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addComponent(exitBt, javax.swing.GroupLayout.DEFAULT_SIZE, 18, Short.MAX_VALUE)
      .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, movePanelLayout.createSequentialGroup()
        .addContainerGap()
        .addComponent(elementName, javax.swing.GroupLayout.PREFERRED_SIZE, 11, javax.swing.GroupLayout.PREFERRED_SIZE))
    );

    javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
    this.setLayout(layout);
    layout.setHorizontalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addComponent(movePanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
      .addComponent(tabbedPane, javax.swing.GroupLayout.DEFAULT_SIZE, 141, Short.MAX_VALUE)
    );
    layout.setVerticalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addComponent(movePanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(tabbedPane, javax.swing.GroupLayout.DEFAULT_SIZE, 149, Short.MAX_VALUE))
    );
  }// </editor-fold>//GEN-END:initComponents

  private void exitBtActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_exitBtActionPerformed
    removeElementFromPanel(mainWin.drawPanel, this);
  }//GEN-LAST:event_exitBtActionPerformed

  private void movePanelMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_movePanelMousePressed
    //nastavenie pociatocnej polohy kurzora pre posuvanie mysou
    startCursorPosX=evt.getX();
    startCursorPosY=evt.getY();
    mainWin.drawPanel.moveToFront(this);
  }//GEN-LAST:event_movePanelMousePressed

  
  private void movePanelMouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_movePanelMouseDragged
   //posuvanie komponenty po canvase, nastavuje sa jej pozicia
    positionX+=evt.getX()-startCursorPosX;
    positionY+=evt.getY()-startCursorPosY;
    
    //osetrenie pri okrajoch
    if(positionX<0) positionX=0;
    if(positionY<0) positionY=0;
    
    //zmenit koli optimalizacii
    mainWin.drawPanel.repaint();
  }//GEN-LAST:event_movePanelMouseDragged

  private void attrBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_attrBoxActionPerformed
    //nastavime element ako aktivny
    mainWin.drawPanel.moveToFront(this);
    
    //nastavenie textBoxu pri prezerani atributov
    JComboBox cb = (JComboBox)evt.getSource();
    String str = (String)cb.getSelectedItem();
    Attribute attr = thisElement.getAttribute(str);
    this.attrValueTfield.setText(attr.getValue());
  }//GEN-LAST:event_attrBoxActionPerformed

  
  private void childListMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_childListMouseClicked
    //nastavime element ako aktivny
    mainWin.drawPanel.moveToFront(this);
    
    //ak bolo dvakrat kliknute, chceme zobrazit dieta elementu
    if(evt.getClickCount()>=2){
      String strEle = this.childList.getSelectedValue().toString();
      strEle = strEle.replace("<","");
      strEle = strEle.replace(">","");
      Element childElement = thisElement.getChild(strEle);
      
      //////////////////////////////////////////////////////////////////////////////////////////////////////
      
      DefaultListModel listModel = (DefaultListModel)this.childList.getModel();
      
      int position = childList.getSelectedIndex();
      listModel.remove(position);
      
      listModel.add(position,"nahrada");
      this.childList.setModel(listModel);
      
      
      //////////////////////////////////////////////////////////////////////////////////////////////////////
      
      //vytvorenie noveho elementu
      ElementPanel newElement = new ElementPanel(mainWin);
      newElement.createElementComponent(childElement,this);
      mainWin.drawPanel.addNewElement(newElement);
      
      //pridanie do zoznamu zobrazovanych potomkov elementu
      drawChildList.add(newElement);
    }
      
  }//GEN-LAST:event_childListMouseClicked

  private void movePanelMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_movePanelMouseReleased
    //po skonceni premiestnenia elementu upravime rozmery panelu
    //podla zoznamu elementov a ich novych suradnic
    mainWin.drawPanel.setPanelResize(true);
    mainWin.drawPanel.repaint();
  }//GEN-LAST:event_movePanelMouseReleased

  private void attrBoxMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_attrBoxMouseClicked
    //nastavime element ako aktivny
    mainWin.drawPanel.moveToFront(this);
  }//GEN-LAST:event_attrBoxMouseClicked
  
  /**
   * @param args the command line arguments
   */ 
  public void createElementComponent(Element element, ElementPanel parent){
    
    //nastavi element
    thisElement=element;
    myParent=parent; 
    this.elementName.setText("<"+element.getName()+">");

    //vytvorenie zoznamu deti elementu
    DefaultListModel listModel = new DefaultListModel();
    java.util.List list = element.getChildren();
    for(int i=0; i<list.size();i++){
      Element child =(Element)list.get(i);
      listModel.addElement("<"+child.getName()+">");
    }
    this.childList.setModel(listModel);
    
    //vytvorenie zoznamu parametrov
    list = element.getAttributes();
    for(int i=0;i<list.size();i++){
      Attribute attr = (Attribute)list.get(i);
      this.attrBox.addItem(attr.getName());
    }
  }
  
  /**
   * @param args the command line arguments
   */
  public void removeElementFromPanel(DrawPanel drawPanel, ElementPanel item){
    
    if(item.myParent!=null){
      //nemazeme korenovy element, ale cast podstromu
      myParent.drawChildList.removeElement(item);
    }
    else{
      //mazeme korenovy element, zrusime cely strom
      for(int i=0; i<drawPanel.elementList.size();i++){
        //odstranime prvky elementov z canvasu
        mainWin.drawPanel.remove(drawPanel.elementList.get(i));
      }
      //nakoniec odstranime polozky zo zoznamu elementov
      drawPanel.elementList.removeAllElements(); 
      mainWin.drawPanel.revalidate();
      mainWin.drawPanel.repaint();
      return;
    }
    
    //rusime cast podstromu
    if(item.drawChildList.size()!=0){
      for(int i=0; i < item.drawChildList.size(); i++){
        ElementPanel child = item.drawChildList.get(i);
        //rekurzivne rusime polozky
        removeElementFromPanel(drawPanel, child);
      }
    }
    //revalidacia panelu
    drawPanel.elementList.removeElement(item);
    mainWin.drawPanel.remove(item);
    mainWin.drawPanel.revalidate();
    mainWin.drawPanel.repaint();

  }
  

  
  public int positionX=0;
  public int positionY=0;
  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JComboBox attrBox;
  private javax.swing.JPanel attrPanel;
  private javax.swing.JTextField attrValueTfield;
  public javax.swing.JList childList;
  private javax.swing.JPanel childPanel;
  private javax.swing.JScrollPane childScrollPane;
  public javax.swing.JLabel elementName;
  public javax.swing.JButton exitBt;
  public javax.swing.JPanel movePanel;
  private javax.swing.JTabbedPane tabbedPane;
  // End of variables declaration//GEN-END:variables
  
}
