/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package GUI;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
/**
 *
 * @author Myshinoo
 */
public class DrawPanel extends JLayeredPane{
  
  public java.util.Vector<ElementPanel> elementList = new java.util.Vector();
  
  private int minWidth=550;
  private int minHeight=450;
  
  private int scrollMaxX=0;
  private int scrollMaxY=0;
  private boolean resizePanel=false;
  
  java.awt.image.BufferedImage imgGrid=null;

  
  public DrawPanel(){
    this.setLayout(new FlowLayout());
    this.setBackground(Color.WHITE);
    this.setOpaque(true);
    
    try{
      java.net.URL url = getClass().getResource("/images/grid.jpg");
     imgGrid = javax.imageio.ImageIO.read(url);
   }
   catch(Exception e){
   }
  }
  
  public void paintComponent(Graphics g){
    super.paintComponent(g);
    
    //premenne pre zistovanie suradnic elementov na canvase
    scrollMaxX=0;
    scrollMaxY=0;
    
    /*
    int f=0;
    for(int i=0;i<10;i++){
      g.drawImage(imgGrid,f, 0, this);
      f+=150;
    }
    */
    for(int i=0; i< elementList.size();i++){
      ElementPanel item =(ElementPanel)elementList.get(i); 
      item.setLocation(item.positionX, item.positionY);
     
      //vykreslovanie spojeni medzi elementmi
      for(int x=0;x<item.drawChildList.size();x++){
        ElementPanel itemChild = (ElementPanel)item.drawChildList.get(x);
        drawRelationLine(item, itemChild,g);
      }
      
      //kontrola rozmerov panelu pre vsetky elementy
      if(item.positionX>scrollMaxX)
        scrollMaxX=item.positionX;
      if(item.positionY>scrollMaxY)
        scrollMaxY=item.positionY;
    }
    //upravime rozmery elementov ak bol panel zmeneny
    if(this.isPanelResize()){
      this.resizeDrawPanel(scrollMaxX,scrollMaxY);
      resizePanel=false;
    }  
  }
    
  /**
   * Funkcia prida novy element na plochu na suradnice 100,100
   * @param element element, ktory pridavame na plochu
   */
  public void addNewElement(ElementPanel element){
    this.add(element);
    this.moveToFront(element);
    elementList.add(element);
    element.positionX=100;
    element.positionY=100;
    this.revalidate();
  }
  
  
  /**
   * Podla zistenych maximalnych suradnic zmeni rozmery plochy
   * @param args the command line arguments
   */ 
  public void resizeDrawPanel(int x, int y){
    if(x<minWidth)
      x=minWidth;
    if(y<minHeight)
      y=minHeight;
    this.setPreferredSize(new Dimension(x+100,y+100));
    this.revalidate();
  }
  
  
  /**
   * @param args the command line arguments
   */ 
  public boolean isPanelResize(){
    return resizePanel;
  }
  
  /**
   * @param args the command line arguments
   */ 
  public void setPanelResize(boolean value){
    this.resizePanel = value;
  }
  
  /**
   * @param args the command line arguments
   */
  public void drawRelationLine(ElementPanel parent, ElementPanel child, Graphics g){
    if(child.positionX < parent.positionX && child.positionY < parent.positionY)
      g.drawLine(parent.positionX, parent.positionY, child.positionX + child.getWidth(), child.positionY + child.getHeight());
    else if(child.positionX < parent.positionX && child.positionY > parent.positionY)
      g.drawLine(parent.positionX, parent.positionY + parent.getHeight(), child.positionX + child.getWidth(), child.positionY);
    else if(child.positionX > parent.positionX && child.positionY > parent.positionY)
      g.drawLine(parent.positionX + parent.getWidth(), parent.positionY + parent.getHeight(), child.positionX, child.positionY);
    else  
      g.drawLine(parent.positionX + parent.getWidth(), parent.positionY, child.positionX, child.positionY + child.getHeight());
  }
}
