/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.DrawPanel;
import GUI.XMLtree;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import utilityXML.XMLreader;

public class MainWindow
extends JFrame {
    public XMLtree myTree;
    public DrawPanel drawPanel;
    public XMLreader parser;
    private String dialogRetCode;
    private JMenuItem addNewAttrPup;
    private JMenuItem addNewChildPup;
    private JButton closeBt;
    private JDialog closeDialog;
    private JMenuItem closeMenuItem;
    private JMenuItem deletePup;
    private JPanel diaBTPanel;
    private JButton dialogCanBT;
    private JLabel dialogLB;
    private JButton dialogNoBT;
    private JButton dialogYesBT;
    private JMenuItem exitMenuItem;
    private JMenu fileMenu;
    private JMenu helpMenu;
    private JMenuBar menuBar;
    private JButton newBt;
    private JMenuItem newMenuItem;
    private JButton openBt;
    private JMenuItem openMenuIten;
    private JMenu optionsMenu;
    private JMenuItem renamePup;
    private JMenuItem saveAsMenuItem;
    private JButton saveBt;
    private JMenuItem saveMenuItem;
    private JScrollPane scrollPaneCanvas;
    private JScrollPane scrollPaneTree;
    private JMenuItem showPup;
    private JSplitPane splitPane;
    private JToolBar toolBar;
    private JPopupMenu treePopup;

    public MainWindow() {
        this.initComponents();
        this.initXMLtree();
        this.initCanvas();
        this.setLocationRelativeTo(null);
    }

    private void initComponents() {
        this.closeDialog = new JDialog();
        this.dialogLB = new JLabel();
        this.diaBTPanel = new JPanel();
        this.dialogYesBT = new JButton();
        this.dialogNoBT = new JButton();
        this.dialogCanBT = new JButton();
        this.treePopup = new JPopupMenu();
        this.showPup = new JMenuItem();
        this.addNewChildPup = new JMenuItem();
        this.addNewAttrPup = new JMenuItem();
        this.renamePup = new JMenuItem();
        this.deletePup = new JMenuItem();
        this.toolBar = new JToolBar();
        this.newBt = new JButton();
        this.openBt = new JButton();
        this.saveBt = new JButton();
        this.closeBt = new JButton();
        this.splitPane = new JSplitPane();
        this.scrollPaneCanvas = new JScrollPane();
        this.scrollPaneTree = new JScrollPane();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.newMenuItem = new JMenuItem();
        this.openMenuIten = new JMenuItem();
        this.saveMenuItem = new JMenuItem();
        this.saveAsMenuItem = new JMenuItem();
        this.closeMenuItem = new JMenuItem();
        this.exitMenuItem = new JMenuItem();
        this.optionsMenu = new JMenu();
        this.helpMenu = new JMenu();
        this.closeDialog.setTitle("XMLvisualizer");
        this.closeDialog.setModal(true);
        this.closeDialog.setResizable(false);
        this.closeDialog.setSize(230, 120);
        this.dialogLB.setFont(new Font("Arial", 0, 12));
        this.dialogLB.setText("Save opened document ?");
        this.dialogYesBT.setFont(new Font("Arial", 0, 11));
        this.dialogYesBT.setText("Yes");
        this.dialogYesBT.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.dialogYesBTActionPerformed(evt);
            }
        });
        this.diaBTPanel.add(this.dialogYesBT);
        this.dialogNoBT.setFont(new Font("Arial", 0, 11));
        this.dialogNoBT.setText("No");
        this.dialogNoBT.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.dialogNoBTActionPerformed(evt);
            }
        });
        this.diaBTPanel.add(this.dialogNoBT);
        this.dialogCanBT.setFont(new Font("Arial", 0, 11));
        this.dialogCanBT.setText("Cancel");
        this.dialogCanBT.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.dialogCanBTActionPerformed(evt);
            }
        });
        this.diaBTPanel.add(this.dialogCanBT);
        GroupLayout closeDialogLayout = new GroupLayout(this.closeDialog.getContentPane());
        this.closeDialog.getContentPane().setLayout(closeDialogLayout);
        closeDialogLayout.setHorizontalGroup(closeDialogLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.diaBTPanel, -1, 213, Short.MAX_VALUE).addGroup(closeDialogLayout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.dialogLB, -2, 174, -2).addContainerGap(21, Short.MAX_VALUE)));
        closeDialogLayout.setVerticalGroup(closeDialogLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(closeDialogLayout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.dialogLB).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.diaBTPanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.showPup.setFont(new Font("Arial", 0, 12));
        this.showPup.setIcon(new ImageIcon(this.getClass().getResource("/images/showPopUp.png")));
        this.showPup.setText("Show");
        this.treePopup.add(this.showPup);
        this.addNewChildPup.setFont(new Font("Arial", 0, 12));
        this.addNewChildPup.setIcon(new ImageIcon(this.getClass().getResource("/images/addPopUp.png")));
        this.addNewChildPup.setText("Add New Child");
        this.treePopup.add(this.addNewChildPup);
        this.addNewAttrPup.setFont(new Font("Arial", 0, 12));
        this.addNewAttrPup.setIcon(new ImageIcon(this.getClass().getResource("/images/addPopUp.png")));
        this.addNewAttrPup.setText("Add New Attribute");
        this.treePopup.add(this.addNewAttrPup);
        this.renamePup.setFont(new Font("Arial", 0, 12));
        this.renamePup.setText("Rename");
        this.treePopup.add(this.renamePup);
        this.deletePup.setFont(new Font("Arial", 0, 12));
        this.deletePup.setText("Delete");
        this.treePopup.add(this.deletePup);
        this.setDefaultCloseOperation(3);
        this.setTitle("XML visualizer");
        this.setFont(new Font("Arial", 0, 12));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                MainWindow.this.formWindowClosing(evt);
            }
        });
        this.toolBar.setBackground(new Color(223, 223, 234));
        this.toolBar.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.toolBar.setRollover(true);
        this.newBt.setBackground(new Color(223, 223, 234));
        this.newBt.setIcon(new ImageIcon(this.getClass().getResource("/images/newDoc.png")));
        this.newBt.setToolTipText("");
        this.newBt.setBorder(null);
        this.newBt.setFocusable(false);
        this.newBt.setHorizontalTextPosition(0);
        this.newBt.setVerticalTextPosition(3);
        this.newBt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.newBtActionPerformed(evt);
            }
        });
        this.toolBar.add(this.newBt);
        this.openBt.setBackground(new Color(223, 223, 234));
        this.openBt.setIcon(new ImageIcon(this.getClass().getResource("/images/openDoc.png")));
        this.openBt.setBorder(null);
        this.openBt.setFocusable(false);
        this.openBt.setHorizontalTextPosition(0);
        this.openBt.setVerticalTextPosition(3);
        this.openBt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.openBtActionPerformed(evt);
            }
        });
        this.toolBar.add(this.openBt);
        this.saveBt.setBackground(new Color(223, 223, 234));
        this.saveBt.setIcon(new ImageIcon(this.getClass().getResource("/images/saveDoc.png")));
        this.saveBt.setBorder(null);
        this.saveBt.setFocusable(false);
        this.saveBt.setHorizontalTextPosition(0);
        this.saveBt.setVerticalTextPosition(3);
        this.saveBt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.saveBtActionPerformed(evt);
            }
        });
        this.toolBar.add(this.saveBt);
        this.closeBt.setBackground(new Color(223, 223, 234));
        this.closeBt.setIcon(new ImageIcon(this.getClass().getResource("/images/closeDoc.png")));
        this.closeBt.setBorder(null);
        this.closeBt.setFocusable(false);
        this.closeBt.setHorizontalTextPosition(0);
        this.closeBt.setVerticalTextPosition(3);
        this.closeBt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.closeBtActionPerformed(evt);
            }
        });
        this.toolBar.add(this.closeBt);
        this.splitPane.setDividerLocation(150);
        this.scrollPaneCanvas.setBackground(new Color(255, 255, 255));
        this.splitPane.setRightComponent(this.scrollPaneCanvas);
        this.splitPane.setLeftComponent(this.scrollPaneTree);
        this.menuBar.setBorder(null);
        this.menuBar.setFont(new Font("Arial", 0, 12));
        this.menuBar.setMargin(new Insets(0, 0, 1, 0));
        this.fileMenu.setText("File");
        this.fileMenu.setFont(new Font("Arial", 0, 12));
        this.newMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.newMenuItem.setFont(new Font("Arial", 0, 12));
        this.newMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/images/newDocMenu.png")));
        this.newMenuItem.setText("  New Document");
        this.newMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.newMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.newMenuItem);
        this.openMenuIten.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.openMenuIten.setFont(new Font("Arial", 0, 12));
        this.openMenuIten.setIcon(new ImageIcon(this.getClass().getResource("/images/openDocMenu.png")));
        this.openMenuIten.setText("  Open Document");
        this.openMenuIten.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.openMenuItenActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.openMenuIten);
        this.saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.saveMenuItem.setFont(new Font("Arial", 0, 12));
        this.saveMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/images/saveDocMenu.png")));
        this.saveMenuItem.setText("  Save");
        this.saveMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.saveMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveMenuItem);
        this.saveAsMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.saveAsMenuItem.setFont(new Font("Arial", 0, 12));
        this.saveAsMenuItem.setText("  Save As");
        this.saveAsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.saveAsMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveAsMenuItem);
        this.closeMenuItem.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        this.closeMenuItem.setFont(new Font("Arial", 0, 12));
        this.closeMenuItem.setText("  Close");
        this.closeMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.closeMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.closeMenuItem);
        this.exitMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.exitMenuItem.setFont(new Font("Arial", 0, 12));
        this.exitMenuItem.setText("  Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.optionsMenu.setText("Tools");
        this.optionsMenu.setFont(new Font("Arial", 0, 12));
        this.menuBar.add(this.optionsMenu);
        this.helpMenu.setText("Help");
        this.helpMenu.setFont(new Font("Arial", 0, 12));
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.toolBar, -1, 888, Short.MAX_VALUE).addComponent(this.splitPane, GroupLayout.Alignment.TRAILING, -1, 888, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.toolBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.splitPane, -1, 583, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void newBtActionPerformed(ActionEvent evt) {
        if (this.parser != null && this.parser.isDocumentChanged()) {
            this.showDialog("Save changes to opened document?");
        }
        this.initXMLtree();
        this.initCanvas();
    }

    private void openBtActionPerformed(ActionEvent evt) {
        if (this.parser != null && this.parser.isDocumentChanged()) {
            this.showDialog("Save changes to opened document?");
        }
        this.openXMLdocument();
    }

    private void saveBtActionPerformed(ActionEvent evt) {
        if (this.parser != null) {
            this.parser.saveXMLdoc(this.parser.openDocument, this.parser.openFile);
        }
    }

    private void closeBtActionPerformed(ActionEvent evt) {
        if (this.parser != null && this.parser.isDocumentChanged()) {
            this.showDialog("Save changes to opened document?");
        }
        System.out.print(this.dialogRetCode);
        this.initXMLtree();
        this.initCanvas();
    }

    private void newMenuItemActionPerformed(ActionEvent evt) {
        if (this.parser != null && this.parser.isDocumentChanged()) {
            this.showDialog("Save changes to opened document?");
        }
        this.initXMLtree();
        this.initCanvas();
    }

    private void openMenuItenActionPerformed(ActionEvent evt) {
        if (this.parser != null && this.parser.isDocumentChanged()) {
            this.showDialog("Save changes to opened document?");
        }
        this.openXMLdocument();
    }

    private void saveMenuItemActionPerformed(ActionEvent evt) {
        if (this.parser != null) {
            this.parser.saveXMLdoc(this.parser.openDocument, this.parser.openFile);
        }
    }

    private void closeMenuItemActionPerformed(ActionEvent evt) {
        if (this.parser != null && this.parser.isDocumentChanged()) {
            this.showDialog("Save changes to opened document?");
        }
        this.initXMLtree();
        this.initCanvas();
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        if (this.parser != null && this.parser.isDocumentChanged()) {
            this.showDialog("Save changes to opened document?");
        }
        System.exit(1);
    }

    private void saveAsMenuItemActionPerformed(ActionEvent evt) {
        this.saveXMLdocument();
    }

    private void dialogYesBTActionPerformed(ActionEvent evt) {
        this.dialogRetCode = "yes";
        this.closeDialog.setVisible(false);
    }

    private void dialogNoBTActionPerformed(ActionEvent evt) {
        this.dialogRetCode = "no";
        this.closeDialog.setVisible(false);
    }

    private void dialogCanBTActionPerformed(ActionEvent evt) {
        this.dialogRetCode = "cancel";
        this.closeDialog.setVisible(false);
    }

    private void formWindowClosing(WindowEvent evt) {
        if (this.parser != null && this.parser.isDocumentChanged()) {
            this.showDialog("Save changes to opened document?");
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new MainWindow().setVisible(true);
            }
        });
    }

    public void initXMLtree() {
        DefaultMutableTreeNode top = new DefaultMutableTreeNode("unknow");
        this.myTree = new XMLtree(top, this);
        this.myTree.add(this.treePopup);
        this.scrollPaneTree.setViewportView(this.myTree);
    }

    public void initCanvas() {
        this.drawPanel = new DrawPanel();
        this.scrollPaneCanvas.setViewportView(this.drawPanel);
        this.drawPanel.setPreferredSize(new Dimension(550, 450));
        this.drawPanel.revalidate();
        this.drawPanel.repaint();
    }

    public void showPopUp(Component comp, int x, int y) {
        this.treePopup.show(comp, x, y);
    }

    public void openXMLdocument() {
        JFileChooser chooser = new JFileChooser();
        this.recursivelySetFonts(chooser, new Font("Arial", 0, 12));
        chooser.setDialogTitle("Open Document");
        FileNameExtensionFilter filter = new FileNameExtensionFilter("xml", "XML");
        chooser.setFileFilter(filter);
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            File file = chooser.getSelectedFile();
            this.parser = new XMLreader();
            try {
                this.initCanvas();
                this.myTree.createTree(this.parser.openXMLdoc(file));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void saveXMLdocument() {
        JFileChooser chooser = new JFileChooser();
        this.recursivelySetFonts(chooser, new Font("Arial", 0, 12));
        chooser.setDialogTitle("Save Document");
        FileNameExtensionFilter filter = new FileNameExtensionFilter("xml", "XML");
        chooser.setFileFilter(filter);
        int returnVal = chooser.showSaveDialog(this);
        if (returnVal == 0 && this.parser != null) {
            File file = chooser.getSelectedFile();
            if (file.exists()) {
                System.out.println("Zelate si prepisat dokument");
                this.parser.saveXMLdoc(this.parser.openDocument, file);
            } else {
                file = new File(chooser.getSelectedFile().toString() + ".xml");
                this.parser.saveXMLdoc(this.parser.openDocument, file);
            }
        }
    }

    public void recursivelySetFonts(Component comp, Font font) {
        comp.setFont(font);
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            int ub = cont.getComponentCount();
            for (int j = 0; j < ub; ++j) {
                this.recursivelySetFonts(cont.getComponent(j), font);
            }
        }
    }

    public void showDialog(String actionText) {
        this.dialogRetCode = null;
        Dimension formsize = this.getSize();
        Point p = this.getLocation();
        this.closeDialog.setLocation(p.x + formsize.width / 3, p.y + formsize.height / 3);
        this.dialogLB.setText(actionText);
        this.closeDialog.setVisible(true);
        this.closeDialog.pack();
    }
}

