/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.DrawPanel;
import GUI.MainWindow;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.LineBorder;
import org.jdom.Attribute;
import org.jdom.Element;

public class ElementPanel
extends JPanel {
    private MainWindow mainWin;
    private Element thisElement = null;
    public ElementPanel myParent = null;
    public Vector<ElementPanel> drawChildList = new Vector();
    private int startCursorPosX;
    private int startCursorPosY;
    public int positionX = 0;
    public int positionY = 0;
    private JComboBox attrBox;
    private JPanel attrPanel;
    private JTextField attrValueTfield;
    public JList childList;
    private JPanel childPanel;
    private JScrollPane childScrollPane;
    public JLabel elementName;
    public JButton exitBt;
    public JPanel movePanel;
    private JTabbedPane tabbedPane;

    public ElementPanel(MainWindow mainWin) {
        this.initComponents();
        this.mainWin = mainWin;
    }

    private void initComponents() {
        this.tabbedPane = new JTabbedPane();
        this.childPanel = new JPanel();
        this.childScrollPane = new JScrollPane();
        this.childList = new JList();
        this.attrPanel = new JPanel();
        this.attrBox = new JComboBox();
        this.attrValueTfield = new JTextField();
        this.movePanel = new JPanel();
        this.elementName = new JLabel();
        this.exitBt = new JButton();
        this.setBackground(new Color(168, 205, 230));
        this.setBorder(new LineBorder(new Color(255, 255, 255), 1, true));
        this.tabbedPane.setFont(new Font("Arial", 0, 11));
        this.childList.setFont(new Font("Arial", 0, 11));
        this.childList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ElementPanel.this.childListMouseClicked(evt);
            }
        });
        this.childScrollPane.setViewportView(this.childList);
        GroupLayout childPanelLayout = new GroupLayout(this.childPanel);
        this.childPanel.setLayout(childPanelLayout);
        childPanelLayout.setHorizontalGroup(childPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.childScrollPane, GroupLayout.Alignment.TRAILING, -1, 136, Short.MAX_VALUE));
        childPanelLayout.setVerticalGroup(childPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(childPanelLayout.createSequentialGroup().addComponent(this.childScrollPane, -2, 61, -2).addContainerGap(63, Short.MAX_VALUE)));
        this.tabbedPane.addTab("child", this.childPanel);
        this.attrBox.setFont(new Font("Arial", 0, 11));
        this.attrBox.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ElementPanel.this.attrBoxMouseClicked(evt);
            }
        });
        this.attrBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ElementPanel.this.attrBoxActionPerformed(evt);
            }
        });
        GroupLayout attrPanelLayout = new GroupLayout(this.attrPanel);
        this.attrPanel.setLayout(attrPanelLayout);
        attrPanelLayout.setHorizontalGroup(attrPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.attrBox, GroupLayout.Alignment.TRAILING, 0, 136, Short.MAX_VALUE).addComponent(this.attrValueTfield, -1, 136, Short.MAX_VALUE));
        attrPanelLayout.setVerticalGroup(attrPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(attrPanelLayout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.attrBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.attrValueTfield, -2, -1, -2).addContainerGap(70, Short.MAX_VALUE)));
        this.tabbedPane.addTab("attribute", this.attrPanel);
        this.movePanel.setBackground(new Color(95, 153, 209));
        this.movePanel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                ElementPanel.this.movePanelMousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                ElementPanel.this.movePanelMouseReleased(evt);
            }
        });
        this.movePanel.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                ElementPanel.this.movePanelMouseDragged(evt);
            }
        });
        this.elementName.setFont(new Font("Arial", 1, 13));
        this.elementName.setText("Element");
        this.exitBt.setIcon(new ImageIcon(this.getClass().getResource("/images/closeElement.png")));
        this.exitBt.setBorder(BorderFactory.createCompoundBorder());
        this.exitBt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ElementPanel.this.exitBtActionPerformed(evt);
            }
        });
        GroupLayout movePanelLayout = new GroupLayout(this.movePanel);
        this.movePanel.setLayout(movePanelLayout);
        movePanelLayout.setHorizontalGroup(movePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, movePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.elementName, -1, -1, Short.MAX_VALUE).addGap(64, 64, 64).addComponent(this.exitBt)));
        movePanelLayout.setVerticalGroup(movePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.exitBt, -1, 18, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, movePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.elementName, -2, 11, -2)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.movePanel, -1, -1, Short.MAX_VALUE).addComponent(this.tabbedPane, -1, 141, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.movePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tabbedPane, -1, 149, Short.MAX_VALUE)));
    }

    private void exitBtActionPerformed(ActionEvent evt) {
        this.removeElementFromPanel(this.mainWin.drawPanel, this);
    }

    private void movePanelMousePressed(MouseEvent evt) {
        this.startCursorPosX = evt.getX();
        this.startCursorPosY = evt.getY();
        this.mainWin.drawPanel.moveToFront(this);
    }

    private void movePanelMouseDragged(MouseEvent evt) {
        this.positionX += evt.getX() - this.startCursorPosX;
        this.positionY += evt.getY() - this.startCursorPosY;
        if (this.positionX < 0) {
            this.positionX = 0;
        }
        if (this.positionY < 0) {
            this.positionY = 0;
        }
        this.mainWin.drawPanel.repaint();
    }

    private void attrBoxActionPerformed(ActionEvent evt) {
        this.mainWin.drawPanel.moveToFront(this);
        JComboBox cb = (JComboBox)evt.getSource();
        String str = (String)cb.getSelectedItem();
        Attribute attr = this.thisElement.getAttribute(str);
        this.attrValueTfield.setText(attr.getValue());
    }

    private void childListMouseClicked(MouseEvent evt) {
        this.mainWin.drawPanel.moveToFront(this);
        if (evt.getClickCount() >= 2) {
            String strEle = this.childList.getSelectedValue().toString();
            strEle = strEle.replace("<", "");
            strEle = strEle.replace(">", "");
            Element childElement = this.thisElement.getChild(strEle);
            DefaultListModel listModel = (DefaultListModel)this.childList.getModel();
            int position = this.childList.getSelectedIndex();
            listModel.remove(position);
            listModel.add(position, "nahrada");
            this.childList.setModel(listModel);
            ElementPanel newElement = new ElementPanel(this.mainWin);
            newElement.createElementComponent(childElement, this);
            this.mainWin.drawPanel.addNewElement(newElement);
            this.drawChildList.add(newElement);
        }
    }

    private void movePanelMouseReleased(MouseEvent evt) {
        this.mainWin.drawPanel.setPanelResize(true);
        this.mainWin.drawPanel.repaint();
    }

    private void attrBoxMouseClicked(MouseEvent evt) {
        this.mainWin.drawPanel.moveToFront(this);
    }

    public void createElementComponent(Element element, ElementPanel parent) {
        int i;
        this.thisElement = element;
        this.myParent = parent;
        this.elementName.setText("<" + element.getName() + ">");
        DefaultListModel<String> listModel = new DefaultListModel<String>();
        List list = element.getChildren();
        for (i = 0; i < list.size(); ++i) {
            Element child = (Element)list.get(i);
            listModel.addElement("<" + child.getName() + ">");
        }
        this.childList.setModel(listModel);
        list = element.getAttributes();
        for (i = 0; i < list.size(); ++i) {
            Attribute attr = (Attribute)list.get(i);
            this.attrBox.addItem(attr.getName());
        }
    }

    public void removeElementFromPanel(DrawPanel drawPanel, ElementPanel item) {
        if (item.myParent == null) {
            for (int i = 0; i < drawPanel.elementList.size(); ++i) {
                this.mainWin.drawPanel.remove(drawPanel.elementList.get(i));
            }
            drawPanel.elementList.removeAllElements();
            this.mainWin.drawPanel.revalidate();
            this.mainWin.drawPanel.repaint();
            return;
        }
        this.myParent.drawChildList.removeElement(item);
        if (item.drawChildList.size() != 0) {
            for (int i = 0; i < item.drawChildList.size(); ++i) {
                ElementPanel child = item.drawChildList.get(i);
                this.removeElementFromPanel(drawPanel, child);
            }
        }
        drawPanel.elementList.removeElement(item);
        this.mainWin.drawPanel.remove(item);
        this.mainWin.drawPanel.revalidate();
        this.mainWin.drawPanel.repaint();
    }
}

