/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.ElementPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.JLayeredPane;

public class DrawPanel
extends JLayeredPane {
    public Vector<ElementPanel> elementList = new Vector();
    private int minWidth = 550;
    private int minHeight = 450;
    private int scrollMaxX = 0;
    private int scrollMaxY = 0;
    private boolean resizePanel = false;
    BufferedImage imgGrid = null;

    public DrawPanel() {
        this.setLayout(new FlowLayout());
        this.setBackground(Color.WHITE);
        this.setOpaque(true);
        try {
            URL url = this.getClass().getResource("/images/grid.jpg");
            this.imgGrid = ImageIO.read(url);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void paintComponent(Graphics g) {
        int i;
        super.paintComponent(g);
        this.scrollMaxX = 0;
        this.scrollMaxY = 0;
        int f = 0;
        for (i = 0; i < 10; ++i) {
            g.drawImage(this.imgGrid, f, 0, this);
            f += 150;
        }
        for (i = 0; i < this.elementList.size(); ++i) {
            ElementPanel item = this.elementList.get(i);
            item.setLocation(item.positionX, item.positionY);
            for (int x = 0; x < item.drawChildList.size(); ++x) {
                ElementPanel itemChild = item.drawChildList.get(x);
                this.drawRelationLine(item, itemChild, g);
            }
            if (item.positionX > this.scrollMaxX) {
                this.scrollMaxX = item.positionX;
            }
            if (item.positionY <= this.scrollMaxY) continue;
            this.scrollMaxY = item.positionY;
        }
        if (this.isPanelResize()) {
            this.resizeDrawPanel(this.scrollMaxX, this.scrollMaxY);
            this.resizePanel = false;
        }
    }

    public void addNewElement(ElementPanel element) {
        this.add(element);
        this.moveToFront(element);
        this.elementList.add(element);
        element.positionX = 100;
        element.positionY = 100;
        this.revalidate();
    }

    public void resizeDrawPanel(int x, int y) {
        if (x < this.minWidth) {
            x = this.minWidth;
        }
        if (y < this.minHeight) {
            y = this.minHeight;
        }
        this.setPreferredSize(new Dimension(x + 100, y + 100));
        this.revalidate();
    }

    public boolean isPanelResize() {
        return this.resizePanel;
    }

    public void setPanelResize(boolean value) {
        this.resizePanel = value;
    }

    public void drawRelationLine(ElementPanel parent, ElementPanel child, Graphics g) {
        if (child.positionX < parent.positionX && child.positionY < parent.positionY) {
            g.drawLine(parent.positionX, parent.positionY, child.positionX + child.getWidth(), child.positionY + child.getHeight());
        } else if (child.positionX < parent.positionX && child.positionY > parent.positionY) {
            g.drawLine(parent.positionX, parent.positionY + parent.getHeight(), child.positionX + child.getWidth(), child.positionY);
        } else if (child.positionX > parent.positionX && child.positionY > parent.positionY) {
            g.drawLine(parent.positionX + parent.getWidth(), parent.positionY + parent.getHeight(), child.positionX, child.positionY);
        } else {
            g.drawLine(parent.positionX + parent.getWidth(), parent.positionY, child.positionX, child.positionY + child.getHeight());
        }
    }
}

