package convert.relaxng.translate;

import convert.relaxng.translate.util.InvalidParamsException;
import convert.relaxng.edit.SchemaCollection;
import convert.relaxng.input.InputFailedException;
import convert.relaxng.input.InputFormat;
import convert.relaxng.input.MultiInputFormat;
import convert.relaxng.input.xml.XmlInputFormat;
import convert.relaxng.input.dtd.DtdInputFormat;
import convert.relaxng.input.parse.compact.CompactParseInputFormat;
import convert.relaxng.input.parse.sax.SAXParseInputFormat;
import convert.relaxng.output.LocalOutputDirectory;
import convert.relaxng.output.OutputDirectory;
import convert.relaxng.output.OutputFailedException;
import convert.relaxng.output.OutputFormat;
import convert.relaxng.output.dtd.DtdOutputFormat;
import convert.relaxng.output.rnc.RncOutputFormat;
import convert.relaxng.output.rng.RngOutputFormat;
import convert.relaxng.output.xsd.XsdOutputFormat;
import convert.xml.sax.ErrorHandlerImpl;
import convert.util.Localizer;
import convert.util.OptionParser;
import convert.util.UriOrFile;
import convert.util.Version;
import org.xml.sax.SAXException;

import base.*;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Vector;

public class Driver {

    private static String inputType;
    private static String outputType;
    private static final ErrorHandlerImpl eh = new ErrorHandlerImpl();
    private static final String DEFAULT_OUTPUT_ENCODING = "UTF-8";
    private static final int DEFAULT_LINE_LENGTH = 72;
    private static final int DEFAULT_INDENT = 2;

    public static void SchematoSchema(String inputPath, String outputPath, File outputFile) {
        List<String> inputParams = new Vector<String>();
        List<String> outputParams = new Vector<String>();
        try {
            inputType = "";
            inputType = extension(inputPath);
            if (inputType.length() > 0) {
                inputType = inputType.substring(1);
            }
            InputFormat inFormat;
            inFormat = new SAXParseInputFormat();
            OutputFormat of;
            String ext = extension(outputPath);
            outputType = ext;
            if (outputType.length() > 0) {
                outputType = outputType.substring(1);
            }
            if (outputType.equalsIgnoreCase("dtd")) {
                of = new DtdOutputFormat();
            } else if (outputType.equalsIgnoreCase("rng")) {
                of = new RngOutputFormat();
            } else if (outputType.equalsIgnoreCase("xsd")) {
                of = new XsdOutputFormat();
            } else {//if (outputType.equalsIgnoreCase("rnc"))

                of = new RncOutputFormat();
            }
            String[] inputParamArray = inputParams.toArray(new String[0]);
            outputType = outputType.toLowerCase();
            SchemaCollection sc;

            sc = inFormat.load(UriOrFile.toUri(inputPath), inputParamArray, outputType, eh);
            OutputDirectory od = new LocalOutputDirectory(sc.getMainUri(),
                    outputFile,
                    ext,
                    DEFAULT_OUTPUT_ENCODING,
                    DEFAULT_LINE_LENGTH,
                    DEFAULT_INDENT);
            of.output(sc, od, outputParams.toArray(new String[0]), inputType.toLowerCase(), eh);

        } catch (Exception e) {
            MainWindow.ShowMessage("ERROR!", "Error occured while converting the XML schema!");
        }
    }

    static private String extension(String s) {
        int dot = s.lastIndexOf(".");
        if (dot < 0) {
            return "";
        }
        return s.substring(dot);
    }
}
