/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package base;

import base.*;


import java.awt.*;
import java.io.*;
import java.net.URL;
import java.util.*;
import org.dom4j.*;
import org.dom4j.io.*;
import org.jdom.*;
import org.jdom.input.SAXBuilder;
import org.apache.commons.io.IOUtils;


/**
 *
 * @author illi
 */
public class XMLHandler {

    
    private static SAXBuilder saxBuilder;
    private static boolean validate = false;
    private static BufferedReader reader;
    private static byte[] xml = new byte[] {};
    

    
    /**
     * Metoda ktora nacita dokument z daneho URL
     * 
     * @param url cesta k dokumentu
     * @return vracia xml dokument
     * @throws org.dom4j.DocumentException - ked je problem s dokumentom
     */
    public static org.jdom.Document readDocument(String path) throws Exception {
        saxBuilder = new SAXBuilder("org.apache.xerces.parsers.SAXParser", validate);
        /*reader = new BufferedReader(new FileReader(new File(path)));
        xml = IOUtils.toByteArray(reader);*/
        URL url = new File(path).toURL();
        org.jdom.Document document = saxBuilder.build(url);
        return document;
    }

    /**
     * Metoda ktora dany dokument naformatuje do stringu
     * 
     * @param doc dokument z ktoreho sa nacitava
     * @return string ktory obsahuje naformatovany dokument
     */
    static public String docToString(String doc) {
        StringBuilder sb = new StringBuilder();
                
        try {
            BufferedReader breader = new BufferedReader(new FileReader(new File(doc)));
            String line = "";
            while((line = breader.readLine()) != null) {
                sb.append(line + "\n");
            }
            breader.close();
            return sb.toString();
        } catch (Exception e) {
            MainWindow.ShowMessage("ERROR!","Unable to load XML document!");
            return "";
        } 
    }
    
    /*static public String docToString(Document doc) {
        try {
            String encoding = doc.getXMLEncoding();
            if (encoding == null) {
                encoding = "UTF-8";
            }
            Writer osw = new StringWriter();
            OutputFormat opf = new OutputFormat("", false, encoding);
            XMLWriter xmlwriter = new XMLWriter(osw, opf);
            xmlwriter.write(doc);
            xmlwriter.close();
            return osw.toString();
        } catch (IOException ex) {
            MainWindow.ShowMessage("ERROR!","Unable to load XML document!");
            return "";
        }
    }*/
    
    /**
     * Zápis stringu do suboru
     * @param string string nacitany z okna
     * @throws java.io.IOException
     */
    public static void writeFromString(String string) throws IOException {
        /*String t = ".xml";
        if (MainWindow.XMLpath.substring(MainWindow.XMLpath.length() - 4).compareTo(t) != 0) {
            MainWindow.XMLpath += t;
        }*/
        BufferedWriter out = new BufferedWriter(new FileWriter(MainWindow.XMLpath));
        out.write(string);
        out.close();
    }
    
    /**
     * Metoda na vyrvorenie configuracneho suboru config.xml
     * @throws java.io.IOException
     */
    public static void createConfig() throws IOException {
        String filename = "./config.xml";
        org.dom4j.Document document = DocumentHelper.createDocument();
        org.dom4j.Element root = document.addElement("config");
        root.addElement("XMLTextColorR").addText(Integer.toString(MainWindow.XMLColor.getRed()));
        root.addElement("XMLTextColorG").addText(Integer.toString(MainWindow.XMLColor.getGreen()));
        root.addElement("XMLTextColorB").addText(Integer.toString(MainWindow.XMLColor.getBlue()));
        root.addElement("XSDTextColorR").addText(Integer.toString(MainWindow.XSDColor.getRed()));
        root.addElement("XSDTextColorG").addText(Integer.toString(MainWindow.XSDColor.getGreen()));
        root.addElement("XSDTextColorB").addText(Integer.toString(MainWindow.XSDColor.getBlue()));
        root.addElement("SchemaOutputFormat").addText(Integer.toString(MainWindow.SchemaOutputFormat));
        root.addElement("DisplayMode").addText(Integer.toString(MainWindow.DisplayMode));
        root.addElement("HelpPath").addText(MainWindow.HelpPath);
        root.addElement("DocPath").addText(MainWindow.DocPath);
        XMLWriter writer = new XMLWriter(new FileWriter(filename));
        writer.write(document);
        writer.close();
    }
    
     /**
     * Metoda ktora nacita konfiguracny subor
      * 
     */
    public static void loadConfig() throws DocumentException {
        String filename = "./config.xml";
        SAXReader sreader = new SAXReader();
        org.dom4j.Document doc = sreader.read(filename);
        org.dom4j.Element root = doc.getRootElement();
        try{
            MainWindow.XMLColor = new Color(
                    Integer.parseInt(root.elementText("XMLTextColorR")), 
                    Integer.parseInt(root.elementText("XMLTextColorG")), 
                    Integer.parseInt(root.elementText("XMLTextColorB")));
            MainWindow.XSDColor = new Color(
                    Integer.parseInt(root.elementText("XSDTextColorR")), 
                    Integer.parseInt(root.elementText("XSDTextColorG")), 
                    Integer.parseInt(root.elementText("XSDTextColorB")));
            MainWindow.SchemaOutputFormat = Integer.parseInt(root.elementText("SchemaOutputFormat"));
            MainWindow.DisplayMode = Integer.parseInt(root.elementText("DisplayMode"));
            MainWindow.HelpPath = root.elementText("HelpPath");
            MainWindow.DocPath = root.elementText("DocPath");
        }catch (Exception ex){
            MainWindow.XMLColor = new Color(0, 0, 0);
            MainWindow.XSDColor = new Color(0, 80, 0);
            MainWindow.SchemaOutputFormat = 0;
            MainWindow.DisplayMode = 0;
            MainWindow.HelpPath = "doc/help/helpcontents.html";
            MainWindow.DocPath = "doc/javadoc/index.html";
        }
    }
}
