// XmlValidtation (For .NET 2.0)
// Author: Keyvan Nayyeri (www.nayyeri.net)
// Copyright  2006 Keyvan Nayyeri

using System;
using System.Xml;
using System.Xml.Schema;
using System.IO;
using System.Collections;

namespace XMLDabster
{
	/// <summary>
	/// This class gets the address of an XML and
	/// an XSD Schema file and validates XML file against
	/// this Schema and returns an ArrayList of string
	/// values of all errors.
	/// </summary>
	public class Validator
	{
		#region Private members
		private string XSDPath;
		private XmlTextReader Reader;
		private ArrayList Results = new ArrayList();
		#endregion
		#region Constructor
		/// <summary>
		/// Gets the address of XSD Schema file and sets the relative private member.
		/// with its value.
		/// </summary>
		/// <param name="XSD">The physical path of XSD Schema file.</param>
		public Validator(string XSD)
		{
			this.XSDPath = XSD;
		}// XMLValidator
		#endregion
		#region Public methods
		/// <summary>
		/// This public method tries to return all errors
		/// of validating the XML file against XSD Schema.
		/// </summary>
		/// <param name="XMLPath">The physical path of XML file.</param>
		/// <returns>An ArrayList of string values of all errors</returns>
		public ArrayList ValidateIt(string XMLPath)
		{
			ValidatingProcess(XMLPath);

			return this.Results;
		}// ValidateIt
		#endregion
		#region Private methods
		/// <summary>
		/// Creates an XML Schema and adds it to the collection of our schemas.
		/// </summary>
		private void ValidatingProcess(string XMLPath)
		{
            try
            {
                // 1- Read XML file content
                this.Reader = new XmlTextReader(XMLPath);

                // 2- Read Schema file content
                StreamReader SR = new StreamReader(this.XSDPath);

                // 3- Create a new instance of XmlSchema object
                XmlSchema Schema = new XmlSchema();
                // 4- Set Schema object by calling XmlSchema.Read() method
                Schema = XmlSchema.Read(SR, 
                    new ValidationEventHandler(ReaderSettings_ValidationEventHandler));

                // 5- Create a new instance of XmlReaderSettings object
                XmlReaderSettings ReaderSettings = new XmlReaderSettings();     
                // 6- Set ValidationType for XmlReaderSettings object
                ReaderSettings.ValidationType = ValidationType.Schema;                
                // 7- Add Schema to XmlReaderSettings Schemas collection
                ReaderSettings.Schemas.Add(Schema);

                // 8- Add your ValidationEventHandler address to 
                // XmlReaderSettings ValidationEventHandler
                ReaderSettings.ValidationEventHandler += 
                    new ValidationEventHandler(ReaderSettings_ValidationEventHandler);

                // 9- Create a new instance of XmlReader object
                XmlReader objXmlReader = XmlReader.Create(Reader, ReaderSettings);


                // 10- Read XML content in a loop
                while (objXmlReader.Read())
                { /*Empty loop*/}

            }//try
            // Handle exceptions if you want
            catch (UnauthorizedAccessException AccessEx)
            {
                throw AccessEx;
            }//catch
            catch (Exception Ex)
            {
                throw Ex;
            }//catch
		}// ValidatingProcess
		/// <summary>
		/// This handler simply adds all erros with their line and
		/// position number to the result.
		/// </summary>
		/// <param name="sender">object</param>
		/// <param name="args">ValidationEventArgs</param>
        private void ReaderSettings_ValidationEventHandler(object sender, 
            ValidationEventArgs args)
		{
            // 11- Implement your logic for each validation iteration
          	string strTemp;
			strTemp = "Line: " + this.Reader.LineNumber + " - Position: " 
                + this.Reader.LinePosition + " - " + args.Message;

			this.Results.Add(strTemp);
        }// ReaderSettings_ValidationEventHandler
		#endregion
	}
}
