﻿//
// Author: Ladislav Pospech, xpospe01
// Email: xpospe01@stud.fit.vutbr.cz, ladislav.pospech@gmail.com
//
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;

namespace XMLDabster
{
  static class HTMLProc
  {
    /// <summary>
    /// metoda ma na vstupu datovou tabulku a cestu elementu od korene dokumentu
    /// z toho vygeneruje HTML kod zobrazeni cele tabulky a vrati jej pro ulozeni.
    /// </summary>
    /// <param name="table">Datova tabulka kterou chceme exportovat</param>
    /// <param name="pathFromRoot">Cesta od korene dokumentu ke zvolenemu elementu</param>
    /// <returns>retezec s vygenerovanym HTML kodem</returns>
    public static string CreateHTML(DataTable table, string pathFromRoot)
    {
      string HTMLout = "";
      string trStart = "<tr>";
      string trEnd = "</tr>";
      string tdStart = "<td>";
      string tdEnd = "</td>";
      string tdHeadStart = "<td bgcolor=\"#33CCFF\"><strong>";
      string tdHeadEnd = "</strong></td>";
      
      string tableStart = "<table border=\"1\" cellpadding=\"4\" cellspacing=\"0\" bordercolor=\"#000000\">";
      string tableEnd = "<table>";
      
      string head1 = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">" +
                     "<html xmlns=\"http://www.w3.org/1999/xhtml\"><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" /><title>";
      string title = table.TableName.Remove(table.TableName.LastIndexOf('.'));
      string head2 = "</title></head><style>";
      string styles = "body {font-family: Verdana, Arial, Helvetica, sans-serif;}\ntd {font-size:small;}";
      string head3 = "</style><body><h1>";
      string header = pathFromRoot;
      string head4 = "</h1>";

      string footer = "<br /><font size=\"1\">Generated by XMLDabster @ Ladislav Pospěch 2008</font></body></html>";

      HTMLout = head1 + title + head2 + styles + head3 + header + head4 ;

      HTMLout += tableStart + trStart;

      foreach (DataColumn dataCol in table.Columns)
      {
        HTMLout += tdHeadStart + dataCol.ColumnName + tdHeadEnd;
      }

      HTMLout += trEnd;

      foreach (DataRow dataRow in table.Rows)
      {
        HTMLout += trStart;
        foreach (DataColumn dataCol in table.Columns)
        {
          HTMLout += tdStart + dataRow[dataCol].ToString() + tdEnd;
        }
        HTMLout += trEnd;
      }

      HTMLout += tableEnd;

      HTMLout += footer;

      return HTMLout;

    }
  }
}
