//-----------------------------------------------------------------------------
// pyramid.h
// Pyramid of images and auxiliary structures for detection.
// Jiri Havel, DCGM FIT BUT, Brno
// $Id$
//-----------------------------------------------------------------------------

#ifndef _PYRAMID_H_
#define _PYRAMID_H_

#include <vector>

#include <cv.h>

#include "lrd_engine.h"
#include "imagetools.h"

class Pyramid
{
private :

	class Level
	{
	public :
		float width, height;
		IplImage *image;
		std::vector<TConvolution *> *convolutions;
		int *xAddressTable;
		int *yAddressTable;
		Rank *ranks;

		Level();

		//alloc image, convolutions
		//alloc and fill address tables and ranks
		void Init(const CvSize &, const TClassifier &);
		void Kill();

		void InitInstance(const Level & level);
		void KillInstance();

		//Calculate convolutions from image
		void Convolve();

		unsigned Scan(const TClassifier & classifier, TDetectionList &detections);
	};

	typedef std::vector<Level> Levels;
	Levels levels;

	typedef std::vector<Pyramid*> Instances;
	Instances instances;

	static unsigned getLevelCount(unsigned octaves, CvSize size, const TClassifier & classifier);

	void InitInstance(const Pyramid & pyramid);
	void KillInstance();

public :

	Pyramid(unsigned instanceCount = 1);
	~Pyramid();

	//allocate pyramid levels
	void Init(unsigned octaves, const CvSize &size, const TClassifier &);
	void Kill();

	//fill pyramid levels
	void Build(IplImage *image);

	//calculate convolutions and run detection(parallel if omp available)
	unsigned Scan(const TClassifier & classifier, const CvSize &originalSize, TDetectionList & detections);

	//instancing for paralelizaton
	Pyramid *getInstance(unsigned id);
};

#endif
