/******************************************************************************
 *      "Copyright (C) 2006, ApS s.r.o Brno, All Rights Reserved"             *
 ******************************************************************************
 *============================================================================*
 *   Version "0.1"    Header/source file for the project   "xmltransutils.h"  *
 *----------------------------------------------------------------------------*
 * VERSION   DATE    TIME  BY   CHANGE/COMMENTS                               *
 *----------------------------------------------------------------------------*
 *============================================================================*/
 
#ifndef __XMLTRANSUTILS__
#define __XMLTRANSUTILS__

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

static const int IO_BUFF_SIZE = 100000;	// size of buffer for I/O opration 

/*
 * structure which represents the table of simulators - needed for SoC simulation
 * it's used as storage of information where simulators are running
 *  name : name of the simulator
 *  ip: ip address of the computer where simulator is running
 *  port: port
 * 
 */
typedef struct TSimTable {
    char *name;
    char *ip;
    char *port;
    struct TSimTable *next;
} SimTable;

/*
 * common structure for data interchange between MiddleWare and its clients    
 * 
 */
typedef struct TShContainer
{
	char *buffer; 	// start of allocated memory 
	char *data;		// ==buffer+(sizeof(int) ->{ size of data  for I/O} )
	int size;				// size of data 
	int max_size;	// maximum allocated memory
} ShContainer;

/***
 * <COMMAND>
 * 		<ID> ... </ID>
 * 		<PARAMS>
 * 			<ITEM> ... </ITEM>
 * 			<ITEM> ... </ITEM>
 * 			<ITEM> ... </ITEM>
 *			.....  
 * 		</PARAMS> 
 * 	</COMMAND>
 * 
 * */
static const char *XML_TAGS_CMD[2]={"<COMMAND>","</COMMAND>"};
static const char *XML_TAGS_ID[2]={"<ID>","</ID>"};
static const char *XML_TAGS_PARAMS[2]={"<PARAMS>","</PARAMS>"};
static const char *XML_TAGS_ITEM[2]={"<ITEM>","</ITEM>"};
static const char *XML_TAGS_SIMNAME[2]={"<SIMID>","</SIMID>"};
static const char *XML_TAGS_PORT[2]={"<PORT>","</PORT>"};
static const char *XML_TAGS_HOST[2]={"<HOST>","</HOST>"};

static const int OPEN_TAG = 0;
static const int CLOSE_TAG = 1;

/*
 *	base on the argv create XML document
 * 	char *commadStr 	- reference to the string of command	
 * 	char *outBuff	 	- output buffer which contains the XML document
 * 	int *argc			- number of parameters from XML document	
 * 	char **argv			- parameters of XML document
 * 	@return: true parsing of XML struct without error
 */
bool createCmdXMLDocument(char *commadStr,ShContainer *shc,int argc,char **argv);	
/*
 *	base on XML document set the argv, argc and cmd
 * 	char **commadStr 	- reference to the string of command	
 * 	char *inBuff	 	- input buffer which contains the XML document
 * 	int *argc			- number of retrieved parameters from XML document	
 * 	char **argv			- retrieved parameters from XML document
 * 	@return: true parsing of XML struct without error
 */
bool getCmdXMLDocument(char **commadStr,ShContainer *shc,int *argc,char **argv);
/* 
 * parses the config file for multiple simulator install
 * int *argc - number of simulators to install  
 */
bool getConfigXMLDocument(char *filename,char ** name,char **ip, char ** port, int *arg_c);
int getFileSize(char *fileName);		// get file size	
char *getFileContent(char *filename); 	// malloc buffer with file content

// Shared Container management
void allocShContainer(ShContainer *shCont,int max_size);
void releaseShContainer(ShContainer *shCont);

//Simtable management
void insertNewSim(char *name, char* ip, char* port);
void releaseSimTable();
//fills argv and argc for createCMD
void getSimArray(char** argv, int *argc);
//@@REMOVE - just for debug
void printSimTable();
	
#endif // XMLTRANS
