/******************************************************************************
 *      "Copyright (C) 2006, ApS s.r.o Brno, All Rights Reserved"             *
 ******************************************************************************
 *============================================================================*
 *   Version number    Header/source file for the project   "file name"     *
 *----------------------------------------------------------------------------*
 * VERSION   DATE    TIME  BY   CHANGE/COMMENTS                               *
 *----------------------------------------------------------------------------*
 *============================================================================*/

#ifndef _SCANNEROBJ_H_INCLUDED_
#define _SCANNEROBJ_H_INCLUDED_

#include "objectfile.h"

#define UNDEFINEDNUM -1

using namespace ObjectFile;


class CScanner{
	public:
		CScanner();
		CScanner(const char *sStr);
		~CScanner();
		
		
		bool LoadFile();
		bool LoadFile(const char* sStr);
		
		//fce pro ziskavani bitu.
		//pokud jsme dorazili na konec, vrazi EOF
		int yylex();

		int GetSecCount();
		int GetDataAddr();
		
	private:
	
		//ziskame dalsi sekci v souboru
		//pokud uz zadna neni, vracime NULL
		CSection* GetNextSection();
		//aktualni sekce
		CSection* m_pActualSection;
		//data sekce, ktera je nactena
		CSectionData * m_pData;
		
		//jmeno vstupniho souboru
		char *m_sFileName;
		
		// address from which the lex returns data
		int m_dataaddr;
		
		//trida pro reprezentaci vstupniho formatu.
		//po nacteni je v ni uchovano vse potrebne pro
		//disassemblovani
		CObjectFile* m_pObjectFile;
		
		//z vstupniho souboru jsou binarni data ziskavana po slovech
		//delka slova je ulozena ve vystupnim formaru
		bool m_bDataLoaded;
		std::string m_sData;
		
		//delka slova, jde o delku "radku" v vystupnim formatu
		int m_nWordLength;
		//jak jsou data ulozena
		eByteOrder m_eByteOrder;
		//pocet sekci (i datovych)
		int m_nSectionsCount;
		//aktualni sekce, konkretne jeji cislo
		int m_nActualSection;
		//pocet "radku" v sekci
		int m_nSectionDataCount;
		//aktualni "radek" v sekci	
		int m_nSectionActualData;
		//aktualni pozice v "radku"
		//delka radku je delka slova (viz. vise)
		int m_nWordActualData;

};

#endif


