#include "image.h"

namespace umf {

template<class T, int NCHAN>
Image<T, NCHAN>::Image(int width, int height, bool allocate, int widthstep)
    :width(width), height(height), channels(NCHAN), allocated(allocate)

{
    if(widthstep == -1)
    {
        this->widthstep = width*NCHAN*sizeof(T);
    } else {
        this->widthstep = widthstep;
    }


    if(allocate)
    {
        this->data = new char[this->widthstep*this->height];
    } else {
        this->data = nullptr;
    }
}


template<class T, int NCHAN>
Image<T, NCHAN>::~Image()
{
    if(this->allocated)
    {
        delete [] this->data;
    }
}



template<class T, int N>
Eigen::Matrix<T, N, 1> Image<T, N>::get2De(int x, int y)
{
    Eigen::Matrix<T, N, 1> retVal;
    T *p = this->get2D(x, y);
    for(int i = 0; i < N; i++){
        retVal(i) = p[i];
    }
    return retVal;
}

template<class T, int N>
void Image<T, N>::get2Der(Eigen::Matrix<T, N, 1> &retVal, int x, int y)
{
    T *p = this->get2D(x, y);
    for(int i = 0; i < N; i++){
        retVal(i) = p[i];
    }
}

template<>
void Image<unsigned char, 3>::get2Der(Eigen::Matrix<unsigned char, 3, 1> &retVal, int x, int y)
{
    unsigned char *p = this->get2D(x, y);
	retVal[0] = p[0];
	retVal[1] = p[1];
	retVal[2] = p[2];
}


template<>
Eigen::Matrix<unsigned char, 3, 1> Image<unsigned char, 3>::get2De(int x, int y)
{
    unsigned char *p = this->get2D(x, y);
    return Eigen::Matrix<unsigned char, 3, 1>(p[0], p[1], p[2]);
}



void convertToGrayscale(ImageRGB *rgb, ImageGray* gray)
{
	if(rgb->width != gray->width || rgb->height != gray->height)
	{
		return;
	}
    for(int row = 0; row < rgb->height; row++)
	{
        for(int col = 0; col < rgb->width; col++)
		{
			unsigned char* p = (unsigned char*) &(rgb->data[row*rgb->widthstep + col*rgb->channels]);
			gray->data[row*gray->widthstep + col] = (unsigned char) (0.299 * p[0]  + 0.587 * p[1] + 0.114*p[2]);
		}
	}
}

template ImageRGB::Image(int width, int height, bool allocate, int widthstep);
template ImageGray::Image(int width, int height, bool allocate, int widthstep);
template ImageRGB::~Image();
template ImageGray::~Image();

//template Eigen::Matrix<unsigned char, 3, 1> ImageRGB::get2De(int x, int y);
template Eigen::Matrix<unsigned char, 1, 1> ImageGray::get2De(int x, int y);

template void ImageGray::get2Der(Eigen::Matrix<unsigned char, 1, 1> &tp, int x, int y);

}
