#ifndef __UMF_UMF_H__
#define __UMF_UMF_H__

#include "util/stream_factory.h"
#include "util/image.h"
#include "util/exceptions.h"
#include "util/umfdebug.h"
#include "edgel_detector.h"
#include "grid_detector.h"
#include "edge_dir_detector.h"
#include "model.h"
#include <vector>
#include <exception>
#include <limits>


namespace umf
{

enum DETECTOR_FLAGS
{
    UMF_FLAG_TRACK_POS = 0x01,
    UMF_FLAG_TRACK_LOCAL_POS = 0x03,
    UMF_FLAG_SUBWINDOWS = 0x04,
    UMF_FLAG_ITER_REFINE = 0x08,
    UMF_FLAG_SUBPIXEL = 0x10,
    UMF_FLAG_CHROMAKEY = 0x20,
    UMF_FLAG_ORIENTATION = 0x40,
	UMF_FLAG_HOMOGRAPHY = 0x80
};

class DetectionTimeoutException: public exception
{
  virtual const char* what() const throw()
  {
    return "DetectionTimout";
  }
};

template< int NCHAN >
class UMFDetector
{
public:
    UMFDetector(int flags);
    ~UMFDetector();

    bool loadMarker(const char* marker_str);

    template< class T >
    bool detect(Image<T, NCHAN> *image, float timeout = -1) throw(DetectionTimeoutException);

    template< class T >
    bool detectPosition(Image<T, NCHAN> *image, std::vector<Eigen::Vector2f> &imgPos, std::vector<Eigen::Vector2f> &modelPos);

	EdgelDetector edgelDetect;
    GridDetector gridDetect;
    EdgeDirDetector<NCHAN> edgeDirDetect;
    Model<NCHAN> model;

private:

    Timer detectionTimer;
    bool checkTimeout(float timeout, bool shouldThrow = true) throw(DetectionTimeoutException);

    template <class T >
    int processSubWindow(Image<T, NCHAN> *image, Eigen::Vector2i &offset, Eigen::Vector2i &size, Location &loc, ImageGray *mask = NULL, bool show = false);

    void getSubwindowOffsets(const Eigen::Vector2i &imgSize,
                             std::vector<Eigen::Vector2i> &offsets,
                             Eigen::Vector2i &subwindowSize);

    void getPointPosition(Location &reflocation, Eigen::Vector2f &imgPos, Eigen::Vector2f &modelPos);

    int flags;
    int subWindowVerticalCount;
    ImageGray *filterMask;
};

}

#endif
