#ifndef _UMF_SCREEN_MARKER_API_
#define _UMF_SCREEN_MARKER_API_

#include <opencv2/core/core.hpp>
#include <opencv2/calib3d/calib3d.hpp>

#ifndef UMF
#define UMF 
#endif

#define UMF_DETECTOR_CHANNELS 1

typedef struct 
{
    cv::Mat H;
} DetectorResult;

   
typedef struct
{
	void *detector;
} DetectorProperties;

#ifdef __cplusplus
extern "C" {
#endif



/******** Detection *********************************************************************************/
/**
 * @param detector the detector created with umf_create_detector
 * @param input input image (gets automatically converted to grayscale, if single channel detector (UMF_DETECTOR_CHANNELS), RGB images has to be RGB, not BGR (opencv default)
 * @param result All the required results
 * @param debug optional RGB image with some debug output - for now ignored
 * @return 1 if success; 0 if fail; <0 if error with parameters
*/
UMF int __stdcall umf_detect(DetectorProperties *detector, cv::Mat *input, DetectorResult *result, cv::Mat *debug = NULL);


/******** Initialization ****************************************************************************/

//Create detector 
UMF int __stdcall umf_create_detector(DetectorProperties *props);

/**
 * Use the marker set by str.
 * The format has to be:
width
height
kernelsize;0
encodedType
datarow0
datarow1
...
datarowHeight
EOF

encodedType -> (numberofshades - 2) << 2
 */
UMF int __stdcall umf_set_marker_str(DetectorProperties *props, char *str);

UMF void __stdcall umf_free_detector(DetectorProperties *detector);


#ifdef __cplusplus
}
#endif

#endif
