package org.fit.graph.umfdetector;

import android.hardware.SensorManager;
import android.util.Log;

/**
 * 
 * @author iszent
 * TODO lil' hacky fixit
 */

public class UMFOrientationFilter implements UMFSensorManager.UMFSensorListener {

	private static final String TAG = "UMFOrientation";
	private static int HISTORY_SIZE = 2;
	private float[] accelerationHistory = new float[HISTORY_SIZE * 3];
	private float[] magSensorValues = new float[3];
	private int historyIndex = 0;

	private boolean onStart = true;
	private boolean useHandBased = false;
	private float[] filterAngles = new float[2];
	
	public synchronized boolean resetState(){
		if(onStart) {
			Log.w(TAG, "Reset called before accelerometer could initialize");
			return false;	
		}
		float[] avgValues = new float[3];
		//now we can start counting
		for(int i = 0; i<HISTORY_SIZE; i++){
			avgValues[0] += accelerationHistory[i*3];
			avgValues[1] += accelerationHistory[i*3+1];
			avgValues[2] += accelerationHistory[i*3+2];
		}
		
		for(int i=0; i<3; i++){
			avgValues[i] /= HISTORY_SIZE;
		}
		
		return true;
	}
	
	public synchronized void getMainAngles(float[] angles)
	{
		angles[0] = filterAngles[0];
		angles[1] = filterAngles[1];
	}

	@Override
	public void onAccelerationChanged(float x, float y, float z, float timeDiff) {
		// first fill the history before giving any data away
		if (onStart) {
			synchronized (this) {
				accelerationHistory[historyIndex * 3] = x;
				accelerationHistory[historyIndex * 3 + 1] = y;
				accelerationHistory[historyIndex * 3 + 2] = z;
				historyIndex++;
				if (historyIndex == HISTORY_SIZE) {
					historyIndex = 0;
					onStart = false;
					this.resetState();
				}
			}
			return;
		}

		float[] avgValues = new float[3];
		// store history
		synchronized (this) {
			accelerationHistory[historyIndex * 3] = x;
			accelerationHistory[historyIndex * 3 + 1] = y;
			accelerationHistory[historyIndex * 3 + 2] = z;

			historyIndex = (historyIndex + 1) % HISTORY_SIZE;

			// now we can start counting
			for (int i = 0; i < HISTORY_SIZE; i++) {
				avgValues[0] += accelerationHistory[i * 3];
				avgValues[1] += accelerationHistory[i * 3 + 1];
				avgValues[2] += accelerationHistory[i * 3 + 2];
			}
		}

		for (int i = 0; i < 3; i++) {
			avgValues[i] /= HISTORY_SIZE;
		}
		// for now everything in here, if too slow with reaction maybe Looper
		
		float[] rotationAngles = new float[3];
		
		/*
		if (useHandBased) {
			handGetAngles(avgValues, rotationAngles);
		} else {
			phoneGetAngles(avgValues, rotationAngles);
		}
		*/
		
		float sum = (float) Math.sqrt(avgValues[0]*avgValues[0] + avgValues[1]*avgValues[1]);
		if(sum < 1e-3)
		{
			rotationAngles[2] = 0;
		} else {
			rotationAngles[2] = (float) Math.acos(avgValues[0]/sum);
		}
		/**
		 * rotationAngles - see http://developer.android.com/reference/android/hardware/SensorManager.html#getOrientation%28float[],%20float[]%29
		 *  0 - rotate around phone normal
		 *  1 - rotate up/down
		 *  2 - rotate around phone's main axis
		 * 
		 * all below anticlockwise 
		 */
		this.filterAngles[0] = (float) Math.PI - rotationAngles[2];
		this.filterAngles[1] = rotationAngles[2] + (float) (Math.PI/2.f);
		//Log.v(TAG, "Filter angle: " + (int) (rotationAngles[0]*180.0/Math.PI) + " " + (int) (rotationAngles[1]*180.0/Math.PI) + " " + (int) (rotationAngles[2]*180.0/Math.PI));
	}
	

	private float getAngle(float axis1, float axis2){
		return (float) Math.acos(axis1/Math.sqrt(axis1*axis1 + axis2*axis2));
	}
	
	private void phoneGetAngles(float[] avgValues, float[] rotationAngles){
		rotationAngles[0] = this.getAngle(avgValues[2],
				(float) Math.sqrt(avgValues[1]*avgValues[1]+avgValues[0]*avgValues[0]));
		rotationAngles[1] = this.getAngle(avgValues[1], 
				(float) Math.sqrt(avgValues[2]*avgValues[2]+avgValues[0]*avgValues[0]));
		rotationAngles[2] = this.getAngle(avgValues[0], 
				(float) Math.sqrt(avgValues[2]*avgValues[2]+avgValues[1]*avgValues[1]));
	}
	
	private void handGetAngles(float[] avgValues, float[] rotationAngles){

        float[] rotationMatrix = new float[16];
        float[] inclinationMatrix = new float[16];
        float[] orientationAngles = new float[3];
        SensorManager.getRotationMatrix(rotationMatrix, inclinationMatrix, avgValues, this.magSensorValues);
        SensorManager.getOrientation(rotationMatrix, orientationAngles);
        rotationAngles[0] = orientationAngles[0];
        rotationAngles[1] = orientationAngles[1];
        rotationAngles[2] = orientationAngles[2];
	}

	@Override
	public void onMagSensorChanged(float field1, float field2, float field3) {
		magSensorValues[0] = field1;
		magSensorValues[1] = field2;
		magSensorValues[2] = field3;
	}

}
