package org.fit.graph.umfdetector;

import android.content.Context;
import android.graphics.ImageFormat;
import android.hardware.Camera;
import android.hardware.Camera.PreviewCallback;

public class UMFCameraPreviewCallback implements PreviewCallback {
	
	public static interface DetectionCallback {
		
		public void onUMFDetected(int success);
	}
	
	
	private NativeDetector detector;
	private NativeDetector.Result resultCache;
	private DetectionCallback detcb;
	private Camera camera;
	private UMFSensorManager sensorManager;
	private UMFOrientationFilter orientationFilter;
	
	public UMFCameraPreviewCallback()
	{
		detector = new NativeDetector();
		resultCache = null;
		detcb = null;
		sensorManager = new UMFSensorManager();
		orientationFilter = new UMFOrientationFilter();
	}
	
	public void setCallback(DetectionCallback cb)
	{
		this.detcb = cb;
	}

	public void startDetection(Context context, Camera camera) {

		//startup application
		sensorManager.startListening(context, this.orientationFilter);
		
		Camera.Parameters p = camera.getParameters();
        Camera.Size mcamsize = p.getPreviewSize();
		detector.init(mcamsize.width, mcamsize.height);
		int format = p.getPreviewFormat();
		int bitsp = ImageFormat.getBitsPerPixel(format);
		int bufSize = bitsp*mcamsize.width*mcamsize.height/8;

		byte[] buffer1 = new byte[bufSize];
		//byte[] buffer2 = new byte[bufSize];
		//byte[] buffer3 = new byte[bufSize];
	
		camera.addCallbackBuffer(buffer1);
		//camera.addCallbackBuffer(buffer2);
		//camera.addCallbackBuffer(buffer3);
		
		camera.setPreviewCallbackWithBuffer(this);
		this.camera = camera;
	}
	
	public void stopDetection() {
		sensorManager.stopListening();
		this.camera.setPreviewCallbackWithBuffer(null);
		detector.free();
		this.camera = null;
	}
	
	@Override
	public void onPreviewFrame(byte[] data, Camera camera) {
		Camera.Size size = camera.getParameters().getPreviewSize();
		
		NativeDetector.Result tempresult = new NativeDetector.Result();
		float[] angles = new float[2];
		this.orientationFilter.getMainAngles(angles);
		int success = detector.detect(data, size.width, size.height, angles[0], tempresult);
		
		if(success > 0)
		{
			this.resultCache = tempresult;
		}
		
		if(this.detcb != null)
		{
			this.detcb.onUMFDetected(success);
		}

		//add back buffer to the front
		camera.addCallbackBuffer(data);
	}
	
	public void getImageCenter(float[] center)
	{
		if(resultCache != null)
		{
			center[0] = resultCache.imgCenterX;
			center[1] = resultCache.imgCenterY;
		} else {
		
			center[0] = -1;
			center[1] = -1;
		}
	}

}
