#include <iostream>
#include <stdio.h>
#include <opencv2/opencv.hpp>
#include <opencv2/imgproc/imgproc.hpp>
#include <opencv2/objdetect/objdetect.hpp>

//*********************************
#include "profiler.h"

TMARK START("START");
TMARK LOOP("LOOP");
////TMARK ALG1("ALG1");
////TMARK ALG2("ALG2");
////TMARK ALG3("ALG3");
//TMARK SUMA("SUMA");
//TMARK MAX("Value");

//TCHAN CHAN0("STATE");
TCHAN CHAN1("RUN");

//TMARK ST0("STATE0",CHAN0);
//TMARK ST1("STATE1",CHAN0);
//TMARK ST2("STATE2",CHAN0);
//TMARK ST3("STATE3",CHAN0);
//TMARK ST4("STATE4",CHAN0);
//TMARK ST5("STATE5",CHAN0);

TMARK OPENI("Image",CHAN1);
TMARK LOADC("Class",CHAN1);
TMARK INIT("Init",CHAN1);
TMARK GRAY("Gray",CHAN1);
TMARK HIST("Hist",CHAN1);
TMARK DETECT("Detect",CHAN1);
TMARK DRAW("Draw",CHAN1);
TMARK WRITE("Write",CHAN1);
TMARK END("END",CHAN1);


using namespace std;
using namespace cv;

#define TESTLOOP 10

String face_cascade_name = "haarcascade_frontalface_alt.xml";
CascadeClassifier face_cascade;

int TProfiler::main(int argc, char *argv[]){

	MARK(START);
    MARK(OPENI);    
    Mat frame,frame2;
    frame = imread("lena.bmp");
    
    MARK(LOADC);
    frame.copyTo(frame2);
    if( !face_cascade.load( face_cascade_name ) ){ 
    	cout<<"--(!)Error loading face cascade\n"; 
    	return -1; 
    }

	MARK(INIT);
    std::vector<Rect> faces;
    Mat frame_gray;
        
    for(int i = 0; i < TESTLOOP; i++){
    	MARK(LOOP);
		MARK(GRAY);
		cvtColor( frame, frame_gray, COLOR_BGR2GRAY );
	
		MARK(HIST);
		equalizeHist( frame_gray, frame_gray );
		            
		MARK(DETECT);
		face_cascade.detectMultiScale( frame_gray, faces, 1.1, 2, 0|CASCADE_SCALE_IMAGE, Size(30, 30) );

		MARK(DRAW);
		for ( size_t i = 0; i < faces.size(); i++ ){
			Point center( faces[i].x + faces[i].width/2, faces[i].y + faces[i].height/2 );
			ellipse( frame2, center, Size( faces[i].width/2, faces[i].height/2 ), 0, 0, 360, Scalar( 255, 0, 255 ), 4, 8, 0 );
		}
    }
    MARK(WRITE);
    imwrite("lena2.jpg",frame2);//*/
    
    MARK(END);
return 0;
}
