#ifndef PROFER_H
#define PROFER_H

#include <fstream>
#include <vector>


#define BOOLTYPE 0
#define ANALOGTYPE 1
#define STATETYPE 2

#define TRUE 1
#define FALSE 0


class TMARK;

class TCHAN{
public:
    TCHAN(const char *str);
    char *title;

    std::vector<TMARK*> _marks;
};


class TMARK{
public:
    TMARK(const char *str);
    TMARK(const char *str, TCHAN &channel);

    char *str;
    int type;
    TCHAN *channel;
};

class TProfiler{
public:
    TProfiler();
    ~TProfiler();
    int main(int argc, char *argv[]);
    void MARK(TMARK mark);
    void MARK(TMARK mark, int value);

    std::ofstream profFile;
    struct timespec sampleTime;
    struct timespec startTime;
};

#endif // PROFER_H
