#include "profiler.h"
#include <ctime>
#include <iostream>
#include <cstring>


std::vector<TCHAN*> *_chans = NULL;
TCHAN *_BOOLCHAN = NULL;


//************************************************************
int main(int argc, char *argv[]){
    TProfiler profiler;

    clock_gettime(CLOCK_THREAD_CPUTIME_ID,&profiler.startTime);

    return profiler.main(argc, argv);
}

//************************************************************
//************************************************************
//************************************************************

TProfiler::TProfiler()
{
    profFile.open("prof.p");

    // print Start Time
    time_t rawTime;
    time(&rawTime);

    profFile <<"START_TIME: "<<ctime(&rawTime)<< std::endl;
    for(int c = 0;c < _chans->size();c++)
        if((*_chans)[c] == _BOOLCHAN)
            for(int i = 0;i < (*_chans)[c]->_marks.size(); i++)
                profFile << (*_chans)[c]->_marks[i]->str<< std::endl;
        else{
            profFile << (*_chans)[c]->title;
            for(int i = 0;i < (*_chans)[c]->_marks.size(); i++)
                profFile <<" "<< (*_chans)[c]->_marks[i]->str;
            profFile << std::endl;
        }
    profFile << std::endl;

    for(int i = 0;i !=_BOOLCHAN->_marks.size(); i++)
            profFile << _BOOLCHAN->_marks[i]->str<<" 0 0"<< std::endl;

    startTime.tv_nsec = 0;
    startTime.tv_sec = 0;
}
//************************************************************
TProfiler::~TProfiler(){

    if(sampleTime.tv_sec*100000+sampleTime.tv_nsec/10000 - startTime.tv_nsec/10000 > 0)
        for(int i = 0;i !=_BOOLCHAN->_marks.size(); i++)
            profFile << _BOOLCHAN->_marks[i]->str<<" 0 "<<sampleTime.tv_sec*100000+sampleTime.tv_nsec/10000 - startTime.tv_nsec/10000<< std::endl;

    profFile<<std::endl<< std::endl;
    profFile.close();

}

//************************************************************
void TProfiler::MARK(TMARK mark){

    clock_gettime(CLOCK_THREAD_CPUTIME_ID,&sampleTime);
    if(mark.type==STATETYPE)
        profFile <<mark.str<<" "<<sampleTime.tv_sec*100000+sampleTime.tv_nsec/10000 - startTime.tv_nsec/10000<< std::endl;
    if(mark.type==BOOLTYPE){
        profFile <<mark.str<<" 1 "<<sampleTime.tv_sec*100000+sampleTime.tv_nsec/10000 - startTime.tv_nsec/10000<< std::endl;
        profFile <<mark.str<<" 0 "<<sampleTime.tv_sec*100000+sampleTime.tv_nsec/10000 - startTime.tv_nsec/10000 + 1<< std::endl;
    }
}

void TProfiler::MARK(TMARK mark, int value){

    clock_gettime(CLOCK_THREAD_CPUTIME_ID,&sampleTime);
    profFile <<mark.str<<" "<<value<<" "<<sampleTime.tv_sec*100000+sampleTime.tv_nsec/10000 - startTime.tv_nsec/10000<< std::endl;

}

//************************************************************
//************************************************************
//************************************************************

TMARK::TMARK(const char *str){

    if(_BOOLCHAN == NULL)
        _BOOLCHAN = new TCHAN("");

    _BOOLCHAN->_marks.push_back(this);

    this->str = new char[strlen(str)];
	strcpy(this->str, str);
	
    this->type = BOOLTYPE;
}

//************************************************************
TMARK::TMARK(const char *str, TCHAN & chan){

    chan._marks.push_back(this);
    
    this->str = new char[strlen(str)];
	strcpy(this->str, str);
	
    //this->str = str;
    this->type = STATETYPE;
}

//************************************************************
//************************************************************
//************************************************************


TCHAN::TCHAN(const char *str){
    if(_chans==NULL)
        _chans  = new std::vector<TCHAN*>;

    _chans->push_back(this);
    
	title = new char[strlen(str)];
	strcpy(title, str);
}

