#include <stdio.h>

#include "master.h"

// FFT includes
#include <fftw3.h>
#include "kiss_fft130/kiss_fft.h"

// FFTW naming macros
#if defined(FLOAT)
  #define FFTW_PRE(post) fftwf_ ## post
#elif defined(DOUBLE)
  #define FFTW_PRE(post) fftw_ ## post
#elif defined(LDOUBLE)
  #define FFTW_PRE(post) fftwl_ ## post
#endif

// Constants
#define LOOPS 400*6000
#define FFT_LEN 1024
//#define LOOPS 20000/256*3600
//#define FFT_LEN 512



int main(void)
{
  // Allocate arrays
#if defined(FFTW)
  fftw_init_threads();
  fftw_plan_with_nthreads(2);
  FFTW_PRE(complex) * in = (FFTW_PRE(complex)*) FFTW_PRE(malloc)(sizeof(FFTW_PRE(complex)) * FFT_LEN);
  FFTW_PRE(complex) * out = (FFTW_PRE(complex)*) FFTW_PRE(malloc)(sizeof(FFTW_PRE(complex)) * FFT_LEN);
#elif defined(KISSFFT)
  kiss_fft_cpx in[FFT_LEN];
  kiss_fft_cpx out[FFT_LEN];
#endif

  // Configure FFT
#if defined(FFTW)
  FFTW_PRE(plan) p = FFTW_PRE(plan_dft_1d)(FFT_LEN, in, out, FFTW_FORWARD, FFTW_ESTIMATE); // TODO: estimate?
#elif defined(KISSFFT)
  kiss_fft_cfg cfg = kiss_fft_alloc(FFT_LEN, 0, 0, 0);
#endif

printf("here\n");

  // Generate random data
  for (int n = 0; n < FFT_LEN; n++) {
#if defined(FFTW)
    in[n][0] = rand();
    in[n][1] = rand();
#elif defined(KISSFFT)
    in[n].r = rand();
    in[n].i = rand();
#endif
  }

  // Loop over FFT's
  for (int i = 0; i < LOOPS; i++) {
#if defined(FFTW)
    FFTW_PRE(execute)(p);
#elif defined(KISSFFT)
    kiss_fft(cfg, in, out);
#endif
  }

  // Deallocate all
#if defined(FFTW)
  FFTW_PRE(destroy_plan)(p);
  FFTW_PRE(free)(in);
  FFTW_PRE(free)(out);
  fftw_cleanup_threads();
#elif defined(KISSFFT)
  free(cfg);
#endif

  return 0;
}

