print("Content-type: text/html\n")
--[[
  File: BFS.lua
  Desc: Breadth first search in tree
  Author: Jan Drazil
]]

function BFS(find, tree)
  if(not tree) then
    return false
  end
  queue={tree}
  while(#queue ~= 0) do
    activeTree=queue[1]
    table.remove(queue,1)
    if(activeTree['value'] == find) then
      return true
    else
      for _,i in pairs(activeTree['tree']) do
        table.insert(queue,i)
      end
    end
  end
  return false
end



---Generated---
data = {["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 923677},{["tree"] = {} ,["value"] = 324012},{["tree"] = {} ,["value"] = 965885},{["tree"] = {} ,["value"] = 175981}} ,["value"] = 786069},{["tree"] = {{["tree"] = {} ,["value"] = 372796},{["tree"] = {} ,["value"] = 344434},{["tree"] = {} ,["value"] = 854201},{["tree"] = {} ,["value"] = 555277}} ,["value"] = 684810},{["tree"] = {{["tree"] = {} ,["value"] = 154078},{["tree"] = {} ,["value"] = 662765},{["tree"] = {} ,["value"] = 178578},{["tree"] = {} ,["value"] = 927091}} ,["value"] = 646066},{["tree"] = {{["tree"] = {} ,["value"] = 883442},{["tree"] = {} ,["value"] = 367348},{["tree"] = {} ,["value"] = 772098},{["tree"] = {} ,["value"] = 582771}} ,["value"] = 685204}} ,["value"] = 739956},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 867356},{["tree"] = {} ,["value"] = 863287},{["tree"] = {} ,["value"] = 299066},{["tree"] = {} ,["value"] = 693573}} ,["value"] = 178084},{["tree"] = {{["tree"] = {} ,["value"] = 636543},{["tree"] = {} ,["value"] = 15078},{["tree"] = {} ,["value"] = 923176},{["tree"] = {} ,["value"] = 918908}} ,["value"] = 548352},{["tree"] = {{["tree"] = {} ,["value"] = 794148},{["tree"] = {} ,["value"] = 894477},{["tree"] = {} ,["value"] = 487410},{["tree"] = {} ,["value"] = 229957}} ,["value"] = 689684},{["tree"] = {{["tree"] = {} ,["value"] = 166256},{["tree"] = {} ,["value"] = 435980},{["tree"] = {} ,["value"] = 28049},{["tree"] = {} ,["value"] = 366526}} ,["value"] = 873007}} ,["value"] = 500961},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 161735},{["tree"] = {} ,["value"] = 522123},{["tree"] = {} ,["value"] = 198678},{["tree"] = {} ,["value"] = 97104}} ,["value"] = 694279},{["tree"] = {{["tree"] = {} ,["value"] = 710611},{["tree"] = {} ,["value"] = 420421},{["tree"] = {} ,["value"] = 695025},{["tree"] = {} ,["value"] = 34196}} ,["value"] = 612718},{["tree"] = {{["tree"] = {} ,["value"] = 809531},{["tree"] = {} ,["value"] = 669310},{["tree"] = {} ,["value"] = 483702},{["tree"] = {} ,["value"] = 979278}} ,["value"] = 773091},{["tree"] = {{["tree"] = {} ,["value"] = 528274},{["tree"] = {} ,["value"] = 195035},{["tree"] = {} ,["value"] = 956429},{["tree"] = {} ,["value"] = 841481}} ,["value"] = 726595}} ,["value"] = 187736},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 308663},{["tree"] = {} ,["value"] = 367685},{["tree"] = {} ,["value"] = 211749},{["tree"] = {} ,["value"] = 596093}} ,["value"] = 876799},{["tree"] = {{["tree"] = {} ,["value"] = 719875},{["tree"] = {} ,["value"] = 122135},{["tree"] = {} ,["value"] = 112646},{["tree"] = {} ,["value"] = 245368}} ,["value"] = 513122},{["tree"] = {{["tree"] = {} ,["value"] = 412004},{["tree"] = {} ,["value"] = 117171},{["tree"] = {} ,["value"] = 529813},{["tree"] = {} ,["value"] = 118310}} ,["value"] = 225269},{["tree"] = {{["tree"] = {} ,["value"] = 170067},{["tree"] = {} ,["value"] = 810610},{["tree"] = {} ,["value"] = 408812},{["tree"] = {} ,["value"] = 310090}} ,["value"] = 214879}} ,["value"] = 661053}} ,["value"] = 201588},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 24240},{["tree"] = {} ,["value"] = 252379},{["tree"] = {} ,["value"] = 452662},{["tree"] = {} ,["value"] = 843050}} ,["value"] = 303675},{["tree"] = {{["tree"] = {} ,["value"] = 333774},{["tree"] = {} ,["value"] = 669478},{["tree"] = {} ,["value"] = 762051},{["tree"] = {} ,["value"] = 343963}} ,["value"] = 71416},{["tree"] = {{["tree"] = {} ,["value"] = 160790},{["tree"] = {} ,["value"] = 846522},{["tree"] = {} ,["value"] = 921749},{["tree"] = {} ,["value"] = 953341}} ,["value"] = 62732},{["tree"] = {{["tree"] = {} ,["value"] = 181916},{["tree"] = {} ,["value"] = 814765},{["tree"] = {} ,["value"] = 868382},{["tree"] = {} ,["value"] = 957971}} ,["value"] = 457874}} ,["value"] = 961973},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 650665},{["tree"] = {} ,["value"] = 247170},{["tree"] = {} ,["value"] = 628615},{["tree"] = {} ,["value"] = 489327}} ,["value"] = 587631},{["tree"] = {{["tree"] = {} ,["value"] = 266734},{["tree"] = {} ,["value"] = 241555},{["tree"] = {} ,["value"] = 768714},{["tree"] = {} ,["value"] = 766948}} ,["value"] = 581172},{["tree"] = {{["tree"] = {} ,["value"] = 288313},{["tree"] = {} ,["value"] = 73663},{["tree"] = {} ,["value"] = 912988},{["tree"] = {} ,["value"] = 356910}} ,["value"] = 248354},{["tree"] = {{["tree"] = {} ,["value"] = 126714},{["tree"] = {} ,["value"] = 967159},{["tree"] = {} ,["value"] = 483681},{["tree"] = {} ,["value"] = 169000}} ,["value"] = 907379}} ,["value"] = 636523},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 426011},{["tree"] = {} ,["value"] = 325272},{["tree"] = {} ,["value"] = 977064},{["tree"] = {} ,["value"] = 765701}} ,["value"] = 863166},{["tree"] = {{["tree"] = {} ,["value"] = 483036},{["tree"] = {} ,["value"] = 340710},{["tree"] = {} ,["value"] = 48181},{["tree"] = {} ,["value"] = 941975}} ,["value"] = 635729},{["tree"] = {{["tree"] = {} ,["value"] = 700901},{["tree"] = {} ,["value"] = 622669},{["tree"] = {} ,["value"] = 93439},{["tree"] = {} ,["value"] = 729391}} ,["value"] = 706480},{["tree"] = {{["tree"] = {} ,["value"] = 296828},{["tree"] = {} ,["value"] = 537492},{["tree"] = {} ,["value"] = 73988},{["tree"] = {} ,["value"] = 863302}} ,["value"] = 535936}} ,["value"] = 443918},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 558108},{["tree"] = {} ,["value"] = 581664},{["tree"] = {} ,["value"] = 990309},{["tree"] = {} ,["value"] = 332837}} ,["value"] = 595031},{["tree"] = {{["tree"] = {} ,["value"] = 395510},{["tree"] = {} ,["value"] = 500051},{["tree"] = {} ,["value"] = 944049},{["tree"] = {} ,["value"] = 64242}} ,["value"] = 232258},{["tree"] = {{["tree"] = {} ,["value"] = 769075},{["tree"] = {} ,["value"] = 453757},{["tree"] = {} ,["value"] = 897270},{["tree"] = {} ,["value"] = 180581}} ,["value"] = 878791},{["tree"] = {{["tree"] = {} ,["value"] = 665874},{["tree"] = {} ,["value"] = 306935},{["tree"] = {} ,["value"] = 497016},{["tree"] = {} ,["value"] = 222502}} ,["value"] = 993808}} ,["value"] = 815774}} ,["value"] = 751224},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 40571},{["tree"] = {} ,["value"] = 632343},{["tree"] = {} ,["value"] = 845469},{["tree"] = {} ,["value"] = 691844}} ,["value"] = 317277},{["tree"] = {{["tree"] = {} ,["value"] = 780888},{["tree"] = {} ,["value"] = 261400},{["tree"] = {} ,["value"] = 726900},{["tree"] = {} ,["value"] = 372844}} ,["value"] = 816177},{["tree"] = {{["tree"] = {} ,["value"] = 254565},{["tree"] = {} ,["value"] = 792667},{["tree"] = {} ,["value"] = 99987},{["tree"] = {} ,["value"] = 579906}} ,["value"] = 891809},{["tree"] = {{["tree"] = {} ,["value"] = 580505},{["tree"] = {} ,["value"] = 441981},{["tree"] = {} ,["value"] = 886235},{["tree"] = {} ,["value"] = 179795}} ,["value"] = 957089}} ,["value"] = 726494},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 559311},{["tree"] = {} ,["value"] = 846674},{["tree"] = {} ,["value"] = 77847},{["tree"] = {} ,["value"] = 972327}} ,["value"] = 177947},{["tree"] = {{["tree"] = {} ,["value"] = 998404},{["tree"] = {} ,["value"] = 119207},{["tree"] = {} ,["value"] = 368633},{["tree"] = {} ,["value"] = 347110}} ,["value"] = 497976},{["tree"] = {{["tree"] = {} ,["value"] = 380464},{["tree"] = {} ,["value"] = 450430},{["tree"] = {} ,["value"] = 824735},{["tree"] = {} ,["value"] = 112023}} ,["value"] = 641831},{["tree"] = {{["tree"] = {} ,["value"] = 724998},{["tree"] = {} ,["value"] = 248344},{["tree"] = {} ,["value"] = 158795},{["tree"] = {} ,["value"] = 718142}} ,["value"] = 626460}} ,["value"] = 945552},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 665368},{["tree"] = {} ,["value"] = 259259},{["tree"] = {} ,["value"] = 64511},{["tree"] = {} ,["value"] = 879791}} ,["value"] = 946663},{["tree"] = {{["tree"] = {} ,["value"] = 863292},{["tree"] = {} ,["value"] = 583010},{["tree"] = {} ,["value"] = 901442},{["tree"] = {} ,["value"] = 301126}} ,["value"] = 438568},{["tree"] = {{["tree"] = {} ,["value"] = 61402},{["tree"] = {} ,["value"] = 591716},{["tree"] = {} ,["value"] = 694076},{["tree"] = {} ,["value"] = 780221}} ,["value"] = 476934},{["tree"] = {{["tree"] = {} ,["value"] = 14364},{["tree"] = {} ,["value"] = 473908},{["tree"] = {} ,["value"] = 981571},{["tree"] = {} ,["value"] = 877727}} ,["value"] = 481412}} ,["value"] = 563339},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 132421},{["tree"] = {} ,["value"] = 806742},{["tree"] = {} ,["value"] = 700926},{["tree"] = {} ,["value"] = 258855}} ,["value"] = 828573},{["tree"] = {{["tree"] = {} ,["value"] = 741544},{["tree"] = {} ,["value"] = 245477},{["tree"] = {} ,["value"] = 393968},{["tree"] = {} ,["value"] = 758669}} ,["value"] = 756559},{["tree"] = {{["tree"] = {} ,["value"] = 833477},{["tree"] = {} ,["value"] = 729662},{["tree"] = {} ,["value"] = 673344},{["tree"] = {} ,["value"] = 333675}} ,["value"] = 438862},{["tree"] = {{["tree"] = {} ,["value"] = 55751},{["tree"] = {} ,["value"] = 69157},{["tree"] = {} ,["value"] = 356168},{["tree"] = {} ,["value"] = 359022}} ,["value"] = 319378}} ,["value"] = 327416}} ,["value"] = 481554},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 682548},{["tree"] = {} ,["value"] = 175740},{["tree"] = {} ,["value"] = 739501},{["tree"] = {} ,["value"] = 489513}} ,["value"] = 744470},{["tree"] = {{["tree"] = {} ,["value"] = 610969},{["tree"] = {} ,["value"] = 950340},{["tree"] = {} ,["value"] = 517084},{["tree"] = {} ,["value"] = 743153}} ,["value"] = 936653},{["tree"] = {{["tree"] = {} ,["value"] = 811907},{["tree"] = {} ,["value"] = 109670},{["tree"] = {} ,["value"] = 865511},{["tree"] = {} ,["value"] = 202871}} ,["value"] = 364990},{["tree"] = {{["tree"] = {} ,["value"] = 718506},{["tree"] = {} ,["value"] = 678674},{["tree"] = {} ,["value"] = 900971},{["tree"] = {} ,["value"] = 353701}} ,["value"] = 529701}} ,["value"] = 454968},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 608252},{["tree"] = {} ,["value"] = 83209},{["tree"] = {} ,["value"] = 425097},{["tree"] = {} ,["value"] = 466400}} ,["value"] = 472781},{["tree"] = {{["tree"] = {} ,["value"] = 429182},{["tree"] = {} ,["value"] = 361859},{["tree"] = {} ,["value"] = 918604},{["tree"] = {} ,["value"] = 680869}} ,["value"] = 384033},{["tree"] = {{["tree"] = {} ,["value"] = 47530},{["tree"] = {} ,["value"] = 391765},{["tree"] = {} ,["value"] = 991052},{["tree"] = {} ,["value"] = 420544}} ,["value"] = 15946},{["tree"] = {{["tree"] = {} ,["value"] = 672132},{["tree"] = {} ,["value"] = 129588},{["tree"] = {} ,["value"] = 883977},{["tree"] = {} ,["value"] = 347628}} ,["value"] = 590092}} ,["value"] = 970905},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 835833},{["tree"] = {} ,["value"] = 539565},{["tree"] = {} ,["value"] = 995097},{["tree"] = {} ,["value"] = 896511}} ,["value"] = 780316},{["tree"] = {{["tree"] = {} ,["value"] = 547332},{["tree"] = {} ,["value"] = 352270},{["tree"] = {} ,["value"] = 222097},{["tree"] = {} ,["value"] = 241833}} ,["value"] = 60753},{["tree"] = {{["tree"] = {} ,["value"] = 549904},{["tree"] = {} ,["value"] = 811080},{["tree"] = {} ,["value"] = 1284},{["tree"] = {} ,["value"] = 964531}} ,["value"] = 209738},{["tree"] = {{["tree"] = {} ,["value"] = 910819},{["tree"] = {} ,["value"] = 987740},{["tree"] = {} ,["value"] = 374176},{["tree"] = {} ,["value"] = 215581}} ,["value"] = 709784}} ,["value"] = 39962},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 737245},{["tree"] = {} ,["value"] = 537867},{["tree"] = {} ,["value"] = 901228},{["tree"] = {} ,["value"] = 361161}} ,["value"] = 663141},{["tree"] = {{["tree"] = {} ,["value"] = 465971},{["tree"] = {} ,["value"] = 848499},{["tree"] = {} ,["value"] = 135036},{["tree"] = {} ,["value"] = 806452}} ,["value"] = 884924},{["tree"] = {{["tree"] = {} ,["value"] = 690529},{["tree"] = {} ,["value"] = 161472},{["tree"] = {} ,["value"] = 930158},{["tree"] = {} ,["value"] = 89647}} ,["value"] = 151723},{["tree"] = {{["tree"] = {} ,["value"] = 295029},{["tree"] = {} ,["value"] = 586161},{["tree"] = {} ,["value"] = 384375},{["tree"] = {} ,["value"] = 208480}} ,["value"] = 441113}} ,["value"] = 424012}} ,["value"] = 336467}} ,["value"] = 792292},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 293338},{["tree"] = {} ,["value"] = 556368},{["tree"] = {} ,["value"] = 782882},{["tree"] = {} ,["value"] = 975242}} ,["value"] = 935533},{["tree"] = {{["tree"] = {} ,["value"] = 30669},{["tree"] = {} ,["value"] = 439794},{["tree"] = {} ,["value"] = 328014},{["tree"] = {} ,["value"] = 364656}} ,["value"] = 180029},{["tree"] = {{["tree"] = {} ,["value"] = 898154},{["tree"] = {} ,["value"] = 621785},{["tree"] = {} ,["value"] = 557580},{["tree"] = {} ,["value"] = 522698}} ,["value"] = 956456},{["tree"] = {{["tree"] = {} ,["value"] = 881481},{["tree"] = {} ,["value"] = 931215},{["tree"] = {} ,["value"] = 637405},{["tree"] = {} ,["value"] = 556772}} ,["value"] = 682954}} ,["value"] = 743844},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 99479},{["tree"] = {} ,["value"] = 901554},{["tree"] = {} ,["value"] = 746424},{["tree"] = {} ,["value"] = 401904}} ,["value"] = 329632},{["tree"] = {{["tree"] = {} ,["value"] = 578173},{["tree"] = {} ,["value"] = 747582},{["tree"] = {} ,["value"] = 354962},{["tree"] = {} ,["value"] = 537648}} ,["value"] = 803478},{["tree"] = {{["tree"] = {} ,["value"] = 620900},{["tree"] = {} ,["value"] = 537013},{["tree"] = {} ,["value"] = 945254},{["tree"] = {} ,["value"] = 989091}} ,["value"] = 287840},{["tree"] = {{["tree"] = {} ,["value"] = 14674},{["tree"] = {} ,["value"] = 603468},{["tree"] = {} ,["value"] = 894693},{["tree"] = {} ,["value"] = 611494}} ,["value"] = 594743}} ,["value"] = 499749},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 720273},{["tree"] = {} ,["value"] = 769521},{["tree"] = {} ,["value"] = 826372},{["tree"] = {} ,["value"] = 745669}} ,["value"] = 323800},{["tree"] = {{["tree"] = {} ,["value"] = 444494},{["tree"] = {} ,["value"] = 893149},{["tree"] = {} ,["value"] = 114907},{["tree"] = {} ,["value"] = 635585}} ,["value"] = 718664},{["tree"] = {{["tree"] = {} ,["value"] = 658353},{["tree"] = {} ,["value"] = 341483},{["tree"] = {} ,["value"] = 857675},{["tree"] = {} ,["value"] = 595665}} ,["value"] = 590503},{["tree"] = {{["tree"] = {} ,["value"] = 517077},{["tree"] = {} ,["value"] = 86374},{["tree"] = {} ,["value"] = 125627},{["tree"] = {} ,["value"] = 92254}} ,["value"] = 654900}} ,["value"] = 587089},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 499996},{["tree"] = {} ,["value"] = 734055},{["tree"] = {} ,["value"] = 121501},{["tree"] = {} ,["value"] = 690945}} ,["value"] = 244963},{["tree"] = {{["tree"] = {} ,["value"] = 77921},{["tree"] = {} ,["value"] = 347437},{["tree"] = {} ,["value"] = 911780},{["tree"] = {} ,["value"] = 978201}} ,["value"] = 75679},{["tree"] = {{["tree"] = {} ,["value"] = 396189},{["tree"] = {} ,["value"] = 787211},{["tree"] = {} ,["value"] = 593700},{["tree"] = {} ,["value"] = 653388}} ,["value"] = 350892},{["tree"] = {{["tree"] = {} ,["value"] = 461305},{["tree"] = {} ,["value"] = 206395},{["tree"] = {} ,["value"] = 57592},{["tree"] = {} ,["value"] = 50210}} ,["value"] = 511953}} ,["value"] = 162042}} ,["value"] = 119794},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 464735},{["tree"] = {} ,["value"] = 910353},{["tree"] = {} ,["value"] = 786833},{["tree"] = {} ,["value"] = 136924}} ,["value"] = 121285},{["tree"] = {{["tree"] = {} ,["value"] = 909941},{["tree"] = {} ,["value"] = 930294},{["tree"] = {} ,["value"] = 416024},{["tree"] = {} ,["value"] = 843966}} ,["value"] = 758556},{["tree"] = {{["tree"] = {} ,["value"] = 48595},{["tree"] = {} ,["value"] = 488925},{["tree"] = {} ,["value"] = 488080},{["tree"] = {} ,["value"] = 121006}} ,["value"] = 297128},{["tree"] = {{["tree"] = {} ,["value"] = 995938},{["tree"] = {} ,["value"] = 244438},{["tree"] = {} ,["value"] = 637988},{["tree"] = {} ,["value"] = 525275}} ,["value"] = 392532}} ,["value"] = 103633},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 731153},{["tree"] = {} ,["value"] = 620267},{["tree"] = {} ,["value"] = 847581},{["tree"] = {} ,["value"] = 801271}} ,["value"] = 581806},{["tree"] = {{["tree"] = {} ,["value"] = 808260},{["tree"] = {} ,["value"] = 312507},{["tree"] = {} ,["value"] = 385969},{["tree"] = {} ,["value"] = 162376}} ,["value"] = 1914},{["tree"] = {{["tree"] = {} ,["value"] = 990460},{["tree"] = {} ,["value"] = 580292},{["tree"] = {} ,["value"] = 289682},{["tree"] = {} ,["value"] = 849103}} ,["value"] = 739454},{["tree"] = {{["tree"] = {} ,["value"] = 16265},{["tree"] = {} ,["value"] = 710204},{["tree"] = {} ,["value"] = 833741},{["tree"] = {} ,["value"] = 798254}} ,["value"] = 307757}} ,["value"] = 852355},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 574843},{["tree"] = {} ,["value"] = 280389},{["tree"] = {} ,["value"] = 355790},{["tree"] = {} ,["value"] = 227781}} ,["value"] = 200040},{["tree"] = {{["tree"] = {} ,["value"] = 301642},{["tree"] = {} ,["value"] = 70663},{["tree"] = {} ,["value"] = 34377},{["tree"] = {} ,["value"] = 56121}} ,["value"] = 480980},{["tree"] = {{["tree"] = {} ,["value"] = 201176},{["tree"] = {} ,["value"] = 320051},{["tree"] = {} ,["value"] = 186514},{["tree"] = {} ,["value"] = 591739}} ,["value"] = 852375},{["tree"] = {{["tree"] = {} ,["value"] = 310671},{["tree"] = {} ,["value"] = 278911},{["tree"] = {} ,["value"] = 762009},{["tree"] = {} ,["value"] = 993388}} ,["value"] = 986807}} ,["value"] = 586656},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 356967},{["tree"] = {} ,["value"] = 6375},{["tree"] = {} ,["value"] = 943675},{["tree"] = {} ,["value"] = 557741}} ,["value"] = 18560},{["tree"] = {{["tree"] = {} ,["value"] = 333612},{["tree"] = {} ,["value"] = 532946},{["tree"] = {} ,["value"] = 797775},{["tree"] = {} ,["value"] = 488784}} ,["value"] = 238576},{["tree"] = {{["tree"] = {} ,["value"] = 170540},{["tree"] = {} ,["value"] = 469524},{["tree"] = {} ,["value"] = 109833},{["tree"] = {} ,["value"] = 621111}} ,["value"] = 994349},{["tree"] = {{["tree"] = {} ,["value"] = 621213},{["tree"] = {} ,["value"] = 122454},{["tree"] = {} ,["value"] = 140595},{["tree"] = {} ,["value"] = 541925}} ,["value"] = 583879}} ,["value"] = 343434}} ,["value"] = 415411},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 569422},{["tree"] = {} ,["value"] = 110550},{["tree"] = {} ,["value"] = 769650},{["tree"] = {} ,["value"] = 785356}} ,["value"] = 511839},{["tree"] = {{["tree"] = {} ,["value"] = 892085},{["tree"] = {} ,["value"] = 189027},{["tree"] = {} ,["value"] = 431766},{["tree"] = {} ,["value"] = 59733}} ,["value"] = 12374},{["tree"] = {{["tree"] = {} ,["value"] = 489902},{["tree"] = {} ,["value"] = 177877},{["tree"] = {} ,["value"] = 863033},{["tree"] = {} ,["value"] = 263376}} ,["value"] = 279067},{["tree"] = {{["tree"] = {} ,["value"] = 84200},{["tree"] = {} ,["value"] = 780615},{["tree"] = {} ,["value"] = 509596},{["tree"] = {} ,["value"] = 418684}} ,["value"] = 794894}} ,["value"] = 686573},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 656275},{["tree"] = {} ,["value"] = 13167},{["tree"] = {} ,["value"] = 604001},{["tree"] = {} ,["value"] = 945013}} ,["value"] = 9419},{["tree"] = {{["tree"] = {} ,["value"] = 28531},{["tree"] = {} ,["value"] = 667293},{["tree"] = {} ,["value"] = 521337},{["tree"] = {} ,["value"] = 23626}} ,["value"] = 465549},{["tree"] = {{["tree"] = {} ,["value"] = 285241},{["tree"] = {} ,["value"] = 270651},{["tree"] = {} ,["value"] = 344181},{["tree"] = {} ,["value"] = 466937}} ,["value"] = 847283},{["tree"] = {{["tree"] = {} ,["value"] = 413993},{["tree"] = {} ,["value"] = 512601},{["tree"] = {} ,["value"] = 19863},{["tree"] = {} ,["value"] = 469180}} ,["value"] = 162646}} ,["value"] = 461388},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 192116},{["tree"] = {} ,["value"] = 360054},{["tree"] = {} ,["value"] = 922079},{["tree"] = {} ,["value"] = 242928}} ,["value"] = 58871},{["tree"] = {{["tree"] = {} ,["value"] = 830475},{["tree"] = {} ,["value"] = 908372},{["tree"] = {} ,["value"] = 389176},{["tree"] = {} ,["value"] = 668959}} ,["value"] = 905132},{["tree"] = {{["tree"] = {} ,["value"] = 239772},{["tree"] = {} ,["value"] = 927922},{["tree"] = {} ,["value"] = 9365},{["tree"] = {} ,["value"] = 551587}} ,["value"] = 830126},{["tree"] = {{["tree"] = {} ,["value"] = 286235},{["tree"] = {} ,["value"] = 415632},{["tree"] = {} ,["value"] = 69593},{["tree"] = {} ,["value"] = 746987}} ,["value"] = 353437}} ,["value"] = 920424},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 269703},{["tree"] = {} ,["value"] = 781079},{["tree"] = {} ,["value"] = 590120},{["tree"] = {} ,["value"] = 647476}} ,["value"] = 141655},{["tree"] = {{["tree"] = {} ,["value"] = 447510},{["tree"] = {} ,["value"] = 558795},{["tree"] = {} ,["value"] = 684079},{["tree"] = {} ,["value"] = 857534}} ,["value"] = 415187},{["tree"] = {{["tree"] = {} ,["value"] = 62658},{["tree"] = {} ,["value"] = 304840},{["tree"] = {} ,["value"] = 201546},{["tree"] = {} ,["value"] = 927235}} ,["value"] = 360126},{["tree"] = {{["tree"] = {} ,["value"] = 722519},{["tree"] = {} ,["value"] = 370732},{["tree"] = {} ,["value"] = 438766},{["tree"] = {} ,["value"] = 837000}} ,["value"] = 962874}} ,["value"] = 279685}} ,["value"] = 870319},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 164736},{["tree"] = {} ,["value"] = 42051},{["tree"] = {} ,["value"] = 899981},{["tree"] = {} ,["value"] = 809811}} ,["value"] = 276180},{["tree"] = {{["tree"] = {} ,["value"] = 350958},{["tree"] = {} ,["value"] = 826343},{["tree"] = {} ,["value"] = 333798},{["tree"] = {} ,["value"] = 762934}} ,["value"] = 329578},{["tree"] = {{["tree"] = {} ,["value"] = 661527},{["tree"] = {} ,["value"] = 957789},{["tree"] = {} ,["value"] = 343042},{["tree"] = {} ,["value"] = 360921}} ,["value"] = 978272},{["tree"] = {{["tree"] = {} ,["value"] = 301775},{["tree"] = {} ,["value"] = 263091},{["tree"] = {} ,["value"] = 551376},{["tree"] = {} ,["value"] = 107842}} ,["value"] = 984276}} ,["value"] = 160810},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 298753},{["tree"] = {} ,["value"] = 763593},{["tree"] = {} ,["value"] = 430165},{["tree"] = {} ,["value"] = 426597}} ,["value"] = 386876},{["tree"] = {{["tree"] = {} ,["value"] = 395412},{["tree"] = {} ,["value"] = 863537},{["tree"] = {} ,["value"] = 814009},{["tree"] = {} ,["value"] = 412898}} ,["value"] = 489825},{["tree"] = {{["tree"] = {} ,["value"] = 545071},{["tree"] = {} ,["value"] = 765338},{["tree"] = {} ,["value"] = 870659},{["tree"] = {} ,["value"] = 658275}} ,["value"] = 242468},{["tree"] = {{["tree"] = {} ,["value"] = 997468},{["tree"] = {} ,["value"] = 833825},{["tree"] = {} ,["value"] = 9887},{["tree"] = {} ,["value"] = 164151}} ,["value"] = 726498}} ,["value"] = 294243},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 620599},{["tree"] = {} ,["value"] = 343064},{["tree"] = {} ,["value"] = 916607},{["tree"] = {} ,["value"] = 841012}} ,["value"] = 334080},{["tree"] = {{["tree"] = {} ,["value"] = 888655},{["tree"] = {} ,["value"] = 774845},{["tree"] = {} ,["value"] = 152782},{["tree"] = {} ,["value"] = 15986}} ,["value"] = 11758},{["tree"] = {{["tree"] = {} ,["value"] = 105519},{["tree"] = {} ,["value"] = 226187},{["tree"] = {} ,["value"] = 989635},{["tree"] = {} ,["value"] = 62305}} ,["value"] = 66133},{["tree"] = {{["tree"] = {} ,["value"] = 995359},{["tree"] = {} ,["value"] = 766472},{["tree"] = {} ,["value"] = 754495},{["tree"] = {} ,["value"] = 744123}} ,["value"] = 575996}} ,["value"] = 152568},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 289330},{["tree"] = {} ,["value"] = 827558},{["tree"] = {} ,["value"] = 692259},{["tree"] = {} ,["value"] = 707025}} ,["value"] = 237339},{["tree"] = {{["tree"] = {} ,["value"] = 656129},{["tree"] = {} ,["value"] = 687940},{["tree"] = {} ,["value"] = 248133},{["tree"] = {} ,["value"] = 695231}} ,["value"] = 778280},{["tree"] = {{["tree"] = {} ,["value"] = 241735},{["tree"] = {} ,["value"] = 473586},{["tree"] = {} ,["value"] = 918117},{["tree"] = {} ,["value"] = 734794}} ,["value"] = 259237},{["tree"] = {{["tree"] = {} ,["value"] = 954518},{["tree"] = {} ,["value"] = 372640},{["tree"] = {} ,["value"] = 166938},{["tree"] = {} ,["value"] = 525054}} ,["value"] = 737744}} ,["value"] = 964088}} ,["value"] = 688558}} ,["value"] = 708261},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 857087},{["tree"] = {} ,["value"] = 375867},{["tree"] = {} ,["value"] = 600022},{["tree"] = {} ,["value"] = 651232}} ,["value"] = 209486},{["tree"] = {{["tree"] = {} ,["value"] = 640674},{["tree"] = {} ,["value"] = 556702},{["tree"] = {} ,["value"] = 540612},{["tree"] = {} ,["value"] = 39081}} ,["value"] = 324412},{["tree"] = {{["tree"] = {} ,["value"] = 329168},{["tree"] = {} ,["value"] = 457539},{["tree"] = {} ,["value"] = 967549},{["tree"] = {} ,["value"] = 227246}} ,["value"] = 844696},{["tree"] = {{["tree"] = {} ,["value"] = 644657},{["tree"] = {} ,["value"] = 670535},{["tree"] = {} ,["value"] = 105495},{["tree"] = {} ,["value"] = 769159}} ,["value"] = 429132}} ,["value"] = 553932},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 299195},{["tree"] = {} ,["value"] = 350209},{["tree"] = {} ,["value"] = 296302},{["tree"] = {} ,["value"] = 12569}} ,["value"] = 202232},{["tree"] = {{["tree"] = {} ,["value"] = 883671},{["tree"] = {} ,["value"] = 922873},{["tree"] = {} ,["value"] = 287655},{["tree"] = {} ,["value"] = 899957}} ,["value"] = 711098},{["tree"] = {{["tree"] = {} ,["value"] = 406736},{["tree"] = {} ,["value"] = 816916},{["tree"] = {} ,["value"] = 807330},{["tree"] = {} ,["value"] = 484876}} ,["value"] = 31869},{["tree"] = {{["tree"] = {} ,["value"] = 89583},{["tree"] = {} ,["value"] = 631806},{["tree"] = {} ,["value"] = 906702},{["tree"] = {} ,["value"] = 346621}} ,["value"] = 2062}} ,["value"] = 785266},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 430660},{["tree"] = {} ,["value"] = 56273},{["tree"] = {} ,["value"] = 768591},{["tree"] = {} ,["value"] = 778697}} ,["value"] = 216904},{["tree"] = {{["tree"] = {} ,["value"] = 818217},{["tree"] = {} ,["value"] = 130893},{["tree"] = {} ,["value"] = 30406},{["tree"] = {} ,["value"] = 245184}} ,["value"] = 924475},{["tree"] = {{["tree"] = {} ,["value"] = 49097},{["tree"] = {} ,["value"] = 414566},{["tree"] = {} ,["value"] = 304},{["tree"] = {} ,["value"] = 770738}} ,["value"] = 796597},{["tree"] = {{["tree"] = {} ,["value"] = 247328},{["tree"] = {} ,["value"] = 994801},{["tree"] = {} ,["value"] = 129994},{["tree"] = {} ,["value"] = 67731}} ,["value"] = 100730}} ,["value"] = 399365},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 766453},{["tree"] = {} ,["value"] = 110668},{["tree"] = {} ,["value"] = 77818},{["tree"] = {} ,["value"] = 639849}} ,["value"] = 579139},{["tree"] = {{["tree"] = {} ,["value"] = 618226},{["tree"] = {} ,["value"] = 352749},{["tree"] = {} ,["value"] = 987426},{["tree"] = {} ,["value"] = 845753}} ,["value"] = 809457},{["tree"] = {{["tree"] = {} ,["value"] = 58235},{["tree"] = {} ,["value"] = 734432},{["tree"] = {} ,["value"] = 438378},{["tree"] = {} ,["value"] = 201574}} ,["value"] = 732497},{["tree"] = {{["tree"] = {} ,["value"] = 704068},{["tree"] = {} ,["value"] = 444592},{["tree"] = {} ,["value"] = 648422},{["tree"] = {} ,["value"] = 871458}} ,["value"] = 587112}} ,["value"] = 738834}} ,["value"] = 983845},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 148346},{["tree"] = {} ,["value"] = 621753},{["tree"] = {} ,["value"] = 79808},{["tree"] = {} ,["value"] = 382263}} ,["value"] = 738003},{["tree"] = {{["tree"] = {} ,["value"] = 511801},{["tree"] = {} ,["value"] = 258872},{["tree"] = {} ,["value"] = 279353},{["tree"] = {} ,["value"] = 696228}} ,["value"] = 457594},{["tree"] = {{["tree"] = {} ,["value"] = 155941},{["tree"] = {} ,["value"] = 310432},{["tree"] = {} ,["value"] = 920524},{["tree"] = {} ,["value"] = 705714}} ,["value"] = 627305},{["tree"] = {{["tree"] = {} ,["value"] = 842860},{["tree"] = {} ,["value"] = 621389},{["tree"] = {} ,["value"] = 254384},{["tree"] = {} ,["value"] = 866409}} ,["value"] = 611652}} ,["value"] = 139590},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 267717},{["tree"] = {} ,["value"] = 912695},{["tree"] = {} ,["value"] = 385535},{["tree"] = {} ,["value"] = 584456}} ,["value"] = 223820},{["tree"] = {{["tree"] = {} ,["value"] = 554628},{["tree"] = {} ,["value"] = 91135},{["tree"] = {} ,["value"] = 341719},{["tree"] = {} ,["value"] = 854143}} ,["value"] = 652138},{["tree"] = {{["tree"] = {} ,["value"] = 395007},{["tree"] = {} ,["value"] = 240990},{["tree"] = {} ,["value"] = 281980},{["tree"] = {} ,["value"] = 27122}} ,["value"] = 986148},{["tree"] = {{["tree"] = {} ,["value"] = 504603},{["tree"] = {} ,["value"] = 701005},{["tree"] = {} ,["value"] = 850533},{["tree"] = {} ,["value"] = 938765}} ,["value"] = 622401}} ,["value"] = 20134},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 558295},{["tree"] = {} ,["value"] = 962529},{["tree"] = {} ,["value"] = 32891},{["tree"] = {} ,["value"] = 229396}} ,["value"] = 916383},{["tree"] = {{["tree"] = {} ,["value"] = 877618},{["tree"] = {} ,["value"] = 146083},{["tree"] = {} ,["value"] = 710352},{["tree"] = {} ,["value"] = 196681}} ,["value"] = 927525},{["tree"] = {{["tree"] = {} ,["value"] = 771496},{["tree"] = {} ,["value"] = 358388},{["tree"] = {} ,["value"] = 995719},{["tree"] = {} ,["value"] = 556933}} ,["value"] = 667367},{["tree"] = {{["tree"] = {} ,["value"] = 19668},{["tree"] = {} ,["value"] = 478595},{["tree"] = {} ,["value"] = 359456},{["tree"] = {} ,["value"] = 209059}} ,["value"] = 542632}} ,["value"] = 419253},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 678813},{["tree"] = {} ,["value"] = 919992},{["tree"] = {} ,["value"] = 820008},{["tree"] = {} ,["value"] = 593822}} ,["value"] = 370457},{["tree"] = {{["tree"] = {} ,["value"] = 756899},{["tree"] = {} ,["value"] = 850165},{["tree"] = {} ,["value"] = 722207},{["tree"] = {} ,["value"] = 661860}} ,["value"] = 276864},{["tree"] = {{["tree"] = {} ,["value"] = 846692},{["tree"] = {} ,["value"] = 391557},{["tree"] = {} ,["value"] = 72111},{["tree"] = {} ,["value"] = 290203}} ,["value"] = 440045},{["tree"] = {{["tree"] = {} ,["value"] = 164108},{["tree"] = {} ,["value"] = 946896},{["tree"] = {} ,["value"] = 868978},{["tree"] = {} ,["value"] = 58523}} ,["value"] = 562735}} ,["value"] = 480193}} ,["value"] = 87160},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 321968},{["tree"] = {} ,["value"] = 896049},{["tree"] = {} ,["value"] = 518303},{["tree"] = {} ,["value"] = 541146}} ,["value"] = 480882},{["tree"] = {{["tree"] = {} ,["value"] = 947810},{["tree"] = {} ,["value"] = 531009},{["tree"] = {} ,["value"] = 973476},{["tree"] = {} ,["value"] = 269223}} ,["value"] = 330932},{["tree"] = {{["tree"] = {} ,["value"] = 401646},{["tree"] = {} ,["value"] = 316870},{["tree"] = {} ,["value"] = 834498},{["tree"] = {} ,["value"] = 236263}} ,["value"] = 99215},{["tree"] = {{["tree"] = {} ,["value"] = 395501},{["tree"] = {} ,["value"] = 873899},{["tree"] = {} ,["value"] = 405481},{["tree"] = {} ,["value"] = 115915}} ,["value"] = 554848}} ,["value"] = 413679},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 62574},{["tree"] = {} ,["value"] = 865958},{["tree"] = {} ,["value"] = 63177},{["tree"] = {} ,["value"] = 990116}} ,["value"] = 918965},{["tree"] = {{["tree"] = {} ,["value"] = 364649},{["tree"] = {} ,["value"] = 661764},{["tree"] = {} ,["value"] = 568956},{["tree"] = {} ,["value"] = 213789}} ,["value"] = 709722},{["tree"] = {{["tree"] = {} ,["value"] = 40606},{["tree"] = {} ,["value"] = 535256},{["tree"] = {} ,["value"] = 23064},{["tree"] = {} ,["value"] = 492586}} ,["value"] = 729653},{["tree"] = {{["tree"] = {} ,["value"] = 254665},{["tree"] = {} ,["value"] = 149408},{["tree"] = {} ,["value"] = 907515},{["tree"] = {} ,["value"] = 19926}} ,["value"] = 595107}} ,["value"] = 599377},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 753523},{["tree"] = {} ,["value"] = 307362},{["tree"] = {} ,["value"] = 772866},{["tree"] = {} ,["value"] = 257019}} ,["value"] = 955654},{["tree"] = {{["tree"] = {} ,["value"] = 129325},{["tree"] = {} ,["value"] = 230677},{["tree"] = {} ,["value"] = 391970},{["tree"] = {} ,["value"] = 103036}} ,["value"] = 80360},{["tree"] = {{["tree"] = {} ,["value"] = 642430},{["tree"] = {} ,["value"] = 568800},{["tree"] = {} ,["value"] = 160024},{["tree"] = {} ,["value"] = 639258}} ,["value"] = 429641},{["tree"] = {{["tree"] = {} ,["value"] = 787027},{["tree"] = {} ,["value"] = 442269},{["tree"] = {} ,["value"] = 566940},{["tree"] = {} ,["value"] = 28360}} ,["value"] = 319238}} ,["value"] = 172096},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 807590},{["tree"] = {} ,["value"] = 135544},{["tree"] = {} ,["value"] = 323071},{["tree"] = {} ,["value"] = 941021}} ,["value"] = 598004},{["tree"] = {{["tree"] = {} ,["value"] = 405506},{["tree"] = {} ,["value"] = 284581},{["tree"] = {} ,["value"] = 705898},{["tree"] = {} ,["value"] = 955121}} ,["value"] = 345202},{["tree"] = {{["tree"] = {} ,["value"] = 467136},{["tree"] = {} ,["value"] = 17585},{["tree"] = {} ,["value"] = 95085},{["tree"] = {} ,["value"] = 307612}} ,["value"] = 144906},{["tree"] = {{["tree"] = {} ,["value"] = 727530},{["tree"] = {} ,["value"] = 477329},{["tree"] = {} ,["value"] = 274122},{["tree"] = {} ,["value"] = 12141}} ,["value"] = 763111}} ,["value"] = 43258}} ,["value"] = 54003},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 329713},{["tree"] = {} ,["value"] = 685605},{["tree"] = {} ,["value"] = 939064},{["tree"] = {} ,["value"] = 534778}} ,["value"] = 550734},{["tree"] = {{["tree"] = {} ,["value"] = 469318},{["tree"] = {} ,["value"] = 678536},{["tree"] = {} ,["value"] = 356343},{["tree"] = {} ,["value"] = 940115}} ,["value"] = 23168},{["tree"] = {{["tree"] = {} ,["value"] = 882240},{["tree"] = {} ,["value"] = 302265},{["tree"] = {} ,["value"] = 173653},{["tree"] = {} ,["value"] = 345393}} ,["value"] = 170038},{["tree"] = {{["tree"] = {} ,["value"] = 387870},{["tree"] = {} ,["value"] = 938782},{["tree"] = {} ,["value"] = 998847},{["tree"] = {} ,["value"] = 57740}} ,["value"] = 549525}} ,["value"] = 741616},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 661188},{["tree"] = {} ,["value"] = 762004},{["tree"] = {} ,["value"] = 57548},{["tree"] = {} ,["value"] = 848084}} ,["value"] = 69402},{["tree"] = {{["tree"] = {} ,["value"] = 994125},{["tree"] = {} ,["value"] = 231689},{["tree"] = {} ,["value"] = 33493},{["tree"] = {} ,["value"] = 104766}} ,["value"] = 737221},{["tree"] = {{["tree"] = {} ,["value"] = 508776},{["tree"] = {} ,["value"] = 180020},{["tree"] = {} ,["value"] = 688283},{["tree"] = {} ,["value"] = 701177}} ,["value"] = 942200},{["tree"] = {{["tree"] = {} ,["value"] = 292796},{["tree"] = {} ,["value"] = 651867},{["tree"] = {} ,["value"] = 662325},{["tree"] = {} ,["value"] = 369853}} ,["value"] = 675193}} ,["value"] = 641060},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 589545},{["tree"] = {} ,["value"] = 885041},{["tree"] = {} ,["value"] = 400830},{["tree"] = {} ,["value"] = 299451}} ,["value"] = 957295},{["tree"] = {{["tree"] = {} ,["value"] = 84643},{["tree"] = {} ,["value"] = 202775},{["tree"] = {} ,["value"] = 683025},{["tree"] = {} ,["value"] = 919492}} ,["value"] = 738805},{["tree"] = {{["tree"] = {} ,["value"] = 934754},{["tree"] = {} ,["value"] = 997200},{["tree"] = {} ,["value"] = 79808},{["tree"] = {} ,["value"] = 325889}} ,["value"] = 320467},{["tree"] = {{["tree"] = {} ,["value"] = 471222},{["tree"] = {} ,["value"] = 75402},{["tree"] = {} ,["value"] = 245522},{["tree"] = {} ,["value"] = 622404}} ,["value"] = 797917}} ,["value"] = 102990},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 724221},{["tree"] = {} ,["value"] = 282582},{["tree"] = {} ,["value"] = 693004},{["tree"] = {} ,["value"] = 709883}} ,["value"] = 65225},{["tree"] = {{["tree"] = {} ,["value"] = 588058},{["tree"] = {} ,["value"] = 551032},{["tree"] = {} ,["value"] = 857361},{["tree"] = {} ,["value"] = 127766}} ,["value"] = 317861},{["tree"] = {{["tree"] = {} ,["value"] = 284893},{["tree"] = {} ,["value"] = 308312},{["tree"] = {} ,["value"] = 524709},{["tree"] = {} ,["value"] = 346474}} ,["value"] = 893767},{["tree"] = {{["tree"] = {} ,["value"] = 784513},{["tree"] = {} ,["value"] = 445350},{["tree"] = {} ,["value"] = 808214},{["tree"] = {} ,["value"] = 588602}} ,["value"] = 664185}} ,["value"] = 275778}} ,["value"] = 128530}} ,["value"] = 780086},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 359318},{["tree"] = {} ,["value"] = 554948},{["tree"] = {} ,["value"] = 824030},{["tree"] = {} ,["value"] = 119209}} ,["value"] = 270615},{["tree"] = {{["tree"] = {} ,["value"] = 62705},{["tree"] = {} ,["value"] = 460094},{["tree"] = {} ,["value"] = 332835},{["tree"] = {} ,["value"] = 230212}} ,["value"] = 712359},{["tree"] = {{["tree"] = {} ,["value"] = 369034},{["tree"] = {} ,["value"] = 691515},{["tree"] = {} ,["value"] = 278647},{["tree"] = {} ,["value"] = 751849}} ,["value"] = 216212},{["tree"] = {{["tree"] = {} ,["value"] = 975925},{["tree"] = {} ,["value"] = 678826},{["tree"] = {} ,["value"] = 212039},{["tree"] = {} ,["value"] = 37529}} ,["value"] = 933484}} ,["value"] = 592725},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 405420},{["tree"] = {} ,["value"] = 991737},{["tree"] = {} ,["value"] = 878308},{["tree"] = {} ,["value"] = 293950}} ,["value"] = 726548},{["tree"] = {{["tree"] = {} ,["value"] = 340291},{["tree"] = {} ,["value"] = 522588},{["tree"] = {} ,["value"] = 974718},{["tree"] = {} ,["value"] = 557059}} ,["value"] = 330261},{["tree"] = {{["tree"] = {} ,["value"] = 800897},{["tree"] = {} ,["value"] = 302554},{["tree"] = {} ,["value"] = 148009},{["tree"] = {} ,["value"] = 377261}} ,["value"] = 407784},{["tree"] = {{["tree"] = {} ,["value"] = 180782},{["tree"] = {} ,["value"] = 221459},{["tree"] = {} ,["value"] = 587132},{["tree"] = {} ,["value"] = 369644}} ,["value"] = 746885}} ,["value"] = 589364},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 813344},{["tree"] = {} ,["value"] = 465337},{["tree"] = {} ,["value"] = 990369},{["tree"] = {} ,["value"] = 530915}} ,["value"] = 350015},{["tree"] = {{["tree"] = {} ,["value"] = 477550},{["tree"] = {} ,["value"] = 159303},{["tree"] = {} ,["value"] = 871855},{["tree"] = {} ,["value"] = 594009}} ,["value"] = 325507},{["tree"] = {{["tree"] = {} ,["value"] = 773309},{["tree"] = {} ,["value"] = 470168},{["tree"] = {} ,["value"] = 553295},{["tree"] = {} ,["value"] = 568482}} ,["value"] = 974673},{["tree"] = {{["tree"] = {} ,["value"] = 968829},{["tree"] = {} ,["value"] = 166384},{["tree"] = {} ,["value"] = 875217},{["tree"] = {} ,["value"] = 288499}} ,["value"] = 226605}} ,["value"] = 842720},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 148895},{["tree"] = {} ,["value"] = 946192},{["tree"] = {} ,["value"] = 496050},{["tree"] = {} ,["value"] = 935355}} ,["value"] = 87005},{["tree"] = {{["tree"] = {} ,["value"] = 461433},{["tree"] = {} ,["value"] = 26415},{["tree"] = {} ,["value"] = 870432},{["tree"] = {} ,["value"] = 343172}} ,["value"] = 122943},{["tree"] = {{["tree"] = {} ,["value"] = 261165},{["tree"] = {} ,["value"] = 835896},{["tree"] = {} ,["value"] = 213345},{["tree"] = {} ,["value"] = 492127}} ,["value"] = 821993},{["tree"] = {{["tree"] = {} ,["value"] = 770284},{["tree"] = {} ,["value"] = 328600},{["tree"] = {} ,["value"] = 31475},{["tree"] = {} ,["value"] = 472365}} ,["value"] = 9068}} ,["value"] = 323338}} ,["value"] = 346270},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 916967},{["tree"] = {} ,["value"] = 937657},{["tree"] = {} ,["value"] = 211669},{["tree"] = {} ,["value"] = 753315}} ,["value"] = 634018},{["tree"] = {{["tree"] = {} ,["value"] = 792178},{["tree"] = {} ,["value"] = 822833},{["tree"] = {} ,["value"] = 421750},{["tree"] = {} ,["value"] = 527409}} ,["value"] = 163363},{["tree"] = {{["tree"] = {} ,["value"] = 920408},{["tree"] = {} ,["value"] = 666019},{["tree"] = {} ,["value"] = 903139},{["tree"] = {} ,["value"] = 11467}} ,["value"] = 506839},{["tree"] = {{["tree"] = {} ,["value"] = 853140},{["tree"] = {} ,["value"] = 381437},{["tree"] = {} ,["value"] = 641578},{["tree"] = {} ,["value"] = 370269}} ,["value"] = 762137}} ,["value"] = 303860},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 600572},{["tree"] = {} ,["value"] = 730677},{["tree"] = {} ,["value"] = 101213},{["tree"] = {} ,["value"] = 529556}} ,["value"] = 16646},{["tree"] = {{["tree"] = {} ,["value"] = 23681},{["tree"] = {} ,["value"] = 971450},{["tree"] = {} ,["value"] = 484529},{["tree"] = {} ,["value"] = 326246}} ,["value"] = 420749},{["tree"] = {{["tree"] = {} ,["value"] = 952218},{["tree"] = {} ,["value"] = 212331},{["tree"] = {} ,["value"] = 306087},{["tree"] = {} ,["value"] = 830205}} ,["value"] = 154386},{["tree"] = {{["tree"] = {} ,["value"] = 121426},{["tree"] = {} ,["value"] = 740316},{["tree"] = {} ,["value"] = 665882},{["tree"] = {} ,["value"] = 208049}} ,["value"] = 634667}} ,["value"] = 49683},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 676897},{["tree"] = {} ,["value"] = 201973},{["tree"] = {} ,["value"] = 839996},{["tree"] = {} ,["value"] = 793679}} ,["value"] = 290303},{["tree"] = {{["tree"] = {} ,["value"] = 561366},{["tree"] = {} ,["value"] = 344174},{["tree"] = {} ,["value"] = 262773},{["tree"] = {} ,["value"] = 933830}} ,["value"] = 75148},{["tree"] = {{["tree"] = {} ,["value"] = 750015},{["tree"] = {} ,["value"] = 14764},{["tree"] = {} ,["value"] = 169211},{["tree"] = {} ,["value"] = 930212}} ,["value"] = 581382},{["tree"] = {{["tree"] = {} ,["value"] = 493146},{["tree"] = {} ,["value"] = 171921},{["tree"] = {} ,["value"] = 173062},{["tree"] = {} ,["value"] = 450628}} ,["value"] = 58485}} ,["value"] = 436228},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 676555},{["tree"] = {} ,["value"] = 671941},{["tree"] = {} ,["value"] = 451057},{["tree"] = {} ,["value"] = 405404}} ,["value"] = 222742},{["tree"] = {{["tree"] = {} ,["value"] = 990493},{["tree"] = {} ,["value"] = 822524},{["tree"] = {} ,["value"] = 805808},{["tree"] = {} ,["value"] = 554908}} ,["value"] = 200434},{["tree"] = {{["tree"] = {} ,["value"] = 235453},{["tree"] = {} ,["value"] = 266068},{["tree"] = {} ,["value"] = 919543},{["tree"] = {} ,["value"] = 107361}} ,["value"] = 363981},{["tree"] = {{["tree"] = {} ,["value"] = 29847},{["tree"] = {} ,["value"] = 307645},{["tree"] = {} ,["value"] = 607355},{["tree"] = {} ,["value"] = 967864}} ,["value"] = 510929}} ,["value"] = 109462}} ,["value"] = 78334},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 292346},{["tree"] = {} ,["value"] = 581368},{["tree"] = {} ,["value"] = 818877},{["tree"] = {} ,["value"] = 929787}} ,["value"] = 805631},{["tree"] = {{["tree"] = {} ,["value"] = 667011},{["tree"] = {} ,["value"] = 776551},{["tree"] = {} ,["value"] = 213739},{["tree"] = {} ,["value"] = 433101}} ,["value"] = 713879},{["tree"] = {{["tree"] = {} ,["value"] = 406170},{["tree"] = {} ,["value"] = 678157},{["tree"] = {} ,["value"] = 622958},{["tree"] = {} ,["value"] = 761266}} ,["value"] = 36093},{["tree"] = {{["tree"] = {} ,["value"] = 180676},{["tree"] = {} ,["value"] = 935736},{["tree"] = {} ,["value"] = 646423},{["tree"] = {} ,["value"] = 508461}} ,["value"] = 798201}} ,["value"] = 374776},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 166777},{["tree"] = {} ,["value"] = 256845},{["tree"] = {} ,["value"] = 175740},{["tree"] = {} ,["value"] = 454883}} ,["value"] = 834904},{["tree"] = {{["tree"] = {} ,["value"] = 249863},{["tree"] = {} ,["value"] = 874657},{["tree"] = {} ,["value"] = 150859},{["tree"] = {} ,["value"] = 973821}} ,["value"] = 132315},{["tree"] = {{["tree"] = {} ,["value"] = 58637},{["tree"] = {} ,["value"] = 702742},{["tree"] = {} ,["value"] = 492229},{["tree"] = {} ,["value"] = 969082}} ,["value"] = 568279},{["tree"] = {{["tree"] = {} ,["value"] = 439455},{["tree"] = {} ,["value"] = 701675},{["tree"] = {} ,["value"] = 569574},{["tree"] = {} ,["value"] = 733539}} ,["value"] = 722431}} ,["value"] = 496751},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 387295},{["tree"] = {} ,["value"] = 77723},{["tree"] = {} ,["value"] = 546579},{["tree"] = {} ,["value"] = 334059}} ,["value"] = 670064},{["tree"] = {{["tree"] = {} ,["value"] = 361221},{["tree"] = {} ,["value"] = 301636},{["tree"] = {} ,["value"] = 307275},{["tree"] = {} ,["value"] = 433507}} ,["value"] = 545611},{["tree"] = {{["tree"] = {} ,["value"] = 220196},{["tree"] = {} ,["value"] = 766668},{["tree"] = {} ,["value"] = 271222},{["tree"] = {} ,["value"] = 968029}} ,["value"] = 164851},{["tree"] = {{["tree"] = {} ,["value"] = 890963},{["tree"] = {} ,["value"] = 670852},{["tree"] = {} ,["value"] = 793181},{["tree"] = {} ,["value"] = 919584}} ,["value"] = 299094}} ,["value"] = 143166},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 654115},{["tree"] = {} ,["value"] = 778471},{["tree"] = {} ,["value"] = 119206},{["tree"] = {} ,["value"] = 804990}} ,["value"] = 300842},{["tree"] = {{["tree"] = {} ,["value"] = 387151},{["tree"] = {} ,["value"] = 540871},{["tree"] = {} ,["value"] = 113967},{["tree"] = {} ,["value"] = 15282}} ,["value"] = 110808},{["tree"] = {{["tree"] = {} ,["value"] = 43314},{["tree"] = {} ,["value"] = 103983},{["tree"] = {} ,["value"] = 704443},{["tree"] = {} ,["value"] = 56094}} ,["value"] = 993031},{["tree"] = {{["tree"] = {} ,["value"] = 227348},{["tree"] = {} ,["value"] = 690498},{["tree"] = {} ,["value"] = 165965},{["tree"] = {} ,["value"] = 432536}} ,["value"] = 105915}} ,["value"] = 687485}} ,["value"] = 954026},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 356535},{["tree"] = {} ,["value"] = 143690},{["tree"] = {} ,["value"] = 607415},{["tree"] = {} ,["value"] = 238104}} ,["value"] = 192541},{["tree"] = {{["tree"] = {} ,["value"] = 524745},{["tree"] = {} ,["value"] = 71527},{["tree"] = {} ,["value"] = 396767},{["tree"] = {} ,["value"] = 79540}} ,["value"] = 365358},{["tree"] = {{["tree"] = {} ,["value"] = 19682},{["tree"] = {} ,["value"] = 363905},{["tree"] = {} ,["value"] = 139461},{["tree"] = {} ,["value"] = 83177}} ,["value"] = 699950},{["tree"] = {{["tree"] = {} ,["value"] = 681061},{["tree"] = {} ,["value"] = 356214},{["tree"] = {} ,["value"] = 672323},{["tree"] = {} ,["value"] = 261399}} ,["value"] = 604015}} ,["value"] = 895544},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 824743},{["tree"] = {} ,["value"] = 997562},{["tree"] = {} ,["value"] = 231089},{["tree"] = {} ,["value"] = 815170}} ,["value"] = 632838},{["tree"] = {{["tree"] = {} ,["value"] = 324615},{["tree"] = {} ,["value"] = 118557},{["tree"] = {} ,["value"] = 837677},{["tree"] = {} ,["value"] = 961113}} ,["value"] = 487750},{["tree"] = {{["tree"] = {} ,["value"] = 640814},{["tree"] = {} ,["value"] = 346728},{["tree"] = {} ,["value"] = 865690},{["tree"] = {} ,["value"] = 381864}} ,["value"] = 414439},{["tree"] = {{["tree"] = {} ,["value"] = 967561},{["tree"] = {} ,["value"] = 105375},{["tree"] = {} ,["value"] = 170604},{["tree"] = {} ,["value"] = 137418}} ,["value"] = 904939}} ,["value"] = 346054},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 664299},{["tree"] = {} ,["value"] = 684371},{["tree"] = {} ,["value"] = 569701},{["tree"] = {} ,["value"] = 619581}} ,["value"] = 873218},{["tree"] = {{["tree"] = {} ,["value"] = 223139},{["tree"] = {} ,["value"] = 534859},{["tree"] = {} ,["value"] = 904849},{["tree"] = {} ,["value"] = 53574}} ,["value"] = 9059},{["tree"] = {{["tree"] = {} ,["value"] = 914368},{["tree"] = {} ,["value"] = 255151},{["tree"] = {} ,["value"] = 65702},{["tree"] = {} ,["value"] = 2074}} ,["value"] = 330379},{["tree"] = {{["tree"] = {} ,["value"] = 628569},{["tree"] = {} ,["value"] = 275092},{["tree"] = {} ,["value"] = 295143},{["tree"] = {} ,["value"] = 382208}} ,["value"] = 785290}} ,["value"] = 274924},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 866330},{["tree"] = {} ,["value"] = 26762},{["tree"] = {} ,["value"] = 289958},{["tree"] = {} ,["value"] = 596847}} ,["value"] = 437626},{["tree"] = {{["tree"] = {} ,["value"] = 112742},{["tree"] = {} ,["value"] = 176608},{["tree"] = {} ,["value"] = 650235},{["tree"] = {} ,["value"] = 618067}} ,["value"] = 493755},{["tree"] = {{["tree"] = {} ,["value"] = 6485},{["tree"] = {} ,["value"] = 641292},{["tree"] = {} ,["value"] = 679320},{["tree"] = {} ,["value"] = 941806}} ,["value"] = 709440},{["tree"] = {{["tree"] = {} ,["value"] = 561425},{["tree"] = {} ,["value"] = 602833},{["tree"] = {} ,["value"] = 311425},{["tree"] = {} ,["value"] = 223963}} ,["value"] = 305014}} ,["value"] = 191690}} ,["value"] = 286516}} ,["value"] = 111142}} ,["value"] = 820776},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 690516},{["tree"] = {} ,["value"] = 970210},{["tree"] = {} ,["value"] = 458148},{["tree"] = {} ,["value"] = 436599}} ,["value"] = 770461},{["tree"] = {{["tree"] = {} ,["value"] = 750554},{["tree"] = {} ,["value"] = 163152},{["tree"] = {} ,["value"] = 418137},{["tree"] = {} ,["value"] = 295906}} ,["value"] = 766977},{["tree"] = {{["tree"] = {} ,["value"] = 624062},{["tree"] = {} ,["value"] = 728656},{["tree"] = {} ,["value"] = 767957},{["tree"] = {} ,["value"] = 120490}} ,["value"] = 47633},{["tree"] = {{["tree"] = {} ,["value"] = 228997},{["tree"] = {} ,["value"] = 517437},{["tree"] = {} ,["value"] = 880976},{["tree"] = {} ,["value"] = 447816}} ,["value"] = 97427}} ,["value"] = 326855},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 457104},{["tree"] = {} ,["value"] = 531725},{["tree"] = {} ,["value"] = 342158},{["tree"] = {} ,["value"] = 202320}} ,["value"] = 899858},{["tree"] = {{["tree"] = {} ,["value"] = 49927},{["tree"] = {} ,["value"] = 909117},{["tree"] = {} ,["value"] = 52403},{["tree"] = {} ,["value"] = 942208}} ,["value"] = 91131},{["tree"] = {{["tree"] = {} ,["value"] = 118971},{["tree"] = {} ,["value"] = 259625},{["tree"] = {} ,["value"] = 599663},{["tree"] = {} ,["value"] = 529717}} ,["value"] = 413949},{["tree"] = {{["tree"] = {} ,["value"] = 115796},{["tree"] = {} ,["value"] = 79312},{["tree"] = {} ,["value"] = 339127},{["tree"] = {} ,["value"] = 441083}} ,["value"] = 854582}} ,["value"] = 397106},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 57232},{["tree"] = {} ,["value"] = 886692},{["tree"] = {} ,["value"] = 455716},{["tree"] = {} ,["value"] = 135623}} ,["value"] = 97516},{["tree"] = {{["tree"] = {} ,["value"] = 655487},{["tree"] = {} ,["value"] = 266035},{["tree"] = {} ,["value"] = 56802},{["tree"] = {} ,["value"] = 76077}} ,["value"] = 706382},{["tree"] = {{["tree"] = {} ,["value"] = 646107},{["tree"] = {} ,["value"] = 543472},{["tree"] = {} ,["value"] = 175336},{["tree"] = {} ,["value"] = 818914}} ,["value"] = 640175},{["tree"] = {{["tree"] = {} ,["value"] = 650348},{["tree"] = {} ,["value"] = 219846},{["tree"] = {} ,["value"] = 871229},{["tree"] = {} ,["value"] = 553859}} ,["value"] = 940358}} ,["value"] = 915012},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 606914},{["tree"] = {} ,["value"] = 981168},{["tree"] = {} ,["value"] = 650165},{["tree"] = {} ,["value"] = 25915}} ,["value"] = 928751},{["tree"] = {{["tree"] = {} ,["value"] = 793170},{["tree"] = {} ,["value"] = 992783},{["tree"] = {} ,["value"] = 399065},{["tree"] = {} ,["value"] = 808457}} ,["value"] = 671803},{["tree"] = {{["tree"] = {} ,["value"] = 895309},{["tree"] = {} ,["value"] = 995619},{["tree"] = {} ,["value"] = 555334},{["tree"] = {} ,["value"] = 782127}} ,["value"] = 419408},{["tree"] = {{["tree"] = {} ,["value"] = 410929},{["tree"] = {} ,["value"] = 879279},{["tree"] = {} ,["value"] = 957713},{["tree"] = {} ,["value"] = 922549}} ,["value"] = 735164}} ,["value"] = 29587}} ,["value"] = 33905},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 196846},{["tree"] = {} ,["value"] = 168467},{["tree"] = {} ,["value"] = 540572},{["tree"] = {} ,["value"] = 146260}} ,["value"] = 672579},{["tree"] = {{["tree"] = {} ,["value"] = 743656},{["tree"] = {} ,["value"] = 383074},{["tree"] = {} ,["value"] = 363636},{["tree"] = {} ,["value"] = 984660}} ,["value"] = 811275},{["tree"] = {{["tree"] = {} ,["value"] = 439844},{["tree"] = {} ,["value"] = 471714},{["tree"] = {} ,["value"] = 787255},{["tree"] = {} ,["value"] = 717399}} ,["value"] = 91787},{["tree"] = {{["tree"] = {} ,["value"] = 100640},{["tree"] = {} ,["value"] = 4897},{["tree"] = {} ,["value"] = 364151},{["tree"] = {} ,["value"] = 187906}} ,["value"] = 480441}} ,["value"] = 203097},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 795453},{["tree"] = {} ,["value"] = 535913},{["tree"] = {} ,["value"] = 838628},{["tree"] = {} ,["value"] = 940424}} ,["value"] = 398563},{["tree"] = {{["tree"] = {} ,["value"] = 837321},{["tree"] = {} ,["value"] = 235474},{["tree"] = {} ,["value"] = 206835},{["tree"] = {} ,["value"] = 220699}} ,["value"] = 31912},{["tree"] = {{["tree"] = {} ,["value"] = 968881},{["tree"] = {} ,["value"] = 852496},{["tree"] = {} ,["value"] = 130620},{["tree"] = {} ,["value"] = 618393}} ,["value"] = 654006},{["tree"] = {{["tree"] = {} ,["value"] = 559771},{["tree"] = {} ,["value"] = 982090},{["tree"] = {} ,["value"] = 46178},{["tree"] = {} ,["value"] = 973743}} ,["value"] = 402668}} ,["value"] = 852807},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 371921},{["tree"] = {} ,["value"] = 893084},{["tree"] = {} ,["value"] = 984833},{["tree"] = {} ,["value"] = 95587}} ,["value"] = 918239},{["tree"] = {{["tree"] = {} ,["value"] = 668957},{["tree"] = {} ,["value"] = 492829},{["tree"] = {} ,["value"] = 25778},{["tree"] = {} ,["value"] = 415195}} ,["value"] = 382701},{["tree"] = {{["tree"] = {} ,["value"] = 629623},{["tree"] = {} ,["value"] = 563854},{["tree"] = {} ,["value"] = 653431},{["tree"] = {} ,["value"] = 967371}} ,["value"] = 719463},{["tree"] = {{["tree"] = {} ,["value"] = 837130},{["tree"] = {} ,["value"] = 764078},{["tree"] = {} ,["value"] = 68179},{["tree"] = {} ,["value"] = 635149}} ,["value"] = 799997}} ,["value"] = 632992},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 477133},{["tree"] = {} ,["value"] = 507290},{["tree"] = {} ,["value"] = 56106},{["tree"] = {} ,["value"] = 978626}} ,["value"] = 286650},{["tree"] = {{["tree"] = {} ,["value"] = 424757},{["tree"] = {} ,["value"] = 593808},{["tree"] = {} ,["value"] = 703243},{["tree"] = {} ,["value"] = 72968}} ,["value"] = 874106},{["tree"] = {{["tree"] = {} ,["value"] = 736711},{["tree"] = {} ,["value"] = 702037},{["tree"] = {} ,["value"] = 133758},{["tree"] = {} ,["value"] = 908823}} ,["value"] = 826120},{["tree"] = {{["tree"] = {} ,["value"] = 953553},{["tree"] = {} ,["value"] = 788900},{["tree"] = {} ,["value"] = 156756},{["tree"] = {} ,["value"] = 462235}} ,["value"] = 688995}} ,["value"] = 503314}} ,["value"] = 123101},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 553321},{["tree"] = {} ,["value"] = 436607},{["tree"] = {} ,["value"] = 229762},{["tree"] = {} ,["value"] = 862500}} ,["value"] = 859211},{["tree"] = {{["tree"] = {} ,["value"] = 705764},{["tree"] = {} ,["value"] = 712060},{["tree"] = {} ,["value"] = 283058},{["tree"] = {} ,["value"] = 996242}} ,["value"] = 227845},{["tree"] = {{["tree"] = {} ,["value"] = 186955},{["tree"] = {} ,["value"] = 518050},{["tree"] = {} ,["value"] = 252997},{["tree"] = {} ,["value"] = 236438}} ,["value"] = 497169},{["tree"] = {{["tree"] = {} ,["value"] = 923892},{["tree"] = {} ,["value"] = 748335},{["tree"] = {} ,["value"] = 976182},{["tree"] = {} ,["value"] = 372357}} ,["value"] = 39563}} ,["value"] = 778379},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 155644},{["tree"] = {} ,["value"] = 646455},{["tree"] = {} ,["value"] = 429060},{["tree"] = {} ,["value"] = 226325}} ,["value"] = 233403},{["tree"] = {{["tree"] = {} ,["value"] = 779033},{["tree"] = {} ,["value"] = 60963},{["tree"] = {} ,["value"] = 544316},{["tree"] = {} ,["value"] = 122421}} ,["value"] = 306125},{["tree"] = {{["tree"] = {} ,["value"] = 875966},{["tree"] = {} ,["value"] = 930168},{["tree"] = {} ,["value"] = 188435},{["tree"] = {} ,["value"] = 368384}} ,["value"] = 204274},{["tree"] = {{["tree"] = {} ,["value"] = 973493},{["tree"] = {} ,["value"] = 880205},{["tree"] = {} ,["value"] = 682560},{["tree"] = {} ,["value"] = 121458}} ,["value"] = 652565}} ,["value"] = 436210},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 779812},{["tree"] = {} ,["value"] = 913468},{["tree"] = {} ,["value"] = 253346},{["tree"] = {} ,["value"] = 327035}} ,["value"] = 716847},{["tree"] = {{["tree"] = {} ,["value"] = 813051},{["tree"] = {} ,["value"] = 186750},{["tree"] = {} ,["value"] = 667249},{["tree"] = {} ,["value"] = 443417}} ,["value"] = 770637},{["tree"] = {{["tree"] = {} ,["value"] = 279500},{["tree"] = {} ,["value"] = 101333},{["tree"] = {} ,["value"] = 760412},{["tree"] = {} ,["value"] = 130550}} ,["value"] = 786114},{["tree"] = {{["tree"] = {} ,["value"] = 357528},{["tree"] = {} ,["value"] = 671660},{["tree"] = {} ,["value"] = 627460},{["tree"] = {} ,["value"] = 875405}} ,["value"] = 307544}} ,["value"] = 973688},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 899717},{["tree"] = {} ,["value"] = 507462},{["tree"] = {} ,["value"] = 375850},{["tree"] = {} ,["value"] = 166882}} ,["value"] = 362109},{["tree"] = {{["tree"] = {} ,["value"] = 417740},{["tree"] = {} ,["value"] = 823880},{["tree"] = {} ,["value"] = 179588},{["tree"] = {} ,["value"] = 144941}} ,["value"] = 474979},{["tree"] = {{["tree"] = {} ,["value"] = 800139},{["tree"] = {} ,["value"] = 416531},{["tree"] = {} ,["value"] = 683733},{["tree"] = {} ,["value"] = 636011}} ,["value"] = 620553},{["tree"] = {{["tree"] = {} ,["value"] = 182645},{["tree"] = {} ,["value"] = 486729},{["tree"] = {} ,["value"] = 766641},{["tree"] = {} ,["value"] = 298958}} ,["value"] = 202602}} ,["value"] = 165161}} ,["value"] = 779721},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 812889},{["tree"] = {} ,["value"] = 701055},{["tree"] = {} ,["value"] = 413042},{["tree"] = {} ,["value"] = 650726}} ,["value"] = 174375},{["tree"] = {{["tree"] = {} ,["value"] = 344784},{["tree"] = {} ,["value"] = 808188},{["tree"] = {} ,["value"] = 31775},{["tree"] = {} ,["value"] = 819876}} ,["value"] = 540397},{["tree"] = {{["tree"] = {} ,["value"] = 840567},{["tree"] = {} ,["value"] = 411528},{["tree"] = {} ,["value"] = 529557},{["tree"] = {} ,["value"] = 254052}} ,["value"] = 20853},{["tree"] = {{["tree"] = {} ,["value"] = 548232},{["tree"] = {} ,["value"] = 515858},{["tree"] = {} ,["value"] = 278585},{["tree"] = {} ,["value"] = 870532}} ,["value"] = 702565}} ,["value"] = 589808},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 938686},{["tree"] = {} ,["value"] = 450955},{["tree"] = {} ,["value"] = 701205},{["tree"] = {} ,["value"] = 464230}} ,["value"] = 776552},{["tree"] = {{["tree"] = {} ,["value"] = 643094},{["tree"] = {} ,["value"] = 185267},{["tree"] = {} ,["value"] = 278265},{["tree"] = {} ,["value"] = 922527}} ,["value"] = 63597},{["tree"] = {{["tree"] = {} ,["value"] = 400490},{["tree"] = {} ,["value"] = 450907},{["tree"] = {} ,["value"] = 118060},{["tree"] = {} ,["value"] = 308857}} ,["value"] = 235569},{["tree"] = {{["tree"] = {} ,["value"] = 799263},{["tree"] = {} ,["value"] = 644962},{["tree"] = {} ,["value"] = 534571},{["tree"] = {} ,["value"] = 965884}} ,["value"] = 639201}} ,["value"] = 137489},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 201177},{["tree"] = {} ,["value"] = 192550},{["tree"] = {} ,["value"] = 706527},{["tree"] = {} ,["value"] = 818074}} ,["value"] = 606552},{["tree"] = {{["tree"] = {} ,["value"] = 67955},{["tree"] = {} ,["value"] = 266163},{["tree"] = {} ,["value"] = 716258},{["tree"] = {} ,["value"] = 642276}} ,["value"] = 478652},{["tree"] = {{["tree"] = {} ,["value"] = 264215},{["tree"] = {} ,["value"] = 663785},{["tree"] = {} ,["value"] = 89832},{["tree"] = {} ,["value"] = 806048}} ,["value"] = 516492},{["tree"] = {{["tree"] = {} ,["value"] = 399743},{["tree"] = {} ,["value"] = 777560},{["tree"] = {} ,["value"] = 361834},{["tree"] = {} ,["value"] = 392575}} ,["value"] = 224349}} ,["value"] = 246866},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 428165},{["tree"] = {} ,["value"] = 698856},{["tree"] = {} ,["value"] = 252473},{["tree"] = {} ,["value"] = 835198}} ,["value"] = 719323},{["tree"] = {{["tree"] = {} ,["value"] = 274364},{["tree"] = {} ,["value"] = 810359},{["tree"] = {} ,["value"] = 448376},{["tree"] = {} ,["value"] = 1845}} ,["value"] = 976374},{["tree"] = {{["tree"] = {} ,["value"] = 504717},{["tree"] = {} ,["value"] = 28764},{["tree"] = {} ,["value"] = 569077},{["tree"] = {} ,["value"] = 573435}} ,["value"] = 587135},{["tree"] = {{["tree"] = {} ,["value"] = 797039},{["tree"] = {} ,["value"] = 458014},{["tree"] = {} ,["value"] = 640366},{["tree"] = {} ,["value"] = 972568}} ,["value"] = 48380}} ,["value"] = 637736}} ,["value"] = 845428}} ,["value"] = 737344},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 21247},{["tree"] = {} ,["value"] = 848854},{["tree"] = {} ,["value"] = 577098},{["tree"] = {} ,["value"] = 231311}} ,["value"] = 629336},{["tree"] = {{["tree"] = {} ,["value"] = 739231},{["tree"] = {} ,["value"] = 19219},{["tree"] = {} ,["value"] = 784568},{["tree"] = {} ,["value"] = 523322}} ,["value"] = 190931},{["tree"] = {{["tree"] = {} ,["value"] = 402221},{["tree"] = {} ,["value"] = 527051},{["tree"] = {} ,["value"] = 719614},{["tree"] = {} ,["value"] = 932458}} ,["value"] = 811480},{["tree"] = {{["tree"] = {} ,["value"] = 674249},{["tree"] = {} ,["value"] = 628239},{["tree"] = {} ,["value"] = 572266},{["tree"] = {} ,["value"] = 726119}} ,["value"] = 848008}} ,["value"] = 388654},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 831946},{["tree"] = {} ,["value"] = 292279},{["tree"] = {} ,["value"] = 439117},{["tree"] = {} ,["value"] = 731514}} ,["value"] = 600583},{["tree"] = {{["tree"] = {} ,["value"] = 363554},{["tree"] = {} ,["value"] = 576648},{["tree"] = {} ,["value"] = 76931},{["tree"] = {} ,["value"] = 937107}} ,["value"] = 134184},{["tree"] = {{["tree"] = {} ,["value"] = 221301},{["tree"] = {} ,["value"] = 259901},{["tree"] = {} ,["value"] = 464510},{["tree"] = {} ,["value"] = 991623}} ,["value"] = 348041},{["tree"] = {{["tree"] = {} ,["value"] = 369310},{["tree"] = {} ,["value"] = 436209},{["tree"] = {} ,["value"] = 118442},{["tree"] = {} ,["value"] = 582349}} ,["value"] = 421392}} ,["value"] = 701788},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 648704},{["tree"] = {} ,["value"] = 538340},{["tree"] = {} ,["value"] = 216402},{["tree"] = {} ,["value"] = 906926}} ,["value"] = 991922},{["tree"] = {{["tree"] = {} ,["value"] = 898281},{["tree"] = {} ,["value"] = 997694},{["tree"] = {} ,["value"] = 230261},{["tree"] = {} ,["value"] = 826943}} ,["value"] = 662391},{["tree"] = {{["tree"] = {} ,["value"] = 367686},{["tree"] = {} ,["value"] = 929683},{["tree"] = {} ,["value"] = 491846},{["tree"] = {} ,["value"] = 379562}} ,["value"] = 271563},{["tree"] = {{["tree"] = {} ,["value"] = 554549},{["tree"] = {} ,["value"] = 128119},{["tree"] = {} ,["value"] = 610853},{["tree"] = {} ,["value"] = 79987}} ,["value"] = 312695}} ,["value"] = 108105},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 68593},{["tree"] = {} ,["value"] = 254375},{["tree"] = {} ,["value"] = 631659},{["tree"] = {} ,["value"] = 785444}} ,["value"] = 874059},{["tree"] = {{["tree"] = {} ,["value"] = 8755},{["tree"] = {} ,["value"] = 496278},{["tree"] = {} ,["value"] = 924393},{["tree"] = {} ,["value"] = 783504}} ,["value"] = 342883},{["tree"] = {{["tree"] = {} ,["value"] = 509453},{["tree"] = {} ,["value"] = 855776},{["tree"] = {} ,["value"] = 878072},{["tree"] = {} ,["value"] = 488561}} ,["value"] = 46988},{["tree"] = {{["tree"] = {} ,["value"] = 113300},{["tree"] = {} ,["value"] = 73357},{["tree"] = {} ,["value"] = 405102},{["tree"] = {} ,["value"] = 215677}} ,["value"] = 346998}} ,["value"] = 451290}} ,["value"] = 914811},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 230385},{["tree"] = {} ,["value"] = 761187},{["tree"] = {} ,["value"] = 114152},{["tree"] = {} ,["value"] = 393515}} ,["value"] = 739389},{["tree"] = {{["tree"] = {} ,["value"] = 886223},{["tree"] = {} ,["value"] = 375652},{["tree"] = {} ,["value"] = 356420},{["tree"] = {} ,["value"] = 875922}} ,["value"] = 460911},{["tree"] = {{["tree"] = {} ,["value"] = 118886},{["tree"] = {} ,["value"] = 105703},{["tree"] = {} ,["value"] = 265757},{["tree"] = {} ,["value"] = 110326}} ,["value"] = 291103},{["tree"] = {{["tree"] = {} ,["value"] = 446916},{["tree"] = {} ,["value"] = 937846},{["tree"] = {} ,["value"] = 195336},{["tree"] = {} ,["value"] = 23347}} ,["value"] = 698456}} ,["value"] = 204034},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 419836},{["tree"] = {} ,["value"] = 974523},{["tree"] = {} ,["value"] = 518711},{["tree"] = {} ,["value"] = 113779}} ,["value"] = 667120},{["tree"] = {{["tree"] = {} ,["value"] = 547105},{["tree"] = {} ,["value"] = 47971},{["tree"] = {} ,["value"] = 389909},{["tree"] = {} ,["value"] = 189647}} ,["value"] = 739616},{["tree"] = {{["tree"] = {} ,["value"] = 751338},{["tree"] = {} ,["value"] = 450427},{["tree"] = {} ,["value"] = 239506},{["tree"] = {} ,["value"] = 833957}} ,["value"] = 563599},{["tree"] = {{["tree"] = {} ,["value"] = 323773},{["tree"] = {} ,["value"] = 519942},{["tree"] = {} ,["value"] = 130211},{["tree"] = {} ,["value"] = 443498}} ,["value"] = 566448}} ,["value"] = 47645},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 414111},{["tree"] = {} ,["value"] = 181703},{["tree"] = {} ,["value"] = 543966},{["tree"] = {} ,["value"] = 696955}} ,["value"] = 576190},{["tree"] = {{["tree"] = {} ,["value"] = 151658},{["tree"] = {} ,["value"] = 213789},{["tree"] = {} ,["value"] = 225670},{["tree"] = {} ,["value"] = 50885}} ,["value"] = 121079},{["tree"] = {{["tree"] = {} ,["value"] = 625030},{["tree"] = {} ,["value"] = 225107},{["tree"] = {} ,["value"] = 77321},{["tree"] = {} ,["value"] = 422029}} ,["value"] = 82414},{["tree"] = {{["tree"] = {} ,["value"] = 953916},{["tree"] = {} ,["value"] = 491862},{["tree"] = {} ,["value"] = 61869},{["tree"] = {} ,["value"] = 113560}} ,["value"] = 95505}} ,["value"] = 235356},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 10429},{["tree"] = {} ,["value"] = 866967},{["tree"] = {} ,["value"] = 81526},{["tree"] = {} ,["value"] = 526400}} ,["value"] = 556875},{["tree"] = {{["tree"] = {} ,["value"] = 860820},{["tree"] = {} ,["value"] = 208061},{["tree"] = {} ,["value"] = 371238},{["tree"] = {} ,["value"] = 222338}} ,["value"] = 439798},{["tree"] = {{["tree"] = {} ,["value"] = 431780},{["tree"] = {} ,["value"] = 495412},{["tree"] = {} ,["value"] = 315847},{["tree"] = {} ,["value"] = 36344}} ,["value"] = 153533},{["tree"] = {{["tree"] = {} ,["value"] = 706085},{["tree"] = {} ,["value"] = 850976},{["tree"] = {} ,["value"] = 597258},{["tree"] = {} ,["value"] = 317275}} ,["value"] = 331398}} ,["value"] = 579577}} ,["value"] = 48853},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 115490},{["tree"] = {} ,["value"] = 780637},{["tree"] = {} ,["value"] = 754632},{["tree"] = {} ,["value"] = 480786}} ,["value"] = 395167},{["tree"] = {{["tree"] = {} ,["value"] = 470951},{["tree"] = {} ,["value"] = 176317},{["tree"] = {} ,["value"] = 227402},{["tree"] = {} ,["value"] = 556234}} ,["value"] = 503166},{["tree"] = {{["tree"] = {} ,["value"] = 560115},{["tree"] = {} ,["value"] = 497502},{["tree"] = {} ,["value"] = 130442},{["tree"] = {} ,["value"] = 708480}} ,["value"] = 384000},{["tree"] = {{["tree"] = {} ,["value"] = 293718},{["tree"] = {} ,["value"] = 858084},{["tree"] = {} ,["value"] = 739031},{["tree"] = {} ,["value"] = 848845}} ,["value"] = 741671}} ,["value"] = 228930},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 256448},{["tree"] = {} ,["value"] = 602472},{["tree"] = {} ,["value"] = 366105},{["tree"] = {} ,["value"] = 843245}} ,["value"] = 840105},{["tree"] = {{["tree"] = {} ,["value"] = 815902},{["tree"] = {} ,["value"] = 342105},{["tree"] = {} ,["value"] = 693973},{["tree"] = {} ,["value"] = 250241}} ,["value"] = 719367},{["tree"] = {{["tree"] = {} ,["value"] = 974744},{["tree"] = {} ,["value"] = 551894},{["tree"] = {} ,["value"] = 603025},{["tree"] = {} ,["value"] = 226175}} ,["value"] = 242440},{["tree"] = {{["tree"] = {} ,["value"] = 806469},{["tree"] = {} ,["value"] = 320555},{["tree"] = {} ,["value"] = 450321},{["tree"] = {} ,["value"] = 555096}} ,["value"] = 633097}} ,["value"] = 506116},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 739882},{["tree"] = {} ,["value"] = 304352},{["tree"] = {} ,["value"] = 378850},{["tree"] = {} ,["value"] = 642237}} ,["value"] = 266065},{["tree"] = {{["tree"] = {} ,["value"] = 609743},{["tree"] = {} ,["value"] = 760129},{["tree"] = {} ,["value"] = 640186},{["tree"] = {} ,["value"] = 61382}} ,["value"] = 965846},{["tree"] = {{["tree"] = {} ,["value"] = 435761},{["tree"] = {} ,["value"] = 119455},{["tree"] = {} ,["value"] = 21197},{["tree"] = {} ,["value"] = 190071}} ,["value"] = 569074},{["tree"] = {{["tree"] = {} ,["value"] = 496123},{["tree"] = {} ,["value"] = 763471},{["tree"] = {} ,["value"] = 135538},{["tree"] = {} ,["value"] = 875987}} ,["value"] = 720441}} ,["value"] = 498277},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 642570},{["tree"] = {} ,["value"] = 856089},{["tree"] = {} ,["value"] = 344217},{["tree"] = {} ,["value"] = 686475}} ,["value"] = 980735},{["tree"] = {{["tree"] = {} ,["value"] = 522057},{["tree"] = {} ,["value"] = 615564},{["tree"] = {} ,["value"] = 869926},{["tree"] = {} ,["value"] = 621736}} ,["value"] = 70836},{["tree"] = {{["tree"] = {} ,["value"] = 629987},{["tree"] = {} ,["value"] = 744763},{["tree"] = {} ,["value"] = 446796},{["tree"] = {} ,["value"] = 328834}} ,["value"] = 19632},{["tree"] = {{["tree"] = {} ,["value"] = 573945},{["tree"] = {} ,["value"] = 731682},{["tree"] = {} ,["value"] = 254211},{["tree"] = {} ,["value"] = 983803}} ,["value"] = 525124}} ,["value"] = 92842}} ,["value"] = 200278},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 597410},{["tree"] = {} ,["value"] = 768761},{["tree"] = {} ,["value"] = 581984},{["tree"] = {} ,["value"] = 392233}} ,["value"] = 5325},{["tree"] = {{["tree"] = {} ,["value"] = 657202},{["tree"] = {} ,["value"] = 482718},{["tree"] = {} ,["value"] = 519833},{["tree"] = {} ,["value"] = 929495}} ,["value"] = 456729},{["tree"] = {{["tree"] = {} ,["value"] = 610401},{["tree"] = {} ,["value"] = 706217},{["tree"] = {} ,["value"] = 827059},{["tree"] = {} ,["value"] = 78732}} ,["value"] = 774025},{["tree"] = {{["tree"] = {} ,["value"] = 942474},{["tree"] = {} ,["value"] = 387392},{["tree"] = {} ,["value"] = 357784},{["tree"] = {} ,["value"] = 208496}} ,["value"] = 420041}} ,["value"] = 486386},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 871211},{["tree"] = {} ,["value"] = 139220},{["tree"] = {} ,["value"] = 660764},{["tree"] = {} ,["value"] = 305265}} ,["value"] = 276885},{["tree"] = {{["tree"] = {} ,["value"] = 541186},{["tree"] = {} ,["value"] = 33343},{["tree"] = {} ,["value"] = 888812},{["tree"] = {} ,["value"] = 607530}} ,["value"] = 91924},{["tree"] = {{["tree"] = {} ,["value"] = 892681},{["tree"] = {} ,["value"] = 407963},{["tree"] = {} ,["value"] = 587824},{["tree"] = {} ,["value"] = 524973}} ,["value"] = 794945},{["tree"] = {{["tree"] = {} ,["value"] = 58573},{["tree"] = {} ,["value"] = 802041},{["tree"] = {} ,["value"] = 986536},{["tree"] = {} ,["value"] = 906905}} ,["value"] = 976946}} ,["value"] = 434269},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 372210},{["tree"] = {} ,["value"] = 495550},{["tree"] = {} ,["value"] = 783643},{["tree"] = {} ,["value"] = 715565}} ,["value"] = 76236},{["tree"] = {{["tree"] = {} ,["value"] = 668590},{["tree"] = {} ,["value"] = 295225},{["tree"] = {} ,["value"] = 613280},{["tree"] = {} ,["value"] = 319350}} ,["value"] = 893164},{["tree"] = {{["tree"] = {} ,["value"] = 688462},{["tree"] = {} ,["value"] = 349961},{["tree"] = {} ,["value"] = 212270},{["tree"] = {} ,["value"] = 333468}} ,["value"] = 239259},{["tree"] = {{["tree"] = {} ,["value"] = 68305},{["tree"] = {} ,["value"] = 825499},{["tree"] = {} ,["value"] = 290831},{["tree"] = {} ,["value"] = 377836}} ,["value"] = 64707}} ,["value"] = 248423},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 441097},{["tree"] = {} ,["value"] = 50031},{["tree"] = {} ,["value"] = 574281},{["tree"] = {} ,["value"] = 506246}} ,["value"] = 863345},{["tree"] = {{["tree"] = {} ,["value"] = 585575},{["tree"] = {} ,["value"] = 227424},{["tree"] = {} ,["value"] = 832819},{["tree"] = {} ,["value"] = 709108}} ,["value"] = 92990},{["tree"] = {{["tree"] = {} ,["value"] = 753021},{["tree"] = {} ,["value"] = 523973},{["tree"] = {} ,["value"] = 695790},{["tree"] = {} ,["value"] = 126875}} ,["value"] = 155310},{["tree"] = {{["tree"] = {} ,["value"] = 665438},{["tree"] = {} ,["value"] = 874299},{["tree"] = {} ,["value"] = 337436},{["tree"] = {} ,["value"] = 8613}} ,["value"] = 675529}} ,["value"] = 181939}} ,["value"] = 716569}} ,["value"] = 300812},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 971900},{["tree"] = {} ,["value"] = 999939},{["tree"] = {} ,["value"] = 294371},{["tree"] = {} ,["value"] = 653288}} ,["value"] = 325815},{["tree"] = {{["tree"] = {} ,["value"] = 462519},{["tree"] = {} ,["value"] = 880447},{["tree"] = {} ,["value"] = 270348},{["tree"] = {} ,["value"] = 105742}} ,["value"] = 754084},{["tree"] = {{["tree"] = {} ,["value"] = 725883},{["tree"] = {} ,["value"] = 89329},{["tree"] = {} ,["value"] = 411458},{["tree"] = {} ,["value"] = 713542}} ,["value"] = 785953},{["tree"] = {{["tree"] = {} ,["value"] = 952781},{["tree"] = {} ,["value"] = 146767},{["tree"] = {} ,["value"] = 266726},{["tree"] = {} ,["value"] = 848551}} ,["value"] = 247577}} ,["value"] = 852107},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 648968},{["tree"] = {} ,["value"] = 593452},{["tree"] = {} ,["value"] = 755359},{["tree"] = {} ,["value"] = 452712}} ,["value"] = 448730},{["tree"] = {{["tree"] = {} ,["value"] = 794071},{["tree"] = {} ,["value"] = 838290},{["tree"] = {} ,["value"] = 938025},{["tree"] = {} ,["value"] = 826696}} ,["value"] = 946561},{["tree"] = {{["tree"] = {} ,["value"] = 636397},{["tree"] = {} ,["value"] = 366731},{["tree"] = {} ,["value"] = 200524},{["tree"] = {} ,["value"] = 295535}} ,["value"] = 931221},{["tree"] = {{["tree"] = {} ,["value"] = 56228},{["tree"] = {} ,["value"] = 123817},{["tree"] = {} ,["value"] = 579951},{["tree"] = {} ,["value"] = 268516}} ,["value"] = 233039}} ,["value"] = 689052},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 790925},{["tree"] = {} ,["value"] = 99505},{["tree"] = {} ,["value"] = 725161},{["tree"] = {} ,["value"] = 30576}} ,["value"] = 964233},{["tree"] = {{["tree"] = {} ,["value"] = 187438},{["tree"] = {} ,["value"] = 989044},{["tree"] = {} ,["value"] = 208353},{["tree"] = {} ,["value"] = 213432}} ,["value"] = 290008},{["tree"] = {{["tree"] = {} ,["value"] = 146227},{["tree"] = {} ,["value"] = 38083},{["tree"] = {} ,["value"] = 589855},{["tree"] = {} ,["value"] = 511735}} ,["value"] = 975951},{["tree"] = {{["tree"] = {} ,["value"] = 310417},{["tree"] = {} ,["value"] = 156484},{["tree"] = {} ,["value"] = 365552},{["tree"] = {} ,["value"] = 377131}} ,["value"] = 908573}} ,["value"] = 691274},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 33187},{["tree"] = {} ,["value"] = 136935},{["tree"] = {} ,["value"] = 811441},{["tree"] = {} ,["value"] = 679022}} ,["value"] = 665380},{["tree"] = {{["tree"] = {} ,["value"] = 382353},{["tree"] = {} ,["value"] = 233778},{["tree"] = {} ,["value"] = 643903},{["tree"] = {} ,["value"] = 590237}} ,["value"] = 408528},{["tree"] = {{["tree"] = {} ,["value"] = 235957},{["tree"] = {} ,["value"] = 604741},{["tree"] = {} ,["value"] = 200617},{["tree"] = {} ,["value"] = 954865}} ,["value"] = 236671},{["tree"] = {{["tree"] = {} ,["value"] = 271481},{["tree"] = {} ,["value"] = 855315},{["tree"] = {} ,["value"] = 786338},{["tree"] = {} ,["value"] = 161555}} ,["value"] = 551043}} ,["value"] = 482972}} ,["value"] = 399775},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 16430},{["tree"] = {} ,["value"] = 873690},{["tree"] = {} ,["value"] = 592776},{["tree"] = {} ,["value"] = 46680}} ,["value"] = 809939},{["tree"] = {{["tree"] = {} ,["value"] = 103},{["tree"] = {} ,["value"] = 567990},{["tree"] = {} ,["value"] = 948954},{["tree"] = {} ,["value"] = 70770}} ,["value"] = 340191},{["tree"] = {{["tree"] = {} ,["value"] = 894058},{["tree"] = {} ,["value"] = 272652},{["tree"] = {} ,["value"] = 741794},{["tree"] = {} ,["value"] = 317993}} ,["value"] = 685428},{["tree"] = {{["tree"] = {} ,["value"] = 709823},{["tree"] = {} ,["value"] = 5532},{["tree"] = {} ,["value"] = 25293},{["tree"] = {} ,["value"] = 59322}} ,["value"] = 652912}} ,["value"] = 93236},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 347751},{["tree"] = {} ,["value"] = 439029},{["tree"] = {} ,["value"] = 882546},{["tree"] = {} ,["value"] = 175600}} ,["value"] = 897853},{["tree"] = {{["tree"] = {} ,["value"] = 981568},{["tree"] = {} ,["value"] = 66678},{["tree"] = {} ,["value"] = 974999},{["tree"] = {} ,["value"] = 871579}} ,["value"] = 908728},{["tree"] = {{["tree"] = {} ,["value"] = 254689},{["tree"] = {} ,["value"] = 118094},{["tree"] = {} ,["value"] = 619703},{["tree"] = {} ,["value"] = 414175}} ,["value"] = 826960},{["tree"] = {{["tree"] = {} ,["value"] = 835958},{["tree"] = {} ,["value"] = 137341},{["tree"] = {} ,["value"] = 975336},{["tree"] = {} ,["value"] = 703220}} ,["value"] = 409382}} ,["value"] = 157204},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 890227},{["tree"] = {} ,["value"] = 655270},{["tree"] = {} ,["value"] = 73593},{["tree"] = {} ,["value"] = 820388}} ,["value"] = 179400},{["tree"] = {{["tree"] = {} ,["value"] = 999102},{["tree"] = {} ,["value"] = 831988},{["tree"] = {} ,["value"] = 340375},{["tree"] = {} ,["value"] = 998413}} ,["value"] = 335333},{["tree"] = {{["tree"] = {} ,["value"] = 334439},{["tree"] = {} ,["value"] = 23630},{["tree"] = {} ,["value"] = 285231},{["tree"] = {} ,["value"] = 455097}} ,["value"] = 855600},{["tree"] = {{["tree"] = {} ,["value"] = 685293},{["tree"] = {} ,["value"] = 168262},{["tree"] = {} ,["value"] = 100279},{["tree"] = {} ,["value"] = 143802}} ,["value"] = 244296}} ,["value"] = 224196},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 796807},{["tree"] = {} ,["value"] = 269273},{["tree"] = {} ,["value"] = 346749},{["tree"] = {} ,["value"] = 842109}} ,["value"] = 648449},{["tree"] = {{["tree"] = {} ,["value"] = 621201},{["tree"] = {} ,["value"] = 48256},{["tree"] = {} ,["value"] = 34994},{["tree"] = {} ,["value"] = 347240}} ,["value"] = 207857},{["tree"] = {{["tree"] = {} ,["value"] = 17372},{["tree"] = {} ,["value"] = 998097},{["tree"] = {} ,["value"] = 592657},{["tree"] = {} ,["value"] = 231782}} ,["value"] = 896283},{["tree"] = {{["tree"] = {} ,["value"] = 423200},{["tree"] = {} ,["value"] = 511662},{["tree"] = {} ,["value"] = 901693},{["tree"] = {} ,["value"] = 858269}} ,["value"] = 811600}} ,["value"] = 311369}} ,["value"] = 780293},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 938943},{["tree"] = {} ,["value"] = 100949},{["tree"] = {} ,["value"] = 591805},{["tree"] = {} ,["value"] = 158116}} ,["value"] = 922740},{["tree"] = {{["tree"] = {} ,["value"] = 366872},{["tree"] = {} ,["value"] = 657705},{["tree"] = {} ,["value"] = 710794},{["tree"] = {} ,["value"] = 924513}} ,["value"] = 486505},{["tree"] = {{["tree"] = {} ,["value"] = 297716},{["tree"] = {} ,["value"] = 380205},{["tree"] = {} ,["value"] = 968647},{["tree"] = {} ,["value"] = 824179}} ,["value"] = 792413},{["tree"] = {{["tree"] = {} ,["value"] = 736727},{["tree"] = {} ,["value"] = 661724},{["tree"] = {} ,["value"] = 226208},{["tree"] = {} ,["value"] = 594225}} ,["value"] = 624179}} ,["value"] = 496829},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 321807},{["tree"] = {} ,["value"] = 378161},{["tree"] = {} ,["value"] = 786579},{["tree"] = {} ,["value"] = 611889}} ,["value"] = 506836},{["tree"] = {{["tree"] = {} ,["value"] = 933124},{["tree"] = {} ,["value"] = 647484},{["tree"] = {} ,["value"] = 447108},{["tree"] = {} ,["value"] = 547324}} ,["value"] = 145930},{["tree"] = {{["tree"] = {} ,["value"] = 53787},{["tree"] = {} ,["value"] = 654486},{["tree"] = {} ,["value"] = 824541},{["tree"] = {} ,["value"] = 403940}} ,["value"] = 798718},{["tree"] = {{["tree"] = {} ,["value"] = 749061},{["tree"] = {} ,["value"] = 589674},{["tree"] = {} ,["value"] = 431792},{["tree"] = {} ,["value"] = 921206}} ,["value"] = 27152}} ,["value"] = 815682},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 527000},{["tree"] = {} ,["value"] = 418594},{["tree"] = {} ,["value"] = 347352},{["tree"] = {} ,["value"] = 79084}} ,["value"] = 338175},{["tree"] = {{["tree"] = {} ,["value"] = 780898},{["tree"] = {} ,["value"] = 274102},{["tree"] = {} ,["value"] = 217071},{["tree"] = {} ,["value"] = 510807}} ,["value"] = 524124},{["tree"] = {{["tree"] = {} ,["value"] = 571644},{["tree"] = {} ,["value"] = 332605},{["tree"] = {} ,["value"] = 753922},{["tree"] = {} ,["value"] = 943759}} ,["value"] = 971256},{["tree"] = {{["tree"] = {} ,["value"] = 229928},{["tree"] = {} ,["value"] = 537367},{["tree"] = {} ,["value"] = 217449},{["tree"] = {} ,["value"] = 349500}} ,["value"] = 787057}} ,["value"] = 208316},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 494509},{["tree"] = {} ,["value"] = 235145},{["tree"] = {} ,["value"] = 847747},{["tree"] = {} ,["value"] = 764199}} ,["value"] = 179280},{["tree"] = {{["tree"] = {} ,["value"] = 995730},{["tree"] = {} ,["value"] = 213527},{["tree"] = {} ,["value"] = 924412},{["tree"] = {} ,["value"] = 908125}} ,["value"] = 37246},{["tree"] = {{["tree"] = {} ,["value"] = 975828},{["tree"] = {} ,["value"] = 279770},{["tree"] = {} ,["value"] = 93480},{["tree"] = {} ,["value"] = 450274}} ,["value"] = 600514},{["tree"] = {{["tree"] = {} ,["value"] = 135832},{["tree"] = {} ,["value"] = 84858},{["tree"] = {} ,["value"] = 200353},{["tree"] = {} ,["value"] = 871715}} ,["value"] = 33380}} ,["value"] = 234394}} ,["value"] = 666758},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 498556},{["tree"] = {} ,["value"] = 390100},{["tree"] = {} ,["value"] = 317770},{["tree"] = {} ,["value"] = 529108}} ,["value"] = 731969},{["tree"] = {{["tree"] = {} ,["value"] = 296925},{["tree"] = {} ,["value"] = 908739},{["tree"] = {} ,["value"] = 497907},{["tree"] = {} ,["value"] = 196967}} ,["value"] = 4557},{["tree"] = {{["tree"] = {} ,["value"] = 706339},{["tree"] = {} ,["value"] = 795795},{["tree"] = {} ,["value"] = 38597},{["tree"] = {} ,["value"] = 316771}} ,["value"] = 198047},{["tree"] = {{["tree"] = {} ,["value"] = 420108},{["tree"] = {} ,["value"] = 708678},{["tree"] = {} ,["value"] = 691315},{["tree"] = {} ,["value"] = 256601}} ,["value"] = 80857}} ,["value"] = 99573},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 956050},{["tree"] = {} ,["value"] = 563772},{["tree"] = {} ,["value"] = 178923},{["tree"] = {} ,["value"] = 62862}} ,["value"] = 529832},{["tree"] = {{["tree"] = {} ,["value"] = 178129},{["tree"] = {} ,["value"] = 634945},{["tree"] = {} ,["value"] = 102412},{["tree"] = {} ,["value"] = 948234}} ,["value"] = 299348},{["tree"] = {{["tree"] = {} ,["value"] = 292107},{["tree"] = {} ,["value"] = 145291},{["tree"] = {} ,["value"] = 536804},{["tree"] = {} ,["value"] = 92436}} ,["value"] = 893300},{["tree"] = {{["tree"] = {} ,["value"] = 550821},{["tree"] = {} ,["value"] = 862870},{["tree"] = {} ,["value"] = 916095},{["tree"] = {} ,["value"] = 18525}} ,["value"] = 515483}} ,["value"] = 34168},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 546776},{["tree"] = {} ,["value"] = 268219},{["tree"] = {} ,["value"] = 498685},{["tree"] = {} ,["value"] = 540657}} ,["value"] = 150524},{["tree"] = {{["tree"] = {} ,["value"] = 580984},{["tree"] = {} ,["value"] = 262244},{["tree"] = {} ,["value"] = 755077},{["tree"] = {} ,["value"] = 67365}} ,["value"] = 355474},{["tree"] = {{["tree"] = {} ,["value"] = 624979},{["tree"] = {} ,["value"] = 988893},{["tree"] = {} ,["value"] = 576059},{["tree"] = {} ,["value"] = 882782}} ,["value"] = 552097},{["tree"] = {{["tree"] = {} ,["value"] = 375890},{["tree"] = {} ,["value"] = 268285},{["tree"] = {} ,["value"] = 918915},{["tree"] = {} ,["value"] = 546505}} ,["value"] = 383294}} ,["value"] = 659609},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 617941},{["tree"] = {} ,["value"] = 857865},{["tree"] = {} ,["value"] = 229671},{["tree"] = {} ,["value"] = 386398}} ,["value"] = 338810},{["tree"] = {{["tree"] = {} ,["value"] = 346736},{["tree"] = {} ,["value"] = 305467},{["tree"] = {} ,["value"] = 13030},{["tree"] = {} ,["value"] = 411974}} ,["value"] = 126847},{["tree"] = {{["tree"] = {} ,["value"] = 843264},{["tree"] = {} ,["value"] = 974768},{["tree"] = {} ,["value"] = 855369},{["tree"] = {} ,["value"] = 871576}} ,["value"] = 410803},{["tree"] = {{["tree"] = {} ,["value"] = 365993},{["tree"] = {} ,["value"] = 939688},{["tree"] = {} ,["value"] = 73580},{["tree"] = {} ,["value"] = 382514}} ,["value"] = 621214}} ,["value"] = 402815}} ,["value"] = 206057}} ,["value"] = 961403},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 468196},{["tree"] = {} ,["value"] = 388059},{["tree"] = {} ,["value"] = 965010},{["tree"] = {} ,["value"] = 834747}} ,["value"] = 779397},{["tree"] = {{["tree"] = {} ,["value"] = 273956},{["tree"] = {} ,["value"] = 910677},{["tree"] = {} ,["value"] = 629976},{["tree"] = {} ,["value"] = 293654}} ,["value"] = 483911},{["tree"] = {{["tree"] = {} ,["value"] = 305848},{["tree"] = {} ,["value"] = 317575},{["tree"] = {} ,["value"] = 656434},{["tree"] = {} ,["value"] = 829625}} ,["value"] = 647969},{["tree"] = {{["tree"] = {} ,["value"] = 951003},{["tree"] = {} ,["value"] = 688085},{["tree"] = {} ,["value"] = 558905},{["tree"] = {} ,["value"] = 792280}} ,["value"] = 627791}} ,["value"] = 901377},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 354193},{["tree"] = {} ,["value"] = 196665},{["tree"] = {} ,["value"] = 884620},{["tree"] = {} ,["value"] = 546269}} ,["value"] = 57655},{["tree"] = {{["tree"] = {} ,["value"] = 969280},{["tree"] = {} ,["value"] = 210778},{["tree"] = {} ,["value"] = 520518},{["tree"] = {} ,["value"] = 313277}} ,["value"] = 526990},{["tree"] = {{["tree"] = {} ,["value"] = 342396},{["tree"] = {} ,["value"] = 237483},{["tree"] = {} ,["value"] = 702487},{["tree"] = {} ,["value"] = 299018}} ,["value"] = 467248},{["tree"] = {{["tree"] = {} ,["value"] = 603708},{["tree"] = {} ,["value"] = 340634},{["tree"] = {} ,["value"] = 487794},{["tree"] = {} ,["value"] = 682787}} ,["value"] = 82269}} ,["value"] = 923417},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 173923},{["tree"] = {} ,["value"] = 46644},{["tree"] = {} ,["value"] = 353186},{["tree"] = {} ,["value"] = 240586}} ,["value"] = 309451},{["tree"] = {{["tree"] = {} ,["value"] = 808564},{["tree"] = {} ,["value"] = 11968},{["tree"] = {} ,["value"] = 683843},{["tree"] = {} ,["value"] = 178332}} ,["value"] = 75979},{["tree"] = {{["tree"] = {} ,["value"] = 394357},{["tree"] = {} ,["value"] = 734824},{["tree"] = {} ,["value"] = 531671},{["tree"] = {} ,["value"] = 640}} ,["value"] = 869024},{["tree"] = {{["tree"] = {} ,["value"] = 188005},{["tree"] = {} ,["value"] = 588794},{["tree"] = {} ,["value"] = 914738},{["tree"] = {} ,["value"] = 625619}} ,["value"] = 506254}} ,["value"] = 212523},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 291458},{["tree"] = {} ,["value"] = 467573},{["tree"] = {} ,["value"] = 409331},{["tree"] = {} ,["value"] = 460846}} ,["value"] = 848033},{["tree"] = {{["tree"] = {} ,["value"] = 697977},{["tree"] = {} ,["value"] = 959820},{["tree"] = {} ,["value"] = 396701},{["tree"] = {} ,["value"] = 597344}} ,["value"] = 613650},{["tree"] = {{["tree"] = {} ,["value"] = 641210},{["tree"] = {} ,["value"] = 746860},{["tree"] = {} ,["value"] = 877850},{["tree"] = {} ,["value"] = 508177}} ,["value"] = 158839},{["tree"] = {{["tree"] = {} ,["value"] = 395292},{["tree"] = {} ,["value"] = 468388},{["tree"] = {} ,["value"] = 676729},{["tree"] = {} ,["value"] = 32264}} ,["value"] = 416827}} ,["value"] = 796001}} ,["value"] = 667841},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 933669},{["tree"] = {} ,["value"] = 799681},{["tree"] = {} ,["value"] = 113768},{["tree"] = {} ,["value"] = 159986}} ,["value"] = 187431},{["tree"] = {{["tree"] = {} ,["value"] = 717121},{["tree"] = {} ,["value"] = 655155},{["tree"] = {} ,["value"] = 225621},{["tree"] = {} ,["value"] = 556874}} ,["value"] = 854469},{["tree"] = {{["tree"] = {} ,["value"] = 486052},{["tree"] = {} ,["value"] = 201844},{["tree"] = {} ,["value"] = 842893},{["tree"] = {} ,["value"] = 281326}} ,["value"] = 630129},{["tree"] = {{["tree"] = {} ,["value"] = 700857},{["tree"] = {} ,["value"] = 470209},{["tree"] = {} ,["value"] = 755673},{["tree"] = {} ,["value"] = 404568}} ,["value"] = 827138}} ,["value"] = 304095},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 434692},{["tree"] = {} ,["value"] = 243390},{["tree"] = {} ,["value"] = 295237},{["tree"] = {} ,["value"] = 235879}} ,["value"] = 592307},{["tree"] = {{["tree"] = {} ,["value"] = 902085},{["tree"] = {} ,["value"] = 727507},{["tree"] = {} ,["value"] = 873713},{["tree"] = {} ,["value"] = 615760}} ,["value"] = 63397},{["tree"] = {{["tree"] = {} ,["value"] = 40370},{["tree"] = {} ,["value"] = 712758},{["tree"] = {} ,["value"] = 521392},{["tree"] = {} ,["value"] = 189614}} ,["value"] = 358815},{["tree"] = {{["tree"] = {} ,["value"] = 602228},{["tree"] = {} ,["value"] = 42647},{["tree"] = {} ,["value"] = 7075},{["tree"] = {} ,["value"] = 124026}} ,["value"] = 933158}} ,["value"] = 671465},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 443059},{["tree"] = {} ,["value"] = 581630},{["tree"] = {} ,["value"] = 38412},{["tree"] = {} ,["value"] = 76132}} ,["value"] = 896525},{["tree"] = {{["tree"] = {} ,["value"] = 293336},{["tree"] = {} ,["value"] = 50173},{["tree"] = {} ,["value"] = 991076},{["tree"] = {} ,["value"] = 373692}} ,["value"] = 649862},{["tree"] = {{["tree"] = {} ,["value"] = 507658},{["tree"] = {} ,["value"] = 466365},{["tree"] = {} ,["value"] = 705528},{["tree"] = {} ,["value"] = 697774}} ,["value"] = 780187},{["tree"] = {{["tree"] = {} ,["value"] = 468271},{["tree"] = {} ,["value"] = 355488},{["tree"] = {} ,["value"] = 517570},{["tree"] = {} ,["value"] = 872037}} ,["value"] = 45485}} ,["value"] = 540031},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 856090},{["tree"] = {} ,["value"] = 118769},{["tree"] = {} ,["value"] = 164699},{["tree"] = {} ,["value"] = 770757}} ,["value"] = 648949},{["tree"] = {{["tree"] = {} ,["value"] = 117789},{["tree"] = {} ,["value"] = 395973},{["tree"] = {} ,["value"] = 580577},{["tree"] = {} ,["value"] = 268229}} ,["value"] = 57478},{["tree"] = {{["tree"] = {} ,["value"] = 190746},{["tree"] = {} ,["value"] = 693722},{["tree"] = {} ,["value"] = 769972},{["tree"] = {} ,["value"] = 451011}} ,["value"] = 33326},{["tree"] = {{["tree"] = {} ,["value"] = 724189},{["tree"] = {} ,["value"] = 920725},{["tree"] = {} ,["value"] = 456767},{["tree"] = {} ,["value"] = 553194}} ,["value"] = 126528}} ,["value"] = 245113}} ,["value"] = 888964},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 49999},{["tree"] = {} ,["value"] = 603111},{["tree"] = {} ,["value"] = 490843},{["tree"] = {} ,["value"] = 156779}} ,["value"] = 687867},{["tree"] = {{["tree"] = {} ,["value"] = 449078},{["tree"] = {} ,["value"] = 485937},{["tree"] = {} ,["value"] = 688353},{["tree"] = {} ,["value"] = 490392}} ,["value"] = 878342},{["tree"] = {{["tree"] = {} ,["value"] = 911754},{["tree"] = {} ,["value"] = 578563},{["tree"] = {} ,["value"] = 135876},{["tree"] = {} ,["value"] = 6810}} ,["value"] = 921616},{["tree"] = {{["tree"] = {} ,["value"] = 483231},{["tree"] = {} ,["value"] = 915405},{["tree"] = {} ,["value"] = 895075},{["tree"] = {} ,["value"] = 861911}} ,["value"] = 532267}} ,["value"] = 400544},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 8774},{["tree"] = {} ,["value"] = 515587},{["tree"] = {} ,["value"] = 100126},{["tree"] = {} ,["value"] = 485993}} ,["value"] = 735601},{["tree"] = {{["tree"] = {} ,["value"] = 80468},{["tree"] = {} ,["value"] = 135692},{["tree"] = {} ,["value"] = 504295},{["tree"] = {} ,["value"] = 132695}} ,["value"] = 162964},{["tree"] = {{["tree"] = {} ,["value"] = 530016},{["tree"] = {} ,["value"] = 861971},{["tree"] = {} ,["value"] = 8715},{["tree"] = {} ,["value"] = 922311}} ,["value"] = 237150},{["tree"] = {{["tree"] = {} ,["value"] = 409246},{["tree"] = {} ,["value"] = 692872},{["tree"] = {} ,["value"] = 689721},{["tree"] = {} ,["value"] = 96449}} ,["value"] = 568560}} ,["value"] = 998414},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 375905},{["tree"] = {} ,["value"] = 836213},{["tree"] = {} ,["value"] = 324549},{["tree"] = {} ,["value"] = 424284}} ,["value"] = 356351},{["tree"] = {{["tree"] = {} ,["value"] = 248756},{["tree"] = {} ,["value"] = 783070},{["tree"] = {} ,["value"] = 799217},{["tree"] = {} ,["value"] = 663561}} ,["value"] = 686948},{["tree"] = {{["tree"] = {} ,["value"] = 40725},{["tree"] = {} ,["value"] = 291182},{["tree"] = {} ,["value"] = 951690},{["tree"] = {} ,["value"] = 199530}} ,["value"] = 926084},{["tree"] = {{["tree"] = {} ,["value"] = 181478},{["tree"] = {} ,["value"] = 535230},{["tree"] = {} ,["value"] = 345101},{["tree"] = {} ,["value"] = 913227}} ,["value"] = 632430}} ,["value"] = 955391},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 323360},{["tree"] = {} ,["value"] = 838747},{["tree"] = {} ,["value"] = 593397},{["tree"] = {} ,["value"] = 902089}} ,["value"] = 499225},{["tree"] = {{["tree"] = {} ,["value"] = 658926},{["tree"] = {} ,["value"] = 303343},{["tree"] = {} ,["value"] = 585042},{["tree"] = {} ,["value"] = 327033}} ,["value"] = 981242},{["tree"] = {{["tree"] = {} ,["value"] = 223448},{["tree"] = {} ,["value"] = 282094},{["tree"] = {} ,["value"] = 882451},{["tree"] = {} ,["value"] = 563156}} ,["value"] = 125320},{["tree"] = {{["tree"] = {} ,["value"] = 383269},{["tree"] = {} ,["value"] = 342784},{["tree"] = {} ,["value"] = 963529},{["tree"] = {} ,["value"] = 647942}} ,["value"] = 714990}} ,["value"] = 530472}} ,["value"] = 130408},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 194557},{["tree"] = {} ,["value"] = 649513},{["tree"] = {} ,["value"] = 59098},{["tree"] = {} ,["value"] = 586129}} ,["value"] = 490146},{["tree"] = {{["tree"] = {} ,["value"] = 848485},{["tree"] = {} ,["value"] = 381051},{["tree"] = {} ,["value"] = 633192},{["tree"] = {} ,["value"] = 256630}} ,["value"] = 610217},{["tree"] = {{["tree"] = {} ,["value"] = 737560},{["tree"] = {} ,["value"] = 327362},{["tree"] = {} ,["value"] = 437502},{["tree"] = {} ,["value"] = 541555}} ,["value"] = 444694},{["tree"] = {{["tree"] = {} ,["value"] = 196143},{["tree"] = {} ,["value"] = 767114},{["tree"] = {} ,["value"] = 197401},{["tree"] = {} ,["value"] = 335582}} ,["value"] = 762470}} ,["value"] = 773318},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 733580},{["tree"] = {} ,["value"] = 238537},{["tree"] = {} ,["value"] = 307953},{["tree"] = {} ,["value"] = 707688}} ,["value"] = 285177},{["tree"] = {{["tree"] = {} ,["value"] = 135830},{["tree"] = {} ,["value"] = 854037},{["tree"] = {} ,["value"] = 723896},{["tree"] = {} ,["value"] = 130016}} ,["value"] = 622948},{["tree"] = {{["tree"] = {} ,["value"] = 419749},{["tree"] = {} ,["value"] = 473982},{["tree"] = {} ,["value"] = 526692},{["tree"] = {} ,["value"] = 106503}} ,["value"] = 833684},{["tree"] = {{["tree"] = {} ,["value"] = 862758},{["tree"] = {} ,["value"] = 569244},{["tree"] = {} ,["value"] = 511081},{["tree"] = {} ,["value"] = 226945}} ,["value"] = 309771}} ,["value"] = 493408},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 237879},{["tree"] = {} ,["value"] = 698538},{["tree"] = {} ,["value"] = 349995},{["tree"] = {} ,["value"] = 68873}} ,["value"] = 534372},{["tree"] = {{["tree"] = {} ,["value"] = 722527},{["tree"] = {} ,["value"] = 993824},{["tree"] = {} ,["value"] = 705977},{["tree"] = {} ,["value"] = 781661}} ,["value"] = 975758},{["tree"] = {{["tree"] = {} ,["value"] = 961646},{["tree"] = {} ,["value"] = 647350},{["tree"] = {} ,["value"] = 378053},{["tree"] = {} ,["value"] = 496973}} ,["value"] = 657734},{["tree"] = {{["tree"] = {} ,["value"] = 415762},{["tree"] = {} ,["value"] = 686224},{["tree"] = {} ,["value"] = 585389},{["tree"] = {} ,["value"] = 651637}} ,["value"] = 466991}} ,["value"] = 638483},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 620364},{["tree"] = {} ,["value"] = 340715},{["tree"] = {} ,["value"] = 999491},{["tree"] = {} ,["value"] = 45452}} ,["value"] = 330167},{["tree"] = {{["tree"] = {} ,["value"] = 962462},{["tree"] = {} ,["value"] = 977305},{["tree"] = {} ,["value"] = 130161},{["tree"] = {} ,["value"] = 312131}} ,["value"] = 742538},{["tree"] = {{["tree"] = {} ,["value"] = 754348},{["tree"] = {} ,["value"] = 420561},{["tree"] = {} ,["value"] = 835425},{["tree"] = {} ,["value"] = 119664}} ,["value"] = 34453},{["tree"] = {{["tree"] = {} ,["value"] = 914045},{["tree"] = {} ,["value"] = 318398},{["tree"] = {} ,["value"] = 569547},{["tree"] = {} ,["value"] = 786156}} ,["value"] = 225226}} ,["value"] = 446451}} ,["value"] = 548765}} ,["value"] = 382990}} ,["value"] = 351149},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 482408},{["tree"] = {} ,["value"] = 205667},{["tree"] = {} ,["value"] = 34706},{["tree"] = {} ,["value"] = 386779}} ,["value"] = 302197},{["tree"] = {{["tree"] = {} ,["value"] = 82601},{["tree"] = {} ,["value"] = 839438},{["tree"] = {} ,["value"] = 129327},{["tree"] = {} ,["value"] = 168634}} ,["value"] = 491116},{["tree"] = {{["tree"] = {} ,["value"] = 93039},{["tree"] = {} ,["value"] = 236448},{["tree"] = {} ,["value"] = 4002},{["tree"] = {} ,["value"] = 295934}} ,["value"] = 805941},{["tree"] = {{["tree"] = {} ,["value"] = 968792},{["tree"] = {} ,["value"] = 55630},{["tree"] = {} ,["value"] = 120374},{["tree"] = {} ,["value"] = 495582}} ,["value"] = 667194}} ,["value"] = 310014},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 22737},{["tree"] = {} ,["value"] = 566665},{["tree"] = {} ,["value"] = 327606},{["tree"] = {} ,["value"] = 643422}} ,["value"] = 7163},{["tree"] = {{["tree"] = {} ,["value"] = 354900},{["tree"] = {} ,["value"] = 976736},{["tree"] = {} ,["value"] = 80323},{["tree"] = {} ,["value"] = 192615}} ,["value"] = 846860},{["tree"] = {{["tree"] = {} ,["value"] = 559807},{["tree"] = {} ,["value"] = 21323},{["tree"] = {} ,["value"] = 107457},{["tree"] = {} ,["value"] = 840316}} ,["value"] = 559501},{["tree"] = {{["tree"] = {} ,["value"] = 377710},{["tree"] = {} ,["value"] = 799710},{["tree"] = {} ,["value"] = 40094},{["tree"] = {} ,["value"] = 889496}} ,["value"] = 110346}} ,["value"] = 261854},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 215135},{["tree"] = {} ,["value"] = 313780},{["tree"] = {} ,["value"] = 841567},{["tree"] = {} ,["value"] = 37653}} ,["value"] = 10817},{["tree"] = {{["tree"] = {} ,["value"] = 427060},{["tree"] = {} ,["value"] = 668101},{["tree"] = {} ,["value"] = 278},{["tree"] = {} ,["value"] = 829535}} ,["value"] = 418898},{["tree"] = {{["tree"] = {} ,["value"] = 925403},{["tree"] = {} ,["value"] = 241601},{["tree"] = {} ,["value"] = 261078},{["tree"] = {} ,["value"] = 116041}} ,["value"] = 556362},{["tree"] = {{["tree"] = {} ,["value"] = 826463},{["tree"] = {} ,["value"] = 699642},{["tree"] = {} ,["value"] = 547615},{["tree"] = {} ,["value"] = 109100}} ,["value"] = 576415}} ,["value"] = 903592},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 441759},{["tree"] = {} ,["value"] = 223908},{["tree"] = {} ,["value"] = 459611},{["tree"] = {} ,["value"] = 259096}} ,["value"] = 419078},{["tree"] = {{["tree"] = {} ,["value"] = 702656},{["tree"] = {} ,["value"] = 107761},{["tree"] = {} ,["value"] = 459904},{["tree"] = {} ,["value"] = 237840}} ,["value"] = 936582},{["tree"] = {{["tree"] = {} ,["value"] = 485003},{["tree"] = {} ,["value"] = 823885},{["tree"] = {} ,["value"] = 876135},{["tree"] = {} ,["value"] = 898181}} ,["value"] = 867464},{["tree"] = {{["tree"] = {} ,["value"] = 563683},{["tree"] = {} ,["value"] = 613232},{["tree"] = {} ,["value"] = 61201},{["tree"] = {} ,["value"] = 680731}} ,["value"] = 797655}} ,["value"] = 756189}} ,["value"] = 75413},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 102618},{["tree"] = {} ,["value"] = 193610},{["tree"] = {} ,["value"] = 770579},{["tree"] = {} ,["value"] = 126109}} ,["value"] = 68024},{["tree"] = {{["tree"] = {} ,["value"] = 1391},{["tree"] = {} ,["value"] = 21032},{["tree"] = {} ,["value"] = 615368},{["tree"] = {} ,["value"] = 391690}} ,["value"] = 690939},{["tree"] = {{["tree"] = {} ,["value"] = 600890},{["tree"] = {} ,["value"] = 73341},{["tree"] = {} ,["value"] = 926688},{["tree"] = {} ,["value"] = 896821}} ,["value"] = 940912},{["tree"] = {{["tree"] = {} ,["value"] = 527736},{["tree"] = {} ,["value"] = 857457},{["tree"] = {} ,["value"] = 474716},{["tree"] = {} ,["value"] = 92043}} ,["value"] = 429642}} ,["value"] = 692630},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 412823},{["tree"] = {} ,["value"] = 157457},{["tree"] = {} ,["value"] = 453075},{["tree"] = {} ,["value"] = 402991}} ,["value"] = 449130},{["tree"] = {{["tree"] = {} ,["value"] = 176697},{["tree"] = {} ,["value"] = 478489},{["tree"] = {} ,["value"] = 938587},{["tree"] = {} ,["value"] = 550611}} ,["value"] = 4619},{["tree"] = {{["tree"] = {} ,["value"] = 714173},{["tree"] = {} ,["value"] = 826571},{["tree"] = {} ,["value"] = 874365},{["tree"] = {} ,["value"] = 281270}} ,["value"] = 258959},{["tree"] = {{["tree"] = {} ,["value"] = 498376},{["tree"] = {} ,["value"] = 929203},{["tree"] = {} ,["value"] = 63942},{["tree"] = {} ,["value"] = 584942}} ,["value"] = 563661}} ,["value"] = 764962},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 256069},{["tree"] = {} ,["value"] = 135636},{["tree"] = {} ,["value"] = 522654},{["tree"] = {} ,["value"] = 58622}} ,["value"] = 573450},{["tree"] = {{["tree"] = {} ,["value"] = 175183},{["tree"] = {} ,["value"] = 230305},{["tree"] = {} ,["value"] = 385740},{["tree"] = {} ,["value"] = 675323}} ,["value"] = 913368},{["tree"] = {{["tree"] = {} ,["value"] = 661046},{["tree"] = {} ,["value"] = 844960},{["tree"] = {} ,["value"] = 787362},{["tree"] = {} ,["value"] = 522876}} ,["value"] = 279372},{["tree"] = {{["tree"] = {} ,["value"] = 819167},{["tree"] = {} ,["value"] = 148805},{["tree"] = {} ,["value"] = 282163},{["tree"] = {} ,["value"] = 261287}} ,["value"] = 410253}} ,["value"] = 961991},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 222444},{["tree"] = {} ,["value"] = 255618},{["tree"] = {} ,["value"] = 728271},{["tree"] = {} ,["value"] = 659999}} ,["value"] = 187632},{["tree"] = {{["tree"] = {} ,["value"] = 645164},{["tree"] = {} ,["value"] = 945623},{["tree"] = {} ,["value"] = 908529},{["tree"] = {} ,["value"] = 409762}} ,["value"] = 57665},{["tree"] = {{["tree"] = {} ,["value"] = 528454},{["tree"] = {} ,["value"] = 145380},{["tree"] = {} ,["value"] = 115651},{["tree"] = {} ,["value"] = 588174}} ,["value"] = 96943},{["tree"] = {{["tree"] = {} ,["value"] = 167894},{["tree"] = {} ,["value"] = 420693},{["tree"] = {} ,["value"] = 880375},{["tree"] = {} ,["value"] = 957606}} ,["value"] = 396189}} ,["value"] = 41692}} ,["value"] = 469738},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 73182},{["tree"] = {} ,["value"] = 655220},{["tree"] = {} ,["value"] = 607205},{["tree"] = {} ,["value"] = 117239}} ,["value"] = 843146},{["tree"] = {{["tree"] = {} ,["value"] = 804366},{["tree"] = {} ,["value"] = 941014},{["tree"] = {} ,["value"] = 248794},{["tree"] = {} ,["value"] = 57690}} ,["value"] = 399970},{["tree"] = {{["tree"] = {} ,["value"] = 387098},{["tree"] = {} ,["value"] = 334369},{["tree"] = {} ,["value"] = 808527},{["tree"] = {} ,["value"] = 935896}} ,["value"] = 673873},{["tree"] = {{["tree"] = {} ,["value"] = 189703},{["tree"] = {} ,["value"] = 129628},{["tree"] = {} ,["value"] = 244140},{["tree"] = {} ,["value"] = 365439}} ,["value"] = 588878}} ,["value"] = 741442},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 812780},{["tree"] = {} ,["value"] = 667144},{["tree"] = {} ,["value"] = 573774},{["tree"] = {} ,["value"] = 595194}} ,["value"] = 337083},{["tree"] = {{["tree"] = {} ,["value"] = 751703},{["tree"] = {} ,["value"] = 678889},{["tree"] = {} ,["value"] = 946530},{["tree"] = {} ,["value"] = 287382}} ,["value"] = 381598},{["tree"] = {{["tree"] = {} ,["value"] = 858598},{["tree"] = {} ,["value"] = 773832},{["tree"] = {} ,["value"] = 756494},{["tree"] = {} ,["value"] = 69303}} ,["value"] = 584490},{["tree"] = {{["tree"] = {} ,["value"] = 530259},{["tree"] = {} ,["value"] = 783717},{["tree"] = {} ,["value"] = 472442},{["tree"] = {} ,["value"] = 916524}} ,["value"] = 148447}} ,["value"] = 951156},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 258104},{["tree"] = {} ,["value"] = 999862},{["tree"] = {} ,["value"] = 947165},{["tree"] = {} ,["value"] = 986434}} ,["value"] = 214747},{["tree"] = {{["tree"] = {} ,["value"] = 663702},{["tree"] = {} ,["value"] = 685431},{["tree"] = {} ,["value"] = 143713},{["tree"] = {} ,["value"] = 468803}} ,["value"] = 125838},{["tree"] = {{["tree"] = {} ,["value"] = 816352},{["tree"] = {} ,["value"] = 983959},{["tree"] = {} ,["value"] = 635142},{["tree"] = {} ,["value"] = 137705}} ,["value"] = 229883},{["tree"] = {{["tree"] = {} ,["value"] = 475097},{["tree"] = {} ,["value"] = 119556},{["tree"] = {} ,["value"] = 889486},{["tree"] = {} ,["value"] = 512297}} ,["value"] = 219467}} ,["value"] = 784183},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 730937},{["tree"] = {} ,["value"] = 643705},{["tree"] = {} ,["value"] = 29893},{["tree"] = {} ,["value"] = 1267}} ,["value"] = 954912},{["tree"] = {{["tree"] = {} ,["value"] = 117696},{["tree"] = {} ,["value"] = 486908},{["tree"] = {} ,["value"] = 732},{["tree"] = {} ,["value"] = 876660}} ,["value"] = 967008},{["tree"] = {{["tree"] = {} ,["value"] = 156338},{["tree"] = {} ,["value"] = 528021},{["tree"] = {} ,["value"] = 789523},{["tree"] = {} ,["value"] = 1681}} ,["value"] = 85712},{["tree"] = {{["tree"] = {} ,["value"] = 670664},{["tree"] = {} ,["value"] = 131497},{["tree"] = {} ,["value"] = 563918},{["tree"] = {} ,["value"] = 362647}} ,["value"] = 685071}} ,["value"] = 255177}} ,["value"] = 695278},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 63539},{["tree"] = {} ,["value"] = 418915},{["tree"] = {} ,["value"] = 814119},{["tree"] = {} ,["value"] = 395323}} ,["value"] = 845399},{["tree"] = {{["tree"] = {} ,["value"] = 158092},{["tree"] = {} ,["value"] = 707078},{["tree"] = {} ,["value"] = 567503},{["tree"] = {} ,["value"] = 773010}} ,["value"] = 431840},{["tree"] = {{["tree"] = {} ,["value"] = 746595},{["tree"] = {} ,["value"] = 757197},{["tree"] = {} ,["value"] = 966582},{["tree"] = {} ,["value"] = 591753}} ,["value"] = 266117},{["tree"] = {{["tree"] = {} ,["value"] = 295314},{["tree"] = {} ,["value"] = 66282},{["tree"] = {} ,["value"] = 995737},{["tree"] = {} ,["value"] = 592132}} ,["value"] = 107469}} ,["value"] = 897950},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 335928},{["tree"] = {} ,["value"] = 30802},{["tree"] = {} ,["value"] = 789735},{["tree"] = {} ,["value"] = 915526}} ,["value"] = 627449},{["tree"] = {{["tree"] = {} ,["value"] = 11620},{["tree"] = {} ,["value"] = 454362},{["tree"] = {} ,["value"] = 722108},{["tree"] = {} ,["value"] = 229153}} ,["value"] = 948067},{["tree"] = {{["tree"] = {} ,["value"] = 623758},{["tree"] = {} ,["value"] = 359662},{["tree"] = {} ,["value"] = 10343},{["tree"] = {} ,["value"] = 825346}} ,["value"] = 558286},{["tree"] = {{["tree"] = {} ,["value"] = 671998},{["tree"] = {} ,["value"] = 211732},{["tree"] = {} ,["value"] = 312646},{["tree"] = {} ,["value"] = 969842}} ,["value"] = 118365}} ,["value"] = 518091},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 652303},{["tree"] = {} ,["value"] = 607409},{["tree"] = {} ,["value"] = 537763},{["tree"] = {} ,["value"] = 52078}} ,["value"] = 389382},{["tree"] = {{["tree"] = {} ,["value"] = 19637},{["tree"] = {} ,["value"] = 921767},{["tree"] = {} ,["value"] = 986231},{["tree"] = {} ,["value"] = 546873}} ,["value"] = 645109},{["tree"] = {{["tree"] = {} ,["value"] = 445773},{["tree"] = {} ,["value"] = 590912},{["tree"] = {} ,["value"] = 7497},{["tree"] = {} ,["value"] = 221028}} ,["value"] = 457052},{["tree"] = {{["tree"] = {} ,["value"] = 543562},{["tree"] = {} ,["value"] = 807779},{["tree"] = {} ,["value"] = 896289},{["tree"] = {} ,["value"] = 539270}} ,["value"] = 405498}} ,["value"] = 945184},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 231533},{["tree"] = {} ,["value"] = 297375},{["tree"] = {} ,["value"] = 651869},{["tree"] = {} ,["value"] = 752661}} ,["value"] = 887924},{["tree"] = {{["tree"] = {} ,["value"] = 476157},{["tree"] = {} ,["value"] = 858642},{["tree"] = {} ,["value"] = 118269},{["tree"] = {} ,["value"] = 61941}} ,["value"] = 818250},{["tree"] = {{["tree"] = {} ,["value"] = 708536},{["tree"] = {} ,["value"] = 980972},{["tree"] = {} ,["value"] = 485756},{["tree"] = {} ,["value"] = 183949}} ,["value"] = 360331},{["tree"] = {{["tree"] = {} ,["value"] = 83885},{["tree"] = {} ,["value"] = 798319},{["tree"] = {} ,["value"] = 791968},{["tree"] = {} ,["value"] = 780333}} ,["value"] = 951564}} ,["value"] = 979873}} ,["value"] = 19838}} ,["value"] = 202816},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 605219},{["tree"] = {} ,["value"] = 764641},{["tree"] = {} ,["value"] = 763882},{["tree"] = {} ,["value"] = 289892}} ,["value"] = 948505},{["tree"] = {{["tree"] = {} ,["value"] = 281886},{["tree"] = {} ,["value"] = 680611},{["tree"] = {} ,["value"] = 350961},{["tree"] = {} ,["value"] = 353194}} ,["value"] = 983737},{["tree"] = {{["tree"] = {} ,["value"] = 533647},{["tree"] = {} ,["value"] = 851288},{["tree"] = {} ,["value"] = 551942},{["tree"] = {} ,["value"] = 570190}} ,["value"] = 572053},{["tree"] = {{["tree"] = {} ,["value"] = 948517},{["tree"] = {} ,["value"] = 166825},{["tree"] = {} ,["value"] = 260455},{["tree"] = {} ,["value"] = 815697}} ,["value"] = 259821}} ,["value"] = 218612},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 595974},{["tree"] = {} ,["value"] = 725998},{["tree"] = {} ,["value"] = 798514},{["tree"] = {} ,["value"] = 151412}} ,["value"] = 797294},{["tree"] = {{["tree"] = {} ,["value"] = 635920},{["tree"] = {} ,["value"] = 964029},{["tree"] = {} ,["value"] = 243052},{["tree"] = {} ,["value"] = 949186}} ,["value"] = 448658},{["tree"] = {{["tree"] = {} ,["value"] = 595441},{["tree"] = {} ,["value"] = 326920},{["tree"] = {} ,["value"] = 535547},{["tree"] = {} ,["value"] = 502405}} ,["value"] = 164143},{["tree"] = {{["tree"] = {} ,["value"] = 297592},{["tree"] = {} ,["value"] = 122668},{["tree"] = {} ,["value"] = 766418},{["tree"] = {} ,["value"] = 914164}} ,["value"] = 58935}} ,["value"] = 972745},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 621374},{["tree"] = {} ,["value"] = 656075},{["tree"] = {} ,["value"] = 797715},{["tree"] = {} ,["value"] = 24616}} ,["value"] = 817276},{["tree"] = {{["tree"] = {} ,["value"] = 219545},{["tree"] = {} ,["value"] = 808380},{["tree"] = {} ,["value"] = 608700},{["tree"] = {} ,["value"] = 377540}} ,["value"] = 337186},{["tree"] = {{["tree"] = {} ,["value"] = 367705},{["tree"] = {} ,["value"] = 804893},{["tree"] = {} ,["value"] = 735874},{["tree"] = {} ,["value"] = 439225}} ,["value"] = 157563},{["tree"] = {{["tree"] = {} ,["value"] = 401043},{["tree"] = {} ,["value"] = 607863},{["tree"] = {} ,["value"] = 94957},{["tree"] = {} ,["value"] = 217341}} ,["value"] = 988326}} ,["value"] = 505957},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 529157},{["tree"] = {} ,["value"] = 553898},{["tree"] = {} ,["value"] = 992546},{["tree"] = {} ,["value"] = 880485}} ,["value"] = 540996},{["tree"] = {{["tree"] = {} ,["value"] = 626039},{["tree"] = {} ,["value"] = 470954},{["tree"] = {} ,["value"] = 77480},{["tree"] = {} ,["value"] = 520994}} ,["value"] = 871068},{["tree"] = {{["tree"] = {} ,["value"] = 816501},{["tree"] = {} ,["value"] = 146840},{["tree"] = {} ,["value"] = 99297},{["tree"] = {} ,["value"] = 553009}} ,["value"] = 519072},{["tree"] = {{["tree"] = {} ,["value"] = 596844},{["tree"] = {} ,["value"] = 754506},{["tree"] = {} ,["value"] = 815655},{["tree"] = {} ,["value"] = 629379}} ,["value"] = 693742}} ,["value"] = 280391}} ,["value"] = 655651},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 786533},{["tree"] = {} ,["value"] = 414011},{["tree"] = {} ,["value"] = 14128},{["tree"] = {} ,["value"] = 232273}} ,["value"] = 327293},{["tree"] = {{["tree"] = {} ,["value"] = 354793},{["tree"] = {} ,["value"] = 701946},{["tree"] = {} ,["value"] = 608228},{["tree"] = {} ,["value"] = 260889}} ,["value"] = 52367},{["tree"] = {{["tree"] = {} ,["value"] = 579787},{["tree"] = {} ,["value"] = 426061},{["tree"] = {} ,["value"] = 276465},{["tree"] = {} ,["value"] = 968743}} ,["value"] = 303354},{["tree"] = {{["tree"] = {} ,["value"] = 287169},{["tree"] = {} ,["value"] = 581020},{["tree"] = {} ,["value"] = 464288},{["tree"] = {} ,["value"] = 152398}} ,["value"] = 8515}} ,["value"] = 886359},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 788184},{["tree"] = {} ,["value"] = 337718},{["tree"] = {} ,["value"] = 58111},{["tree"] = {} ,["value"] = 90717}} ,["value"] = 595933},{["tree"] = {{["tree"] = {} ,["value"] = 238664},{["tree"] = {} ,["value"] = 587565},{["tree"] = {} ,["value"] = 429714},{["tree"] = {} ,["value"] = 821973}} ,["value"] = 781116},{["tree"] = {{["tree"] = {} ,["value"] = 472506},{["tree"] = {} ,["value"] = 688887},{["tree"] = {} ,["value"] = 778258},{["tree"] = {} ,["value"] = 72223}} ,["value"] = 964725},{["tree"] = {{["tree"] = {} ,["value"] = 842063},{["tree"] = {} ,["value"] = 417559},{["tree"] = {} ,["value"] = 31789},{["tree"] = {} ,["value"] = 515948}} ,["value"] = 310541}} ,["value"] = 64889},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 901277},{["tree"] = {} ,["value"] = 268739},{["tree"] = {} ,["value"] = 42196},{["tree"] = {} ,["value"] = 782469}} ,["value"] = 7864},{["tree"] = {{["tree"] = {} ,["value"] = 307597},{["tree"] = {} ,["value"] = 411792},{["tree"] = {} ,["value"] = 443921},{["tree"] = {} ,["value"] = 91077}} ,["value"] = 211259},{["tree"] = {{["tree"] = {} ,["value"] = 384714},{["tree"] = {} ,["value"] = 255625},{["tree"] = {} ,["value"] = 530258},{["tree"] = {} ,["value"] = 87602}} ,["value"] = 653174},{["tree"] = {{["tree"] = {} ,["value"] = 688129},{["tree"] = {} ,["value"] = 607338},{["tree"] = {} ,["value"] = 890483},{["tree"] = {} ,["value"] = 245182}} ,["value"] = 721414}} ,["value"] = 97717},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 44691},{["tree"] = {} ,["value"] = 125704},{["tree"] = {} ,["value"] = 316665},{["tree"] = {} ,["value"] = 307552}} ,["value"] = 512700},{["tree"] = {{["tree"] = {} ,["value"] = 747077},{["tree"] = {} ,["value"] = 240891},{["tree"] = {} ,["value"] = 732320},{["tree"] = {} ,["value"] = 18985}} ,["value"] = 113004},{["tree"] = {{["tree"] = {} ,["value"] = 156591},{["tree"] = {} ,["value"] = 326323},{["tree"] = {} ,["value"] = 688314},{["tree"] = {} ,["value"] = 372777}} ,["value"] = 587786},{["tree"] = {{["tree"] = {} ,["value"] = 128706},{["tree"] = {} ,["value"] = 5729},{["tree"] = {} ,["value"] = 668579},{["tree"] = {} ,["value"] = 760121}} ,["value"] = 390703}} ,["value"] = 557245}} ,["value"] = 355776},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 118277},{["tree"] = {} ,["value"] = 186385},{["tree"] = {} ,["value"] = 853549},{["tree"] = {} ,["value"] = 880274}} ,["value"] = 101288},{["tree"] = {{["tree"] = {} ,["value"] = 261885},{["tree"] = {} ,["value"] = 977311},{["tree"] = {} ,["value"] = 716358},{["tree"] = {} ,["value"] = 797160}} ,["value"] = 741378},{["tree"] = {{["tree"] = {} ,["value"] = 752056},{["tree"] = {} ,["value"] = 967615},{["tree"] = {} ,["value"] = 223261},{["tree"] = {} ,["value"] = 886373}} ,["value"] = 244398},{["tree"] = {{["tree"] = {} ,["value"] = 486674},{["tree"] = {} ,["value"] = 526348},{["tree"] = {} ,["value"] = 674734},{["tree"] = {} ,["value"] = 461299}} ,["value"] = 874473}} ,["value"] = 829176},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 661350},{["tree"] = {} ,["value"] = 76490},{["tree"] = {} ,["value"] = 497152},{["tree"] = {} ,["value"] = 61551}} ,["value"] = 999455},{["tree"] = {{["tree"] = {} ,["value"] = 741984},{["tree"] = {} ,["value"] = 749629},{["tree"] = {} ,["value"] = 806479},{["tree"] = {} ,["value"] = 952106}} ,["value"] = 887660},{["tree"] = {{["tree"] = {} ,["value"] = 280079},{["tree"] = {} ,["value"] = 909693},{["tree"] = {} ,["value"] = 631587},{["tree"] = {} ,["value"] = 825850}} ,["value"] = 192520},{["tree"] = {{["tree"] = {} ,["value"] = 738887},{["tree"] = {} ,["value"] = 441674},{["tree"] = {} ,["value"] = 952291},{["tree"] = {} ,["value"] = 116111}} ,["value"] = 212952}} ,["value"] = 471886},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 262718},{["tree"] = {} ,["value"] = 621075},{["tree"] = {} ,["value"] = 727759},{["tree"] = {} ,["value"] = 103991}} ,["value"] = 233778},{["tree"] = {{["tree"] = {} ,["value"] = 393569},{["tree"] = {} ,["value"] = 207657},{["tree"] = {} ,["value"] = 284952},{["tree"] = {} ,["value"] = 833762}} ,["value"] = 737444},{["tree"] = {{["tree"] = {} ,["value"] = 567255},{["tree"] = {} ,["value"] = 832552},{["tree"] = {} ,["value"] = 791424},{["tree"] = {} ,["value"] = 954042}} ,["value"] = 262584},{["tree"] = {{["tree"] = {} ,["value"] = 546336},{["tree"] = {} ,["value"] = 708115},{["tree"] = {} ,["value"] = 745988},{["tree"] = {} ,["value"] = 251382}} ,["value"] = 19354}} ,["value"] = 947146},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 309527},{["tree"] = {} ,["value"] = 986225},{["tree"] = {} ,["value"] = 544587},{["tree"] = {} ,["value"] = 970955}} ,["value"] = 72903},{["tree"] = {{["tree"] = {} ,["value"] = 106452},{["tree"] = {} ,["value"] = 460567},{["tree"] = {} ,["value"] = 428657},{["tree"] = {} ,["value"] = 540396}} ,["value"] = 554586},{["tree"] = {{["tree"] = {} ,["value"] = 315850},{["tree"] = {} ,["value"] = 837990},{["tree"] = {} ,["value"] = 614814},{["tree"] = {} ,["value"] = 775500}} ,["value"] = 149639},{["tree"] = {{["tree"] = {} ,["value"] = 326243},{["tree"] = {} ,["value"] = 98822},{["tree"] = {} ,["value"] = 542030},{["tree"] = {} ,["value"] = 473846}} ,["value"] = 121991}} ,["value"] = 404695}} ,["value"] = 299433},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 973697},{["tree"] = {} ,["value"] = 915578},{["tree"] = {} ,["value"] = 820545},{["tree"] = {} ,["value"] = 346552}} ,["value"] = 548498},{["tree"] = {{["tree"] = {} ,["value"] = 562315},{["tree"] = {} ,["value"] = 889872},{["tree"] = {} ,["value"] = 864537},{["tree"] = {} ,["value"] = 308411}} ,["value"] = 567501},{["tree"] = {{["tree"] = {} ,["value"] = 598248},{["tree"] = {} ,["value"] = 20075},{["tree"] = {} ,["value"] = 222711},{["tree"] = {} ,["value"] = 853493}} ,["value"] = 949652},{["tree"] = {{["tree"] = {} ,["value"] = 642951},{["tree"] = {} ,["value"] = 420875},{["tree"] = {} ,["value"] = 208376},{["tree"] = {} ,["value"] = 596721}} ,["value"] = 830301}} ,["value"] = 423229},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 60531},{["tree"] = {} ,["value"] = 844952},{["tree"] = {} ,["value"] = 180335},{["tree"] = {} ,["value"] = 782916}} ,["value"] = 738134},{["tree"] = {{["tree"] = {} ,["value"] = 258514},{["tree"] = {} ,["value"] = 706281},{["tree"] = {} ,["value"] = 286468},{["tree"] = {} ,["value"] = 608731}} ,["value"] = 834211},{["tree"] = {{["tree"] = {} ,["value"] = 268342},{["tree"] = {} ,["value"] = 500129},{["tree"] = {} ,["value"] = 68188},{["tree"] = {} ,["value"] = 23292}} ,["value"] = 379393},{["tree"] = {{["tree"] = {} ,["value"] = 255955},{["tree"] = {} ,["value"] = 554966},{["tree"] = {} ,["value"] = 572330},{["tree"] = {} ,["value"] = 323104}} ,["value"] = 221144}} ,["value"] = 140009},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 11449},{["tree"] = {} ,["value"] = 223113},{["tree"] = {} ,["value"] = 315176},{["tree"] = {} ,["value"] = 824447}} ,["value"] = 156262},{["tree"] = {{["tree"] = {} ,["value"] = 530562},{["tree"] = {} ,["value"] = 316537},{["tree"] = {} ,["value"] = 29224},{["tree"] = {} ,["value"] = 556945}} ,["value"] = 70545},{["tree"] = {{["tree"] = {} ,["value"] = 396697},{["tree"] = {} ,["value"] = 254825},{["tree"] = {} ,["value"] = 414077},{["tree"] = {} ,["value"] = 650236}} ,["value"] = 456442},{["tree"] = {{["tree"] = {} ,["value"] = 945444},{["tree"] = {} ,["value"] = 818435},{["tree"] = {} ,["value"] = 61861},{["tree"] = {} ,["value"] = 678163}} ,["value"] = 274863}} ,["value"] = 88253},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 777768},{["tree"] = {} ,["value"] = 832522},{["tree"] = {} ,["value"] = 58279},{["tree"] = {} ,["value"] = 178838}} ,["value"] = 7495},{["tree"] = {{["tree"] = {} ,["value"] = 945405},{["tree"] = {} ,["value"] = 495586},{["tree"] = {} ,["value"] = 278723},{["tree"] = {} ,["value"] = 15262}} ,["value"] = 335380},{["tree"] = {{["tree"] = {} ,["value"] = 390213},{["tree"] = {} ,["value"] = 550268},{["tree"] = {} ,["value"] = 185536},{["tree"] = {} ,["value"] = 992582}} ,["value"] = 73555},{["tree"] = {{["tree"] = {} ,["value"] = 485562},{["tree"] = {} ,["value"] = 391444},{["tree"] = {} ,["value"] = 215890},{["tree"] = {} ,["value"] = 306480}} ,["value"] = 752820}} ,["value"] = 380648}} ,["value"] = 341518}} ,["value"] = 596582},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 448325},{["tree"] = {} ,["value"] = 325528},{["tree"] = {} ,["value"] = 829091},{["tree"] = {} ,["value"] = 761499}} ,["value"] = 666423},{["tree"] = {{["tree"] = {} ,["value"] = 611720},{["tree"] = {} ,["value"] = 784228},{["tree"] = {} ,["value"] = 864574},{["tree"] = {} ,["value"] = 398534}} ,["value"] = 330855},{["tree"] = {{["tree"] = {} ,["value"] = 86253},{["tree"] = {} ,["value"] = 891385},{["tree"] = {} ,["value"] = 182698},{["tree"] = {} ,["value"] = 650856}} ,["value"] = 589065},{["tree"] = {{["tree"] = {} ,["value"] = 591230},{["tree"] = {} ,["value"] = 77767},{["tree"] = {} ,["value"] = 76486},{["tree"] = {} ,["value"] = 146077}} ,["value"] = 152042}} ,["value"] = 884780},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 897139},{["tree"] = {} ,["value"] = 157250},{["tree"] = {} ,["value"] = 87879},{["tree"] = {} ,["value"] = 227433}} ,["value"] = 938941},{["tree"] = {{["tree"] = {} ,["value"] = 44568},{["tree"] = {} ,["value"] = 944731},{["tree"] = {} ,["value"] = 722360},{["tree"] = {} ,["value"] = 61806}} ,["value"] = 240897},{["tree"] = {{["tree"] = {} ,["value"] = 944808},{["tree"] = {} ,["value"] = 562497},{["tree"] = {} ,["value"] = 776579},{["tree"] = {} ,["value"] = 332881}} ,["value"] = 916583},{["tree"] = {{["tree"] = {} ,["value"] = 846470},{["tree"] = {} ,["value"] = 28113},{["tree"] = {} ,["value"] = 86921},{["tree"] = {} ,["value"] = 62767}} ,["value"] = 52551}} ,["value"] = 464692},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 199091},{["tree"] = {} ,["value"] = 515331},{["tree"] = {} ,["value"] = 639394},{["tree"] = {} ,["value"] = 230241}} ,["value"] = 500208},{["tree"] = {{["tree"] = {} ,["value"] = 786598},{["tree"] = {} ,["value"] = 728592},{["tree"] = {} ,["value"] = 420011},{["tree"] = {} ,["value"] = 107582}} ,["value"] = 902490},{["tree"] = {{["tree"] = {} ,["value"] = 273062},{["tree"] = {} ,["value"] = 48733},{["tree"] = {} ,["value"] = 777994},{["tree"] = {} ,["value"] = 23533}} ,["value"] = 562727},{["tree"] = {{["tree"] = {} ,["value"] = 904455},{["tree"] = {} ,["value"] = 337540},{["tree"] = {} ,["value"] = 504880},{["tree"] = {} ,["value"] = 811547}} ,["value"] = 595090}} ,["value"] = 203212},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 455042},{["tree"] = {} ,["value"] = 733710},{["tree"] = {} ,["value"] = 663718},{["tree"] = {} ,["value"] = 83673}} ,["value"] = 453547},{["tree"] = {{["tree"] = {} ,["value"] = 413160},{["tree"] = {} ,["value"] = 717683},{["tree"] = {} ,["value"] = 702011},{["tree"] = {} ,["value"] = 415333}} ,["value"] = 144386},{["tree"] = {{["tree"] = {} ,["value"] = 967365},{["tree"] = {} ,["value"] = 802174},{["tree"] = {} ,["value"] = 959480},{["tree"] = {} ,["value"] = 537994}} ,["value"] = 772340},{["tree"] = {{["tree"] = {} ,["value"] = 940899},{["tree"] = {} ,["value"] = 658065},{["tree"] = {} ,["value"] = 127194},{["tree"] = {} ,["value"] = 329092}} ,["value"] = 286360}} ,["value"] = 845173}} ,["value"] = 568908},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 172424},{["tree"] = {} ,["value"] = 739358},{["tree"] = {} ,["value"] = 338691},{["tree"] = {} ,["value"] = 270553}} ,["value"] = 475642},{["tree"] = {{["tree"] = {} ,["value"] = 303920},{["tree"] = {} ,["value"] = 221922},{["tree"] = {} ,["value"] = 848780},{["tree"] = {} ,["value"] = 219478}} ,["value"] = 952834},{["tree"] = {{["tree"] = {} ,["value"] = 681126},{["tree"] = {} ,["value"] = 961267},{["tree"] = {} ,["value"] = 66421},{["tree"] = {} ,["value"] = 524574}} ,["value"] = 353456},{["tree"] = {{["tree"] = {} ,["value"] = 745997},{["tree"] = {} ,["value"] = 190069},{["tree"] = {} ,["value"] = 965349},{["tree"] = {} ,["value"] = 122550}} ,["value"] = 180220}} ,["value"] = 378131},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 571986},{["tree"] = {} ,["value"] = 387113},{["tree"] = {} ,["value"] = 787555},{["tree"] = {} ,["value"] = 735687}} ,["value"] = 450928},{["tree"] = {{["tree"] = {} ,["value"] = 860723},{["tree"] = {} ,["value"] = 145526},{["tree"] = {} ,["value"] = 360874},{["tree"] = {} ,["value"] = 372994}} ,["value"] = 881100},{["tree"] = {{["tree"] = {} ,["value"] = 629816},{["tree"] = {} ,["value"] = 235230},{["tree"] = {} ,["value"] = 801955},{["tree"] = {} ,["value"] = 18635}} ,["value"] = 588252},{["tree"] = {{["tree"] = {} ,["value"] = 846582},{["tree"] = {} ,["value"] = 848702},{["tree"] = {} ,["value"] = 837104},{["tree"] = {} ,["value"] = 22525}} ,["value"] = 406616}} ,["value"] = 44662},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 932281},{["tree"] = {} ,["value"] = 534097},{["tree"] = {} ,["value"] = 249116},{["tree"] = {} ,["value"] = 654997}} ,["value"] = 999251},{["tree"] = {{["tree"] = {} ,["value"] = 677237},{["tree"] = {} ,["value"] = 238247},{["tree"] = {} ,["value"] = 353245},{["tree"] = {} ,["value"] = 603538}} ,["value"] = 529828},{["tree"] = {{["tree"] = {} ,["value"] = 938712},{["tree"] = {} ,["value"] = 703811},{["tree"] = {} ,["value"] = 92053},{["tree"] = {} ,["value"] = 507788}} ,["value"] = 23224},{["tree"] = {{["tree"] = {} ,["value"] = 208002},{["tree"] = {} ,["value"] = 684114},{["tree"] = {} ,["value"] = 640104},{["tree"] = {} ,["value"] = 823834}} ,["value"] = 166403}} ,["value"] = 657477},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 27782},{["tree"] = {} ,["value"] = 155364},{["tree"] = {} ,["value"] = 217381},{["tree"] = {} ,["value"] = 88370}} ,["value"] = 383012},{["tree"] = {{["tree"] = {} ,["value"] = 37278},{["tree"] = {} ,["value"] = 490568},{["tree"] = {} ,["value"] = 294100},{["tree"] = {} ,["value"] = 151576}} ,["value"] = 934440},{["tree"] = {{["tree"] = {} ,["value"] = 822358},{["tree"] = {} ,["value"] = 337082},{["tree"] = {} ,["value"] = 945109},{["tree"] = {} ,["value"] = 30628}} ,["value"] = 84022},{["tree"] = {{["tree"] = {} ,["value"] = 324289},{["tree"] = {} ,["value"] = 98144},{["tree"] = {} ,["value"] = 654116},{["tree"] = {} ,["value"] = 757154}} ,["value"] = 876160}} ,["value"] = 854079}} ,["value"] = 992188},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 512148},{["tree"] = {} ,["value"] = 530254},{["tree"] = {} ,["value"] = 616562},{["tree"] = {} ,["value"] = 410696}} ,["value"] = 631467},{["tree"] = {{["tree"] = {} ,["value"] = 497075},{["tree"] = {} ,["value"] = 8293},{["tree"] = {} ,["value"] = 368335},{["tree"] = {} ,["value"] = 681408}} ,["value"] = 775335},{["tree"] = {{["tree"] = {} ,["value"] = 915778},{["tree"] = {} ,["value"] = 197937},{["tree"] = {} ,["value"] = 301203},{["tree"] = {} ,["value"] = 412327}} ,["value"] = 743939},{["tree"] = {{["tree"] = {} ,["value"] = 557428},{["tree"] = {} ,["value"] = 174245},{["tree"] = {} ,["value"] = 255223},{["tree"] = {} ,["value"] = 466256}} ,["value"] = 636803}} ,["value"] = 660495},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 646857},{["tree"] = {} ,["value"] = 614797},{["tree"] = {} ,["value"] = 55133},{["tree"] = {} ,["value"] = 661893}} ,["value"] = 686062},{["tree"] = {{["tree"] = {} ,["value"] = 302002},{["tree"] = {} ,["value"] = 14172},{["tree"] = {} ,["value"] = 947050},{["tree"] = {} ,["value"] = 656329}} ,["value"] = 16499},{["tree"] = {{["tree"] = {} ,["value"] = 140089},{["tree"] = {} ,["value"] = 270693},{["tree"] = {} ,["value"] = 172129},{["tree"] = {} ,["value"] = 241762}} ,["value"] = 502437},{["tree"] = {{["tree"] = {} ,["value"] = 742594},{["tree"] = {} ,["value"] = 608793},{["tree"] = {} ,["value"] = 569792},{["tree"] = {} ,["value"] = 511360}} ,["value"] = 473847}} ,["value"] = 250280},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 386726},{["tree"] = {} ,["value"] = 754052},{["tree"] = {} ,["value"] = 791101},{["tree"] = {} ,["value"] = 3232}} ,["value"] = 789751},{["tree"] = {{["tree"] = {} ,["value"] = 93394},{["tree"] = {} ,["value"] = 964818},{["tree"] = {} ,["value"] = 980045},{["tree"] = {} ,["value"] = 643969}} ,["value"] = 515938},{["tree"] = {{["tree"] = {} ,["value"] = 233929},{["tree"] = {} ,["value"] = 12051},{["tree"] = {} ,["value"] = 500728},{["tree"] = {} ,["value"] = 16076}} ,["value"] = 227224},{["tree"] = {{["tree"] = {} ,["value"] = 441437},{["tree"] = {} ,["value"] = 430216},{["tree"] = {} ,["value"] = 335851},{["tree"] = {} ,["value"] = 336012}} ,["value"] = 10868}} ,["value"] = 566035},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 951471},{["tree"] = {} ,["value"] = 199142},{["tree"] = {} ,["value"] = 953631},{["tree"] = {} ,["value"] = 578065}} ,["value"] = 823695},{["tree"] = {{["tree"] = {} ,["value"] = 353169},{["tree"] = {} ,["value"] = 89751},{["tree"] = {} ,["value"] = 583530},{["tree"] = {} ,["value"] = 339049}} ,["value"] = 423393},{["tree"] = {{["tree"] = {} ,["value"] = 479199},{["tree"] = {} ,["value"] = 111266},{["tree"] = {} ,["value"] = 725388},{["tree"] = {} ,["value"] = 632542}} ,["value"] = 556441},{["tree"] = {{["tree"] = {} ,["value"] = 597372},{["tree"] = {} ,["value"] = 921413},{["tree"] = {} ,["value"] = 93915},{["tree"] = {} ,["value"] = 643795}} ,["value"] = 564376}} ,["value"] = 560996}} ,["value"] = 47970},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 833195},{["tree"] = {} ,["value"] = 19041},{["tree"] = {} ,["value"] = 434579},{["tree"] = {} ,["value"] = 650153}} ,["value"] = 35818},{["tree"] = {{["tree"] = {} ,["value"] = 593828},{["tree"] = {} ,["value"] = 155107},{["tree"] = {} ,["value"] = 911441},{["tree"] = {} ,["value"] = 713790}} ,["value"] = 593616},{["tree"] = {{["tree"] = {} ,["value"] = 470384},{["tree"] = {} ,["value"] = 628763},{["tree"] = {} ,["value"] = 445989},{["tree"] = {} ,["value"] = 898867}} ,["value"] = 837601},{["tree"] = {{["tree"] = {} ,["value"] = 596844},{["tree"] = {} ,["value"] = 78743},{["tree"] = {} ,["value"] = 284741},{["tree"] = {} ,["value"] = 719539}} ,["value"] = 187032}} ,["value"] = 694017},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 642316},{["tree"] = {} ,["value"] = 24431},{["tree"] = {} ,["value"] = 30385},{["tree"] = {} ,["value"] = 903182}} ,["value"] = 712574},{["tree"] = {{["tree"] = {} ,["value"] = 461037},{["tree"] = {} ,["value"] = 88660},{["tree"] = {} ,["value"] = 149431},{["tree"] = {} ,["value"] = 933791}} ,["value"] = 332657},{["tree"] = {{["tree"] = {} ,["value"] = 558197},{["tree"] = {} ,["value"] = 351307},{["tree"] = {} ,["value"] = 736359},{["tree"] = {} ,["value"] = 372690}} ,["value"] = 114095},{["tree"] = {{["tree"] = {} ,["value"] = 357686},{["tree"] = {} ,["value"] = 434737},{["tree"] = {} ,["value"] = 878515},{["tree"] = {} ,["value"] = 822785}} ,["value"] = 903582}} ,["value"] = 375120},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 191257},{["tree"] = {} ,["value"] = 431790},{["tree"] = {} ,["value"] = 723169},{["tree"] = {} ,["value"] = 462876}} ,["value"] = 621523},{["tree"] = {{["tree"] = {} ,["value"] = 769159},{["tree"] = {} ,["value"] = 703834},{["tree"] = {} ,["value"] = 380087},{["tree"] = {} ,["value"] = 682861}} ,["value"] = 451345},{["tree"] = {{["tree"] = {} ,["value"] = 36937},{["tree"] = {} ,["value"] = 189899},{["tree"] = {} ,["value"] = 169157},{["tree"] = {} ,["value"] = 81941}} ,["value"] = 904862},{["tree"] = {{["tree"] = {} ,["value"] = 283505},{["tree"] = {} ,["value"] = 124952},{["tree"] = {} ,["value"] = 90220},{["tree"] = {} ,["value"] = 591968}} ,["value"] = 84108}} ,["value"] = 23143},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 856960},{["tree"] = {} ,["value"] = 649222},{["tree"] = {} ,["value"] = 567917},{["tree"] = {} ,["value"] = 723133}} ,["value"] = 990392},{["tree"] = {{["tree"] = {} ,["value"] = 927666},{["tree"] = {} ,["value"] = 588436},{["tree"] = {} ,["value"] = 723924},{["tree"] = {} ,["value"] = 15214}} ,["value"] = 965943},{["tree"] = {{["tree"] = {} ,["value"] = 767898},{["tree"] = {} ,["value"] = 781768},{["tree"] = {} ,["value"] = 708386},{["tree"] = {} ,["value"] = 832347}} ,["value"] = 685188},{["tree"] = {{["tree"] = {} ,["value"] = 102032},{["tree"] = {} ,["value"] = 785724},{["tree"] = {} ,["value"] = 966146},{["tree"] = {} ,["value"] = 932843}} ,["value"] = 262378}} ,["value"] = 534074}} ,["value"] = 162999}} ,["value"] = 153246},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 969463},{["tree"] = {} ,["value"] = 784197},{["tree"] = {} ,["value"] = 537647},{["tree"] = {} ,["value"] = 413822}} ,["value"] = 348334},{["tree"] = {{["tree"] = {} ,["value"] = 639585},{["tree"] = {} ,["value"] = 728784},{["tree"] = {} ,["value"] = 190359},{["tree"] = {} ,["value"] = 229719}} ,["value"] = 535670},{["tree"] = {{["tree"] = {} ,["value"] = 155834},{["tree"] = {} ,["value"] = 209797},{["tree"] = {} ,["value"] = 446344},{["tree"] = {} ,["value"] = 436906}} ,["value"] = 188313},{["tree"] = {{["tree"] = {} ,["value"] = 809859},{["tree"] = {} ,["value"] = 351012},{["tree"] = {} ,["value"] = 112721},{["tree"] = {} ,["value"] = 741056}} ,["value"] = 258199}} ,["value"] = 471098},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 938629},{["tree"] = {} ,["value"] = 650160},{["tree"] = {} ,["value"] = 376780},{["tree"] = {} ,["value"] = 105550}} ,["value"] = 674240},{["tree"] = {{["tree"] = {} ,["value"] = 932554},{["tree"] = {} ,["value"] = 541698},{["tree"] = {} ,["value"] = 682579},{["tree"] = {} ,["value"] = 48651}} ,["value"] = 331589},{["tree"] = {{["tree"] = {} ,["value"] = 747170},{["tree"] = {} ,["value"] = 457550},{["tree"] = {} ,["value"] = 378938},{["tree"] = {} ,["value"] = 876170}} ,["value"] = 375491},{["tree"] = {{["tree"] = {} ,["value"] = 339730},{["tree"] = {} ,["value"] = 632368},{["tree"] = {} ,["value"] = 302253},{["tree"] = {} ,["value"] = 527928}} ,["value"] = 224223}} ,["value"] = 480970},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 351935},{["tree"] = {} ,["value"] = 273324},{["tree"] = {} ,["value"] = 635084},{["tree"] = {} ,["value"] = 690860}} ,["value"] = 721662},{["tree"] = {{["tree"] = {} ,["value"] = 679093},{["tree"] = {} ,["value"] = 824158},{["tree"] = {} ,["value"] = 778644},{["tree"] = {} ,["value"] = 98865}} ,["value"] = 676499},{["tree"] = {{["tree"] = {} ,["value"] = 900909},{["tree"] = {} ,["value"] = 115039},{["tree"] = {} ,["value"] = 640730},{["tree"] = {} ,["value"] = 171031}} ,["value"] = 227720},{["tree"] = {{["tree"] = {} ,["value"] = 253329},{["tree"] = {} ,["value"] = 59564},{["tree"] = {} ,["value"] = 495268},{["tree"] = {} ,["value"] = 22677}} ,["value"] = 993763}} ,["value"] = 139058},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 271194},{["tree"] = {} ,["value"] = 940622},{["tree"] = {} ,["value"] = 241510},{["tree"] = {} ,["value"] = 785224}} ,["value"] = 194662},{["tree"] = {{["tree"] = {} ,["value"] = 904679},{["tree"] = {} ,["value"] = 83640},{["tree"] = {} ,["value"] = 521701},{["tree"] = {} ,["value"] = 976041}} ,["value"] = 949834},{["tree"] = {{["tree"] = {} ,["value"] = 325902},{["tree"] = {} ,["value"] = 180644},{["tree"] = {} ,["value"] = 123632},{["tree"] = {} ,["value"] = 634094}} ,["value"] = 791986},{["tree"] = {{["tree"] = {} ,["value"] = 19823},{["tree"] = {} ,["value"] = 383385},{["tree"] = {} ,["value"] = 771195},{["tree"] = {} ,["value"] = 2965}} ,["value"] = 34502}} ,["value"] = 305422}} ,["value"] = 581850},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 940527},{["tree"] = {} ,["value"] = 294460},{["tree"] = {} ,["value"] = 945225},{["tree"] = {} ,["value"] = 25422}} ,["value"] = 387076},{["tree"] = {{["tree"] = {} ,["value"] = 112680},{["tree"] = {} ,["value"] = 385317},{["tree"] = {} ,["value"] = 68546},{["tree"] = {} ,["value"] = 773120}} ,["value"] = 480355},{["tree"] = {{["tree"] = {} ,["value"] = 410332},{["tree"] = {} ,["value"] = 785926},{["tree"] = {} ,["value"] = 413722},{["tree"] = {} ,["value"] = 206616}} ,["value"] = 976934},{["tree"] = {{["tree"] = {} ,["value"] = 683729},{["tree"] = {} ,["value"] = 518679},{["tree"] = {} ,["value"] = 899692},{["tree"] = {} ,["value"] = 25573}} ,["value"] = 139494}} ,["value"] = 773413},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 715794},{["tree"] = {} ,["value"] = 827111},{["tree"] = {} ,["value"] = 863705},{["tree"] = {} ,["value"] = 500430}} ,["value"] = 535870},{["tree"] = {{["tree"] = {} ,["value"] = 294050},{["tree"] = {} ,["value"] = 189456},{["tree"] = {} ,["value"] = 812109},{["tree"] = {} ,["value"] = 324647}} ,["value"] = 685323},{["tree"] = {{["tree"] = {} ,["value"] = 368373},{["tree"] = {} ,["value"] = 359707},{["tree"] = {} ,["value"] = 998061},{["tree"] = {} ,["value"] = 96052}} ,["value"] = 714258},{["tree"] = {{["tree"] = {} ,["value"] = 174387},{["tree"] = {} ,["value"] = 932834},{["tree"] = {} ,["value"] = 106086},{["tree"] = {} ,["value"] = 313253}} ,["value"] = 895585}} ,["value"] = 257942},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 188216},{["tree"] = {} ,["value"] = 132636},{["tree"] = {} ,["value"] = 378515},{["tree"] = {} ,["value"] = 279435}} ,["value"] = 333092},{["tree"] = {{["tree"] = {} ,["value"] = 43184},{["tree"] = {} ,["value"] = 717902},{["tree"] = {} ,["value"] = 88041},{["tree"] = {} ,["value"] = 759223}} ,["value"] = 626780},{["tree"] = {{["tree"] = {} ,["value"] = 20036},{["tree"] = {} ,["value"] = 461266},{["tree"] = {} ,["value"] = 169813},{["tree"] = {} ,["value"] = 751368}} ,["value"] = 225297},{["tree"] = {{["tree"] = {} ,["value"] = 911455},{["tree"] = {} ,["value"] = 720161},{["tree"] = {} ,["value"] = 89979},{["tree"] = {} ,["value"] = 16610}} ,["value"] = 968359}} ,["value"] = 139287},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 375422},{["tree"] = {} ,["value"] = 462900},{["tree"] = {} ,["value"] = 840210},{["tree"] = {} ,["value"] = 414238}} ,["value"] = 682776},{["tree"] = {{["tree"] = {} ,["value"] = 116108},{["tree"] = {} ,["value"] = 77777},{["tree"] = {} ,["value"] = 891920},{["tree"] = {} ,["value"] = 62225}} ,["value"] = 89135},{["tree"] = {{["tree"] = {} ,["value"] = 804074},{["tree"] = {} ,["value"] = 351775},{["tree"] = {} ,["value"] = 602311},{["tree"] = {} ,["value"] = 157664}} ,["value"] = 369125},{["tree"] = {{["tree"] = {} ,["value"] = 303147},{["tree"] = {} ,["value"] = 225265},{["tree"] = {} ,["value"] = 440868},{["tree"] = {} ,["value"] = 437594}} ,["value"] = 113052}} ,["value"] = 719313}} ,["value"] = 411710},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 167454},{["tree"] = {} ,["value"] = 56682},{["tree"] = {} ,["value"] = 418004},{["tree"] = {} ,["value"] = 320056}} ,["value"] = 619169},{["tree"] = {{["tree"] = {} ,["value"] = 751479},{["tree"] = {} ,["value"] = 415410},{["tree"] = {} ,["value"] = 378543},{["tree"] = {} ,["value"] = 988908}} ,["value"] = 46797},{["tree"] = {{["tree"] = {} ,["value"] = 529668},{["tree"] = {} ,["value"] = 685392},{["tree"] = {} ,["value"] = 276217},{["tree"] = {} ,["value"] = 609967}} ,["value"] = 107340},{["tree"] = {{["tree"] = {} ,["value"] = 178821},{["tree"] = {} ,["value"] = 542415},{["tree"] = {} ,["value"] = 514180},{["tree"] = {} ,["value"] = 491746}} ,["value"] = 683106}} ,["value"] = 211197},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 238019},{["tree"] = {} ,["value"] = 457144},{["tree"] = {} ,["value"] = 490274},{["tree"] = {} ,["value"] = 427645}} ,["value"] = 402131},{["tree"] = {{["tree"] = {} ,["value"] = 859871},{["tree"] = {} ,["value"] = 353035},{["tree"] = {} ,["value"] = 341121},{["tree"] = {} ,["value"] = 459202}} ,["value"] = 18041},{["tree"] = {{["tree"] = {} ,["value"] = 895160},{["tree"] = {} ,["value"] = 29487},{["tree"] = {} ,["value"] = 764315},{["tree"] = {} ,["value"] = 634987}} ,["value"] = 147435},{["tree"] = {{["tree"] = {} ,["value"] = 693325},{["tree"] = {} ,["value"] = 448531},{["tree"] = {} ,["value"] = 128508},{["tree"] = {} ,["value"] = 390444}} ,["value"] = 817503}} ,["value"] = 568669},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 538512},{["tree"] = {} ,["value"] = 829081},{["tree"] = {} ,["value"] = 198300},{["tree"] = {} ,["value"] = 18851}} ,["value"] = 925331},{["tree"] = {{["tree"] = {} ,["value"] = 695944},{["tree"] = {} ,["value"] = 528911},{["tree"] = {} ,["value"] = 156259},{["tree"] = {} ,["value"] = 10505}} ,["value"] = 998826},{["tree"] = {{["tree"] = {} ,["value"] = 291539},{["tree"] = {} ,["value"] = 700937},{["tree"] = {} ,["value"] = 289676},{["tree"] = {} ,["value"] = 805797}} ,["value"] = 432733},{["tree"] = {{["tree"] = {} ,["value"] = 147992},{["tree"] = {} ,["value"] = 388810},{["tree"] = {} ,["value"] = 409623},{["tree"] = {} ,["value"] = 16245}} ,["value"] = 165313}} ,["value"] = 151191},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 533340},{["tree"] = {} ,["value"] = 603},{["tree"] = {} ,["value"] = 344876},{["tree"] = {} ,["value"] = 13187}} ,["value"] = 492026},{["tree"] = {{["tree"] = {} ,["value"] = 587535},{["tree"] = {} ,["value"] = 386255},{["tree"] = {} ,["value"] = 759820},{["tree"] = {} ,["value"] = 952986}} ,["value"] = 439930},{["tree"] = {{["tree"] = {} ,["value"] = 364635},{["tree"] = {} ,["value"] = 487217},{["tree"] = {} ,["value"] = 698450},{["tree"] = {} ,["value"] = 758046}} ,["value"] = 563176},{["tree"] = {{["tree"] = {} ,["value"] = 44908},{["tree"] = {} ,["value"] = 739148},{["tree"] = {} ,["value"] = 970507},{["tree"] = {} ,["value"] = 235060}} ,["value"] = 348556}} ,["value"] = 741408}} ,["value"] = 567828},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 240263},{["tree"] = {} ,["value"] = 62561},{["tree"] = {} ,["value"] = 335559},{["tree"] = {} ,["value"] = 482914}} ,["value"] = 235850},{["tree"] = {{["tree"] = {} ,["value"] = 434636},{["tree"] = {} ,["value"] = 888370},{["tree"] = {} ,["value"] = 168985},{["tree"] = {} ,["value"] = 783493}} ,["value"] = 8884},{["tree"] = {{["tree"] = {} ,["value"] = 246120},{["tree"] = {} ,["value"] = 667507},{["tree"] = {} ,["value"] = 82350},{["tree"] = {} ,["value"] = 732028}} ,["value"] = 832976},{["tree"] = {{["tree"] = {} ,["value"] = 178966},{["tree"] = {} ,["value"] = 802949},{["tree"] = {} ,["value"] = 614954},{["tree"] = {} ,["value"] = 839526}} ,["value"] = 903396}} ,["value"] = 155565},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 223879},{["tree"] = {} ,["value"] = 389992},{["tree"] = {} ,["value"] = 894125},{["tree"] = {} ,["value"] = 629173}} ,["value"] = 410385},{["tree"] = {{["tree"] = {} ,["value"] = 348253},{["tree"] = {} ,["value"] = 124065},{["tree"] = {} ,["value"] = 959025},{["tree"] = {} ,["value"] = 333139}} ,["value"] = 678640},{["tree"] = {{["tree"] = {} ,["value"] = 612730},{["tree"] = {} ,["value"] = 844582},{["tree"] = {} ,["value"] = 470396},{["tree"] = {} ,["value"] = 568534}} ,["value"] = 290155},{["tree"] = {{["tree"] = {} ,["value"] = 386661},{["tree"] = {} ,["value"] = 995764},{["tree"] = {} ,["value"] = 262618},{["tree"] = {} ,["value"] = 691204}} ,["value"] = 283910}} ,["value"] = 163819},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 684172},{["tree"] = {} ,["value"] = 31462},{["tree"] = {} ,["value"] = 495702},{["tree"] = {} ,["value"] = 12449}} ,["value"] = 872150},{["tree"] = {{["tree"] = {} ,["value"] = 96995},{["tree"] = {} ,["value"] = 468974},{["tree"] = {} ,["value"] = 646926},{["tree"] = {} ,["value"] = 413678}} ,["value"] = 411952},{["tree"] = {{["tree"] = {} ,["value"] = 41027},{["tree"] = {} ,["value"] = 675638},{["tree"] = {} ,["value"] = 685545},{["tree"] = {} ,["value"] = 818687}} ,["value"] = 635358},{["tree"] = {{["tree"] = {} ,["value"] = 628910},{["tree"] = {} ,["value"] = 468379},{["tree"] = {} ,["value"] = 215841},{["tree"] = {} ,["value"] = 161294}} ,["value"] = 196133}} ,["value"] = 676298},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 596831},{["tree"] = {} ,["value"] = 561771},{["tree"] = {} ,["value"] = 396687},{["tree"] = {} ,["value"] = 472723}} ,["value"] = 555257},{["tree"] = {{["tree"] = {} ,["value"] = 473110},{["tree"] = {} ,["value"] = 29139},{["tree"] = {} ,["value"] = 20608},{["tree"] = {} ,["value"] = 479707}} ,["value"] = 407159},{["tree"] = {{["tree"] = {} ,["value"] = 800232},{["tree"] = {} ,["value"] = 958077},{["tree"] = {} ,["value"] = 302056},{["tree"] = {} ,["value"] = 355620}} ,["value"] = 887983},{["tree"] = {{["tree"] = {} ,["value"] = 549256},{["tree"] = {} ,["value"] = 728801},{["tree"] = {} ,["value"] = 239571},{["tree"] = {} ,["value"] = 475837}} ,["value"] = 303914}} ,["value"] = 425714}} ,["value"] = 192670}} ,["value"] = 728834}} ,["value"] = 34023},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 597019},{["tree"] = {} ,["value"] = 64943},{["tree"] = {} ,["value"] = 742508},{["tree"] = {} ,["value"] = 501630}} ,["value"] = 912609},{["tree"] = {{["tree"] = {} ,["value"] = 238887},{["tree"] = {} ,["value"] = 665870},{["tree"] = {} ,["value"] = 700187},{["tree"] = {} ,["value"] = 117327}} ,["value"] = 162390},{["tree"] = {{["tree"] = {} ,["value"] = 673762},{["tree"] = {} ,["value"] = 350842},{["tree"] = {} ,["value"] = 69992},{["tree"] = {} ,["value"] = 362204}} ,["value"] = 826571},{["tree"] = {{["tree"] = {} ,["value"] = 602421},{["tree"] = {} ,["value"] = 670374},{["tree"] = {} ,["value"] = 198181},{["tree"] = {} ,["value"] = 515784}} ,["value"] = 264345}} ,["value"] = 549846},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 352821},{["tree"] = {} ,["value"] = 551023},{["tree"] = {} ,["value"] = 305640},{["tree"] = {} ,["value"] = 347865}} ,["value"] = 611953},{["tree"] = {{["tree"] = {} ,["value"] = 494091},{["tree"] = {} ,["value"] = 727963},{["tree"] = {} ,["value"] = 708817},{["tree"] = {} ,["value"] = 611611}} ,["value"] = 358248},{["tree"] = {{["tree"] = {} ,["value"] = 950969},{["tree"] = {} ,["value"] = 247274},{["tree"] = {} ,["value"] = 152904},{["tree"] = {} ,["value"] = 697133}} ,["value"] = 199432},{["tree"] = {{["tree"] = {} ,["value"] = 16434},{["tree"] = {} ,["value"] = 297328},{["tree"] = {} ,["value"] = 863931},{["tree"] = {} ,["value"] = 327177}} ,["value"] = 325328}} ,["value"] = 347961},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 908578},{["tree"] = {} ,["value"] = 285041},{["tree"] = {} ,["value"] = 427055},{["tree"] = {} ,["value"] = 62091}} ,["value"] = 328382},{["tree"] = {{["tree"] = {} ,["value"] = 568424},{["tree"] = {} ,["value"] = 899624},{["tree"] = {} ,["value"] = 95060},{["tree"] = {} ,["value"] = 935921}} ,["value"] = 297359},{["tree"] = {{["tree"] = {} ,["value"] = 371444},{["tree"] = {} ,["value"] = 275833},{["tree"] = {} ,["value"] = 462204},{["tree"] = {} ,["value"] = 286418}} ,["value"] = 589797},{["tree"] = {{["tree"] = {} ,["value"] = 732354},{["tree"] = {} ,["value"] = 521813},{["tree"] = {} ,["value"] = 726111},{["tree"] = {} ,["value"] = 947271}} ,["value"] = 606492}} ,["value"] = 26414},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 81713},{["tree"] = {} ,["value"] = 673871},{["tree"] = {} ,["value"] = 967323},{["tree"] = {} ,["value"] = 777156}} ,["value"] = 958209},{["tree"] = {{["tree"] = {} ,["value"] = 708857},{["tree"] = {} ,["value"] = 393222},{["tree"] = {} ,["value"] = 696583},{["tree"] = {} ,["value"] = 741159}} ,["value"] = 14600},{["tree"] = {{["tree"] = {} ,["value"] = 833441},{["tree"] = {} ,["value"] = 325320},{["tree"] = {} ,["value"] = 447815},{["tree"] = {} ,["value"] = 590201}} ,["value"] = 388721},{["tree"] = {{["tree"] = {} ,["value"] = 96421},{["tree"] = {} ,["value"] = 595343},{["tree"] = {} ,["value"] = 32652},{["tree"] = {} ,["value"] = 373586}} ,["value"] = 41340}} ,["value"] = 413726}} ,["value"] = 785126},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 219170},{["tree"] = {} ,["value"] = 32267},{["tree"] = {} ,["value"] = 826717},{["tree"] = {} ,["value"] = 785523}} ,["value"] = 608393},{["tree"] = {{["tree"] = {} ,["value"] = 821613},{["tree"] = {} ,["value"] = 568610},{["tree"] = {} ,["value"] = 499843},{["tree"] = {} ,["value"] = 276187}} ,["value"] = 324052},{["tree"] = {{["tree"] = {} ,["value"] = 67282},{["tree"] = {} ,["value"] = 676696},{["tree"] = {} ,["value"] = 413380},{["tree"] = {} ,["value"] = 57924}} ,["value"] = 371321},{["tree"] = {{["tree"] = {} ,["value"] = 306780},{["tree"] = {} ,["value"] = 893071},{["tree"] = {} ,["value"] = 158280},{["tree"] = {} ,["value"] = 176619}} ,["value"] = 617940}} ,["value"] = 182841},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 275752},{["tree"] = {} ,["value"] = 910715},{["tree"] = {} ,["value"] = 453561},{["tree"] = {} ,["value"] = 868085}} ,["value"] = 66417},{["tree"] = {{["tree"] = {} ,["value"] = 590398},{["tree"] = {} ,["value"] = 810495},{["tree"] = {} ,["value"] = 819875},{["tree"] = {} ,["value"] = 762299}} ,["value"] = 13698},{["tree"] = {{["tree"] = {} ,["value"] = 613924},{["tree"] = {} ,["value"] = 588869},{["tree"] = {} ,["value"] = 56792},{["tree"] = {} ,["value"] = 54585}} ,["value"] = 13829},{["tree"] = {{["tree"] = {} ,["value"] = 648822},{["tree"] = {} ,["value"] = 882582},{["tree"] = {} ,["value"] = 213822},{["tree"] = {} ,["value"] = 808768}} ,["value"] = 907302}} ,["value"] = 120609},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 480201},{["tree"] = {} ,["value"] = 402174},{["tree"] = {} ,["value"] = 987229},{["tree"] = {} ,["value"] = 924682}} ,["value"] = 742740},{["tree"] = {{["tree"] = {} ,["value"] = 703547},{["tree"] = {} ,["value"] = 432417},{["tree"] = {} ,["value"] = 439258},{["tree"] = {} ,["value"] = 73125}} ,["value"] = 85334},{["tree"] = {{["tree"] = {} ,["value"] = 825955},{["tree"] = {} ,["value"] = 463277},{["tree"] = {} ,["value"] = 386291},{["tree"] = {} ,["value"] = 515983}} ,["value"] = 623853},{["tree"] = {{["tree"] = {} ,["value"] = 744718},{["tree"] = {} ,["value"] = 89546},{["tree"] = {} ,["value"] = 586607},{["tree"] = {} ,["value"] = 92755}} ,["value"] = 398393}} ,["value"] = 847655},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 517633},{["tree"] = {} ,["value"] = 305061},{["tree"] = {} ,["value"] = 885939},{["tree"] = {} ,["value"] = 772866}} ,["value"] = 768918},{["tree"] = {{["tree"] = {} ,["value"] = 133461},{["tree"] = {} ,["value"] = 295626},{["tree"] = {} ,["value"] = 668546},{["tree"] = {} ,["value"] = 675967}} ,["value"] = 54807},{["tree"] = {{["tree"] = {} ,["value"] = 26528},{["tree"] = {} ,["value"] = 951767},{["tree"] = {} ,["value"] = 824584},{["tree"] = {} ,["value"] = 445630}} ,["value"] = 348539},{["tree"] = {{["tree"] = {} ,["value"] = 229715},{["tree"] = {} ,["value"] = 398757},{["tree"] = {} ,["value"] = 784312},{["tree"] = {} ,["value"] = 516776}} ,["value"] = 842739}} ,["value"] = 663421}} ,["value"] = 644560},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 631575},{["tree"] = {} ,["value"] = 607001},{["tree"] = {} ,["value"] = 739701},{["tree"] = {} ,["value"] = 278472}} ,["value"] = 116653},{["tree"] = {{["tree"] = {} ,["value"] = 364527},{["tree"] = {} ,["value"] = 266274},{["tree"] = {} ,["value"] = 430524},{["tree"] = {} ,["value"] = 108272}} ,["value"] = 5594},{["tree"] = {{["tree"] = {} ,["value"] = 179508},{["tree"] = {} ,["value"] = 742594},{["tree"] = {} ,["value"] = 303071},{["tree"] = {} ,["value"] = 536334}} ,["value"] = 719123},{["tree"] = {{["tree"] = {} ,["value"] = 832147},{["tree"] = {} ,["value"] = 337645},{["tree"] = {} ,["value"] = 224954},{["tree"] = {} ,["value"] = 250586}} ,["value"] = 53152}} ,["value"] = 730732},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 486201},{["tree"] = {} ,["value"] = 398252},{["tree"] = {} ,["value"] = 547142},{["tree"] = {} ,["value"] = 493270}} ,["value"] = 249100},{["tree"] = {{["tree"] = {} ,["value"] = 525740},{["tree"] = {} ,["value"] = 619399},{["tree"] = {} ,["value"] = 751171},{["tree"] = {} ,["value"] = 80424}} ,["value"] = 783541},{["tree"] = {{["tree"] = {} ,["value"] = 646562},{["tree"] = {} ,["value"] = 940298},{["tree"] = {} ,["value"] = 954816},{["tree"] = {} ,["value"] = 586340}} ,["value"] = 532060},{["tree"] = {{["tree"] = {} ,["value"] = 223372},{["tree"] = {} ,["value"] = 47122},{["tree"] = {} ,["value"] = 455386},{["tree"] = {} ,["value"] = 349463}} ,["value"] = 572144}} ,["value"] = 763126},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 433024},{["tree"] = {} ,["value"] = 852542},{["tree"] = {} ,["value"] = 30977},{["tree"] = {} ,["value"] = 625}} ,["value"] = 758746},{["tree"] = {{["tree"] = {} ,["value"] = 925516},{["tree"] = {} ,["value"] = 717896},{["tree"] = {} ,["value"] = 611580},{["tree"] = {} ,["value"] = 874180}} ,["value"] = 152014},{["tree"] = {{["tree"] = {} ,["value"] = 322440},{["tree"] = {} ,["value"] = 484275},{["tree"] = {} ,["value"] = 165807},{["tree"] = {} ,["value"] = 852877}} ,["value"] = 230921},{["tree"] = {{["tree"] = {} ,["value"] = 465961},{["tree"] = {} ,["value"] = 130724},{["tree"] = {} ,["value"] = 51313},{["tree"] = {} ,["value"] = 422408}} ,["value"] = 836516}} ,["value"] = 10830},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 815841},{["tree"] = {} ,["value"] = 268938},{["tree"] = {} ,["value"] = 803211},{["tree"] = {} ,["value"] = 879870}} ,["value"] = 811094},{["tree"] = {{["tree"] = {} ,["value"] = 49854},{["tree"] = {} ,["value"] = 313908},{["tree"] = {} ,["value"] = 5061},{["tree"] = {} ,["value"] = 602236}} ,["value"] = 749401},{["tree"] = {{["tree"] = {} ,["value"] = 849},{["tree"] = {} ,["value"] = 521803},{["tree"] = {} ,["value"] = 71046},{["tree"] = {} ,["value"] = 392544}} ,["value"] = 257930},{["tree"] = {{["tree"] = {} ,["value"] = 553511},{["tree"] = {} ,["value"] = 299011},{["tree"] = {} ,["value"] = 365977},{["tree"] = {} ,["value"] = 39534}} ,["value"] = 772045}} ,["value"] = 860958}} ,["value"] = 476105},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 297950},{["tree"] = {} ,["value"] = 43246},{["tree"] = {} ,["value"] = 510812},{["tree"] = {} ,["value"] = 145672}} ,["value"] = 421363},{["tree"] = {{["tree"] = {} ,["value"] = 681931},{["tree"] = {} ,["value"] = 596969},{["tree"] = {} ,["value"] = 714679},{["tree"] = {} ,["value"] = 588168}} ,["value"] = 764486},{["tree"] = {{["tree"] = {} ,["value"] = 340191},{["tree"] = {} ,["value"] = 841611},{["tree"] = {} ,["value"] = 322007},{["tree"] = {} ,["value"] = 188789}} ,["value"] = 582394},{["tree"] = {{["tree"] = {} ,["value"] = 648843},{["tree"] = {} ,["value"] = 384111},{["tree"] = {} ,["value"] = 399132},{["tree"] = {} ,["value"] = 536565}} ,["value"] = 738305}} ,["value"] = 101304},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 664519},{["tree"] = {} ,["value"] = 604353},{["tree"] = {} ,["value"] = 422082},{["tree"] = {} ,["value"] = 636442}} ,["value"] = 102146},{["tree"] = {{["tree"] = {} ,["value"] = 285690},{["tree"] = {} ,["value"] = 11837},{["tree"] = {} ,["value"] = 85787},{["tree"] = {} ,["value"] = 877064}} ,["value"] = 95939},{["tree"] = {{["tree"] = {} ,["value"] = 638102},{["tree"] = {} ,["value"] = 2875},{["tree"] = {} ,["value"] = 664764},{["tree"] = {} ,["value"] = 637300}} ,["value"] = 554013},{["tree"] = {{["tree"] = {} ,["value"] = 263686},{["tree"] = {} ,["value"] = 506480},{["tree"] = {} ,["value"] = 441000},{["tree"] = {} ,["value"] = 414797}} ,["value"] = 358644}} ,["value"] = 852716},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 990037},{["tree"] = {} ,["value"] = 87837},{["tree"] = {} ,["value"] = 830568},{["tree"] = {} ,["value"] = 15348}} ,["value"] = 838164},{["tree"] = {{["tree"] = {} ,["value"] = 315075},{["tree"] = {} ,["value"] = 723203},{["tree"] = {} ,["value"] = 686026},{["tree"] = {} ,["value"] = 875023}} ,["value"] = 537488},{["tree"] = {{["tree"] = {} ,["value"] = 102611},{["tree"] = {} ,["value"] = 571811},{["tree"] = {} ,["value"] = 129419},{["tree"] = {} ,["value"] = 88764}} ,["value"] = 218257},{["tree"] = {{["tree"] = {} ,["value"] = 287622},{["tree"] = {} ,["value"] = 704068},{["tree"] = {} ,["value"] = 806816},{["tree"] = {} ,["value"] = 556735}} ,["value"] = 965534}} ,["value"] = 56164},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 823173},{["tree"] = {} ,["value"] = 857959},{["tree"] = {} ,["value"] = 457771},{["tree"] = {} ,["value"] = 465029}} ,["value"] = 898882},{["tree"] = {{["tree"] = {} ,["value"] = 929037},{["tree"] = {} ,["value"] = 975784},{["tree"] = {} ,["value"] = 168758},{["tree"] = {} ,["value"] = 432444}} ,["value"] = 225836},{["tree"] = {{["tree"] = {} ,["value"] = 906280},{["tree"] = {} ,["value"] = 381998},{["tree"] = {} ,["value"] = 129665},{["tree"] = {} ,["value"] = 130180}} ,["value"] = 245820},{["tree"] = {{["tree"] = {} ,["value"] = 826786},{["tree"] = {} ,["value"] = 510232},{["tree"] = {} ,["value"] = 620},{["tree"] = {} ,["value"] = 808941}} ,["value"] = 962330}} ,["value"] = 152684}} ,["value"] = 556063}} ,["value"] = 530107},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 812309},{["tree"] = {} ,["value"] = 271029},{["tree"] = {} ,["value"] = 711798},{["tree"] = {} ,["value"] = 288810}} ,["value"] = 449531},{["tree"] = {{["tree"] = {} ,["value"] = 18998},{["tree"] = {} ,["value"] = 163957},{["tree"] = {} ,["value"] = 489697},{["tree"] = {} ,["value"] = 467923}} ,["value"] = 775802},{["tree"] = {{["tree"] = {} ,["value"] = 987251},{["tree"] = {} ,["value"] = 388075},{["tree"] = {} ,["value"] = 232093},{["tree"] = {} ,["value"] = 319499}} ,["value"] = 115525},{["tree"] = {{["tree"] = {} ,["value"] = 237361},{["tree"] = {} ,["value"] = 788600},{["tree"] = {} ,["value"] = 63024},{["tree"] = {} ,["value"] = 763164}} ,["value"] = 447276}} ,["value"] = 947955},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 442181},{["tree"] = {} ,["value"] = 52351},{["tree"] = {} ,["value"] = 872883},{["tree"] = {} ,["value"] = 626446}} ,["value"] = 530187},{["tree"] = {{["tree"] = {} ,["value"] = 154077},{["tree"] = {} ,["value"] = 537383},{["tree"] = {} ,["value"] = 449698},{["tree"] = {} ,["value"] = 895154}} ,["value"] = 531592},{["tree"] = {{["tree"] = {} ,["value"] = 885414},{["tree"] = {} ,["value"] = 948792},{["tree"] = {} ,["value"] = 642432},{["tree"] = {} ,["value"] = 711357}} ,["value"] = 794166},{["tree"] = {{["tree"] = {} ,["value"] = 73802},{["tree"] = {} ,["value"] = 563874},{["tree"] = {} ,["value"] = 762468},{["tree"] = {} ,["value"] = 132354}} ,["value"] = 39594}} ,["value"] = 600200},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 105142},{["tree"] = {} ,["value"] = 517739},{["tree"] = {} ,["value"] = 299435},{["tree"] = {} ,["value"] = 746085}} ,["value"] = 694003},{["tree"] = {{["tree"] = {} ,["value"] = 697803},{["tree"] = {} ,["value"] = 764731},{["tree"] = {} ,["value"] = 623581},{["tree"] = {} ,["value"] = 559114}} ,["value"] = 120922},{["tree"] = {{["tree"] = {} ,["value"] = 942199},{["tree"] = {} ,["value"] = 983587},{["tree"] = {} ,["value"] = 445103},{["tree"] = {} ,["value"] = 999480}} ,["value"] = 991695},{["tree"] = {{["tree"] = {} ,["value"] = 23171},{["tree"] = {} ,["value"] = 5258},{["tree"] = {} ,["value"] = 340128},{["tree"] = {} ,["value"] = 186196}} ,["value"] = 345927}} ,["value"] = 576888},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 763875},{["tree"] = {} ,["value"] = 305841},{["tree"] = {} ,["value"] = 257351},{["tree"] = {} ,["value"] = 89927}} ,["value"] = 322265},{["tree"] = {{["tree"] = {} ,["value"] = 550218},{["tree"] = {} ,["value"] = 936150},{["tree"] = {} ,["value"] = 595357},{["tree"] = {} ,["value"] = 30527}} ,["value"] = 96834},{["tree"] = {{["tree"] = {} ,["value"] = 638729},{["tree"] = {} ,["value"] = 676394},{["tree"] = {} ,["value"] = 707036},{["tree"] = {} ,["value"] = 631658}} ,["value"] = 182100},{["tree"] = {{["tree"] = {} ,["value"] = 534497},{["tree"] = {} ,["value"] = 285126},{["tree"] = {} ,["value"] = 729510},{["tree"] = {} ,["value"] = 294969}} ,["value"] = 818258}} ,["value"] = 88624}} ,["value"] = 981166},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 186951},{["tree"] = {} ,["value"] = 698672},{["tree"] = {} ,["value"] = 855733},{["tree"] = {} ,["value"] = 571365}} ,["value"] = 945083},{["tree"] = {{["tree"] = {} ,["value"] = 337585},{["tree"] = {} ,["value"] = 252190},{["tree"] = {} ,["value"] = 550126},{["tree"] = {} ,["value"] = 280969}} ,["value"] = 157822},{["tree"] = {{["tree"] = {} ,["value"] = 812000},{["tree"] = {} ,["value"] = 594458},{["tree"] = {} ,["value"] = 378597},{["tree"] = {} ,["value"] = 501876}} ,["value"] = 381764},{["tree"] = {{["tree"] = {} ,["value"] = 382914},{["tree"] = {} ,["value"] = 270666},{["tree"] = {} ,["value"] = 969815},{["tree"] = {} ,["value"] = 916476}} ,["value"] = 714823}} ,["value"] = 238578},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 57599},{["tree"] = {} ,["value"] = 861545},{["tree"] = {} ,["value"] = 540042},{["tree"] = {} ,["value"] = 464949}} ,["value"] = 353472},{["tree"] = {{["tree"] = {} ,["value"] = 150137},{["tree"] = {} ,["value"] = 405430},{["tree"] = {} ,["value"] = 365415},{["tree"] = {} ,["value"] = 224395}} ,["value"] = 202717},{["tree"] = {{["tree"] = {} ,["value"] = 282315},{["tree"] = {} ,["value"] = 183730},{["tree"] = {} ,["value"] = 536698},{["tree"] = {} ,["value"] = 880518}} ,["value"] = 388515},{["tree"] = {{["tree"] = {} ,["value"] = 802895},{["tree"] = {} ,["value"] = 249370},{["tree"] = {} ,["value"] = 880085},{["tree"] = {} ,["value"] = 146715}} ,["value"] = 968012}} ,["value"] = 699474},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 164539},{["tree"] = {} ,["value"] = 628909},{["tree"] = {} ,["value"] = 544288},{["tree"] = {} ,["value"] = 797648}} ,["value"] = 398434},{["tree"] = {{["tree"] = {} ,["value"] = 701174},{["tree"] = {} ,["value"] = 858078},{["tree"] = {} ,["value"] = 782674},{["tree"] = {} ,["value"] = 910906}} ,["value"] = 251519},{["tree"] = {{["tree"] = {} ,["value"] = 728233},{["tree"] = {} ,["value"] = 337791},{["tree"] = {} ,["value"] = 417747},{["tree"] = {} ,["value"] = 714575}} ,["value"] = 92994},{["tree"] = {{["tree"] = {} ,["value"] = 930382},{["tree"] = {} ,["value"] = 760415},{["tree"] = {} ,["value"] = 801724},{["tree"] = {} ,["value"] = 839471}} ,["value"] = 97270}} ,["value"] = 497165},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 738068},{["tree"] = {} ,["value"] = 339276},{["tree"] = {} ,["value"] = 138201},{["tree"] = {} ,["value"] = 12003}} ,["value"] = 343824},{["tree"] = {{["tree"] = {} ,["value"] = 631164},{["tree"] = {} ,["value"] = 89927},{["tree"] = {} ,["value"] = 769038},{["tree"] = {} ,["value"] = 555324}} ,["value"] = 55112},{["tree"] = {{["tree"] = {} ,["value"] = 910001},{["tree"] = {} ,["value"] = 859181},{["tree"] = {} ,["value"] = 135915},{["tree"] = {} ,["value"] = 361216}} ,["value"] = 964898},{["tree"] = {{["tree"] = {} ,["value"] = 470694},{["tree"] = {} ,["value"] = 336808},{["tree"] = {} ,["value"] = 966195},{["tree"] = {} ,["value"] = 200813}} ,["value"] = 18482}} ,["value"] = 756600}} ,["value"] = 533881},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 2976},{["tree"] = {} ,["value"] = 434963},{["tree"] = {} ,["value"] = 979927},{["tree"] = {} ,["value"] = 479293}} ,["value"] = 239421},{["tree"] = {{["tree"] = {} ,["value"] = 94371},{["tree"] = {} ,["value"] = 543745},{["tree"] = {} ,["value"] = 107108},{["tree"] = {} ,["value"] = 226037}} ,["value"] = 53167},{["tree"] = {{["tree"] = {} ,["value"] = 586403},{["tree"] = {} ,["value"] = 713162},{["tree"] = {} ,["value"] = 84313},{["tree"] = {} ,["value"] = 263136}} ,["value"] = 374798},{["tree"] = {{["tree"] = {} ,["value"] = 843843},{["tree"] = {} ,["value"] = 429224},{["tree"] = {} ,["value"] = 955777},{["tree"] = {} ,["value"] = 658635}} ,["value"] = 574863}} ,["value"] = 660514},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 508486},{["tree"] = {} ,["value"] = 399792},{["tree"] = {} ,["value"] = 436101},{["tree"] = {} ,["value"] = 712017}} ,["value"] = 823416},{["tree"] = {{["tree"] = {} ,["value"] = 817267},{["tree"] = {} ,["value"] = 409357},{["tree"] = {} ,["value"] = 822460},{["tree"] = {} ,["value"] = 98244}} ,["value"] = 470390},{["tree"] = {{["tree"] = {} ,["value"] = 87508},{["tree"] = {} ,["value"] = 309474},{["tree"] = {} ,["value"] = 366695},{["tree"] = {} ,["value"] = 189084}} ,["value"] = 802386},{["tree"] = {{["tree"] = {} ,["value"] = 794993},{["tree"] = {} ,["value"] = 878902},{["tree"] = {} ,["value"] = 773366},{["tree"] = {} ,["value"] = 334159}} ,["value"] = 689785}} ,["value"] = 475810},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 217555},{["tree"] = {} ,["value"] = 421479},{["tree"] = {} ,["value"] = 803155},{["tree"] = {} ,["value"] = 40846}} ,["value"] = 297721},{["tree"] = {{["tree"] = {} ,["value"] = 505837},{["tree"] = {} ,["value"] = 888740},{["tree"] = {} ,["value"] = 702667},{["tree"] = {} ,["value"] = 883416}} ,["value"] = 637539},{["tree"] = {{["tree"] = {} ,["value"] = 945453},{["tree"] = {} ,["value"] = 75181},{["tree"] = {} ,["value"] = 94346},{["tree"] = {} ,["value"] = 608931}} ,["value"] = 665573},{["tree"] = {{["tree"] = {} ,["value"] = 870594},{["tree"] = {} ,["value"] = 937797},{["tree"] = {} ,["value"] = 591391},{["tree"] = {} ,["value"] = 278793}} ,["value"] = 903642}} ,["value"] = 232260},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 354863},{["tree"] = {} ,["value"] = 637343},{["tree"] = {} ,["value"] = 938432},{["tree"] = {} ,["value"] = 591828}} ,["value"] = 192243},{["tree"] = {{["tree"] = {} ,["value"] = 630246},{["tree"] = {} ,["value"] = 558618},{["tree"] = {} ,["value"] = 900699},{["tree"] = {} ,["value"] = 680982}} ,["value"] = 716146},{["tree"] = {{["tree"] = {} ,["value"] = 102279},{["tree"] = {} ,["value"] = 695531},{["tree"] = {} ,["value"] = 631579},{["tree"] = {} ,["value"] = 168605}} ,["value"] = 182276},{["tree"] = {{["tree"] = {} ,["value"] = 956999},{["tree"] = {} ,["value"] = 559866},{["tree"] = {} ,["value"] = 21260},{["tree"] = {} ,["value"] = 277429}} ,["value"] = 147606}} ,["value"] = 675208}} ,["value"] = 171667},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 57111},{["tree"] = {} ,["value"] = 802075},{["tree"] = {} ,["value"] = 800868},{["tree"] = {} ,["value"] = 367694}} ,["value"] = 110027},{["tree"] = {{["tree"] = {} ,["value"] = 200661},{["tree"] = {} ,["value"] = 602769},{["tree"] = {} ,["value"] = 390321},{["tree"] = {} ,["value"] = 595730}} ,["value"] = 198451},{["tree"] = {{["tree"] = {} ,["value"] = 210540},{["tree"] = {} ,["value"] = 863541},{["tree"] = {} ,["value"] = 625753},{["tree"] = {} ,["value"] = 338938}} ,["value"] = 473041},{["tree"] = {{["tree"] = {} ,["value"] = 812469},{["tree"] = {} ,["value"] = 667417},{["tree"] = {} ,["value"] = 507369},{["tree"] = {} ,["value"] = 121427}} ,["value"] = 841902}} ,["value"] = 694455},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 220708},{["tree"] = {} ,["value"] = 603569},{["tree"] = {} ,["value"] = 992613},{["tree"] = {} ,["value"] = 208843}} ,["value"] = 692559},{["tree"] = {{["tree"] = {} ,["value"] = 932946},{["tree"] = {} ,["value"] = 255176},{["tree"] = {} ,["value"] = 949942},{["tree"] = {} ,["value"] = 176904}} ,["value"] = 874323},{["tree"] = {{["tree"] = {} ,["value"] = 131968},{["tree"] = {} ,["value"] = 675742},{["tree"] = {} ,["value"] = 362988},{["tree"] = {} ,["value"] = 144318}} ,["value"] = 268590},{["tree"] = {{["tree"] = {} ,["value"] = 258196},{["tree"] = {} ,["value"] = 887941},{["tree"] = {} ,["value"] = 811828},{["tree"] = {} ,["value"] = 700015}} ,["value"] = 698150}} ,["value"] = 172569},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 563526},{["tree"] = {} ,["value"] = 884045},{["tree"] = {} ,["value"] = 436852},{["tree"] = {} ,["value"] = 291932}} ,["value"] = 458490},{["tree"] = {{["tree"] = {} ,["value"] = 372347},{["tree"] = {} ,["value"] = 5221},{["tree"] = {} ,["value"] = 878418},{["tree"] = {} ,["value"] = 321885}} ,["value"] = 29649},{["tree"] = {{["tree"] = {} ,["value"] = 831525},{["tree"] = {} ,["value"] = 266118},{["tree"] = {} ,["value"] = 644070},{["tree"] = {} ,["value"] = 203322}} ,["value"] = 39430},{["tree"] = {{["tree"] = {} ,["value"] = 806882},{["tree"] = {} ,["value"] = 114882},{["tree"] = {} ,["value"] = 673968},{["tree"] = {} ,["value"] = 710288}} ,["value"] = 199597}} ,["value"] = 13403},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 340415},{["tree"] = {} ,["value"] = 465069},{["tree"] = {} ,["value"] = 216190},{["tree"] = {} ,["value"] = 864672}} ,["value"] = 338347},{["tree"] = {{["tree"] = {} ,["value"] = 372031},{["tree"] = {} ,["value"] = 194311},{["tree"] = {} ,["value"] = 835111},{["tree"] = {} ,["value"] = 30691}} ,["value"] = 586642},{["tree"] = {{["tree"] = {} ,["value"] = 315525},{["tree"] = {} ,["value"] = 412339},{["tree"] = {} ,["value"] = 926970},{["tree"] = {} ,["value"] = 408430}} ,["value"] = 990363},{["tree"] = {{["tree"] = {} ,["value"] = 316303},{["tree"] = {} ,["value"] = 839157},{["tree"] = {} ,["value"] = 451395},{["tree"] = {} ,["value"] = 879610}} ,["value"] = 762622}} ,["value"] = 729099}} ,["value"] = 10633}} ,["value"] = 951133},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 72574},{["tree"] = {} ,["value"] = 541478},{["tree"] = {} ,["value"] = 111354},{["tree"] = {} ,["value"] = 439579}} ,["value"] = 886255},{["tree"] = {{["tree"] = {} ,["value"] = 726746},{["tree"] = {} ,["value"] = 954933},{["tree"] = {} ,["value"] = 509426},{["tree"] = {} ,["value"] = 956900}} ,["value"] = 336304},{["tree"] = {{["tree"] = {} ,["value"] = 327767},{["tree"] = {} ,["value"] = 34604},{["tree"] = {} ,["value"] = 696685},{["tree"] = {} ,["value"] = 103853}} ,["value"] = 473614},{["tree"] = {{["tree"] = {} ,["value"] = 905912},{["tree"] = {} ,["value"] = 566581},{["tree"] = {} ,["value"] = 199332},{["tree"] = {} ,["value"] = 546052}} ,["value"] = 3536}} ,["value"] = 453832},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 431733},{["tree"] = {} ,["value"] = 178779},{["tree"] = {} ,["value"] = 155763},{["tree"] = {} ,["value"] = 460937}} ,["value"] = 943784},{["tree"] = {{["tree"] = {} ,["value"] = 17900},{["tree"] = {} ,["value"] = 324702},{["tree"] = {} ,["value"] = 650065},{["tree"] = {} ,["value"] = 966993}} ,["value"] = 995981},{["tree"] = {{["tree"] = {} ,["value"] = 590486},{["tree"] = {} ,["value"] = 654279},{["tree"] = {} ,["value"] = 319773},{["tree"] = {} ,["value"] = 15531}} ,["value"] = 991060},{["tree"] = {{["tree"] = {} ,["value"] = 929867},{["tree"] = {} ,["value"] = 595630},{["tree"] = {} ,["value"] = 476719},{["tree"] = {} ,["value"] = 537538}} ,["value"] = 197688}} ,["value"] = 662392},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 349874},{["tree"] = {} ,["value"] = 940973},{["tree"] = {} ,["value"] = 716159},{["tree"] = {} ,["value"] = 323440}} ,["value"] = 734276},{["tree"] = {{["tree"] = {} ,["value"] = 274163},{["tree"] = {} ,["value"] = 184834},{["tree"] = {} ,["value"] = 865866},{["tree"] = {} ,["value"] = 405891}} ,["value"] = 145641},{["tree"] = {{["tree"] = {} ,["value"] = 733659},{["tree"] = {} ,["value"] = 83027},{["tree"] = {} ,["value"] = 232406},{["tree"] = {} ,["value"] = 252138}} ,["value"] = 641465},{["tree"] = {{["tree"] = {} ,["value"] = 708316},{["tree"] = {} ,["value"] = 538918},{["tree"] = {} ,["value"] = 536440},{["tree"] = {} ,["value"] = 315512}} ,["value"] = 842630}} ,["value"] = 202403},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 903958},{["tree"] = {} ,["value"] = 80185},{["tree"] = {} ,["value"] = 620706},{["tree"] = {} ,["value"] = 73809}} ,["value"] = 928047},{["tree"] = {{["tree"] = {} ,["value"] = 615055},{["tree"] = {} ,["value"] = 331818},{["tree"] = {} ,["value"] = 706843},{["tree"] = {} ,["value"] = 130866}} ,["value"] = 173335},{["tree"] = {{["tree"] = {} ,["value"] = 833597},{["tree"] = {} ,["value"] = 510020},{["tree"] = {} ,["value"] = 416965},{["tree"] = {} ,["value"] = 221436}} ,["value"] = 240650},{["tree"] = {{["tree"] = {} ,["value"] = 681361},{["tree"] = {} ,["value"] = 831289},{["tree"] = {} ,["value"] = 8380},{["tree"] = {} ,["value"] = 42268}} ,["value"] = 216316}} ,["value"] = 663107}} ,["value"] = 261445},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 37953},{["tree"] = {} ,["value"] = 877353},{["tree"] = {} ,["value"] = 283932},{["tree"] = {} ,["value"] = 123467}} ,["value"] = 433673},{["tree"] = {{["tree"] = {} ,["value"] = 584698},{["tree"] = {} ,["value"] = 717886},{["tree"] = {} ,["value"] = 840047},{["tree"] = {} ,["value"] = 244680}} ,["value"] = 630113},{["tree"] = {{["tree"] = {} ,["value"] = 202411},{["tree"] = {} ,["value"] = 989688},{["tree"] = {} ,["value"] = 756437},{["tree"] = {} ,["value"] = 194027}} ,["value"] = 153332},{["tree"] = {{["tree"] = {} ,["value"] = 485491},{["tree"] = {} ,["value"] = 376586},{["tree"] = {} ,["value"] = 743974},{["tree"] = {} ,["value"] = 610810}} ,["value"] = 843244}} ,["value"] = 995972},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 91644},{["tree"] = {} ,["value"] = 56494},{["tree"] = {} ,["value"] = 649005},{["tree"] = {} ,["value"] = 46200}} ,["value"] = 471886},{["tree"] = {{["tree"] = {} ,["value"] = 103845},{["tree"] = {} ,["value"] = 860577},{["tree"] = {} ,["value"] = 414339},{["tree"] = {} ,["value"] = 472322}} ,["value"] = 12857},{["tree"] = {{["tree"] = {} ,["value"] = 832974},{["tree"] = {} ,["value"] = 377366},{["tree"] = {} ,["value"] = 976998},{["tree"] = {} ,["value"] = 667009}} ,["value"] = 309389},{["tree"] = {{["tree"] = {} ,["value"] = 595637},{["tree"] = {} ,["value"] = 599201},{["tree"] = {} ,["value"] = 464245},{["tree"] = {} ,["value"] = 825378}} ,["value"] = 406747}} ,["value"] = 851576},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 805266},{["tree"] = {} ,["value"] = 600271},{["tree"] = {} ,["value"] = 32868},{["tree"] = {} ,["value"] = 5108}} ,["value"] = 91406},{["tree"] = {{["tree"] = {} ,["value"] = 621065},{["tree"] = {} ,["value"] = 229651},{["tree"] = {} ,["value"] = 648715},{["tree"] = {} ,["value"] = 753499}} ,["value"] = 868316},{["tree"] = {{["tree"] = {} ,["value"] = 162270},{["tree"] = {} ,["value"] = 460678},{["tree"] = {} ,["value"] = 315235},{["tree"] = {} ,["value"] = 701234}} ,["value"] = 143617},{["tree"] = {{["tree"] = {} ,["value"] = 532870},{["tree"] = {} ,["value"] = 25868},{["tree"] = {} ,["value"] = 725675},{["tree"] = {} ,["value"] = 572955}} ,["value"] = 336817}} ,["value"] = 880143},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 612337},{["tree"] = {} ,["value"] = 267198},{["tree"] = {} ,["value"] = 526191},{["tree"] = {} ,["value"] = 921802}} ,["value"] = 810143},{["tree"] = {{["tree"] = {} ,["value"] = 775134},{["tree"] = {} ,["value"] = 396108},{["tree"] = {} ,["value"] = 189667},{["tree"] = {} ,["value"] = 256655}} ,["value"] = 577954},{["tree"] = {{["tree"] = {} ,["value"] = 423956},{["tree"] = {} ,["value"] = 127679},{["tree"] = {} ,["value"] = 104141},{["tree"] = {} ,["value"] = 334836}} ,["value"] = 829059},{["tree"] = {{["tree"] = {} ,["value"] = 305207},{["tree"] = {} ,["value"] = 464140},{["tree"] = {} ,["value"] = 167242},{["tree"] = {} ,["value"] = 286479}} ,["value"] = 788293}} ,["value"] = 644173}} ,["value"] = 120168},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 386519},{["tree"] = {} ,["value"] = 936658},{["tree"] = {} ,["value"] = 406839},{["tree"] = {} ,["value"] = 298199}} ,["value"] = 761028},{["tree"] = {{["tree"] = {} ,["value"] = 28869},{["tree"] = {} ,["value"] = 505302},{["tree"] = {} ,["value"] = 156424},{["tree"] = {} ,["value"] = 77773}} ,["value"] = 900864},{["tree"] = {{["tree"] = {} ,["value"] = 158780},{["tree"] = {} ,["value"] = 758693},{["tree"] = {} ,["value"] = 380492},{["tree"] = {} ,["value"] = 575223}} ,["value"] = 74311},{["tree"] = {{["tree"] = {} ,["value"] = 653217},{["tree"] = {} ,["value"] = 801991},{["tree"] = {} ,["value"] = 791113},{["tree"] = {} ,["value"] = 306768}} ,["value"] = 939985}} ,["value"] = 11173},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 84520},{["tree"] = {} ,["value"] = 658456},{["tree"] = {} ,["value"] = 874171},{["tree"] = {} ,["value"] = 532731}} ,["value"] = 866265},{["tree"] = {{["tree"] = {} ,["value"] = 661272},{["tree"] = {} ,["value"] = 223635},{["tree"] = {} ,["value"] = 645419},{["tree"] = {} ,["value"] = 855794}} ,["value"] = 701619},{["tree"] = {{["tree"] = {} ,["value"] = 889007},{["tree"] = {} ,["value"] = 298707},{["tree"] = {} ,["value"] = 316573},{["tree"] = {} ,["value"] = 271399}} ,["value"] = 758005},{["tree"] = {{["tree"] = {} ,["value"] = 710158},{["tree"] = {} ,["value"] = 235766},{["tree"] = {} ,["value"] = 398854},{["tree"] = {} ,["value"] = 954888}} ,["value"] = 822397}} ,["value"] = 865383},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 913161},{["tree"] = {} ,["value"] = 81521},{["tree"] = {} ,["value"] = 712470},{["tree"] = {} ,["value"] = 128511}} ,["value"] = 803929},{["tree"] = {{["tree"] = {} ,["value"] = 55325},{["tree"] = {} ,["value"] = 779120},{["tree"] = {} ,["value"] = 895856},{["tree"] = {} ,["value"] = 368700}} ,["value"] = 210729},{["tree"] = {{["tree"] = {} ,["value"] = 130710},{["tree"] = {} ,["value"] = 935901},{["tree"] = {} ,["value"] = 960114},{["tree"] = {} ,["value"] = 274151}} ,["value"] = 549325},{["tree"] = {{["tree"] = {} ,["value"] = 815328},{["tree"] = {} ,["value"] = 421853},{["tree"] = {} ,["value"] = 859637},{["tree"] = {} ,["value"] = 566384}} ,["value"] = 457529}} ,["value"] = 452234},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 535449},{["tree"] = {} ,["value"] = 888598},{["tree"] = {} ,["value"] = 833122},{["tree"] = {} ,["value"] = 466305}} ,["value"] = 565054},{["tree"] = {{["tree"] = {} ,["value"] = 797394},{["tree"] = {} ,["value"] = 468372},{["tree"] = {} ,["value"] = 605660},{["tree"] = {} ,["value"] = 493122}} ,["value"] = 926256},{["tree"] = {{["tree"] = {} ,["value"] = 413276},{["tree"] = {} ,["value"] = 860428},{["tree"] = {} ,["value"] = 271679},{["tree"] = {} ,["value"] = 961585}} ,["value"] = 731805},{["tree"] = {{["tree"] = {} ,["value"] = 586234},{["tree"] = {} ,["value"] = 620578},{["tree"] = {} ,["value"] = 515608},{["tree"] = {} ,["value"] = 326674}} ,["value"] = 668216}} ,["value"] = 751206}} ,["value"] = 110256},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 35814},{["tree"] = {} ,["value"] = 469565},{["tree"] = {} ,["value"] = 879581},{["tree"] = {} ,["value"] = 901564}} ,["value"] = 732001},{["tree"] = {{["tree"] = {} ,["value"] = 642084},{["tree"] = {} ,["value"] = 65419},{["tree"] = {} ,["value"] = 733669},{["tree"] = {} ,["value"] = 698204}} ,["value"] = 117020},{["tree"] = {{["tree"] = {} ,["value"] = 387978},{["tree"] = {} ,["value"] = 412204},{["tree"] = {} ,["value"] = 660364},{["tree"] = {} ,["value"] = 278592}} ,["value"] = 183860},{["tree"] = {{["tree"] = {} ,["value"] = 199840},{["tree"] = {} ,["value"] = 831309},{["tree"] = {} ,["value"] = 59233},{["tree"] = {} ,["value"] = 575874}} ,["value"] = 366745}} ,["value"] = 557511},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 826873},{["tree"] = {} ,["value"] = 946338},{["tree"] = {} ,["value"] = 701122},{["tree"] = {} ,["value"] = 12241}} ,["value"] = 658948},{["tree"] = {{["tree"] = {} ,["value"] = 596808},{["tree"] = {} ,["value"] = 365281},{["tree"] = {} ,["value"] = 600705},{["tree"] = {} ,["value"] = 648823}} ,["value"] = 780233},{["tree"] = {{["tree"] = {} ,["value"] = 140778},{["tree"] = {} ,["value"] = 516992},{["tree"] = {} ,["value"] = 318826},{["tree"] = {} ,["value"] = 638174}} ,["value"] = 918495},{["tree"] = {{["tree"] = {} ,["value"] = 869755},{["tree"] = {} ,["value"] = 236701},{["tree"] = {} ,["value"] = 601614},{["tree"] = {} ,["value"] = 751841}} ,["value"] = 804040}} ,["value"] = 429404},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 438394},{["tree"] = {} ,["value"] = 444757},{["tree"] = {} ,["value"] = 868244},{["tree"] = {} ,["value"] = 848566}} ,["value"] = 873847},{["tree"] = {{["tree"] = {} ,["value"] = 557347},{["tree"] = {} ,["value"] = 816499},{["tree"] = {} ,["value"] = 354416},{["tree"] = {} ,["value"] = 924657}} ,["value"] = 362431},{["tree"] = {{["tree"] = {} ,["value"] = 408098},{["tree"] = {} ,["value"] = 34797},{["tree"] = {} ,["value"] = 425367},{["tree"] = {} ,["value"] = 465749}} ,["value"] = 849574},{["tree"] = {{["tree"] = {} ,["value"] = 747671},{["tree"] = {} ,["value"] = 618176},{["tree"] = {} ,["value"] = 730484},{["tree"] = {} ,["value"] = 526761}} ,["value"] = 743631}} ,["value"] = 781475},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 399383},{["tree"] = {} ,["value"] = 41416},{["tree"] = {} ,["value"] = 555170},{["tree"] = {} ,["value"] = 872550}} ,["value"] = 8247},{["tree"] = {{["tree"] = {} ,["value"] = 163831},{["tree"] = {} ,["value"] = 794051},{["tree"] = {} ,["value"] = 194299},{["tree"] = {} ,["value"] = 321037}} ,["value"] = 321578},{["tree"] = {{["tree"] = {} ,["value"] = 298732},{["tree"] = {} ,["value"] = 786466},{["tree"] = {} ,["value"] = 842100},{["tree"] = {} ,["value"] = 933969}} ,["value"] = 18432},{["tree"] = {{["tree"] = {} ,["value"] = 938114},{["tree"] = {} ,["value"] = 108624},{["tree"] = {} ,["value"] = 636768},{["tree"] = {} ,["value"] = 602187}} ,["value"] = 418842}} ,["value"] = 429828}} ,["value"] = 449189}} ,["value"] = 39598},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 379251},{["tree"] = {} ,["value"] = 788368},{["tree"] = {} ,["value"] = 886113},{["tree"] = {} ,["value"] = 938250}} ,["value"] = 484882},{["tree"] = {{["tree"] = {} ,["value"] = 853280},{["tree"] = {} ,["value"] = 796432},{["tree"] = {} ,["value"] = 769769},{["tree"] = {} ,["value"] = 176505}} ,["value"] = 233465},{["tree"] = {{["tree"] = {} ,["value"] = 724411},{["tree"] = {} ,["value"] = 780200},{["tree"] = {} ,["value"] = 993864},{["tree"] = {} ,["value"] = 333925}} ,["value"] = 357753},{["tree"] = {{["tree"] = {} ,["value"] = 323242},{["tree"] = {} ,["value"] = 116269},{["tree"] = {} ,["value"] = 110576},{["tree"] = {} ,["value"] = 916542}} ,["value"] = 971352}} ,["value"] = 334410},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 168613},{["tree"] = {} ,["value"] = 672460},{["tree"] = {} ,["value"] = 163672},{["tree"] = {} ,["value"] = 350725}} ,["value"] = 673775},{["tree"] = {{["tree"] = {} ,["value"] = 132451},{["tree"] = {} ,["value"] = 523695},{["tree"] = {} ,["value"] = 755769},{["tree"] = {} ,["value"] = 995123}} ,["value"] = 748458},{["tree"] = {{["tree"] = {} ,["value"] = 687134},{["tree"] = {} ,["value"] = 477694},{["tree"] = {} ,["value"] = 471280},{["tree"] = {} ,["value"] = 869863}} ,["value"] = 789416},{["tree"] = {{["tree"] = {} ,["value"] = 719380},{["tree"] = {} ,["value"] = 192797},{["tree"] = {} ,["value"] = 397222},{["tree"] = {} ,["value"] = 218485}} ,["value"] = 111957}} ,["value"] = 562241},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 610157},{["tree"] = {} ,["value"] = 727095},{["tree"] = {} ,["value"] = 409889},{["tree"] = {} ,["value"] = 969978}} ,["value"] = 783107},{["tree"] = {{["tree"] = {} ,["value"] = 41291},{["tree"] = {} ,["value"] = 23334},{["tree"] = {} ,["value"] = 858395},{["tree"] = {} ,["value"] = 914563}} ,["value"] = 526946},{["tree"] = {{["tree"] = {} ,["value"] = 123078},{["tree"] = {} ,["value"] = 899274},{["tree"] = {} ,["value"] = 681596},{["tree"] = {} ,["value"] = 527090}} ,["value"] = 728181},{["tree"] = {{["tree"] = {} ,["value"] = 644},{["tree"] = {} ,["value"] = 264406},{["tree"] = {} ,["value"] = 335585},{["tree"] = {} ,["value"] = 825503}} ,["value"] = 843786}} ,["value"] = 559354},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 212387},{["tree"] = {} ,["value"] = 788918},{["tree"] = {} ,["value"] = 348798},{["tree"] = {} ,["value"] = 73256}} ,["value"] = 961413},{["tree"] = {{["tree"] = {} ,["value"] = 722756},{["tree"] = {} ,["value"] = 183170},{["tree"] = {} ,["value"] = 449202},{["tree"] = {} ,["value"] = 38699}} ,["value"] = 295855},{["tree"] = {{["tree"] = {} ,["value"] = 193907},{["tree"] = {} ,["value"] = 388333},{["tree"] = {} ,["value"] = 981108},{["tree"] = {} ,["value"] = 311658}} ,["value"] = 193200},{["tree"] = {{["tree"] = {} ,["value"] = 25450},{["tree"] = {} ,["value"] = 653238},{["tree"] = {} ,["value"] = 71931},{["tree"] = {} ,["value"] = 923954}} ,["value"] = 580473}} ,["value"] = 419135}} ,["value"] = 89293},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 362717},{["tree"] = {} ,["value"] = 414298},{["tree"] = {} ,["value"] = 253769},{["tree"] = {} ,["value"] = 24219}} ,["value"] = 526356},{["tree"] = {{["tree"] = {} ,["value"] = 292961},{["tree"] = {} ,["value"] = 382782},{["tree"] = {} ,["value"] = 799307},{["tree"] = {} ,["value"] = 15453}} ,["value"] = 289538},{["tree"] = {{["tree"] = {} ,["value"] = 761170},{["tree"] = {} ,["value"] = 296542},{["tree"] = {} ,["value"] = 496563},{["tree"] = {} ,["value"] = 315762}} ,["value"] = 827217},{["tree"] = {{["tree"] = {} ,["value"] = 689774},{["tree"] = {} ,["value"] = 24623},{["tree"] = {} ,["value"] = 732625},{["tree"] = {} ,["value"] = 984154}} ,["value"] = 703573}} ,["value"] = 483146},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 23164},{["tree"] = {} ,["value"] = 511717},{["tree"] = {} ,["value"] = 760244},{["tree"] = {} ,["value"] = 331367}} ,["value"] = 587334},{["tree"] = {{["tree"] = {} ,["value"] = 987746},{["tree"] = {} ,["value"] = 349728},{["tree"] = {} ,["value"] = 987693},{["tree"] = {} ,["value"] = 228835}} ,["value"] = 894647},{["tree"] = {{["tree"] = {} ,["value"] = 594329},{["tree"] = {} ,["value"] = 224108},{["tree"] = {} ,["value"] = 342443},{["tree"] = {} ,["value"] = 885680}} ,["value"] = 896209},{["tree"] = {{["tree"] = {} ,["value"] = 762792},{["tree"] = {} ,["value"] = 258651},{["tree"] = {} ,["value"] = 147775},{["tree"] = {} ,["value"] = 434177}} ,["value"] = 379471}} ,["value"] = 549254},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 16196},{["tree"] = {} ,["value"] = 436462},{["tree"] = {} ,["value"] = 771474},{["tree"] = {} ,["value"] = 724797}} ,["value"] = 254682},{["tree"] = {{["tree"] = {} ,["value"] = 393528},{["tree"] = {} ,["value"] = 174012},{["tree"] = {} ,["value"] = 936388},{["tree"] = {} ,["value"] = 3078}} ,["value"] = 675747},{["tree"] = {{["tree"] = {} ,["value"] = 242894},{["tree"] = {} ,["value"] = 529945},{["tree"] = {} ,["value"] = 964982},{["tree"] = {} ,["value"] = 935486}} ,["value"] = 16849},{["tree"] = {{["tree"] = {} ,["value"] = 945013},{["tree"] = {} ,["value"] = 363376},{["tree"] = {} ,["value"] = 335443},{["tree"] = {} ,["value"] = 760873}} ,["value"] = 86713}} ,["value"] = 491036},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 881253},{["tree"] = {} ,["value"] = 12846},{["tree"] = {} ,["value"] = 687791},{["tree"] = {} ,["value"] = 481238}} ,["value"] = 16950},{["tree"] = {{["tree"] = {} ,["value"] = 212682},{["tree"] = {} ,["value"] = 137844},{["tree"] = {} ,["value"] = 33016},{["tree"] = {} ,["value"] = 652052}} ,["value"] = 65785},{["tree"] = {{["tree"] = {} ,["value"] = 100894},{["tree"] = {} ,["value"] = 601999},{["tree"] = {} ,["value"] = 673580},{["tree"] = {} ,["value"] = 759727}} ,["value"] = 102963},{["tree"] = {{["tree"] = {} ,["value"] = 75023},{["tree"] = {} ,["value"] = 804591},{["tree"] = {} ,["value"] = 945852},{["tree"] = {} ,["value"] = 467049}} ,["value"] = 556653}} ,["value"] = 321992}} ,["value"] = 879117},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 303752},{["tree"] = {} ,["value"] = 753769},{["tree"] = {} ,["value"] = 166785},{["tree"] = {} ,["value"] = 548564}} ,["value"] = 46344},{["tree"] = {{["tree"] = {} ,["value"] = 68658},{["tree"] = {} ,["value"] = 967766},{["tree"] = {} ,["value"] = 808308},{["tree"] = {} ,["value"] = 572533}} ,["value"] = 794551},{["tree"] = {{["tree"] = {} ,["value"] = 114680},{["tree"] = {} ,["value"] = 169483},{["tree"] = {} ,["value"] = 107505},{["tree"] = {} ,["value"] = 269015}} ,["value"] = 793345},{["tree"] = {{["tree"] = {} ,["value"] = 869493},{["tree"] = {} ,["value"] = 54494},{["tree"] = {} ,["value"] = 253771},{["tree"] = {} ,["value"] = 705037}} ,["value"] = 525484}} ,["value"] = 129664},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 871420},{["tree"] = {} ,["value"] = 472439},{["tree"] = {} ,["value"] = 643067},{["tree"] = {} ,["value"] = 717291}} ,["value"] = 63881},{["tree"] = {{["tree"] = {} ,["value"] = 918877},{["tree"] = {} ,["value"] = 306484},{["tree"] = {} ,["value"] = 552476},{["tree"] = {} ,["value"] = 181910}} ,["value"] = 630391},{["tree"] = {{["tree"] = {} ,["value"] = 633934},{["tree"] = {} ,["value"] = 548254},{["tree"] = {} ,["value"] = 845089},{["tree"] = {} ,["value"] = 128668}} ,["value"] = 411212},{["tree"] = {{["tree"] = {} ,["value"] = 126649},{["tree"] = {} ,["value"] = 387199},{["tree"] = {} ,["value"] = 347956},{["tree"] = {} ,["value"] = 66350}} ,["value"] = 820696}} ,["value"] = 549300},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 73708},{["tree"] = {} ,["value"] = 121593},{["tree"] = {} ,["value"] = 626323},{["tree"] = {} ,["value"] = 277050}} ,["value"] = 693664},{["tree"] = {{["tree"] = {} ,["value"] = 813376},{["tree"] = {} ,["value"] = 220049},{["tree"] = {} ,["value"] = 214924},{["tree"] = {} ,["value"] = 12075}} ,["value"] = 810974},{["tree"] = {{["tree"] = {} ,["value"] = 51147},{["tree"] = {} ,["value"] = 101285},{["tree"] = {} ,["value"] = 570413},{["tree"] = {} ,["value"] = 623907}} ,["value"] = 465004},{["tree"] = {{["tree"] = {} ,["value"] = 982048},{["tree"] = {} ,["value"] = 534070},{["tree"] = {} ,["value"] = 371659},{["tree"] = {} ,["value"] = 516903}} ,["value"] = 5854}} ,["value"] = 267513},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 891715},{["tree"] = {} ,["value"] = 53942},{["tree"] = {} ,["value"] = 127957},{["tree"] = {} ,["value"] = 152846}} ,["value"] = 335223},{["tree"] = {{["tree"] = {} ,["value"] = 746196},{["tree"] = {} ,["value"] = 822924},{["tree"] = {} ,["value"] = 490748},{["tree"] = {} ,["value"] = 464305}} ,["value"] = 368322},{["tree"] = {{["tree"] = {} ,["value"] = 518700},{["tree"] = {} ,["value"] = 566024},{["tree"] = {} ,["value"] = 286768},{["tree"] = {} ,["value"] = 671985}} ,["value"] = 63264},{["tree"] = {{["tree"] = {} ,["value"] = 23489},{["tree"] = {} ,["value"] = 867569},{["tree"] = {} ,["value"] = 398353},{["tree"] = {} ,["value"] = 195555}} ,["value"] = 936945}} ,["value"] = 4986}} ,["value"] = 506579},{["tree"] = {{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 646758},{["tree"] = {} ,["value"] = 605965},{["tree"] = {} ,["value"] = 732419},{["tree"] = {} ,["value"] = 447695}} ,["value"] = 818221},{["tree"] = {{["tree"] = {} ,["value"] = 136453},{["tree"] = {} ,["value"] = 149313},{["tree"] = {} ,["value"] = 202471},{["tree"] = {} ,["value"] = 473604}} ,["value"] = 513230},{["tree"] = {{["tree"] = {} ,["value"] = 935945},{["tree"] = {} ,["value"] = 760199},{["tree"] = {} ,["value"] = 473127},{["tree"] = {} ,["value"] = 904618}} ,["value"] = 186365},{["tree"] = {{["tree"] = {} ,["value"] = 798907},{["tree"] = {} ,["value"] = 746109},{["tree"] = {} ,["value"] = 7784},{["tree"] = {} ,["value"] = 830376}} ,["value"] = 71367}} ,["value"] = 656257},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 321803},{["tree"] = {} ,["value"] = 324454},{["tree"] = {} ,["value"] = 219026},{["tree"] = {} ,["value"] = 526603}} ,["value"] = 299835},{["tree"] = {{["tree"] = {} ,["value"] = 227363},{["tree"] = {} ,["value"] = 783885},{["tree"] = {} ,["value"] = 501746},{["tree"] = {} ,["value"] = 238898}} ,["value"] = 473848},{["tree"] = {{["tree"] = {} ,["value"] = 8755},{["tree"] = {} ,["value"] = 129693},{["tree"] = {} ,["value"] = 913511},{["tree"] = {} ,["value"] = 657478}} ,["value"] = 728637},{["tree"] = {{["tree"] = {} ,["value"] = 174948},{["tree"] = {} ,["value"] = 378063},{["tree"] = {} ,["value"] = 652186},{["tree"] = {} ,["value"] = 424169}} ,["value"] = 27579}} ,["value"] = 525761},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 133857},{["tree"] = {} ,["value"] = 628738},{["tree"] = {} ,["value"] = 243643},{["tree"] = {} ,["value"] = 751086}} ,["value"] = 147941},{["tree"] = {{["tree"] = {} ,["value"] = 855071},{["tree"] = {} ,["value"] = 312419},{["tree"] = {} ,["value"] = 202022},{["tree"] = {} ,["value"] = 313485}} ,["value"] = 609972},{["tree"] = {{["tree"] = {} ,["value"] = 502819},{["tree"] = {} ,["value"] = 563670},{["tree"] = {} ,["value"] = 865778},{["tree"] = {} ,["value"] = 914492}} ,["value"] = 244285},{["tree"] = {{["tree"] = {} ,["value"] = 907175},{["tree"] = {} ,["value"] = 966614},{["tree"] = {} ,["value"] = 758735},{["tree"] = {} ,["value"] = 92153}} ,["value"] = 282391}} ,["value"] = 458045},{["tree"] = {{["tree"] = {{["tree"] = {} ,["value"] = 507953},{["tree"] = {} ,["value"] = 78413},{["tree"] = {} ,["value"] = 924106},{["tree"] = {} ,["value"] = 312767}} ,["value"] = 7318},{["tree"] = {{["tree"] = {} ,["value"] = 556021},{["tree"] = {} ,["value"] = 311400},{["tree"] = {} ,["value"] = 821531},{["tree"] = {} ,["value"] = 594664}} ,["value"] = 462389},{["tree"] = {{["tree"] = {} ,["value"] = 856255},{["tree"] = {} ,["value"] = 791613},{["tree"] = {} ,["value"] = 146135},{["tree"] = {} ,["value"] = 147819}} ,["value"] = 525228},{["tree"] = {{["tree"] = {} ,["value"] = 127338},{["tree"] = {} ,["value"] = 287559},{["tree"] = {} ,["value"] = 524439},{["tree"] = {} ,["value"] = 747953}} ,["value"] = 100602}} ,["value"] = 226977}} ,["value"] = 250818}} ,["value"] = 429647}} ,["value"] = 464263}} ,["value"] = 461562}
print(BFS(726494, data))
