CC = gcc
LD = gcc
CFLAGS = -Wall -std=gnu99 -pedantic

ifdef DEBUG
CFLAGS += -DDEBUG -pg -ggdb3
endif

CP ?= cp -v

PROJECT ?= $(notdir $(CURDIR))

USONDA_LIBS = $(USONDA_HOME)/software/libs
USONDA_APPS = $(USONDA_HOME)/software/apps

SONDA_TRUNK   ?= $(realpath $(USONDA_HOME)/../sonda/trunk)
SONDA_SWTOOLS  = $(SONDA_TRUNK)/swtools

$(eval $(shell test -d "$(USONDA_HOME)" || echo "Variable USONDA_HOME ($(USONDA_HOME)) is not valid" > /dev/stderr))
$(eval $(shell test -d "$(SONDA_TRUNK)" || echo "Variable SONDA_TRUNK ($(SONDA_TRUNK)) is not valid" > /dev/stderr))

$(info Project: $(PROJECT))

all: $(PROJECT)
help: help-usonda
help-usonda:
	@echo Usage: make [VAR=VALUE]
	@echo "  PROJECT        name of the current project (what 'all' depends on)"
	@echo "  USONDA_HOME    variable pointing to the home of the usonda project (SVN)"
	@echo "  SONDA_TRUNK    variable pointing to the trunk of the sonda project (SVN)"
	@echo "  DTREE_VERSION  use version of dtree library"
	@echo "  DTREE_PATH     override the default path pointing to the dtree library home"
	@echo "  HWIO_VERSION   use version of hwio library"
	@echo "  HWIO_IMPL      backend of the hwio library"
	@echo "  HWIO_PATH      override the default path pointing to the hwio library home"
	@echo ""
	@echo "Current settings:"
	@echo "  PROJECT       = $(PROJECT)"
	@echo "  USONDA_HOME   = $(USONDA_HOME)"
	@echo "  SONDA_TRUNK   = $(SONDA_TRUNK)"
	@echo "  DTREE_VERSION = $(DTREE_VERSION)"
	@echo "  DTREE_PATH    = $(DTREE_PATH)"
	@echo "  HWIO_VERSION  = $(HWIO_VERSION)"
	@echo "  HWIO_IMPL     = $(HWIO_IMPL)"
	@echo "  HWIO_PATH     = $(HWIO_PATH)"
	@echo ""

##############################

DTREE_VERSION ?= v2.0
DTREE_PATH ?= $(USONDA_LIBS)/dtree/$(DTREE_VERSION)

define USE_DTREE
	$(shell test -f $(DTREE_PATH)/libdtree.so || echo "Missing libdtree.so" > /dev/stderr)
	CFLAGS += -I$(DTREE_PATH)
	LDFLAGS += -L$(DTREE_PATH) -ldtree
endef

HWIO_VERSION ?= v1.0
HWIO_PATH ?= $(SONDA_SWTOOLS)/hwio/$(HWIO_VERSION)
HWIO_IMPL ?= linux

define USE_HWIO_TOOL
	$(shell test -f $(HWIO_PATH)/libhwio_tool.so || echo "Missing libhwio_tool.so" > /dev/stderr)
	CFLAGS += -I$(HWIO_PATH)
	LDFLAGS += -L$(HWIO_PATH) -lhwio_tool
endef

define USE_HWIO
	$(shell test -f $(HWIO_PATH)/hwio-$(HWIO_IMPL)/libhwio_$(HWIO_IMPL).so || echo "Missing libhwio_$(HWIO_IMPL).so" > /dev/stderr)
	CFLAGS += -I$(HWIO_PATH)
	LDFLAGS += -L$(HWIO_PATH)/hwio-$(HWIO_IMPL) -lhwio_$(HWIO_IMPL)
endef
